/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.monitoring;

import java.lang.reflect.Field;
import org.apache.hadoop.metrics2.impl.MetricsSystemImpl;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.phoenix.log.LogLevel;
import org.apache.phoenix.monitoring.MetricType;
import org.apache.phoenix.monitoring.MetricUtil;
import org.apache.phoenix.monitoring.MetricsStopWatch;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class MetricUtilTest {
    @Test
    public void testGetMetricsStopWatchWithMetricsTrue() throws Exception {
        MetricsStopWatch metricsStopWatch = MetricUtil.getMetricsStopWatch((boolean)true, (LogLevel)LogLevel.OFF, (MetricType)MetricType.WALL_CLOCK_TIME_MS);
        Assert.assertTrue((boolean)metricsStopWatch.getMetricsEnabled());
        metricsStopWatch.start();
        metricsStopWatch = MetricUtil.getMetricsStopWatch((boolean)false, (LogLevel)LogLevel.INFO, (MetricType)MetricType.RESULT_SET_TIME_MS);
        Assert.assertTrue((boolean)metricsStopWatch.getMetricsEnabled());
    }

    @Test
    public void testGetMetricsStopWatchWithMetricsFalse() throws Exception {
        MetricsStopWatch metricsStopWatch = MetricUtil.getMetricsStopWatch((boolean)false, (LogLevel)LogLevel.OFF, (MetricType)MetricType.WALL_CLOCK_TIME_MS);
        Assert.assertFalse((boolean)metricsStopWatch.getMetricsEnabled());
    }

    @Test
    public void testInternalMetricsField() throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        MetricsSystemImpl metrics = (MetricsSystemImpl)DefaultMetricsSystem.instance();
        Field prefixField = MetricsSystemImpl.class.getDeclaredField("prefix");
        prefixField.setAccessible(true);
        String oldValue = (String)prefixField.get(metrics);
        prefixField.set(metrics, "dummy");
        prefixField.set(metrics, oldValue);
        prefixField.setAccessible(false);
    }
}

