/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.monitoring;

import java.util.HashMap;
import org.apache.hadoop.metrics2.lib.DynamicMetricsRegistry;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.monitoring.IndexMetricsIT;
import org.apache.phoenix.schema.metrics.MetricsMetadataSourceImpl;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.ReadOnlyProps;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class MetadataMetricsIT
extends ParallelStatsDisabledIT {
    @BeforeClass
    public static void setup() throws Exception {
        HashMap props = Maps.newHashMapWithExpectedSize((int)3);
        props.put("phoenix.task.handling.initial.delay.ms", Long.toString(Long.MAX_VALUE));
        props.put("phoenix.scanner.lease.renew.enabled", String.valueOf(false));
        MetadataMetricsIT.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
    }

    @Test
    public void testCreateMetrics() {
        MetricsMetadataSourceImpl metadataSource = new MetricsMetadataSourceImpl();
        DynamicMetricsRegistry registry = metadataSource.getMetricsRegistry();
        metadataSource.incrementCreateExportCount();
        IndexMetricsIT.verifyCounter("createExportCount", registry);
        metadataSource.incrementCreateExportFailureCount();
        IndexMetricsIT.verifyCounter("createExportFailureCount", registry);
        long time = 10L;
        metadataSource.updateCreateExportTime(time);
        IndexMetricsIT.verifyHistogram("createExportTime", registry, time);
        metadataSource.updateCreateExportFailureTime(time);
        IndexMetricsIT.verifyHistogram("createExportFailureTime", registry, time);
    }

    @Test
    public void testAlterMetrics() {
        MetricsMetadataSourceImpl metadataSource = new MetricsMetadataSourceImpl();
        DynamicMetricsRegistry registry = metadataSource.getMetricsRegistry();
        metadataSource.incrementAlterExportCount();
        IndexMetricsIT.verifyCounter("alterExportCount", registry);
        metadataSource.incrementAlterExportFailureCount();
        IndexMetricsIT.verifyCounter("alterExportFailureCount", registry);
        long time = 10L;
        metadataSource.updateAlterExportTime(time);
        IndexMetricsIT.verifyHistogram("alterExportTime", registry, time);
        metadataSource.updateAlterExportFailureTime(time);
        IndexMetricsIT.verifyHistogram("alterExportFailureTime", registry, time);
    }

    @Test
    public void testCreateTableMetrics() {
        MetricsMetadataSourceImpl metadataSource = new MetricsMetadataSourceImpl();
        DynamicMetricsRegistry registry = metadataSource.getMetricsRegistry();
        metadataSource.incrementCreateTableCount();
        IndexMetricsIT.verifyCounter("createTableCount", registry);
    }

    @Test
    public void testCreateViewMetrics() {
        MetricsMetadataSourceImpl metadataSource = new MetricsMetadataSourceImpl();
        DynamicMetricsRegistry registry = metadataSource.getMetricsRegistry();
        metadataSource.incrementCreateViewCount();
        IndexMetricsIT.verifyCounter("createViewCount", registry);
    }

    @Test
    public void testCreateIndexMetrics() {
        MetricsMetadataSourceImpl metadataSource = new MetricsMetadataSourceImpl();
        DynamicMetricsRegistry registry = metadataSource.getMetricsRegistry();
        metadataSource.incrementCreateIndexCount();
        IndexMetricsIT.verifyCounter("createIndexCount", registry);
    }

    @Test
    public void testCreateSchemaMetrics() {
        MetricsMetadataSourceImpl metadataSource = new MetricsMetadataSourceImpl();
        DynamicMetricsRegistry registry = metadataSource.getMetricsRegistry();
        metadataSource.incrementCreateSchemaCount();
        IndexMetricsIT.verifyCounter("createSchemaCount", registry);
    }

    @Test
    public void testCreateFunctionMetrics() {
        MetricsMetadataSourceImpl metadataSource = new MetricsMetadataSourceImpl();
        DynamicMetricsRegistry registry = metadataSource.getMetricsRegistry();
        metadataSource.incrementCreateFunctionCount();
        IndexMetricsIT.verifyCounter("createFunctionCount", registry);
    }

    @Test
    public void testAlterAddColumnsMetrics() {
        MetricsMetadataSourceImpl metadataSource = new MetricsMetadataSourceImpl();
        DynamicMetricsRegistry registry = metadataSource.getMetricsRegistry();
        metadataSource.incrementAlterAddColumnCount();
        IndexMetricsIT.verifyCounter("alterAddColumnCount", registry);
    }

    @Test
    public void testAlterDropColumnsMetrics() {
        MetricsMetadataSourceImpl metadataSource = new MetricsMetadataSourceImpl();
        DynamicMetricsRegistry registry = metadataSource.getMetricsRegistry();
        metadataSource.incrementAlterDropColumnCount();
        IndexMetricsIT.verifyCounter("alterDropColumnCount", registry);
    }

    @Test
    public void testDropTableMetrics() {
        MetricsMetadataSourceImpl metadataSource = new MetricsMetadataSourceImpl();
        DynamicMetricsRegistry registry = metadataSource.getMetricsRegistry();
        metadataSource.incrementDropTableCount();
        IndexMetricsIT.verifyCounter("dropTableCount", registry);
    }

    @Test
    public void testDropViewMetrics() {
        MetricsMetadataSourceImpl metadataSource = new MetricsMetadataSourceImpl();
        DynamicMetricsRegistry registry = metadataSource.getMetricsRegistry();
        metadataSource.incrementDropViewCount();
        IndexMetricsIT.verifyCounter("dropViewCount", registry);
    }

    @Test
    public void testDropIndexMetrics() {
        MetricsMetadataSourceImpl metadataSource = new MetricsMetadataSourceImpl();
        DynamicMetricsRegistry registry = metadataSource.getMetricsRegistry();
        metadataSource.incrementDropIndexCount();
        IndexMetricsIT.verifyCounter("dropIndexCount", registry);
    }

    @Test
    public void testDropSchemaMetrics() {
        MetricsMetadataSourceImpl metadataSource = new MetricsMetadataSourceImpl();
        DynamicMetricsRegistry registry = metadataSource.getMetricsRegistry();
        metadataSource.incrementDropSchemaCount();
        IndexMetricsIT.verifyCounter("dropSchemaCount", registry);
    }

    @Test
    public void testDropFunctionMetrics() {
        MetricsMetadataSourceImpl metadataSource = new MetricsMetadataSourceImpl();
        DynamicMetricsRegistry registry = metadataSource.getMetricsRegistry();
        metadataSource.incrementDropFunctionCount();
        IndexMetricsIT.verifyCounter("dropFunctionCount", registry);
    }

    @Test
    public void testMetadataCacheUsedSizeMetrics() {
        MetricsMetadataSourceImpl metadataSource = new MetricsMetadataSourceImpl();
        DynamicMetricsRegistry registry = metadataSource.getMetricsRegistry();
        int estimatedSizeOfTable1 = 1000;
        int estimatedSizeOfTable2 = 500;
        metadataSource.incrementMetadataCacheUsedSize((long)estimatedSizeOfTable1);
        IndexMetricsIT.verifyCounterWithValue("metadataCacheEstimatedUsedSize", registry, estimatedSizeOfTable1);
        metadataSource.incrementMetadataCacheUsedSize((long)estimatedSizeOfTable2);
        IndexMetricsIT.verifyCounterWithValue("metadataCacheEstimatedUsedSize", registry, estimatedSizeOfTable1 + estimatedSizeOfTable2);
        metadataSource.decrementMetadataCacheUsedSize((long)estimatedSizeOfTable1);
        IndexMetricsIT.verifyCounterWithValue("metadataCacheEstimatedUsedSize", registry, estimatedSizeOfTable2);
        metadataSource.decrementMetadataCacheUsedSize((long)estimatedSizeOfTable2);
        IndexMetricsIT.verifyCounterWithValue("metadataCacheEstimatedUsedSize", registry, 0L);
    }

    @Test
    public void testMetadataCacheCountMetrics() {
        MetricsMetadataSourceImpl metadataSource = new MetricsMetadataSourceImpl();
        DynamicMetricsRegistry registry = metadataSource.getMetricsRegistry();
        metadataSource.incrementMetadataCacheHitCount();
        IndexMetricsIT.verifyCounter("metadataCacheHitCount", registry);
        metadataSource.incrementMetadataCacheMissCount();
        IndexMetricsIT.verifyCounter("metadataCacheMissCount", registry);
        metadataSource.incrementMetadataCacheEvictionCount();
        IndexMetricsIT.verifyCounter("metadataCacheEvictionCount", registry);
        metadataSource.incrementMetadataCacheRemovalCount();
        IndexMetricsIT.verifyCounter("metadataCacheRemovalCount", registry);
        metadataSource.incrementMetadataCacheAddCount();
        IndexMetricsIT.verifyCounter("metadataCacheAddCount", registry);
    }
}

