/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.monitoring;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.jdbc.PhoenixResultSet;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.monitoring.MetricType;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.ReadOnlyProps;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class CountRowsScannedIT
extends BaseTest {
    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap props = Maps.newHashMapWithExpectedSize((int)2);
        props.put("phoenix.query.request.metrics.enabled", "true");
        props.put("hbase.client.scanner.caching", "10");
        CountRowsScannedIT.setUpTestDriver(new ReadOnlyProps((Map)props));
    }

    @Test
    public void testSinglePrimaryKey() throws Exception {
        Connection conn = DriverManager.getConnection(CountRowsScannedIT.getUrl());
        String tableName = CountRowsScannedIT.generateUniqueName();
        PhoenixStatement stmt = conn.createStatement().unwrap(PhoenixStatement.class);
        stmt.execute("CREATE TABLE " + tableName + " (A UNSIGNED_LONG NOT NULL PRIMARY KEY, Z UNSIGNED_LONG)");
        for (int i = 1; i <= 100; ++i) {
            String sql = String.format("UPSERT INTO %s VALUES (%d, %d)", tableName, i, i);
            stmt.execute(sql);
        }
        conn.commit();
        long count1 = this.countRowsScannedFromSql((Statement)stmt, "SELECT A,Z FROM " + tableName + " WHERE A >= 3 AND Z >= 7");
        Assert.assertEquals((long)98L, (long)count1);
        long count2 = this.countRowsScannedFromSql((Statement)stmt, "SELECT A,Z FROM " + tableName + " WHERE A >= 3");
        Assert.assertEquals((long)98L, (long)count2);
        long count3 = this.countRowsScannedFromSql((Statement)stmt, "SELECT A,Z FROM " + tableName + " WHERE Z >= 7");
        Assert.assertEquals((long)100L, (long)count3);
        long count4 = this.countRowsScannedFromSql((Statement)stmt, "SELECT A,Z FROM " + tableName + " WHERE A >= 3 limit 1");
        Assert.assertEquals((long)1L, (long)count4);
        long count5 = this.countRowsScannedFromSql((Statement)stmt, "SELECT A,Z FROM " + tableName + " WHERE Z >= 7 limit 1");
        Assert.assertEquals((long)7L, (long)count5);
        long count6 = this.countRowsScannedFromSql((Statement)stmt, "SELECT A,Z FROM " + tableName + " WHERE A >= 3 ORDER BY A limit 1");
        Assert.assertEquals((long)1L, (long)count6);
        long count7 = this.countRowsScannedFromSql((Statement)stmt, "SELECT A,Z FROM " + tableName + " WHERE A >= 3 ORDER BY Z limit 1");
        Assert.assertEquals((long)98L, (long)count7);
        long count8 = this.countRowsScannedFromSql((Statement)stmt, "SELECT A,Z FROM " + tableName + " WHERE Z >= 7 ORDER BY A limit 1");
        Assert.assertEquals((long)7L, (long)count8);
        long count9 = this.countRowsScannedFromSql((Statement)stmt, "SELECT A,Z FROM " + tableName + " WHERE Z >= 7 ORDER BY A desc limit 1");
        Assert.assertEquals((long)1L, (long)count9);
        long count10 = this.countRowsScannedFromSql((Statement)stmt, "SELECT A,Z FROM " + tableName + " WHERE Z >= 7 AND Z <= 60 ORDER BY A desc limit 1");
        Assert.assertEquals((long)41L, (long)count10);
        long count11 = this.countRowsScannedFromSql((Statement)stmt, "SELECT A,Z FROM " + tableName + " WHERE Z >= 7 ORDER BY Z limit 1");
        Assert.assertEquals((long)100L, (long)count11);
        long count12 = this.countRowsScannedFromSql((Statement)stmt, "SELECT A,Z FROM " + tableName + " WHERE A in (20, 45, 68, 3)");
        Assert.assertEquals((long)7L, (long)count12);
        String ddl = String.format("alter table %s set \"%s\" = true", tableName, "phoenix.bloomfilter.multikey.pointlookup");
        conn.createStatement().execute(ddl);
        long count13 = this.countRowsScannedFromSql((Statement)stmt, "SELECT A,Z FROM " + tableName + " WHERE A in (20, 45, 68, 3)");
        Assert.assertEquals((long)4L, (long)count13);
    }

    @Test
    public void testMultiPrimaryKeys() throws Exception {
        Connection conn = DriverManager.getConnection(CountRowsScannedIT.getUrl());
        String tableName = CountRowsScannedIT.generateUniqueName();
        PhoenixStatement stmt = conn.createStatement().unwrap(PhoenixStatement.class);
        stmt.executeUpdate("CREATE TABLE IF NOT EXISTS " + tableName + " (A UNSIGNED_LONG NOT NULL, B UNSIGNED_LONG NOT NULL,  Z UNSIGNED_LONG, CONSTRAINT pk PRIMARY KEY (A, B))");
        for (int i = 1; i <= 100; ++i) {
            String sql = String.format("UPSERT INTO %s VALUES (%d, %d, %d)", tableName, i % 5 + 1, i, i);
            stmt.execute(sql);
        }
        conn.commit();
        long count1 = this.countRowsScannedFromSql((Statement)stmt, "SELECT A,B,Z FROM " + tableName + " WHERE A >= 2 AND B >= 3");
        Assert.assertEquals((long)79L, (long)count1);
        long count2 = this.countRowsScannedFromSql((Statement)stmt, "SELECT A,B,Z FROM " + tableName + " WHERE B >= 3");
        Assert.assertEquals((long)100L, (long)count2);
        long count3 = this.countRowsScannedFromSql((Statement)stmt, "SELECT A,B,Z FROM " + tableName + " WHERE Z >= 7");
        Assert.assertEquals((long)100L, (long)count3);
        long count4 = this.countRowsScannedFromSql((Statement)stmt, "SELECT SUM(A) FROM " + tableName + " WHERE B >= 3");
        Assert.assertEquals((long)100L, (long)count4);
        long count5 = this.countRowsScannedFromSql((Statement)stmt, "SELECT B, SUM(A), SUM(Z) FROM " + tableName + " WHERE A >= 2 AND B >= 3 GROUP BY B");
        Assert.assertEquals((long)79L, (long)count5);
        long count6 = this.countRowsScannedFromSql((Statement)stmt, "SELECT B, SUM(A), SUM(Z) FROM " + tableName + " WHERE A >= 2 AND B >= 3 GROUP BY B ORDER BY B DESC");
        Assert.assertEquals((long)79L, (long)count6);
    }

    @Test
    public void testQueryWithDeleteMarkers() throws Exception {
        Connection conn = DriverManager.getConnection(CountRowsScannedIT.getUrl());
        String tableName = CountRowsScannedIT.generateUniqueName();
        PhoenixStatement stmt = conn.createStatement().unwrap(PhoenixStatement.class);
        stmt.execute("CREATE TABLE " + tableName + " (A UNSIGNED_LONG NOT NULL PRIMARY KEY, Z UNSIGNED_LONG)");
        for (int i = 1; i <= 100; ++i) {
            String sql = String.format("UPSERT INTO %s VALUES (%d, %d)", tableName, i, i);
            stmt.execute(sql);
        }
        conn.commit();
        String selectQuery = "SELECT A,Z FROM " + tableName + " LIMIT 1";
        for (int i = 10; i <= 100; i += 10) {
            stmt.execute("DELETE FROM " + tableName + " WHERE A < " + i);
            conn.commit();
            long count = this.countRowsScannedFromSql((Statement)stmt, selectQuery);
            Assert.assertEquals((long)i, (long)count);
        }
    }

    @Test
    public void testQueryIndex() throws Exception {
        Connection conn = DriverManager.getConnection(CountRowsScannedIT.getUrl());
        String tableName = CountRowsScannedIT.generateUniqueName();
        String indexName = CountRowsScannedIT.generateUniqueName();
        PhoenixStatement stmt = conn.createStatement().unwrap(PhoenixStatement.class);
        stmt.execute("CREATE TABLE " + tableName + " (A UNSIGNED_LONG NOT NULL PRIMARY KEY, Z UNSIGNED_LONG)");
        stmt.execute("CREATE INDEX " + indexName + " ON " + tableName + "(Z) INCLUDE (A)");
        for (int i = 1; i <= 100; ++i) {
            String sql = String.format("UPSERT INTO %s VALUES (%d, %d)", tableName, i, i);
            stmt.execute(sql);
        }
        conn.commit();
        String selectQuery = "SELECT A FROM " + tableName + " WHERE Z > 49 AND Z < 71";
        long count = this.countRowsScannedFromSql((Statement)stmt, selectQuery);
        Assert.assertEquals((long)21L, (long)count);
        Assert.assertEquals((Object)indexName, (Object)stmt.getQueryPlan().getTableRef().getTable().getTableName().toString());
    }

    @Test
    public void testQueryUncoveredIndex() throws Exception {
        Connection conn = DriverManager.getConnection(CountRowsScannedIT.getUrl());
        String tableName = CountRowsScannedIT.generateUniqueName();
        String indexName = CountRowsScannedIT.generateUniqueName();
        PhoenixStatement stmt = conn.createStatement().unwrap(PhoenixStatement.class);
        stmt.execute("CREATE TABLE " + tableName + " (A UNSIGNED_LONG NOT NULL PRIMARY KEY, Z UNSIGNED_LONG)");
        stmt.execute("CREATE UNCOVERED INDEX " + indexName + " ON " + tableName + "(Z)");
        for (int i = 1; i <= 100; ++i) {
            String sql = String.format("UPSERT INTO %s VALUES (%d, %d)", tableName, i, i);
            stmt.execute(sql);
        }
        conn.commit();
        String selectQuery = "SELECT A FROM " + tableName + " WHERE Z > 34 AND Z < 63";
        long count = this.countRowsScannedFromSql((Statement)stmt, selectQuery);
        Assert.assertEquals((long)28L, (long)count);
        Assert.assertEquals((Object)indexName, (Object)stmt.getQueryPlan().getTableRef().getTable().getTableName().toString());
    }

    @Test
    public void testJoin() throws Exception {
        Connection conn = DriverManager.getConnection(CountRowsScannedIT.getUrl());
        String tableName1 = CountRowsScannedIT.generateUniqueName();
        String tableName2 = CountRowsScannedIT.generateUniqueName();
        PhoenixStatement stmt = conn.createStatement().unwrap(PhoenixStatement.class);
        stmt.executeUpdate("CREATE TABLE IF NOT EXISTS " + tableName1 + " (A UNSIGNED_LONG NOT NULL, B UNSIGNED_LONG NOT NULL,  Z UNSIGNED_LONG, CONSTRAINT pk PRIMARY KEY (A, B))");
        stmt.executeUpdate("CREATE TABLE IF NOT EXISTS " + tableName2 + " (A UNSIGNED_LONG NOT NULL, B UNSIGNED_LONG NOT NULL,  Z UNSIGNED_LONG, CONSTRAINT pk PRIMARY KEY (A, B))");
        for (int i = 1; i <= 100; ++i) {
            String sql1 = String.format("UPSERT INTO %s VALUES (%d, %d, %d)", tableName1, i, i + 50, i);
            stmt.execute(sql1);
            String sql2 = String.format("UPSERT INTO %s VALUES (%d, %d, %d)", tableName2, i, i, i);
            stmt.execute(sql2);
        }
        conn.commit();
        long count1 = this.countRowsScannedFromSql((Statement)stmt, "SELECT * FROM " + tableName1 + " WHERE A >= 40");
        Assert.assertEquals((long)61L, (long)count1);
        long count2 = this.countRowsScannedFromSql((Statement)stmt, "SELECT * FROM " + tableName2 + " WHERE B >= 20");
        Assert.assertEquals((long)100L, (long)count2);
        String sqlJoin = "SELECT X.K, X.VX, Y.VY FROM ( SELECT B AS K, A AS VX FROM " + tableName1 + " WHERE A >= 40) X JOIN (SELECT A AS K, B AS VY FROM " + tableName2 + " WHERE B >= 20) Y ON X.K=Y.K";
        long count3 = this.countRowsScannedFromSql((Statement)stmt, sqlJoin);
        Assert.assertEquals((long)161L, (long)count3);
    }

    @Test
    public void testUnionAll() throws Exception {
        Connection conn = DriverManager.getConnection(CountRowsScannedIT.getUrl());
        String tableName1 = CountRowsScannedIT.generateUniqueName();
        String tableName2 = CountRowsScannedIT.generateUniqueName();
        PhoenixStatement stmt = conn.createStatement().unwrap(PhoenixStatement.class);
        stmt.executeUpdate("CREATE TABLE IF NOT EXISTS " + tableName1 + " (A UNSIGNED_LONG NOT NULL, Z UNSIGNED_LONG, CONSTRAINT pk PRIMARY KEY (A))");
        stmt.executeUpdate("CREATE TABLE IF NOT EXISTS " + tableName2 + " (B UNSIGNED_LONG NOT NULL, Z UNSIGNED_LONG, CONSTRAINT pk PRIMARY KEY (B))");
        for (int i = 1; i <= 100; ++i) {
            String sql1 = String.format("UPSERT INTO %s VALUES (%d, %d)", tableName1, i, i);
            stmt.execute(sql1);
            String sql2 = String.format("UPSERT INTO %s VALUES (%d, %d)", tableName2, i, i);
            stmt.execute(sql2);
        }
        conn.commit();
        long count1 = this.countRowsScannedFromSql((Statement)stmt, "SELECT A, Z FROM " + tableName1 + " WHERE A >= 40");
        Assert.assertEquals((long)61L, (long)count1);
        long count2 = this.countRowsScannedFromSql((Statement)stmt, "SELECT B, Z FROM " + tableName2 + " WHERE B >= 20");
        Assert.assertEquals((long)81L, (long)count2);
        String sqlUnionAll = "SELECT SUM(Z) FROM ( SELECT Z FROM " + tableName1 + " WHERE A >= 40 UNION ALL SELECT Z FROM " + tableName2 + " WHERE B >= 20)";
        long count3 = this.countRowsScannedFromSql((Statement)stmt, sqlUnionAll);
        Assert.assertEquals((long)142L, (long)count3);
        String sqlUnionAllGroupBy = "SELECT K, SUM(Z) FROM ( SELECT A AS K, Z FROM " + tableName1 + " WHERE A >= 40 UNION ALL SELECT B AS K, Z FROM " + tableName2 + " WHERE B >= 20) GROUP BY K";
        long count4 = this.countRowsScannedFromSql((Statement)stmt, sqlUnionAllGroupBy);
        Assert.assertEquals((long)142L, (long)count4);
    }

    private long countRowsScannedFromSql(Statement stmt, String sql) throws SQLException {
        ResultSet rs = stmt.executeQuery(sql);
        while (rs.next()) {
        }
        return this.getRowsScanned(rs);
    }

    private long getRowsScanned(ResultSet rs) throws SQLException {
        if (!(rs instanceof PhoenixResultSet)) {
            return -1L;
        }
        Map metrics = PhoenixRuntime.getRequestReadMetricInfo((ResultSet)rs);
        long sum = 0L;
        boolean valid = false;
        for (Map.Entry entry : metrics.entrySet()) {
            Long val = (Long)((Map)entry.getValue()).get(MetricType.COUNT_ROWS_SCANNED);
            if (val == null) continue;
            sum += val.longValue();
            valid = true;
        }
        if (valid) {
            return sum;
        }
        return -1L;
    }
}

