/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.monitoring;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.util.VersionInfo;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.jdbc.AbstractRPCConnectionInfo;
import org.apache.phoenix.jdbc.ConnectionInfo;
import org.apache.phoenix.jdbc.ZKConnectionInfo;
import org.apache.phoenix.monitoring.BaseHTableThreadPoolMetricsIT;
import org.apache.phoenix.monitoring.HTableThreadPoolHistograms;
import org.apache.phoenix.monitoring.HTableThreadPoolMetricsManager;
import org.apache.phoenix.monitoring.HistogramDistribution;
import org.apache.phoenix.query.ConfigurationFactory;
import org.apache.phoenix.util.InstanceResolver;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={NeedsOwnMiniClusterTest.class})
@RunWith(value=Parameterized.class)
public class CQSIThreadPoolMetricsIT
extends BaseHTableThreadPoolMetricsIT {
    private final String registryClassName;
    private final Properties props = new Properties();

    public CQSIThreadPoolMetricsIT(String registryClassName) {
        this.registryClassName = registryClassName;
    }

    @BeforeClass
    public static void setUp() throws Exception {
        final Configuration conf = HBaseConfiguration.create();
        CQSIThreadPoolMetricsIT.setUpConfigForMiniCluster(conf);
        conf.setBoolean("phoenix.cqsi.thread.pool.metrics.enabled", true);
        conf.setBoolean("phoenix.cqsi.thread.pool.enabled", true);
        InstanceResolver.clearSingletons();
        InstanceResolver.getSingleton(ConfigurationFactory.class, (Object)new ConfigurationFactory(){

            public Configuration getConfiguration() {
                return conf;
            }

            public Configuration getConfiguration(Configuration confToClone) {
                Configuration copy = new Configuration(conf);
                copy.addResource(confToClone);
                return copy;
            }
        });
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("phoenix.tests.minicluster.nummasters", "2");
        CQSIThreadPoolMetricsIT.setUpTestDriver(new ReadOnlyProps(props));
    }

    @Before
    public void testCaseSetup() {
        this.props.setProperty("hbase.client.registry.impl", this.registryClassName);
    }

    @After
    public void cleanup() throws Exception {
        driver.cleanUpCQSICache();
        HTableThreadPoolMetricsManager.clearHTableThreadPoolHistograms();
        this.props.clear();
    }

    @Parameterized.Parameters(name="CQSIThreadPoolMetricsIT_registryClassName={0}")
    public static synchronized Collection<String> data() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("org.apache.hadoop.hbase.client.ZKConnectionRegistry");
        if (VersionInfo.compareVersion((String)VersionInfo.getVersion(), (String)"2.3.0") >= 0) {
            list.add("org.apache.hadoop.hbase.client.MasterRegistry");
        }
        if (VersionInfo.compareVersion((String)VersionInfo.getVersion(), (String)"2.5.0") >= 0) {
            list.add("org.apache.hadoop.hbase.client.RpcConnectionRegistry");
        }
        return list;
    }

    @Test
    public void testHistogramsPerConnInfo() throws Exception {
        Map<String, String> expectedTagKeyValues;
        String histogramKey;
        Map<String, List<HistogramDistribution>> htableThreadPoolHistograms;
        String tableName = CQSIThreadPoolMetricsIT.generateUniqueName();
        String cqsiNameService1 = "service1";
        String cqsiNameService2 = "service2";
        String url = QueryUtil.getConnectionUrl((Properties)this.props, (Configuration)utility.getConfiguration(), (String)cqsiNameService1);
        try (Connection conn = driver.connect(url, this.props);){
            this.createTableAndUpsertData(conn, tableName);
            htableThreadPoolHistograms = this.runQueryAndGetHistograms(conn, tableName);
            histogramKey = this.getHistogramKey(url);
            this.assertHTableThreadPoolUsed(htableThreadPoolHistograms, histogramKey);
            expectedTagKeyValues = this.getExpectedTagKeyValues(url, cqsiNameService1);
            this.assertHistogramTags(htableThreadPoolHistograms, expectedTagKeyValues, histogramKey);
        }
        url = QueryUtil.getConnectionUrl((Properties)this.props, (Configuration)utility.getConfiguration(), (String)cqsiNameService2);
        htableThreadPoolHistograms = PhoenixRuntime.getHTableThreadPoolHistograms();
        Assert.assertNull(htableThreadPoolHistograms.get(this.getHistogramKey(url)));
        conn = driver.connect(url, this.props);
        try {
            htableThreadPoolHistograms = this.runQueryAndGetHistograms(conn, tableName);
            this.assertHTableThreadPoolNotUsed(htableThreadPoolHistograms, histogramKey);
            expectedTagKeyValues = this.getExpectedTagKeyValues(url, cqsiNameService1);
            this.assertHistogramTags(htableThreadPoolHistograms, expectedTagKeyValues, histogramKey);
            histogramKey = this.getHistogramKey(url);
            this.assertHTableThreadPoolUsed(htableThreadPoolHistograms, histogramKey);
            expectedTagKeyValues = this.getExpectedTagKeyValues(url, cqsiNameService2);
            this.assertHistogramTags(htableThreadPoolHistograms, expectedTagKeyValues, histogramKey);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    @Test
    public void testCQSIThreadPoolHistogramsDisabled() throws Exception {
        String tableName = CQSIThreadPoolMetricsIT.generateUniqueName();
        String cqsiName = "service1";
        this.props.setProperty("phoenix.cqsi.thread.pool.metrics.enabled", "false");
        this.props.setProperty("phoenix.cqsi.thread.pool.enabled", "true");
        String url = QueryUtil.getConnectionUrl((Properties)this.props, (Configuration)utility.getConfiguration(), (String)cqsiName);
        try (Connection conn = driver.connect(url, this.props);){
            this.createTableAndUpsertData(conn, tableName);
            Map<String, List<HistogramDistribution>> htableThreadPoolHistograms = this.runQueryAndGetHistograms(conn, tableName);
            String histogramKey = this.getHistogramKey(url);
            Assert.assertNull(htableThreadPoolHistograms.get(histogramKey));
        }
    }

    @Test
    public void testDefaultCQSIHistograms() throws Exception {
        String tableName = CQSIThreadPoolMetricsIT.generateUniqueName();
        String url = QueryUtil.getConnectionUrl((Properties)this.props, (Configuration)utility.getConfiguration());
        try (Connection conn = driver.connect(url, this.props);){
            this.createTableAndUpsertData(conn, tableName);
            Map<String, List<HistogramDistribution>> htableThreadPoolHistograms = this.runQueryAndGetHistograms(conn, tableName);
            String histogramKey = this.getHistogramKey(url);
            this.assertHTableThreadPoolUsed(htableThreadPoolHistograms, histogramKey);
            Map<String, String> expectedTagKeyValues = this.getExpectedTagKeyValues(url, "DEFAULT_CQSN");
            this.assertHistogramTags(htableThreadPoolHistograms, expectedTagKeyValues, histogramKey);
        }
    }

    @Test
    public void testThreadPoolHistogramsSharedAcrossCQSIWithSameConnInfo() throws Exception {
        String histogramKey;
        Map<String, List<HistogramDistribution>> htableThreadPoolHistograms;
        String tableName = CQSIThreadPoolMetricsIT.generateUniqueName();
        String cqsiName = "service1";
        String url = QueryUtil.getConnectionUrl((Properties)this.props, (Configuration)utility.getConfiguration(), (String)cqsiName);
        try (Connection conn = driver.connect(url, this.props);){
            this.createTableAndUpsertData(conn, tableName);
            htableThreadPoolHistograms = this.runQueryAndGetHistograms(conn, tableName);
            histogramKey = this.getHistogramKey(url);
            this.assertHTableThreadPoolUsed(htableThreadPoolHistograms, histogramKey);
            Map<String, String> expectedTagKeyValues = this.getExpectedTagKeyValues(url, cqsiName);
            this.assertHistogramTags(htableThreadPoolHistograms, expectedTagKeyValues, histogramKey);
        }
        driver.cleanUpCQSICache();
        conn = driver.connect(url, this.props);
        try {
            htableThreadPoolHistograms = this.runQueryAndGetHistograms(conn, tableName);
            String histogramKeyForDefaultCQSI = this.getHistogramKey(QueryUtil.getConnectionUrl((Properties)new Properties(), (Configuration)utility.getConfiguration()));
            HashSet<String> histogramKeySet = new HashSet<String>(Arrays.asList(histogramKeyForDefaultCQSI, histogramKey));
            Assert.assertTrue((boolean)histogramKeySet.containsAll(htableThreadPoolHistograms.keySet()));
            this.assertHTableThreadPoolUsed(htableThreadPoolHistograms, histogramKey);
            Map<String, String> expectedTagKeyValues = this.getExpectedTagKeyValues(url, cqsiName);
            this.assertHistogramTags(htableThreadPoolHistograms, expectedTagKeyValues, histogramKey);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    private String getHistogramKey(String url) throws SQLException {
        return ConnectionInfo.createNoLogin((String)url, null, null).toUrl();
    }

    private Map<String, String> getExpectedTagKeyValues(String url, String cqsiName) throws SQLException {
        HashMap<String, String> expectedTagKeyValues = new HashMap<String, String>();
        ConnectionInfo connInfo = ConnectionInfo.createNoLogin((String)url, null, null);
        if (this.registryClassName.equals("org.apache.hadoop.hbase.client.ZKConnectionRegistry")) {
            expectedTagKeyValues.put(HTableThreadPoolHistograms.Tag.servers.name(), ((ZKConnectionInfo)connInfo).getZkHosts());
        } else {
            expectedTagKeyValues.put(HTableThreadPoolHistograms.Tag.servers.name(), ((AbstractRPCConnectionInfo)connInfo).getBoostrapServers());
        }
        expectedTagKeyValues.put(HTableThreadPoolHistograms.Tag.cqsiName.name(), cqsiName);
        return expectedTagKeyValues;
    }
}

