/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce.util;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Job;
import org.apache.phoenix.mapreduce.index.IndexScrutinyTool;
import org.apache.phoenix.mapreduce.util.PhoenixConfigurationUtil;
import org.apache.phoenix.mapreduce.util.PhoenixConfigurationUtilHelper;
import org.apache.phoenix.mapreduce.util.PhoenixMapReduceUtil;
import org.apache.phoenix.query.BaseConnectionlessQueryTest;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;

public class PhoenixConfigurationUtilTest
extends BaseConnectionlessQueryTest {
    private static final String ORIGINAL_CLUSTER_QUORUM = "myzookeeperhost";
    private static final String OVERRIDE_CLUSTER_QUORUM = "myoverridezookeeperhost";
    protected static String TEST_URL = "jdbc:phoenix:none;test=true";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpsertStatementOnNewViewWithReferencedCols() throws Exception {
        try (Connection conn = DriverManager.getConnection(PhoenixConfigurationUtilTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));){
            String tableName = "TEST_TABLE_WITH_VIEW";
            String viewName = "TEST_VIEW";
            String ddl = "CREATE TABLE TEST_TABLE_WITH_VIEW  (a_string varchar not null, a_binary varbinary not null, col1 integer  CONSTRAINT pk PRIMARY KEY (a_string, a_binary))\n";
            conn.createStatement().execute(ddl);
            String viewDdl = "CREATE VIEW TEST_VIEW  AS SELECT * FROM TEST_TABLE_WITH_VIEW\n";
            conn.createStatement().execute(viewDdl);
            Configuration configuration = new Configuration();
            PhoenixConfigurationUtil.setOutputClusterUrl((Configuration)configuration, (String)TEST_URL);
            PhoenixConfigurationUtil.setOutputTableName((Configuration)configuration, (String)"TEST_VIEW");
            PhoenixConfigurationUtil.setPhysicalTableName((Configuration)configuration, (String)"TEST_VIEW");
            PhoenixConfigurationUtil.setUpsertColumnNames((Configuration)configuration, (String[])new String[]{"A_STRING", "A_BINARY", "COL1"});
            String upserStatement = PhoenixConfigurationUtil.getUpsertStatement((Configuration)configuration);
            String expectedUpsertStatement = "UPSERT  INTO TEST_VIEW (\"A_STRING\", \"A_BINARY\", \"0\".\"COL1\") VALUES (?, ?, ?)";
            Assert.assertEquals((Object)"UPSERT  INTO TEST_VIEW (\"A_STRING\", \"A_BINARY\", \"0\".\"COL1\") VALUES (?, ?, ?)", (Object)upserStatement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpsertStatementOnNewTableWithReferencedCols() throws Exception {
        try (Connection conn = DriverManager.getConnection(PhoenixConfigurationUtilTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));){
            String tableName = "TEST_TABLE_WITH_REF_COLS";
            String ddl = "CREATE TABLE TEST_TABLE_WITH_REF_COLS  (a_string varchar not null, a_binary varbinary not null, col1 integer  CONSTRAINT pk PRIMARY KEY (a_string, a_binary))\n";
            conn.createStatement().execute(ddl);
            Configuration configuration = new Configuration();
            PhoenixConfigurationUtil.setOutputClusterUrl((Configuration)configuration, (String)TEST_URL);
            PhoenixConfigurationUtil.setOutputTableName((Configuration)configuration, (String)"TEST_TABLE_WITH_REF_COLS");
            PhoenixConfigurationUtil.setPhysicalTableName((Configuration)configuration, (String)"TEST_TABLE_WITH_REF_COLS");
            PhoenixConfigurationUtil.setUpsertColumnNames((Configuration)configuration, (String[])new String[]{"A_STRING", "A_BINARY", "COL1"});
            String upserStatement = PhoenixConfigurationUtil.getUpsertStatement((Configuration)configuration);
            String expectedUpsertStatement = "UPSERT  INTO TEST_TABLE_WITH_REF_COLS (\"A_STRING\", \"A_BINARY\", \"0\".\"COL1\") VALUES (?, ?, ?)";
            Assert.assertEquals((Object)"UPSERT  INTO TEST_TABLE_WITH_REF_COLS (\"A_STRING\", \"A_BINARY\", \"0\".\"COL1\") VALUES (?, ?, ?)", (Object)upserStatement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpsertStatement() throws Exception {
        String tableName = "TEST_TABLE";
        try (Connection conn = DriverManager.getConnection(PhoenixConfigurationUtilTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));){
            String ddl = "CREATE TABLE TEST_TABLE  (a_string varchar not null, a_binary varbinary not null, col1 integer  CONSTRAINT pk PRIMARY KEY (a_string, a_binary))\n";
            conn.createStatement().execute(ddl);
            Configuration configuration = new Configuration();
            PhoenixConfigurationUtil.setOutputClusterUrl((Configuration)configuration, (String)TEST_URL);
            PhoenixConfigurationUtil.setOutputTableName((Configuration)configuration, (String)"TEST_TABLE");
            PhoenixConfigurationUtil.setPhysicalTableName((Configuration)configuration, (String)"TEST_TABLE");
            String upserStatement = PhoenixConfigurationUtil.getUpsertStatement((Configuration)configuration);
            String expectedUpsertStatement = "UPSERT INTO TEST_TABLE VALUES (?, ?, ?)";
            Assert.assertEquals((Object)"UPSERT INTO TEST_TABLE VALUES (?, ?, ?)", (Object)upserStatement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelectStatement() throws Exception {
        String tableName = "TEST_TABLE";
        try (Connection conn = DriverManager.getConnection(PhoenixConfigurationUtilTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));){
            String ddl = "CREATE TABLE TEST_TABLE  (a_string varchar not null, a_binary varbinary not null, col1 integer  CONSTRAINT pk PRIMARY KEY (a_string, a_binary))\n";
            conn.createStatement().execute(ddl);
            Configuration configuration = new Configuration();
            PhoenixConfigurationUtil.setInputClusterUrl((Configuration)configuration, (String)TEST_URL);
            PhoenixConfigurationUtil.setInputTableName((Configuration)configuration, (String)"TEST_TABLE");
            String selectStatement = PhoenixConfigurationUtil.getSelectStatement((Configuration)configuration);
            String expectedSelectStatement = "SELECT \"A_STRING\" , \"A_BINARY\" , \"0\".\"COL1\" FROM TEST_TABLE";
            Assert.assertEquals((Object)"SELECT \"A_STRING\" , \"A_BINARY\" , \"0\".\"COL1\" FROM TEST_TABLE", (Object)selectStatement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelectStatementWithSchema() throws Exception {
        Connection conn = DriverManager.getConnection(PhoenixConfigurationUtilTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
        String tableName = "TEST_TABLE";
        String schemaName = SchemaUtil.getEscapedArgument((String)"schema");
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)"TEST_TABLE");
        try {
            String ddl = "CREATE TABLE " + fullTableName + "  (a_string varchar not null, a_binary varbinary not null, col1 integer  CONSTRAINT pk PRIMARY KEY (a_string, a_binary))\n";
            conn.createStatement().execute(ddl);
            Configuration configuration = new Configuration();
            PhoenixConfigurationUtil.setInputClusterUrl((Configuration)configuration, (String)TEST_URL);
            PhoenixConfigurationUtil.setInputTableName((Configuration)configuration, (String)fullTableName);
            String selectStatement = PhoenixConfigurationUtil.getSelectStatement((Configuration)configuration);
            String expectedSelectStatement = "SELECT \"A_STRING\" , \"A_BINARY\" , \"0\".\"COL1\" FROM " + fullTableName;
            Assert.assertEquals((Object)expectedSelectStatement, (Object)selectStatement);
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelectStatementForSpecificColumns() throws Exception {
        String tableName = "TEST_TABLE";
        try (Connection conn = DriverManager.getConnection(PhoenixConfigurationUtilTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));){
            String ddl = "CREATE TABLE TEST_TABLE  (a_string varchar not null, a_binary varbinary not null, col1 integer  CONSTRAINT pk PRIMARY KEY (a_string, a_binary))\n";
            conn.createStatement().execute(ddl);
            Configuration configuration = new Configuration();
            PhoenixConfigurationUtil.setInputClusterUrl((Configuration)configuration, (String)TEST_URL);
            PhoenixConfigurationUtil.setInputTableName((Configuration)configuration, (String)"TEST_TABLE");
            PhoenixConfigurationUtil.setSelectColumnNames((Configuration)configuration, (String[])new String[]{"A_BINARY"});
            String selectStatement = PhoenixConfigurationUtil.getSelectStatement((Configuration)configuration);
            String expectedSelectStatement = "SELECT \"A_BINARY\" FROM TEST_TABLE";
            Assert.assertEquals((Object)"SELECT \"A_BINARY\" FROM TEST_TABLE", (Object)selectStatement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelectStatementForArrayTypes() throws Exception {
        String tableName = "TEST_TABLE";
        try (Connection conn = DriverManager.getConnection(PhoenixConfigurationUtilTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));){
            String ddl = "CREATE TABLE TEST_TABLE  (ID BIGINT NOT NULL PRIMARY KEY, VCARRAY VARCHAR[])\n";
            conn.createStatement().execute(ddl);
            Configuration configuration = new Configuration();
            PhoenixConfigurationUtil.setInputClusterUrl((Configuration)configuration, (String)TEST_URL);
            PhoenixConfigurationUtil.setSelectColumnNames((Configuration)configuration, (String[])new String[]{"ID", "VCARRAY"});
            PhoenixConfigurationUtil.setSchemaType((Configuration)configuration, (PhoenixConfigurationUtil.SchemaType)PhoenixConfigurationUtil.SchemaType.QUERY);
            PhoenixConfigurationUtil.setInputTableName((Configuration)configuration, (String)"TEST_TABLE");
            String selectStatement = PhoenixConfigurationUtil.getSelectStatement((Configuration)configuration);
            String expectedSelectStatement = "SELECT \"ID\" , \"0\".\"VCARRAY\" FROM TEST_TABLE";
            Assert.assertEquals((Object)"SELECT \"ID\" , \"0\".\"VCARRAY\" FROM TEST_TABLE", (Object)selectStatement);
        }
    }

    @Test
    public void testInputClusterOverride() throws Exception {
        Configuration configuration = new Configuration();
        configuration.set("hbase.zookeeper.quorum", ORIGINAL_CLUSTER_QUORUM);
        String zkQuorum = PhoenixConfigurationUtilHelper.getInputCluster((Configuration)configuration);
        Assert.assertEquals((Object)zkQuorum, (Object)ORIGINAL_CLUSTER_QUORUM);
        configuration.set("phoenix.mapreduce.input.cluster.quorum", OVERRIDE_CLUSTER_QUORUM);
        String zkQuorumOverride = PhoenixConfigurationUtilHelper.getInputCluster((Configuration)configuration);
        Assert.assertEquals((Object)zkQuorumOverride, (Object)OVERRIDE_CLUSTER_QUORUM);
        Configuration configuration2 = new Configuration();
        PhoenixConfigurationUtil.setInputCluster((Configuration)configuration2, (String)OVERRIDE_CLUSTER_QUORUM);
        String zkQuorumOverride2 = PhoenixConfigurationUtilHelper.getInputCluster((Configuration)configuration2);
        Assert.assertEquals((Object)zkQuorumOverride2, (Object)OVERRIDE_CLUSTER_QUORUM);
        Job job = Job.getInstance();
        PhoenixMapReduceUtil.setInputCluster((Job)job, (String)OVERRIDE_CLUSTER_QUORUM);
        Configuration configuration3 = job.getConfiguration();
        String zkQuorumOverride3 = PhoenixConfigurationUtilHelper.getInputCluster((Configuration)configuration3);
        Assert.assertEquals((Object)zkQuorumOverride3, (Object)OVERRIDE_CLUSTER_QUORUM);
    }

    @Test
    public void testOutputClusterOverride() throws Exception {
        Configuration configuration = new Configuration();
        configuration.set("hbase.zookeeper.quorum", ORIGINAL_CLUSTER_QUORUM);
        String zkQuorum = PhoenixConfigurationUtilHelper.getOutputCluster((Configuration)configuration);
        Assert.assertEquals((Object)zkQuorum, (Object)ORIGINAL_CLUSTER_QUORUM);
        configuration.set("phoenix.mapreduce.output.cluster.quorum", OVERRIDE_CLUSTER_QUORUM);
        String zkQuorumOverride = PhoenixConfigurationUtilHelper.getOutputCluster((Configuration)configuration);
        Assert.assertEquals((Object)zkQuorumOverride, (Object)OVERRIDE_CLUSTER_QUORUM);
        Configuration configuration2 = new Configuration();
        PhoenixConfigurationUtil.setOutputCluster((Configuration)configuration2, (String)OVERRIDE_CLUSTER_QUORUM);
        String zkQuorumOverride2 = PhoenixConfigurationUtilHelper.getOutputCluster((Configuration)configuration2);
        Assert.assertEquals((Object)zkQuorumOverride2, (Object)OVERRIDE_CLUSTER_QUORUM);
        Job job = Job.getInstance();
        PhoenixMapReduceUtil.setOutputCluster((Job)job, (String)OVERRIDE_CLUSTER_QUORUM);
        Configuration configuration3 = job.getConfiguration();
        String zkQuorumOverride3 = PhoenixConfigurationUtilHelper.getOutputCluster((Configuration)configuration3);
        Assert.assertEquals((Object)zkQuorumOverride3, (Object)OVERRIDE_CLUSTER_QUORUM);
    }

    @Test
    public void testMrJobTypeOverride() throws Exception {
        Job job = Job.getInstance();
        Configuration configuration = job.getConfiguration();
        PhoenixConfigurationUtil.MRJobType mrJobType = PhoenixConfigurationUtil.getMRJobType((Configuration)configuration, (String)PhoenixConfigurationUtil.MRJobType.QUERY.name());
        Assert.assertEquals((Object)PhoenixConfigurationUtil.MRJobType.QUERY.name(), (Object)mrJobType.name());
        PhoenixConfigurationUtil.setMRJobType((Configuration)configuration, (PhoenixConfigurationUtil.MRJobType)PhoenixConfigurationUtil.MRJobType.UPDATE_STATS);
        mrJobType = PhoenixConfigurationUtil.getMRJobType((Configuration)configuration, (String)PhoenixConfigurationUtil.MRJobType.QUERY.name());
        Assert.assertEquals((Object)PhoenixConfigurationUtil.MRJobType.UPDATE_STATS.name(), (Object)mrJobType.name());
    }

    @Test
    public void testTimeRangeOverride() {
        Configuration configuration = new Configuration();
        Long startTime = 1L;
        Long endTime = 2L;
        PhoenixConfigurationUtil.setIndexToolStartTime((Configuration)configuration, (Long)startTime);
        PhoenixConfigurationUtil.setCurrentScnValue((Configuration)configuration, (Long)endTime);
        Assert.assertEquals((long)startTime, (long)Long.parseLong(PhoenixConfigurationUtil.getIndexToolStartTime((Configuration)configuration)));
        Assert.assertEquals((long)endTime, (long)Long.parseLong(PhoenixConfigurationUtil.getCurrentScnValue((Configuration)configuration)));
    }

    @Test
    public void testLastVerifyTimeConfig() {
        Configuration configuration = new Configuration();
        Long lastVerifyTime = 2L;
        PhoenixConfigurationUtil.setIndexToolLastVerifyTime((Configuration)configuration, (Long)lastVerifyTime);
        Assert.assertEquals((long)lastVerifyTime, (long)Long.parseLong(PhoenixConfigurationUtil.getIndexToolLastVerifyTime((Configuration)configuration)));
    }

    @Test
    public void testIndexToolSourceConfig() {
        Configuration conf = new Configuration();
        IndexScrutinyTool.SourceTable sourceTable = PhoenixConfigurationUtil.getIndexToolSourceTable((Configuration)conf);
        Assert.assertEquals((Object)sourceTable, (Object)IndexScrutinyTool.SourceTable.DATA_TABLE_SOURCE);
        PhoenixConfigurationUtil.setIndexToolSourceTable((Configuration)conf, (IndexScrutinyTool.SourceTable)IndexScrutinyTool.SourceTable.INDEX_TABLE_SOURCE);
        sourceTable = PhoenixConfigurationUtil.getIndexToolSourceTable((Configuration)conf);
        Assert.assertEquals((Object)sourceTable, (Object)IndexScrutinyTool.SourceTable.INDEX_TABLE_SOURCE);
        PhoenixConfigurationUtil.setIndexToolSourceTable((Configuration)conf, (IndexScrutinyTool.SourceTable)IndexScrutinyTool.SourceTable.DATA_TABLE_SOURCE);
        sourceTable = PhoenixConfigurationUtil.getIndexToolSourceTable((Configuration)conf);
        Assert.assertEquals((Object)sourceTable, (Object)IndexScrutinyTool.SourceTable.DATA_TABLE_SOURCE);
    }
}

