/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.phoenix.mapreduce.util.ColumnInfoToStringEncoderDecoder;
import org.apache.phoenix.schema.types.PDate;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.ColumnInfo;
import org.junit.Assert;
import org.junit.Test;

public class ColumnInfoToStringEncoderDecoderTest {
    @Test
    public void testEncodeDecode() {
        Configuration configuration = new Configuration();
        ColumnInfo columnInfo1 = new ColumnInfo("col1", PVarchar.INSTANCE.getSqlType());
        ColumnInfo columnInfo2 = new ColumnInfo("col2", PDate.INSTANCE.getSqlType());
        ArrayList expectedColInfos = Lists.newArrayList((Object[])new ColumnInfo[]{columnInfo1, columnInfo2});
        ColumnInfoToStringEncoderDecoder.encode((Configuration)configuration, (List)expectedColInfos);
        Assert.assertEquals((long)2L, (long)configuration.getInt("phoenix.colinfo.encoder.decoder.count", 0));
        Assert.assertEquals((Object)columnInfo1.toString(), (Object)configuration.get(String.format("%s_%d", "phoenix.colinfo.encoder.decoeder.value", 0)));
        Assert.assertEquals((Object)columnInfo2.toString(), (Object)configuration.get(String.format("%s_%d", "phoenix.colinfo.encoder.decoeder.value", 1)));
        List actualColInfos = ColumnInfoToStringEncoderDecoder.decode((Configuration)configuration);
        Assert.assertEquals((Object)expectedColInfos, (Object)actualColInfos);
    }

    @Test
    public void testEncodeDecodeWithNulls() {
        Configuration configuration = new Configuration();
        ColumnInfo columnInfo1 = new ColumnInfo("col1", PVarchar.INSTANCE.getSqlType());
        ArrayList expectedColInfos = Lists.newArrayList((Object[])new ColumnInfo[]{columnInfo1});
        ColumnInfoToStringEncoderDecoder.encode((Configuration)configuration, (List)Lists.newArrayList((Object[])new ColumnInfo[]{columnInfo1, null}));
        Assert.assertEquals((long)1L, (long)configuration.getInt("phoenix.colinfo.encoder.decoder.count", 0));
        Assert.assertEquals((Object)columnInfo1.toString(), (Object)configuration.get(String.format("%s_%d", "phoenix.colinfo.encoder.decoeder.value", 0)));
        List actualColInfos = ColumnInfoToStringEncoderDecoder.decode((Configuration)configuration);
        Assert.assertEquals((Object)expectedColInfos, (Object)actualColInfos);
    }
}

