/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce.index;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import org.apache.phoenix.mapreduce.index.BaseIndexTest;
import org.apache.phoenix.mapreduce.index.IndexScrutinyTableOutput;
import org.apache.phoenix.mapreduce.index.SourceTargetColumnNames;
import org.apache.phoenix.mapreduce.util.IndexColumnNames;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IndexScrutinyTableOutputTest
extends BaseIndexTest {
    private static final long SCRUTINY_TIME_MILLIS = 1502908914193L;

    @Override
    @Before
    public void setup() throws Exception {
        super.setup();
        this.conn.createStatement().execute("CREATE TABLE IF NOT EXISTS PHOENIX_INDEX_SCRUTINY\n(\n    SOURCE_TABLE VARCHAR NOT NULL,\n    TARGET_TABLE VARCHAR NOT NULL,\n    SCRUTINY_EXECUTE_TIME BIGINT NOT NULL,\n    SOURCE_ROW_PK_HASH VARCHAR NOT NULL,\n    SOURCE_TS BIGINT,\n    TARGET_TS BIGINT,\n    HAS_TARGET_ROW BOOLEAN,\n    BEYOND_MAX_LOOKBACK BOOLEAN,\n    CONSTRAINT PK PRIMARY KEY\n    (\n        SOURCE_TABLE,\n        TARGET_TABLE,\n        SCRUTINY_EXECUTE_TIME,\n        SOURCE_ROW_PK_HASH\n    )\n)  COLUMN_ENCODED_BYTES = 0 ");
        this.conn.createStatement().execute("CREATE TABLE IF NOT EXISTS PHOENIX_INDEX_SCRUTINY_METADATA\n(\n    SOURCE_TABLE VARCHAR NOT NULL,\n    TARGET_TABLE VARCHAR NOT NULL,\n    SCRUTINY_EXECUTE_TIME BIGINT NOT NULL,\n    SOURCE_TYPE VARCHAR,\n    CMD_LINE_ARGS VARCHAR,\n    INPUT_RECORDS BIGINT,\n    FAILED_RECORDS BIGINT,\n    VALID_ROW_COUNT BIGINT,\n    INVALID_ROW_COUNT BIGINT,\n    INCORRECT_COVERED_COL_VAL_COUNT BIGINT,\n    BATCHES_PROCESSED_COUNT BIGINT,\n    SOURCE_DYNAMIC_COLS VARCHAR,\n    TARGET_DYNAMIC_COLS VARCHAR,\n    INVALID_ROWS_QUERY_ALL VARCHAR,\n    INVALID_ROWS_QUERY_MISSING_TARGET VARCHAR,\n    INVALID_ROWS_QUERY_BAD_COVERED_COL_VAL VARCHAR,\n    INVALID_ROWS_QUERY_BEYOND_MAX_LOOKBACK VARCHAR,\n    BEYOND_MAX_LOOKBACK_COUNT BIGINT,\n    CONSTRAINT PK PRIMARY KEY\n    (\n        SOURCE_TABLE,\n        TARGET_TABLE,\n        SCRUTINY_EXECUTE_TIME\n    )\n)\n");
    }

    @Test
    public void testConstructMetadataParamQuery() {
        String metadataParamQuery = IndexScrutinyTableOutput.constructMetadataParamQuery(Arrays.asList("INVALID_ROWS_QUERY_ALL"));
        Assert.assertEquals((Object)"SELECT \"INVALID_ROWS_QUERY_ALL\" FROM PHOENIX_INDEX_SCRUTINY_METADATA WHERE (\"SOURCE_TABLE\",\"TARGET_TABLE\",\"SCRUTINY_EXECUTE_TIME\") IN ((?,?,?))", (Object)metadataParamQuery);
    }

    @Test
    public void testGetSqlQueryAllInvalidRows() throws SQLException {
        SourceTargetColumnNames.DataSourceColNames columnNames = new SourceTargetColumnNames.DataSourceColNames(this.pDataTable, this.pIndexTable);
        String sqlStr = IndexScrutinyTableOutput.getSqlQueryAllInvalidRows((Connection)this.conn, (SourceTargetColumnNames)columnNames, (long)1502908914193L);
        Assert.assertEquals((Object)"SELECT \"SOURCE_TABLE\" , \"TARGET_TABLE\" , \"SCRUTINY_EXECUTE_TIME\" , \"SOURCE_ROW_PK_HASH\" , \"SOURCE_TS\" , \"TARGET_TS\" , \"HAS_TARGET_ROW\" , \"BEYOND_MAX_LOOKBACK\" , \"ID\" , \"PK_PART2\" , \"NAME\" , \"ZIP\" , \":ID\" , \":PK_PART2\" , \"0:NAME\" , \"0:ZIP\" FROM PHOENIX_INDEX_SCRUTINY(\"ID\" INTEGER,\"PK_PART2\" TINYINT,\"NAME\" VARCHAR,\"ZIP\" BIGINT,\":ID\" INTEGER,\":PK_PART2\" TINYINT,\"0:NAME\" VARCHAR,\"0:ZIP\" BIGINT) WHERE (\"SOURCE_TABLE\",\"TARGET_TABLE\",\"SCRUTINY_EXECUTE_TIME\") IN (('TEST_SCHEMA.TEST_INDEX_COLUMN_NAMES_UTIL','TEST_SCHEMA.TEST_ICN_INDEX',1502908914193))", (Object)sqlStr);
    }

    @Test
    public void testGetSqlQueryMissingTargetRows() throws SQLException {
        SourceTargetColumnNames.DataSourceColNames columnNames = new SourceTargetColumnNames.DataSourceColNames(this.pDataTable, this.pIndexTable);
        String query = IndexScrutinyTableOutput.getSqlQueryMissingTargetRows((Connection)this.conn, (SourceTargetColumnNames)columnNames, (long)1502908914193L);
        Assert.assertEquals((Object)"SELECT \"SOURCE_TABLE\" , \"TARGET_TABLE\" , \"SCRUTINY_EXECUTE_TIME\" , \"SOURCE_ROW_PK_HASH\" , \"SOURCE_TS\" , \"TARGET_TS\" , \"HAS_TARGET_ROW\" , \"BEYOND_MAX_LOOKBACK\" , \"ID\" , \"PK_PART2\" , \"NAME\" , \"ZIP\" , \":ID\" , \":PK_PART2\" , \"0:NAME\" , \"0:ZIP\" FROM PHOENIX_INDEX_SCRUTINY(\"ID\" INTEGER,\"PK_PART2\" TINYINT,\"NAME\" VARCHAR,\"ZIP\" BIGINT,\":ID\" INTEGER,\":PK_PART2\" TINYINT,\"0:NAME\" VARCHAR,\"0:ZIP\" BIGINT) WHERE (\"SOURCE_TABLE\",\"TARGET_TABLE\",\"SCRUTINY_EXECUTE_TIME\", \"HAS_TARGET_ROW\") IN (('TEST_SCHEMA.TEST_INDEX_COLUMN_NAMES_UTIL','TEST_SCHEMA.TEST_ICN_INDEX',1502908914193,false))", (Object)query);
    }

    @Test
    public void testGetSqlQueryBadCoveredColVal() throws SQLException {
        SourceTargetColumnNames.DataSourceColNames columnNames = new SourceTargetColumnNames.DataSourceColNames(this.pDataTable, this.pIndexTable);
        String query = IndexScrutinyTableOutput.getSqlQueryBadCoveredColVal((Connection)this.conn, (SourceTargetColumnNames)columnNames, (long)1502908914193L);
        Assert.assertEquals((Object)"SELECT \"SOURCE_TABLE\" , \"TARGET_TABLE\" , \"SCRUTINY_EXECUTE_TIME\" , \"SOURCE_ROW_PK_HASH\" , \"SOURCE_TS\" , \"TARGET_TS\" , \"HAS_TARGET_ROW\" , \"BEYOND_MAX_LOOKBACK\" , \"ID\" , \"PK_PART2\" , \"NAME\" , \"ZIP\" , \":ID\" , \":PK_PART2\" , \"0:NAME\" , \"0:ZIP\" FROM PHOENIX_INDEX_SCRUTINY(\"ID\" INTEGER,\"PK_PART2\" TINYINT,\"NAME\" VARCHAR,\"ZIP\" BIGINT,\":ID\" INTEGER,\":PK_PART2\" TINYINT,\"0:NAME\" VARCHAR,\"0:ZIP\" BIGINT) WHERE (\"SOURCE_TABLE\",\"TARGET_TABLE\",\"SCRUTINY_EXECUTE_TIME\", \"HAS_TARGET_ROW\") IN (('TEST_SCHEMA.TEST_INDEX_COLUMN_NAMES_UTIL','TEST_SCHEMA.TEST_ICN_INDEX',1502908914193,true))", (Object)query);
    }

    @Test
    public void testGetSqlQueryBeyondMaxLookback() throws SQLException {
        SourceTargetColumnNames.DataSourceColNames columnNames = new SourceTargetColumnNames.DataSourceColNames(this.pDataTable, this.pIndexTable);
        String query = IndexScrutinyTableOutput.getSqlQueryBeyondMaxLookback((Connection)this.conn, (SourceTargetColumnNames)columnNames, (long)1502908914193L);
        Assert.assertEquals((Object)"SELECT \"SOURCE_TABLE\" , \"TARGET_TABLE\" , \"SCRUTINY_EXECUTE_TIME\" , \"SOURCE_ROW_PK_HASH\" , \"SOURCE_TS\" , \"TARGET_TS\" , \"HAS_TARGET_ROW\" , \"BEYOND_MAX_LOOKBACK\" , \"ID\" , \"PK_PART2\" , \"NAME\" , \"ZIP\" , \":ID\" , \":PK_PART2\" , \"0:NAME\" , \"0:ZIP\" FROM PHOENIX_INDEX_SCRUTINY(\"ID\" INTEGER,\"PK_PART2\" TINYINT,\"NAME\" VARCHAR,\"ZIP\" BIGINT,\":ID\" INTEGER,\":PK_PART2\" TINYINT,\"0:NAME\" VARCHAR,\"0:ZIP\" BIGINT) WHERE (\"SOURCE_TABLE\",\"TARGET_TABLE\",\"SCRUTINY_EXECUTE_TIME\", \"HAS_TARGET_ROW\", \"BEYOND_MAX_LOOKBACK\") IN (('TEST_SCHEMA.TEST_INDEX_COLUMN_NAMES_UTIL','TEST_SCHEMA.TEST_ICN_INDEX',1502908914193,false,true))", (Object)query);
    }

    @Test
    public void testGetOutputTableUpsert() throws Exception {
        IndexColumnNames columnNames = new IndexColumnNames(this.pDataTable, this.pIndexTable);
        String outputTableUpsert = IndexScrutinyTableOutput.constructOutputTableUpsert((List)columnNames.getDynamicDataCols(), (List)columnNames.getDynamicIndexCols(), (Connection)this.conn);
        this.conn.prepareStatement(outputTableUpsert);
        Assert.assertEquals((Object)"UPSERT  INTO PHOENIX_INDEX_SCRUTINY (\"SOURCE_TABLE\", \"TARGET_TABLE\", \"SCRUTINY_EXECUTE_TIME\", \"SOURCE_ROW_PK_HASH\", \"SOURCE_TS\", \"TARGET_TS\", \"HAS_TARGET_ROW\", \"BEYOND_MAX_LOOKBACK\", \"ID\" INTEGER, \"PK_PART2\" TINYINT, \"NAME\" VARCHAR, \"ZIP\" BIGINT, \":ID\" INTEGER, \":PK_PART2\" TINYINT, \"0:NAME\" VARCHAR, \"0:ZIP\" BIGINT) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", (Object)outputTableUpsert);
    }
}

