/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce.index;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Properties;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.query.BaseConnectionlessQueryTest;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;

public class BaseIndexTest
extends BaseConnectionlessQueryTest {
    protected static final String SCHEMA_NAME = "TEST_SCHEMA";
    protected static final String DATA_TABLE_NAME = "TEST_INDEX_COLUMN_NAMES_UTIL";
    protected static final String INDEX_TABLE_NAME = "TEST_ICN_INDEX";
    protected static final String DATA_TABLE_FULL_NAME = "TEST_SCHEMA.TEST_INDEX_COLUMN_NAMES_UTIL";
    protected static final String INDEX_TABLE_FULL_NAME = "TEST_SCHEMA.TEST_ICN_INDEX";
    private static final String DATA_TABLE_DDL = "CREATE TABLE IF NOT EXISTS TEST_SCHEMA.TEST_INDEX_COLUMN_NAMES_UTIL\n(\n    ID INTEGER NOT NULL,\n    PK_PART2 TINYINT NOT NULL,\n    NAME VARCHAR,\n    ZIP BIGINT,\n    EMPLOYER CHAR(20),\n    CONSTRAINT PK PRIMARY KEY\n    (\n        ID,\n        PK_PART2\n        \n    )\n)";
    private static final String INDEX_TABLE_DDL = "CREATE INDEX TEST_ICN_INDEX ON TEST_SCHEMA.TEST_INDEX_COLUMN_NAMES_UTIL (NAME) INCLUDE (ZIP)";
    protected PTable pDataTable;
    protected PTable pIndexTable;
    protected Connection conn;

    @BeforeClass
    public static synchronized void setupClass() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(BaseIndexTest.getUrl(), props);){
            conn.setAutoCommit(true);
            conn.createStatement().execute(DATA_TABLE_DDL);
            conn.createStatement().execute(INDEX_TABLE_DDL);
        }
    }

    @Before
    public void setup() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        this.conn = DriverManager.getConnection(BaseIndexTest.getUrl(), props);
        PhoenixConnection pconn = this.conn.unwrap(PhoenixConnection.class);
        this.pDataTable = pconn.getTable(new PTableKey(pconn.getTenantId(), DATA_TABLE_FULL_NAME));
        this.pIndexTable = pconn.getTable(new PTableKey(pconn.getTenantId(), INDEX_TABLE_FULL_NAME));
    }

    @After
    public void tearDown() throws Exception {
        if (this.conn != null) {
            this.conn.close();
        }
    }
}

