/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce;

import java.io.IOException;
import org.apache.commons.csv.CSVRecord;
import org.apache.phoenix.mapreduce.CsvToKeyValueMapper;
import org.junit.Assert;
import org.junit.Test;

public class CsvToKeyValueMapperTest {
    @Test
    public void testCsvLineParser() throws IOException {
        CsvToKeyValueMapper.CsvLineParser lineParser = new CsvToKeyValueMapper.CsvLineParser(Character.valueOf(';'), Character.valueOf('\"'), Character.valueOf('\\'));
        CSVRecord parsed = lineParser.parse("one;two");
        Assert.assertEquals((Object)"one", (Object)parsed.get(0));
        Assert.assertEquals((Object)"two", (Object)parsed.get(1));
        Assert.assertTrue((boolean)parsed.isConsistent());
        Assert.assertEquals((long)1L, (long)parsed.getRecordNumber());
    }

    @Test
    public void testCsvLineParserWithQuoting() throws IOException {
        CsvToKeyValueMapper.CsvLineParser lineParser = new CsvToKeyValueMapper.CsvLineParser(Character.valueOf(';'), Character.valueOf('\"'), Character.valueOf('\\'));
        CSVRecord parsed = lineParser.parse("\"\\\"one\";\"\\;two\\\\\"");
        Assert.assertEquals((Object)"\"one", (Object)parsed.get(0));
        Assert.assertEquals((Object)";two\\", (Object)parsed.get(1));
        Assert.assertTrue((boolean)parsed.isConsistent());
        Assert.assertEquals((long)1L, (long)parsed.getRecordNumber());
    }
}

