/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce;

import java.util.Arrays;
import java.util.Collection;
import org.apache.phoenix.mapreduce.AbstractBulkLoadTool;
import org.apache.phoenix.mapreduce.CsvBulkLoadTool;
import org.apache.phoenix.mapreduce.JsonBulkLoadTool;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.CommandLine;
import org.apache.phoenix.util.SchemaUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class BulkLoadToolTest {
    @Parameterized.Parameter(value=0)
    public AbstractBulkLoadTool bulkLoadTool;

    @Parameterized.Parameters
    public static Collection<Object[]> params() {
        return Arrays.asList({new CsvBulkLoadTool()}, {new JsonBulkLoadTool()});
    }

    @Test
    public void testParseOptions() {
        CommandLine cmdLine = this.bulkLoadTool.parseOptions(new String[]{"--input", "/input", "--table", "mytable"});
        Assert.assertEquals((Object)"mytable", (Object)cmdLine.getOptionValue(CsvBulkLoadTool.TABLE_NAME_OPT.getOpt()));
        Assert.assertEquals((Object)"/input", (Object)cmdLine.getOptionValue(CsvBulkLoadTool.INPUT_PATH_OPT.getOpt()));
    }

    @Test(expected=IllegalStateException.class)
    public void testParseOptions_ExtraArguments() {
        this.bulkLoadTool.parseOptions(new String[]{"--input", "/input", "--table", "mytable", "these", "shouldnt", "be", "here"});
    }

    @Test(expected=IllegalStateException.class)
    public void testParseOptions_NoInput() {
        this.bulkLoadTool.parseOptions(new String[]{"--table", "mytable"});
    }

    @Test(expected=IllegalStateException.class)
    public void testParseOptions_NoTable() {
        this.bulkLoadTool.parseOptions(new String[]{"--input", "/input"});
    }

    @Test
    public void testGetQualifiedTableName() {
        Assert.assertEquals((Object)"MYSCHEMA.MYTABLE", (Object)SchemaUtil.getQualifiedTableName((String)"mySchema", (String)"myTable"));
    }

    @Test
    public void testGetQualifiedTableName_NullSchema() {
        Assert.assertEquals((Object)"MYTABLE", (Object)SchemaUtil.getQualifiedTableName(null, (String)"myTable"));
    }
}

