/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.util.KerberosName;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.jdbc.ConnectionInfo;
import org.apache.phoenix.query.ConfigurationFactory;
import org.apache.phoenix.util.InstanceResolver;
import org.apache.phoenix.util.ReadOnlyProps;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={NeedsOwnMiniClusterTest.class})
public class SecureUserConnectionsIT {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecureUserConnectionsIT.class);
    private static final int KDC_START_ATTEMPTS = 10;
    private static final File TEMP_DIR = new File(SecureUserConnectionsIT.getClassTempDir());
    private static final File KEYTAB_DIR = new File(TEMP_DIR, "keytabs");
    private static final File KDC_DIR = new File(TEMP_DIR, "kdc");
    private static final List<File> USER_KEYTAB_FILES = new ArrayList<File>();
    private static final List<File> SERVICE_KEYTAB_FILES = new ArrayList<File>();
    private static final int NUM_USERS = 3;
    private static final Properties EMPTY_PROPERTIES = new Properties();
    private static final String BASE_URL = "jdbc:phoenix:localhost:2181";
    private static MiniKdc KDC;

    @BeforeClass
    public static synchronized void setupKdc() throws Exception {
        SecureUserConnectionsIT.ensureIsEmptyDirectory(KDC_DIR);
        SecureUserConnectionsIT.ensureIsEmptyDirectory(KEYTAB_DIR);
        boolean started = false;
        for (int i = 0; !started && i < 10; ++i) {
            Properties kdcConf = MiniKdc.createConf();
            kdcConf.put("debug", (Object)true);
            KDC = new MiniKdc(kdcConf, KDC_DIR);
            try {
                KDC.start();
                started = true;
                continue;
            }
            catch (Exception e) {
                LOGGER.warn("PHOENIX-3287: Failed to start KDC, retrying..", (Throwable)e);
            }
        }
        Assert.assertTrue((String)"The embedded KDC failed to start successfully after 10 attempts.", (boolean)started);
        SecureUserConnectionsIT.createUsers(3);
        SecureUserConnectionsIT.createServiceUsers(3);
        final Configuration conf = new Configuration(false);
        conf.set("hadoop.security.authentication", "kerberos");
        conf.set("hbase.security.authentication", "kerberos");
        conf.setBoolean("hbase.security.authorization", true);
        conf.set("hbase.client.registry.impl", "org.apache.hadoop.hbase.client.ZKConnectionRegistry");
        UserGroupInformation.setConfiguration((Configuration)conf);
        InstanceResolver.clearSingletons();
        InstanceResolver.getSingleton(ConfigurationFactory.class, (Object)new ConfigurationFactory(){

            public Configuration getConfiguration() {
                return conf;
            }

            public Configuration getConfiguration(Configuration confToClone) {
                Configuration copy = new Configuration(conf);
                copy.addResource(confToClone);
                return copy;
            }
        });
        SecureUserConnectionsIT.updateDefaultRealm();
    }

    private static void updateDefaultRealm() throws Exception {
        Field f = KerberosName.class.getDeclaredField("defaultRealm");
        f.setAccessible(true);
        f.set(null, "EXAMPLE.COM");
    }

    @AfterClass
    public static synchronized void stopKdc() throws Exception {
        InstanceResolver.clearSingletons();
        if (null != KDC) {
            KDC.stop();
            KDC = null;
        }
    }

    private static String getClassTempDir() {
        StringBuilder sb = new StringBuilder(32);
        sb.append(System.getProperty("user.dir")).append(File.separator);
        sb.append("target").append(File.separator);
        sb.append(SecureUserConnectionsIT.class.getSimpleName());
        return sb.toString();
    }

    private static void ensureIsEmptyDirectory(File f) throws IOException {
        if (f.exists()) {
            if (f.isDirectory()) {
                FileUtils.deleteDirectory((File)f);
            } else {
                Assert.assertTrue((String)"Failed to delete keytab directory", (boolean)f.delete());
            }
        }
        Assert.assertTrue((String)"Failed to create keytab directory", (boolean)f.mkdirs());
    }

    private static void createUsers(int numUsers) throws Exception {
        Assert.assertNotNull((String)"KDC is null, was setup method called?", (Object)KDC);
        for (int i = 1; i <= numUsers; ++i) {
            String principal = "user" + i;
            File keytabFile = new File(KEYTAB_DIR, principal + ".keytab");
            KDC.createPrincipal(keytabFile, new String[]{principal});
            USER_KEYTAB_FILES.add(keytabFile);
        }
    }

    private static void createServiceUsers(int numUsers) throws Exception {
        Assert.assertNotNull((String)"KDC is null, was setup method called?", (Object)KDC);
        for (int i = 1; i <= numUsers; ++i) {
            String principal = "user" + i + "/localhost";
            File keytabFile = new File(KEYTAB_DIR, "user" + i + ".service.keytab");
            KDC.createPrincipal(keytabFile, new String[]{principal});
            SERVICE_KEYTAB_FILES.add(keytabFile);
        }
    }

    private static String getUserPrincipal(int offset) {
        return "user" + offset + "@" + KDC.getRealm();
    }

    private static String getServicePrincipal(int offset) {
        return "user" + offset + "/localhost@" + KDC.getRealm();
    }

    public static File getUserKeytabFile(int offset) {
        return SecureUserConnectionsIT.getKeytabFile(offset, USER_KEYTAB_FILES);
    }

    public static File getServiceKeytabFile(int offset) {
        return SecureUserConnectionsIT.getKeytabFile(offset, SERVICE_KEYTAB_FILES);
    }

    private static File getKeytabFile(int offset, List<File> keytabs) {
        Assert.assertTrue((String)("Invalid offset: " + offset), (offset - 1 >= 0 && offset - 1 < keytabs.size() ? 1 : 0) != 0);
        return keytabs.get(offset - 1);
    }

    private String joinUserAuthentication(String origUrl, String principal, File keytab) {
        StringBuilder sb = new StringBuilder(64);
        if (origUrl.charAt(origUrl.length() - 1) == ';') {
            sb.append(origUrl, 0, origUrl.length() - 1);
        } else {
            sb.append(origUrl);
        }
        sb.append(':').append(principal);
        sb.append(':').append(keytab.getPath());
        return sb.append(';').toString();
    }

    @Test
    public void testMultipleInvocationsBySameUserAreEquivalent() throws Exception {
        final HashSet<ConnectionInfo> connections = new HashSet<ConnectionInfo>();
        final String princ1 = SecureUserConnectionsIT.getUserPrincipal(1);
        final File keytab1 = SecureUserConnectionsIT.getUserKeytabFile(1);
        UserGroupInformation ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)princ1, (String)keytab1.getPath());
        PrivilegedExceptionAction<Void> callable = new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                String url = SecureUserConnectionsIT.this.joinUserAuthentication(SecureUserConnectionsIT.BASE_URL, princ1, keytab1);
                connections.add(ConnectionInfo.create((String)url, (ReadOnlyProps)ReadOnlyProps.EMPTY_PROPS, (Properties)EMPTY_PROPERTIES));
                return null;
            }
        };
        ugi.doAs((PrivilegedExceptionAction)callable);
        Assert.assertEquals((long)1L, (long)connections.size());
        this.verifyAllConnectionsAreKerberosBased(connections);
        ugi.doAs((PrivilegedExceptionAction)callable);
        Assert.assertEquals((long)1L, (long)connections.size());
        this.verifyAllConnectionsAreKerberosBased(connections);
    }

    @Test
    public void testMultipleUniqueUGIInstancesAreDisjoint() throws Exception {
        final HashSet<ConnectionInfo> connections = new HashSet<ConnectionInfo>();
        final String princ1 = SecureUserConnectionsIT.getUserPrincipal(1);
        final File keytab1 = SecureUserConnectionsIT.getUserKeytabFile(1);
        UserGroupInformation ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)princ1, (String)keytab1.getPath());
        PrivilegedExceptionAction<Void> callable = new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                String url = SecureUserConnectionsIT.this.joinUserAuthentication(SecureUserConnectionsIT.BASE_URL, princ1, keytab1);
                connections.add(ConnectionInfo.create((String)url, (ReadOnlyProps)ReadOnlyProps.EMPTY_PROPS, (Properties)EMPTY_PROPERTIES));
                return null;
            }
        };
        ugi.doAs((PrivilegedExceptionAction)callable);
        Assert.assertEquals((long)1L, (long)connections.size());
        this.verifyAllConnectionsAreKerberosBased(connections);
        UserGroupInformation ugiCopy = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)princ1, (String)keytab1.getPath());
        ugiCopy.doAs((PrivilegedExceptionAction)callable);
        Assert.assertEquals((long)2L, (long)connections.size());
        this.verifyAllConnectionsAreKerberosBased(connections);
    }

    @Test
    public void testAlternatingLogins() throws Exception {
        final HashSet<ConnectionInfo> connections = new HashSet<ConnectionInfo>();
        final String princ1 = SecureUserConnectionsIT.getUserPrincipal(1);
        final File keytab1 = SecureUserConnectionsIT.getUserKeytabFile(1);
        final String princ2 = SecureUserConnectionsIT.getUserPrincipal(2);
        final File keytab2 = SecureUserConnectionsIT.getUserKeytabFile(2);
        UserGroupInformation ugi1 = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)princ1, (String)keytab1.getPath());
        UserGroupInformation ugi2 = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)princ2, (String)keytab2.getPath());
        ugi1.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                String url = SecureUserConnectionsIT.this.joinUserAuthentication(SecureUserConnectionsIT.BASE_URL, princ1, keytab1);
                connections.add(ConnectionInfo.create((String)url, (ReadOnlyProps)ReadOnlyProps.EMPTY_PROPS, (Properties)EMPTY_PROPERTIES));
                return null;
            }
        });
        Assert.assertEquals((long)1L, (long)connections.size());
        this.verifyAllConnectionsAreKerberosBased(connections);
        ugi2.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                String url = SecureUserConnectionsIT.this.joinUserAuthentication(SecureUserConnectionsIT.BASE_URL, princ2, keytab2);
                connections.add(ConnectionInfo.create((String)url, (ReadOnlyProps)ReadOnlyProps.EMPTY_PROPS, (Properties)EMPTY_PROPERTIES));
                return null;
            }
        });
        Assert.assertEquals((long)2L, (long)connections.size());
        this.verifyAllConnectionsAreKerberosBased(connections);
        ugi1.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                String url = SecureUserConnectionsIT.this.joinUserAuthentication(SecureUserConnectionsIT.BASE_URL, princ1, keytab1);
                connections.add(ConnectionInfo.create((String)url, (ReadOnlyProps)ReadOnlyProps.EMPTY_PROPS, (Properties)EMPTY_PROPERTIES));
                return null;
            }
        });
        Assert.assertEquals((long)2L, (long)connections.size());
        this.verifyAllConnectionsAreKerberosBased(connections);
    }

    @Test
    public void testAlternatingDestructiveLogins() throws Exception {
        HashSet<ConnectionInfo> connections = new HashSet<ConnectionInfo>();
        String princ1 = SecureUserConnectionsIT.getUserPrincipal(1);
        File keytab1 = SecureUserConnectionsIT.getUserKeytabFile(1);
        String princ2 = SecureUserConnectionsIT.getUserPrincipal(2);
        File keytab2 = SecureUserConnectionsIT.getUserKeytabFile(2);
        String url1 = this.joinUserAuthentication(BASE_URL, princ1, keytab1);
        String url2 = this.joinUserAuthentication(BASE_URL, princ2, keytab2);
        UserGroupInformation.loginUserFromKeytab((String)princ1, (String)keytab1.getPath());
        connections.add(ConnectionInfo.create((String)url1, (ReadOnlyProps)ReadOnlyProps.EMPTY_PROPS, (Properties)EMPTY_PROPERTIES));
        Assert.assertEquals((long)1L, (long)connections.size());
        this.verifyAllConnectionsAreKerberosBased(connections);
        UserGroupInformation.loginUserFromKeytab((String)princ2, (String)keytab2.getPath());
        connections.add(ConnectionInfo.create((String)url2, (ReadOnlyProps)ReadOnlyProps.EMPTY_PROPS, (Properties)EMPTY_PROPERTIES));
        Assert.assertEquals((long)2L, (long)connections.size());
        this.verifyAllConnectionsAreKerberosBased(connections);
        UserGroupInformation.loginUserFromKeytab((String)princ1, (String)keytab1.getPath());
        connections.add(ConnectionInfo.create((String)url1, (ReadOnlyProps)ReadOnlyProps.EMPTY_PROPS, (Properties)EMPTY_PROPERTIES));
        Assert.assertEquals((long)3L, (long)connections.size());
        this.verifyAllConnectionsAreKerberosBased(connections);
    }

    @Test
    public void testMultipleConnectionsAsSameUser() throws Exception {
        HashSet<ConnectionInfo> connections = new HashSet<ConnectionInfo>();
        String princ1 = SecureUserConnectionsIT.getUserPrincipal(1);
        File keytab1 = SecureUserConnectionsIT.getUserKeytabFile(1);
        String url = this.joinUserAuthentication(BASE_URL, princ1, keytab1);
        UserGroupInformation.loginUserFromKeytab((String)princ1, (String)keytab1.getPath());
        connections.add(ConnectionInfo.create((String)url, (ReadOnlyProps)ReadOnlyProps.EMPTY_PROPS, (Properties)EMPTY_PROPERTIES));
        Assert.assertEquals((long)1L, (long)connections.size());
        this.verifyAllConnectionsAreKerberosBased(connections);
        connections.add(ConnectionInfo.create((String)url, (ReadOnlyProps)ReadOnlyProps.EMPTY_PROPS, (Properties)EMPTY_PROPERTIES));
        Assert.assertEquals((long)1L, (long)connections.size());
    }

    @Test
    public void testMultipleConnectionsAsSameUserWithoutLogin() throws Exception {
        HashSet<ConnectionInfo> connections = new HashSet<ConnectionInfo>();
        String princ1 = SecureUserConnectionsIT.getUserPrincipal(1);
        File keytab1 = SecureUserConnectionsIT.getUserKeytabFile(1);
        String url = this.joinUserAuthentication(BASE_URL, princ1, keytab1);
        connections.add(ConnectionInfo.create((String)url, (ReadOnlyProps)ReadOnlyProps.EMPTY_PROPS, (Properties)EMPTY_PROPERTIES));
        Assert.assertEquals((long)1L, (long)connections.size());
        this.verifyAllConnectionsAreKerberosBased(connections);
        connections.add(ConnectionInfo.create((String)url, (ReadOnlyProps)ReadOnlyProps.EMPTY_PROPS, (Properties)EMPTY_PROPERTIES));
        Assert.assertEquals((long)1L, (long)connections.size());
    }

    @Test
    public void testAlternatingConnectionsWithoutLogin() throws Exception {
        HashSet<ConnectionInfo> connections = new HashSet<ConnectionInfo>();
        String princ1 = SecureUserConnectionsIT.getUserPrincipal(1);
        File keytab1 = SecureUserConnectionsIT.getUserKeytabFile(1);
        String princ2 = SecureUserConnectionsIT.getUserPrincipal(2);
        File keytab2 = SecureUserConnectionsIT.getUserKeytabFile(2);
        String url1 = this.joinUserAuthentication(BASE_URL, princ1, keytab1);
        String url2 = this.joinUserAuthentication(BASE_URL, princ2, keytab2);
        connections.add(ConnectionInfo.create((String)url1, (ReadOnlyProps)ReadOnlyProps.EMPTY_PROPS, (Properties)EMPTY_PROPERTIES));
        Assert.assertEquals((long)1L, (long)connections.size());
        this.verifyAllConnectionsAreKerberosBased(connections);
        connections.add(ConnectionInfo.create((String)url2, (ReadOnlyProps)ReadOnlyProps.EMPTY_PROPS, (Properties)EMPTY_PROPERTIES));
        Assert.assertEquals((long)2L, (long)connections.size());
        this.verifyAllConnectionsAreKerberosBased(connections);
        connections.add(ConnectionInfo.create((String)url1, (ReadOnlyProps)ReadOnlyProps.EMPTY_PROPS, (Properties)EMPTY_PROPERTIES));
        Assert.assertEquals((long)3L, (long)connections.size());
        this.verifyAllConnectionsAreKerberosBased(connections);
    }

    @Test
    public void testHostSubstitutionInUrl() throws Exception {
        HashSet<ConnectionInfo> connections = new HashSet<ConnectionInfo>();
        String princ1 = SecureUserConnectionsIT.getServicePrincipal(1);
        File keytab1 = SecureUserConnectionsIT.getServiceKeytabFile(1);
        String princ2 = SecureUserConnectionsIT.getServicePrincipal(2);
        File keytab2 = SecureUserConnectionsIT.getServiceKeytabFile(2);
        String url1 = this.joinUserAuthentication(BASE_URL, princ1, keytab1);
        String url2 = this.joinUserAuthentication(BASE_URL, princ2, keytab2);
        connections.add(ConnectionInfo.create((String)url1, (ReadOnlyProps)ReadOnlyProps.EMPTY_PROPS, (Properties)EMPTY_PROPERTIES));
        Assert.assertEquals((long)1L, (long)connections.size());
        this.verifyAllConnectionsAreKerberosBased(connections);
        connections.add(ConnectionInfo.create((String)url1, (ReadOnlyProps)ReadOnlyProps.EMPTY_PROPS, (Properties)EMPTY_PROPERTIES));
        Assert.assertEquals((long)1L, (long)connections.size());
        this.verifyAllConnectionsAreKerberosBased(connections);
        connections.add(ConnectionInfo.create((String)url2, (ReadOnlyProps)ReadOnlyProps.EMPTY_PROPS, (Properties)EMPTY_PROPERTIES));
        Assert.assertEquals((long)2L, (long)connections.size());
        this.verifyAllConnectionsAreKerberosBased(connections);
        connections.add(ConnectionInfo.create((String)url2, (ReadOnlyProps)ReadOnlyProps.EMPTY_PROPS, (Properties)EMPTY_PROPERTIES));
        Assert.assertEquals((long)2L, (long)connections.size());
        this.verifyAllConnectionsAreKerberosBased(connections);
        connections.add(ConnectionInfo.create((String)url1, (ReadOnlyProps)ReadOnlyProps.EMPTY_PROPS, (Properties)EMPTY_PROPERTIES));
        Assert.assertEquals((long)3L, (long)connections.size());
        this.verifyAllConnectionsAreKerberosBased(connections);
    }

    private void verifyAllConnectionsAreKerberosBased(Collection<ConnectionInfo> connections) {
        for (ConnectionInfo cnxnInfo : connections) {
            Assert.assertTrue((String)("ConnectionInfo does not have kerberos credentials: " + cnxnInfo), (boolean)cnxnInfo.getUser().getUGI().hasKerberosCredentials());
        }
    }
}

