/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.apache.phoenix.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.phoenix.util.ReadOnlyProps;
import org.junit.Assert;
import org.junit.Test;

public class ReadOnlyPropertiesTest {
    private static final String PROPERTY_NAME_1 = "property1";
    private static final String DEFAULT_VALUE_1 = "default1";
    private static final String OVERRIDEN_VALUE_1 = "override1";
    private static final String OVERRIDEN_VALUE_2 = "override2";
    private static final String PROPERTY_NAME_2 = "property2";
    private static final String DEFAULT_VALUE_2 = "default2";
    private static final Map<String, String> EMPTY_OVERRIDE_MAP = Collections.emptyMap();
    private static final Map<String, String> DEFAULT_PROPS_MAP = ImmutableMap.of((Object)"property1", (Object)"default1", (Object)"property2", (Object)"default2");
    private static final Map<String, String> OVERRIDE_MAP = ImmutableMap.of((Object)"property1", (Object)"override1");

    @Test
    public void testDefaultProperties() {
        ReadOnlyProps defaultProps = new ReadOnlyProps(DEFAULT_PROPS_MAP);
        ReadOnlyProps readOnlyProps = new ReadOnlyProps(defaultProps, EMPTY_OVERRIDE_MAP.entrySet().iterator());
        Assert.assertEquals((Object)DEFAULT_VALUE_1, (Object)readOnlyProps.get(PROPERTY_NAME_1));
        Assert.assertEquals((Object)DEFAULT_VALUE_2, (Object)readOnlyProps.get(PROPERTY_NAME_2));
    }

    @Test
    public void testOverrideProperties() {
        ReadOnlyProps defaultProps = new ReadOnlyProps(DEFAULT_PROPS_MAP);
        ReadOnlyProps readOnlyProps = new ReadOnlyProps(defaultProps, OVERRIDE_MAP.entrySet().iterator());
        Assert.assertEquals((Object)OVERRIDEN_VALUE_1, (Object)readOnlyProps.get(PROPERTY_NAME_1));
        Assert.assertEquals((Object)DEFAULT_VALUE_2, (Object)readOnlyProps.get(PROPERTY_NAME_2));
    }

    @Test
    public void testAddAllOverrideProperties() {
        ReadOnlyProps defaultProps = new ReadOnlyProps(DEFAULT_PROPS_MAP);
        Properties overrideProps = new Properties();
        overrideProps.setProperty(PROPERTY_NAME_1, OVERRIDEN_VALUE_1);
        ReadOnlyProps newProps = defaultProps.addAll(overrideProps);
        Assert.assertEquals((Object)OVERRIDEN_VALUE_1, (Object)newProps.get(PROPERTY_NAME_1));
        Assert.assertEquals((Object)DEFAULT_VALUE_2, (Object)newProps.get(PROPERTY_NAME_2));
    }

    @Test
    public void testOverridingNonDefaultProperties() {
        ReadOnlyProps defaultProps = new ReadOnlyProps(DEFAULT_PROPS_MAP);
        Properties props = new Properties();
        props.setProperty(PROPERTY_NAME_1, OVERRIDEN_VALUE_1);
        ReadOnlyProps nonDefaultProps = defaultProps.addAll(props);
        Properties overrideProps = new Properties();
        overrideProps.setProperty(PROPERTY_NAME_1, OVERRIDEN_VALUE_2);
        ReadOnlyProps newProps = nonDefaultProps.addAll(overrideProps);
        Assert.assertEquals((Object)OVERRIDEN_VALUE_2, (Object)newProps.get(PROPERTY_NAME_1));
        Assert.assertEquals((Object)DEFAULT_VALUE_2, (Object)newProps.get(PROPERTY_NAME_2));
    }
}

