/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.phoenix.end2end.ConnectionQueryServicesTestImpl;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.DelegateConnectionQueryServices;
import org.apache.phoenix.schema.PMetaData;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.PTableRef;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class PhoenixTestDriverIT
extends BaseTest {
    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap props = Maps.newHashMapWithExpectedSize((int)1);
        PhoenixTestDriverIT.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
    }

    @Test
    public void testSameCQSI() throws SQLException {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String url = QueryUtil.getConnectionUrl((Properties)props, (Configuration)config, (String)"client1");
        try (Connection conn1 = DriverManager.getConnection(url);
             Connection conn2 = DriverManager.getConnection(url);){
            ConnectionQueryServices cqs1 = conn1.unwrap(PhoenixConnection.class).getQueryServices();
            ConnectionQueryServices cqs2 = conn2.unwrap(PhoenixConnection.class).getQueryServices();
            Assert.assertNotNull((Object)cqs1);
            Assert.assertNotNull((Object)cqs2);
            Assert.assertEquals((String)"Connections using the same URL should have the same CQSI object.", (Object)cqs1, (Object)cqs2);
        }
    }

    @Test
    public void testDifferentCQSI() throws SQLException {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String url1 = QueryUtil.getConnectionUrl((Properties)props, (Configuration)config, (String)"client1");
        String url2 = QueryUtil.getConnectionUrl((Properties)props, (Configuration)config, (String)"client2");
        try (Connection conn1 = DriverManager.getConnection(url1);
             Connection conn2 = DriverManager.getConnection(url2);){
            ConnectionQueryServices cqs1 = conn1.unwrap(PhoenixConnection.class).getQueryServices();
            ConnectionQueryServices cqs2 = conn2.unwrap(PhoenixConnection.class).getQueryServices();
            Assert.assertNotNull((Object)cqs1);
            Assert.assertNotNull((Object)cqs2);
            Assert.assertNotEquals((String)"Connections using different URL should have different CQSI objects.", (Object)cqs1, (Object)cqs2);
        }
    }

    @Test
    public void testDifferentCQSICache() throws SQLException {
        PMetaData cache;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String url1 = QueryUtil.getConnectionUrl((Properties)props, (Configuration)config, (String)"client1");
        String url2 = QueryUtil.getConnectionUrl((Properties)props, (Configuration)config, (String)"client2");
        String tableName = PhoenixTestDriverIT.generateUniqueName();
        try (Connection conn1 = DriverManager.getConnection(url1);){
            conn1.createStatement().execute("CREATE TABLE " + tableName + "(k INTEGER NOT NULL PRIMARY KEY, v1 INTEGER)");
            cache = conn1.unwrap(PhoenixConnection.class).getQueryServices().getMetaDataCache();
            PTableRef pTableRef = cache.getTableRef(new PTableKey(null, tableName));
            Assert.assertNotNull((Object)pTableRef);
        }
        catch (TableNotFoundException e) {
            Assert.fail((String)"Table should have been found in CQSI cache.");
        }
        Connection conn2 = DriverManager.getConnection(url2);
        cache = conn2.unwrap(PhoenixConnection.class).getQueryServices().getMetaDataCache();
        try {
            cache.getTableRef(new PTableKey(null, tableName));
            Assert.fail((String)"Table should not have been found in CQSI cache.");
        }
        catch (TableNotFoundException tableNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testDifferentCQSForServerConnection() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String url = QueryUtil.getConnectionUrl((Properties)props, (Configuration)config);
        try (Connection conn1 = DriverManager.getConnection(url);
             Connection conn2 = QueryUtil.getConnectionOnServer((Properties)props, (Configuration)config);){
            ConnectionQueryServices cqs1 = conn1.unwrap(PhoenixConnection.class).getQueryServices();
            ConnectionQueryServices cqs2 = conn2.unwrap(PhoenixConnection.class).getQueryServices();
            if (cqs2 instanceof DelegateConnectionQueryServices) {
                cqs2 = ((DelegateConnectionQueryServices)cqs2).getDelegate();
            }
            Assert.assertTrue((boolean)(cqs1 instanceof ConnectionQueryServicesTestImpl));
            Assert.assertTrue((boolean)(cqs2 instanceof ConnectionQueryServicesTestImpl));
            Assert.assertNotEquals((String)"Server connection should have a different CQS.", (Object)cqs1, (Object)cqs2);
        }
    }
}

