/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.lang.reflect.Field;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixPreparedStatement;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.query.BaseConnectionlessQueryTest;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class PhoenixStatementTest
extends BaseConnectionlessQueryTest {
    private static Field connectionField;
    private static Field batchField;

    @Test
    public void testMutationUsingExecuteQueryShouldFail() throws Exception {
        Properties connectionProperties = new Properties();
        Connection connection = DriverManager.getConnection(PhoenixStatementTest.getUrl(), connectionProperties);
        Statement stmt = connection.createStatement();
        try {
            stmt.executeQuery("DELETE FROM " + ATABLE);
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.EXECUTE_QUERY_NOT_APPLICABLE.getErrorCode(), (long)e.getErrorCode());
        }
    }

    @Test
    public void testQueriesUsingExecuteUpdateShouldFail() throws Exception {
        Properties connectionProperties = new Properties();
        Connection connection = DriverManager.getConnection(PhoenixStatementTest.getUrl(), connectionProperties);
        Statement stmt = connection.createStatement();
        try {
            stmt.executeUpdate("SELECT * FROM " + ATABLE);
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.EXECUTE_UPDATE_NOT_APPLICABLE.getErrorCode(), (long)e.getErrorCode());
        }
    }

    @Test
    public void testSettingQueryTimeoutViaJdbc() throws Exception {
        Connection connection = DriverManager.getConnection(PhoenixStatementTest.getUrl());
        Statement stmt = connection.createStatement();
        PhoenixStatement phoenixStmt = stmt.unwrap(PhoenixStatement.class);
        stmt.setQueryTimeout(3);
        Assert.assertEquals((long)3L, (long)stmt.getQueryTimeout());
        Assert.assertEquals((long)3000L, (long)phoenixStmt.getQueryTimeoutInMillis());
    }

    @Test
    public void testSettingZeroQueryTimeoutViaJdbc() throws Exception {
        Connection connection = DriverManager.getConnection(PhoenixStatementTest.getUrl());
        Statement stmt = connection.createStatement();
        PhoenixStatement phoenixStmt = stmt.unwrap(PhoenixStatement.class);
        stmt.setQueryTimeout(0);
        Assert.assertEquals((long)2147483L, (long)stmt.getQueryTimeout());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)phoenixStmt.getQueryTimeoutInMillis());
    }

    @Test
    public void testSettingNegativeQueryTimeoutViaJdbc() throws Exception {
        Connection connection = DriverManager.getConnection(PhoenixStatementTest.getUrl());
        Statement stmt = connection.createStatement();
        PhoenixStatement phoenixStmt = stmt.unwrap(PhoenixStatement.class);
        PhoenixConnection phoenixConnection = connection.unwrap(PhoenixConnection.class);
        int defaultQueryTimeout = phoenixConnection.getQueryServices().getProps().getInt("phoenix.query.timeoutMs", 600000);
        stmt.setQueryTimeout(-1);
        Assert.assertEquals((long)(defaultQueryTimeout / 1000), (long)stmt.getQueryTimeout());
        Assert.assertEquals((long)defaultQueryTimeout, (long)phoenixStmt.getQueryTimeoutInMillis());
    }

    @Test
    public void testCustomQueryTimeout() throws Exception {
        Properties connectionProperties = new Properties();
        connectionProperties.setProperty("phoenix.query.timeoutMs", "2350");
        Connection connection = DriverManager.getConnection(PhoenixStatementTest.getUrl(), connectionProperties);
        Statement stmt = connection.createStatement();
        PhoenixStatement phoenixStmt = stmt.unwrap(PhoenixStatement.class);
        Assert.assertEquals((long)3L, (long)stmt.getQueryTimeout());
        Assert.assertEquals((long)2350L, (long)phoenixStmt.getQueryTimeoutInMillis());
    }

    @Test
    public void testZeroCustomQueryTimeout() throws Exception {
        Properties connectionProperties = new Properties();
        connectionProperties.setProperty("phoenix.query.timeoutMs", "0");
        Connection connection = DriverManager.getConnection(PhoenixStatementTest.getUrl(), connectionProperties);
        Statement stmt = connection.createStatement();
        PhoenixStatement phoenixStmt = stmt.unwrap(PhoenixStatement.class);
        Assert.assertEquals((long)0L, (long)stmt.getQueryTimeout());
        Assert.assertEquals((long)0L, (long)phoenixStmt.getQueryTimeoutInMillis());
    }

    @Test
    public void testExecuteBatchWithFailedStatement() throws Exception {
        Properties connectionProperties = new Properties();
        connectionProperties.setProperty("phoenix.query.timeoutMs", "0");
        Connection connection = DriverManager.getConnection(PhoenixStatementTest.getUrl(), connectionProperties);
        Statement stmt = connection.createStatement();
        PhoenixConnection connSpy = (PhoenixConnection)Mockito.spy((Object)connection.unwrap(PhoenixConnection.class));
        connectionField.set(stmt, connSpy);
        ArrayList batch = Lists.newArrayList((Object[])new PhoenixPreparedStatement[]{(PhoenixPreparedStatement)Mockito.mock(PhoenixPreparedStatement.class), (PhoenixPreparedStatement)Mockito.mock(PhoenixPreparedStatement.class), (PhoenixPreparedStatement)Mockito.mock(PhoenixPreparedStatement.class)});
        batchField.set(stmt, batch);
        String exMsg = "TEST";
        Mockito.when((Object)((PhoenixPreparedStatement)batch.get(0)).getUpdateCount()).thenReturn((Object)1);
        ((PhoenixPreparedStatement)Mockito.doThrow((Throwable[])new Throwable[]{new SQLException("TEST")}).when((Object)((PhoenixPreparedStatement)batch.get(1)))).executeForBatch();
        Mockito.when((Object)((PhoenixPreparedStatement)batch.get(1)).getUpdateCount()).thenReturn((Object)1);
        BatchUpdateException ex = (BatchUpdateException)Assert.assertThrows(BatchUpdateException.class, () -> stmt.executeBatch());
        Assert.assertEquals((Object)"TEST", (Object)ex.getCause().getMessage());
        int[] updateCounts = ex.getUpdateCounts();
        Assert.assertEquals((long)3L, (long)updateCounts.length);
        Assert.assertEquals((long)1L, (long)updateCounts[0]);
        Assert.assertEquals((long)-3L, (long)updateCounts[1]);
        Assert.assertEquals((long)-1L, (long)updateCounts[2]);
        ((PhoenixConnection)Mockito.verify((Object)connSpy, (VerificationMode)Mockito.never())).commit();
    }

    @Test
    public void testExecuteBatchWithCommitFailure() throws Exception {
        Properties connectionProperties = new Properties();
        connectionProperties.setProperty("phoenix.query.timeoutMs", "0");
        Connection connection = DriverManager.getConnection(PhoenixStatementTest.getUrl(), connectionProperties);
        Statement stmt = connection.createStatement();
        PhoenixConnection connSpy = (PhoenixConnection)Mockito.spy((Object)connection.unwrap(PhoenixConnection.class));
        connectionField.set(stmt, connSpy);
        ArrayList batch = Lists.newArrayList((Object[])new PhoenixPreparedStatement[]{(PhoenixPreparedStatement)Mockito.mock(PhoenixPreparedStatement.class)});
        batchField.set(stmt, batch);
        String exMsg = "TEST";
        ((PhoenixConnection)Mockito.doThrow((Throwable[])new Throwable[]{new SQLException("TEST")}).when((Object)connSpy)).commit();
        Mockito.when((Object)connSpy.getAutoCommit()).thenReturn((Object)true);
        BatchUpdateException ex = (BatchUpdateException)Assert.assertThrows(BatchUpdateException.class, () -> stmt.executeBatch());
        Assert.assertEquals((Object)"TEST", (Object)ex.getCause().getMessage());
        Assert.assertNull((Object)ex.getUpdateCounts());
    }

    @Test
    public void testRecursiveClose() throws SQLException {
        Connection connection = DriverManager.getConnection(PhoenixStatementTest.getUrl());
        Statement stmt1 = connection.createStatement();
        ResultSet rs11 = stmt1.executeQuery("select * from atable");
        rs11.close();
        Assert.assertTrue((boolean)rs11.isClosed());
        ResultSet rs12 = stmt1.executeQuery("select * from atable");
        stmt1.close();
        Assert.assertTrue((boolean)stmt1.isClosed());
        Assert.assertTrue((boolean)rs12.isClosed());
        Statement stmt2 = connection.createStatement();
        stmt2.closeOnCompletion();
        ResultSet rs21 = stmt2.executeQuery("select * from atable");
        rs21.close();
        Assert.assertTrue((boolean)stmt2.isClosed());
        Statement stmt3 = connection.createStatement();
        ResultSet rs31 = stmt3.executeQuery("select * from atable");
        stmt3.executeUpdate("upsert into ATABLE VALUES ('1', '2', '3')");
        Assert.assertTrue((boolean)rs31.isClosed());
        ResultSet rs32 = stmt3.executeQuery("select * from atable");
        ResultSet rs33 = stmt3.executeQuery("select * from atable");
        Assert.assertTrue((boolean)rs32.isClosed());
        Statement stmt4 = connection.createStatement();
        Statement stmt5 = connection.createStatement();
        ResultSet rs41 = stmt3.executeQuery("select * from atable");
        ResultSet rs51 = stmt3.executeQuery("select * from atable");
        connection.close();
        Assert.assertTrue((boolean)connection.isClosed());
        Assert.assertTrue((boolean)stmt4.isClosed());
        Assert.assertTrue((boolean)stmt5.isClosed());
        Assert.assertTrue((boolean)rs41.isClosed());
        Assert.assertTrue((boolean)rs51.isClosed());
    }

    static {
        try {
            connectionField = PhoenixStatement.class.getDeclaredField("connection");
            connectionField.setAccessible(true);
            batchField = PhoenixStatement.class.getDeclaredField("batch");
            batchField.setAccessible(true);
        }
        catch (NoSuchFieldException | SecurityException exception) {
            // empty catch block
        }
    }
}

