/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.phoenix.jdbc.PhoenixHAExecutorServiceProvider;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class PhoenixHAExecutorServiceProviderTest {
    private static final Properties properties = new Properties();

    @BeforeClass
    public static void setupBeforeClass() {
        properties.setProperty("phoenix.ha.max.pool.size", "2");
        properties.setProperty("phoenix.ha.max.queue.size", "5");
    }

    @AfterClass
    public static void afterClass() {
        PhoenixHAExecutorServiceProvider.resetExecutor();
    }

    @Before
    public void beforeTest() {
        PhoenixHAExecutorServiceProvider.resetExecutor();
        PhoenixHAExecutorServiceProvider.get((Properties)properties);
    }

    @After
    public void afterTest() {
        for (PhoenixHAExecutorServiceProvider.PhoenixHAClusterExecutorServices c : PhoenixHAExecutorServiceProvider.get((Properties)properties)) {
            c.getExecutorService().shutdownNow();
            c.getCloseExecutorService().shutdownNow();
        }
    }

    @Test
    public void testHAExecutorService1Capacity() {
        this.testHAExecutorServiceCapacity(0);
    }

    @Test
    public void testHAExecutorService2Capacity() {
        this.testHAExecutorServiceCapacity(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testHAExecutorServiceCapacity(int index) {
        Properties props = new Properties();
        props.setProperty("phoenix.ha.threadpool.queue.backoff.threshold", "0.5");
        ThreadPoolExecutor es = (ThreadPoolExecutor)((PhoenixHAExecutorServiceProvider.PhoenixHAClusterExecutorServices)PhoenixHAExecutorServiceProvider.get((Properties)properties).get(index)).getExecutorService();
        Object obj = new Object();
        CompletableFuture.runAsync(this.getWaitingRunnable(obj), es);
        CompletableFuture.runAsync(this.getWaitingRunnable(obj), es);
        Assert.assertEquals((long)es.getQueue().size(), (long)0L);
        CompletableFuture.runAsync(this.getWaitingRunnable(obj), es);
        CompletableFuture.runAsync(this.getWaitingRunnable(obj), es);
        Assert.assertTrue((boolean)((Boolean)PhoenixHAExecutorServiceProvider.hasCapacity((Properties)props).get(index)));
        CompletableFuture.runAsync(this.getWaitingRunnable(obj), es);
        Assert.assertFalse((boolean)((Boolean)PhoenixHAExecutorServiceProvider.hasCapacity((Properties)props).get(index)));
        Object object = obj;
        synchronized (object) {
            obj.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHAExecutorServiceQueuing() {
        ThreadPoolExecutor es = (ThreadPoolExecutor)((PhoenixHAExecutorServiceProvider.PhoenixHAClusterExecutorServices)PhoenixHAExecutorServiceProvider.get((Properties)properties).get(0)).getExecutorService();
        Object obj = new Object();
        CompletableFuture.runAsync(this.getWaitingRunnable(obj), es);
        Assert.assertEquals((long)es.getQueue().size(), (long)0L);
        CompletableFuture.runAsync(this.getWaitingRunnable(obj), es);
        Assert.assertEquals((long)es.getQueue().size(), (long)0L);
        CompletableFuture.runAsync(this.getWaitingRunnable(obj), es);
        Assert.assertEquals((long)es.getQueue().size(), (long)1L);
        Object object = obj;
        synchronized (object) {
            obj.notifyAll();
        }
    }

    @Test
    public void testHAExecutorServiceCloserConfigured() {
        ThreadPoolExecutor es1 = (ThreadPoolExecutor)((PhoenixHAExecutorServiceProvider.PhoenixHAClusterExecutorServices)PhoenixHAExecutorServiceProvider.get((Properties)properties).get(0)).getCloseExecutorService();
        ThreadPoolExecutor es2 = (ThreadPoolExecutor)((PhoenixHAExecutorServiceProvider.PhoenixHAClusterExecutorServices)PhoenixHAExecutorServiceProvider.get((Properties)properties).get(1)).getCloseExecutorService();
        int expectedPoolSize = Integer.valueOf("15");
        Assert.assertEquals((long)expectedPoolSize, (long)es1.getMaximumPoolSize());
        Assert.assertEquals((long)expectedPoolSize, (long)es2.getMaximumPoolSize());
        Assert.assertNotEquals((Object)es1, (Object)es2);
    }

    private Runnable getWaitingRunnable(Object obj) {
        return () -> {
            Object object = obj;
            synchronized (object) {
                try {
                    obj.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }
}

