/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.GetDataBuilder;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.phoenix.jdbc.ClusterRoleRecord;
import org.apache.phoenix.jdbc.ClusterRoleRecordTest;
import org.apache.phoenix.jdbc.HighAvailabilityPolicy;
import org.apache.phoenix.jdbc.PhoenixHAAdmin;
import org.apache.phoenix.jdbc.PhoenixHAAdminTool;
import org.apache.zookeeper.KeeperException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoenixHAAdminToolTest {
    private static final Logger LOG = LoggerFactory.getLogger(PhoenixHAAdminToolTest.class);
    private static final String ZK1 = "zk1:2181:/hbase";
    private static final String ZK2 = "zk2:2181:/hbase";
    private static final PrintStream STDOUT = System.out;
    private static final ByteArrayOutputStream STDOUT_CAPTURE = new ByteArrayOutputStream();
    private final PhoenixHAAdmin.HighAvailibilityCuratorProvider mockHighAvailibilityCuratorProvider = (PhoenixHAAdmin.HighAvailibilityCuratorProvider)Mockito.mock(PhoenixHAAdmin.HighAvailibilityCuratorProvider.class);
    private final CuratorFramework curator = (CuratorFramework)Mockito.mock(CuratorFramework.class);
    private final PhoenixHAAdmin admin = new PhoenixHAAdmin("zk1:2181:/hbase", new Configuration(), this.mockHighAvailibilityCuratorProvider);
    private String haGroupName;
    private ClusterRoleRecord recordV1;
    @Rule
    public final TestName testName = new TestName();

    @Before
    public void setup() throws Exception {
        Mockito.when((Object)this.mockHighAvailibilityCuratorProvider.getCurator(Mockito.anyString(), (Properties)ArgumentMatchers.any(Properties.class))).thenReturn((Object)this.curator);
        this.haGroupName = this.testName.getMethodName();
        this.recordV1 = new ClusterRoleRecord(this.haGroupName, HighAvailabilityPolicy.FAILOVER, ZK1, ClusterRoleRecord.ClusterRole.ACTIVE, ZK2, ClusterRoleRecord.ClusterRole.STANDBY, 1L);
        this.saveRecordV1ToZk();
    }

    @After
    public void after() {
        System.setOut(STDOUT);
    }

    @Test
    public void testCommandLineOption() throws Exception {
        String[] args = new String[]{"-m"};
        int ret = ToolRunner.run((Tool)new PhoenixHAAdminTool(), (String[])args);
        Assert.assertEquals((long)1L, (long)ret);
        args = new String[]{"-l", "-m", "cluster-role-records.yaml"};
        ret = ToolRunner.run((Tool)new PhoenixHAAdminTool(), (String[])args);
        Assert.assertEquals((long)1L, (long)ret);
        args = new String[]{"-l", "-F"};
        ret = ToolRunner.run((Tool)new PhoenixHAAdminTool(), (String[])args);
        Assert.assertEquals((long)1L, (long)ret);
        args = new String[]{"-l", "-r"};
        ret = ToolRunner.run((Tool)new PhoenixHAAdminTool(), (String[])args);
        Assert.assertEquals((long)1L, (long)ret);
        args = new String[]{"-m", "cluster-role-records.yaml", "-r"};
        ret = ToolRunner.run((Tool)new PhoenixHAAdminTool(), (String[])args);
        Assert.assertEquals((long)1L, (long)ret);
    }

    @Test
    public void testReadRecordsFromFileJson() throws Exception {
        String fileName = ClusterRoleRecordTest.createJsonFileWithRecords(this.recordV1);
        List records = new PhoenixHAAdminTool().readRecordsFromFile(fileName);
        Assert.assertEquals((long)1L, (long)records.size());
        Assert.assertTrue((boolean)records.contains(this.recordV1));
        String haGroupName2 = this.haGroupName + RandomStringUtils.randomAlphabetic((int)3);
        ClusterRoleRecord record2 = new ClusterRoleRecord(haGroupName2, HighAvailabilityPolicy.FAILOVER, ZK1, ClusterRoleRecord.ClusterRole.ACTIVE, ZK2, ClusterRoleRecord.ClusterRole.STANDBY, 1L);
        String fileName2 = ClusterRoleRecordTest.createJsonFileWithRecords(this.recordV1, record2);
        List records2 = new PhoenixHAAdminTool().readRecordsFromFile(fileName2);
        Assert.assertEquals((long)2L, (long)records2.size());
        Assert.assertTrue((boolean)records2.contains(this.recordV1));
        Assert.assertTrue((boolean)records2.contains(record2));
    }

    @Test
    public void testCreateIfNotExist() throws Exception {
        GetDataBuilder getDataBuilder = (GetDataBuilder)Mockito.mock(GetDataBuilder.class);
        Mockito.when((Object)((byte[])getDataBuilder.forPath(ArgumentMatchers.anyString()))).thenThrow(new Throwable[]{new KeeperException.NoNodeException()});
        Mockito.when((Object)this.curator.getData()).thenReturn((Object)getDataBuilder);
        try {
            this.admin.createOrUpdateDataOnZookeeper(this.recordV1);
        }
        catch (Exception e) {
            LOG.info("Got expected exception when creating the node without mocking it fully", (Throwable)e);
        }
        ((CuratorFramework)Mockito.verify((Object)this.curator, (VerificationMode)Mockito.atLeastOnce())).create();
    }

    @Ignore
    @Test
    public void testUpdate() throws Exception {
        boolean result = false;
        this.saveRecordV1ToZk();
        ClusterRoleRecord recordV2 = new ClusterRoleRecord(this.haGroupName, HighAvailabilityPolicy.FAILOVER, ZK1, ClusterRoleRecord.ClusterRole.STANDBY, ZK2, ClusterRoleRecord.ClusterRole.STANDBY, 2L);
        try {
            result = this.admin.createOrUpdateDataOnZookeeper(recordV2);
        }
        catch (Exception e) {
            LOG.info("Got expected exception when creating the node without mocking it fully", (Throwable)e);
        }
        ((CuratorFramework)Mockito.verify((Object)this.curator, (VerificationMode)Mockito.never())).create();
        ((CuratorFramework)Mockito.verify((Object)this.curator, (VerificationMode)Mockito.atLeastOnce())).newNamespaceAwareEnsurePath(ArgumentMatchers.contains((String)this.haGroupName));
    }

    @Test
    public void testRejectLowerVersionRecord() throws Exception {
        this.saveRecordV1ToZk();
        ClusterRoleRecord recordV0 = new ClusterRoleRecord(this.haGroupName, HighAvailabilityPolicy.FAILOVER, ZK1, ClusterRoleRecord.ClusterRole.STANDBY, ZK2, ClusterRoleRecord.ClusterRole.STANDBY, 0L);
        Assert.assertFalse((boolean)this.admin.createOrUpdateDataOnZookeeper(recordV0));
        ((CuratorFramework)Mockito.verify((Object)this.curator, (VerificationMode)Mockito.never())).setData();
        ((CuratorFramework)Mockito.verify((Object)this.curator, (VerificationMode)Mockito.never())).create();
    }

    @Test
    public void testRejectInconsistentData() throws Exception {
        this.saveRecordV1ToZk();
        ClusterRoleRecord record2 = new ClusterRoleRecord(this.haGroupName, HighAvailabilityPolicy.FAILOVER, ZK1, ClusterRoleRecord.ClusterRole.STANDBY, ZK2, ClusterRoleRecord.ClusterRole.STANDBY, 1L);
        try {
            this.admin.createOrUpdateDataOnZookeeper(record2);
        }
        catch (IOException e) {
            LOG.info("Got expected exception in case of inconsistent record data", (Throwable)e);
            Assert.assertTrue((boolean)e.getMessage().contains("inconsistent"));
        }
    }

    @Test
    public void testHelpMessage() throws Exception {
        System.setOut(new PrintStream(STDOUT_CAPTURE));
        int ret = new PhoenixHAAdminTool().run(new String[]{"-h"});
        Assert.assertEquals((long)0L, (long)ret);
        PhoenixHAAdminTool.OPTIONS.getOptions().forEach(o -> Assert.assertTrue((boolean)STDOUT_CAPTURE.toString().contains(o.getLongOpt())));
    }

    @Test
    public void testGetZookeeperQuorum() {
        Configuration conf = HBaseConfiguration.create();
        String localZk = String.format("127.0.0.1:%d:%s", 2181, "/hbase");
        Assert.assertEquals((Object)localZk, (Object)PhoenixHAAdmin.getLocalZkUrl((Configuration)conf));
        String host = "foobar";
        conf.set("hbase.zookeeper.quorum", "foobar");
        String expectedLocalZk = String.format("%s:%d:%s", "foobar", 2181, "/hbase");
        Assert.assertEquals((Object)expectedLocalZk, (Object)PhoenixHAAdmin.getLocalZkUrl((Configuration)conf));
        int port = 21810;
        conf.setInt("hbase.zookeeper.property.clientPort", 21810);
        String expectedLocalZk2 = String.format("%s:%d:%s", "foobar", 21810, "/hbase");
        Assert.assertEquals((Object)expectedLocalZk2, (Object)PhoenixHAAdmin.getLocalZkUrl((Configuration)conf));
        String znode = "/hbase2";
        conf.set("zookeeper.znode.parent", "/hbase2");
        String expectedLocalZk3 = String.format("%s:%d:%s", "foobar", 21810, "/hbase2");
        Assert.assertEquals((Object)expectedLocalZk3, (Object)PhoenixHAAdmin.getLocalZkUrl((Configuration)conf));
        conf.set("hbase.zookeeper.quorum", "");
        try {
            PhoenixHAAdmin.getLocalZkUrl((Configuration)conf);
            Assert.fail((String)"Should have failed because hbase.zookeeper.quorum is not set");
        }
        catch (IllegalArgumentException e) {
            LOG.info("Got expected exception when no ZK quorum is set", (Throwable)e);
        }
        String invalidPort = "invalidPort";
        conf.set("hbase.zookeeper.property.clientPort", "invalidPort");
        try {
            PhoenixHAAdmin.getLocalZkUrl((Configuration)conf);
            Assert.fail((String)("Should have failed because port " + invalidPort + " is invalid"));
        }
        catch (IllegalArgumentException e) {
            LOG.info("Got expected exception because port {} is invalid", (Object)invalidPort, (Object)e);
        }
    }

    private void saveRecordV1ToZk() throws Exception {
        GetDataBuilder getDataBuilder = (GetDataBuilder)Mockito.mock(GetDataBuilder.class);
        Mockito.when((Object)((byte[])getDataBuilder.forPath(ArgumentMatchers.anyString()))).thenReturn((Object)ClusterRoleRecord.toJson((ClusterRoleRecord)this.recordV1));
        Mockito.when((Object)this.curator.getData()).thenReturn((Object)getDataBuilder);
    }
}

