/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Optional;
import java.util.Properties;
import org.apache.curator.framework.CuratorFramework;
import org.apache.hadoop.hbase.GenericTestUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.jdbc.ClusterRoleRecord;
import org.apache.phoenix.jdbc.ClusterRoleRecordTest;
import org.apache.phoenix.jdbc.HighAvailabilityGroup;
import org.apache.phoenix.jdbc.HighAvailabilityPolicy;
import org.apache.phoenix.jdbc.HighAvailabilityTestingUtility;
import org.apache.phoenix.jdbc.PhoenixHAAdminTool;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={NeedsOwnMiniClusterTest.class})
public class PhoenixHAAdminToolIT {
    private static final Logger LOG = LoggerFactory.getLogger(PhoenixHAAdminToolIT.class);
    private static final HighAvailabilityTestingUtility.HBaseTestingUtilityPair CLUSTERS = new HighAvailabilityTestingUtility.HBaseTestingUtilityPair();
    private static final PrintStream STDOUT = System.out;
    private static final ByteArrayOutputStream STDOUT_CAPTURE = new ByteArrayOutputStream();
    private String haGroupName;
    private ClusterRoleRecord recordV1;
    private ClusterRoleRecord recordV2;
    private PhoenixHAAdminTool admin;
    @Rule
    public final TestName testName = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        CLUSTERS.start();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        PhoenixHAAdminToolIT.getCurator1().close();
        PhoenixHAAdminToolIT.getCurator2().close();
        CLUSTERS.close();
    }

    @Before
    public void setup() throws Exception {
        this.admin = new PhoenixHAAdminTool();
        this.admin.setConf(CLUSTERS.getHBaseCluster1().getConfiguration());
        this.haGroupName = this.testName.getMethodName();
        this.recordV1 = new ClusterRoleRecord(this.haGroupName, HighAvailabilityPolicy.FAILOVER, CLUSTERS.getZkUrl1(), ClusterRoleRecord.ClusterRole.ACTIVE, CLUSTERS.getZkUrl2(), ClusterRoleRecord.ClusterRole.STANDBY, 1L);
        String jsonFileName = ClusterRoleRecordTest.createJsonFileWithRecords(this.recordV1);
        int ret = this.admin.run(new String[]{"-m", jsonFileName});
        if (ret != 0) {
            throw new RuntimeException("Failed to create initial records");
        }
        this.recordV2 = new ClusterRoleRecord(this.haGroupName, HighAvailabilityPolicy.FAILOVER, CLUSTERS.getZkUrl1(), ClusterRoleRecord.ClusterRole.STANDBY, CLUSTERS.getZkUrl2(), ClusterRoleRecord.ClusterRole.ACTIVE, 2L);
    }

    @After
    public void after() {
        System.setOut(STDOUT);
    }

    @Test(timeout=180000L)
    public void testCreateDataOnZookeeper() throws Exception {
        PhoenixHAAdminToolIT.doVerifyClusterRole(this.recordV1);
    }

    @Test(timeout=180000L)
    public void testUpdateSameDataOnZookeeper() throws Exception {
        String jsonFileName = ClusterRoleRecordTest.createJsonFileWithRecords(this.recordV1);
        int ret = this.admin.run(new String[]{"-m", jsonFileName});
        Assert.assertEquals((long)0L, (long)ret);
        PhoenixHAAdminToolIT.doVerifyClusterRole(this.recordV1);
    }

    @Test(timeout=180000L)
    public void testUpdateDataOnZookeeper() throws Exception {
        String jsonFileName = ClusterRoleRecordTest.createJsonFileWithRecords(this.recordV2);
        int ret = this.admin.run(new String[]{"-m", jsonFileName});
        Assert.assertEquals((long)0L, (long)ret);
        PhoenixHAAdminToolIT.doVerifyClusterRole(this.recordV2);
    }

    @Test(timeout=180000L)
    public void testCreateOrUpdateDataOnZookeeperForMultipleHAGroups() throws Exception {
        String haGroupName2 = this.haGroupName + "2";
        ClusterRoleRecord record2 = new ClusterRoleRecord(haGroupName2, HighAvailabilityPolicy.FAILOVER, CLUSTERS.getZkUrl1(), ClusterRoleRecord.ClusterRole.ACTIVE, CLUSTERS.getZkUrl2(), ClusterRoleRecord.ClusterRole.STANDBY, 1L);
        String jsonFileName = ClusterRoleRecordTest.createJsonFileWithRecords(this.recordV2, record2);
        int ret = this.admin.run(new String[]{"-m", jsonFileName});
        Assert.assertEquals((long)0L, (long)ret);
        PhoenixHAAdminToolIT.doVerifyClusterRole(this.recordV2);
        PhoenixHAAdminToolIT.doVerifyClusterRole(record2);
    }

    @Test(timeout=180000L)
    public void testListAllClusterRoleRecordsOnZookeeper() throws Exception {
        System.setOut(new PrintStream(STDOUT_CAPTURE));
        int ret = this.admin.run(new String[]{"-l"});
        Assert.assertEquals((long)0L, (long)ret);
        this.assertStdoutShouldHaveHaGroup(this.recordV1);
    }

    private void assertStdoutShouldHaveHaGroup(ClusterRoleRecord record) {
        LOG.info("Got stdout: \n++++++++\n{}++++++++\n", (Object)STDOUT_CAPTURE.toString());
        Assert.assertTrue((boolean)STDOUT_CAPTURE.toString().contains(record.getHaGroupName()));
    }

    @Test(timeout=180000L)
    public void testRepair() throws Exception {
        int ret = this.admin.run(new String[]{"--repair"});
        Assert.assertEquals((long)0L, (long)ret);
        String zpath = "/" + this.haGroupName;
        this.getCurator1().setData().forPath(zpath, ClusterRoleRecord.toJson((ClusterRoleRecord)this.recordV2));
        PhoenixHAAdminToolIT.doVerifyClusterRole(PhoenixHAAdminToolIT.getCurator1(), this.recordV2);
        PhoenixHAAdminToolIT.doVerifyClusterRole(this.getCurator2(), this.recordV1);
        ret = this.admin.run(new String[]{"--repair"});
        Assert.assertEquals((long)0L, (long)ret);
        PhoenixHAAdminToolIT.doVerifyClusterRole(PhoenixHAAdminToolIT.getCurator1(), this.recordV2);
        PhoenixHAAdminToolIT.doVerifyClusterRole(PhoenixHAAdminToolIT.getCurator2(), this.recordV2);
        ClusterRoleRecord recordV3 = new ClusterRoleRecord(this.haGroupName, HighAvailabilityPolicy.FAILOVER, CLUSTERS.getZkUrl1(), ClusterRoleRecord.ClusterRole.ACTIVE, CLUSTERS.getZkUrl2(), ClusterRoleRecord.ClusterRole.STANDBY, 3L);
        PhoenixHAAdminToolIT.getCurator2().setData().forPath(zpath, ClusterRoleRecord.toJson((ClusterRoleRecord)recordV3));
        PhoenixHAAdminToolIT.doVerifyClusterRole(PhoenixHAAdminToolIT.getCurator1(), this.recordV2);
        PhoenixHAAdminToolIT.doVerifyClusterRole(PhoenixHAAdminToolIT.getCurator2(), recordV3);
        ret = this.admin.run(new String[]{"--repair"});
        Assert.assertEquals((long)0L, (long)ret);
        PhoenixHAAdminToolIT.doVerifyClusterRole(PhoenixHAAdminToolIT.getCurator1(), recordV3);
        PhoenixHAAdminToolIT.doVerifyClusterRole(PhoenixHAAdminToolIT.getCurator2(), recordV3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testRepairGotInconsistentRecords() throws Exception {
        String zpath = "/" + this.haGroupName;
        try {
            ClusterRoleRecord recordDifferent = new ClusterRoleRecord(this.haGroupName, HighAvailabilityPolicy.PARALLEL, CLUSTERS.getZkUrl1(), ClusterRoleRecord.ClusterRole.STANDBY, CLUSTERS.getZkUrl2(), ClusterRoleRecord.ClusterRole.STANDBY, 1L);
            PhoenixHAAdminToolIT.getCurator1().setData().forPath(zpath, ClusterRoleRecord.toJson((ClusterRoleRecord)recordDifferent));
            PhoenixHAAdminToolIT.doVerifyClusterRole(PhoenixHAAdminToolIT.getCurator1(), recordDifferent);
            System.setOut(new PrintStream(STDOUT_CAPTURE));
            int ret = ToolRunner.run((Tool)this.admin, (String[])new String[]{"--repair"});
            Assert.assertEquals((long)3L, (long)ret);
            this.assertStdoutShouldHaveHaGroup(this.recordV1);
        }
        finally {
            PhoenixHAAdminToolIT.getCurator1().setData().forPath(zpath, ClusterRoleRecord.toJson((ClusterRoleRecord)this.recordV1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testUpdateDataOnZookeeperShouldFailWhenActiveZkClusterDown() throws Exception {
        System.setOut(new PrintStream(STDOUT_CAPTURE));
        int zkClientPort = CLUSTERS.getHBaseCluster1().getZkCluster().getClientPort();
        try {
            LOG.info("Shutting down the first HBase cluster...");
            CLUSTERS.getHBaseCluster1().shutdownMiniZKCluster();
            String jsonFileName = ClusterRoleRecordTest.createJsonFileWithRecords(this.recordV2);
            int ret = this.admin.run(new String[]{"-m", jsonFileName});
            Assert.assertEquals((long)2L, (long)ret);
            this.assertStdoutShouldHaveHaGroup(this.recordV1);
            PhoenixHAAdminToolIT.doVerifyClusterRole(PhoenixHAAdminToolIT.getCurator2(), this.recordV1);
        }
        catch (Throwable throwable) {
            CLUSTERS.getHBaseCluster1().startMiniZKCluster(1, new int[]{zkClientPort});
            throw throwable;
        }
        CLUSTERS.getHBaseCluster1().startMiniZKCluster(1, new int[]{zkClientPort});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testUpdateDataOnZookeeperForcefulWhenActiveZKClusterDown() throws Exception {
        System.setOut(new PrintStream(STDOUT_CAPTURE));
        int zkClientPort = CLUSTERS.getHBaseCluster1().getZkCluster().getClientPort();
        try {
            LOG.info("Shutting down the first HBase cluster...");
            CLUSTERS.getHBaseCluster1().shutdownMiniZKCluster();
            String jsonFileName = ClusterRoleRecordTest.createJsonFileWithRecords(this.recordV2);
            int ret = this.admin.run(new String[]{"-m", jsonFileName, "-F"});
            Assert.assertEquals((long)2L, (long)ret);
            this.assertStdoutShouldHaveHaGroup(this.recordV2);
            PhoenixHAAdminToolIT.doVerifyClusterRole(PhoenixHAAdminToolIT.getCurator2(), this.recordV2);
        }
        catch (Throwable throwable) {
            CLUSTERS.getHBaseCluster1().startMiniZKCluster(1, new int[]{zkClientPort});
            throw throwable;
        }
        CLUSTERS.getHBaseCluster1().startMiniZKCluster(1, new int[]{zkClientPort});
    }

    private static void doVerifyClusterRole(ClusterRoleRecord clusterRoleRecord) throws Exception {
        PhoenixHAAdminToolIT.doVerifyClusterRole(PhoenixHAAdminToolIT.getCurator1(), clusterRoleRecord);
        PhoenixHAAdminToolIT.doVerifyClusterRole(PhoenixHAAdminToolIT.getCurator2(), clusterRoleRecord);
    }

    private static void doVerifyClusterRole(CuratorFramework curator, ClusterRoleRecord clusterRoleRecord) throws Exception {
        GenericTestUtils.waitFor(() -> {
            try {
                String path = "/" + clusterRoleRecord.getHaGroupName();
                byte[] data = (byte[])curator.getData().forPath(path);
                Optional recordFromZk = ClusterRoleRecord.fromJson((byte[])data);
                return recordFromZk.isPresent() && ((ClusterRoleRecord)recordFromZk.get()).equals((Object)clusterRoleRecord);
            }
            catch (Exception e) {
                LOG.info("Got exception while waiting for znode is up to date: {}", (Object)e.getMessage());
                return false;
            }
        }, (int)1000, (int)15000);
    }

    private static CuratorFramework getCurator1() throws IOException {
        return HighAvailabilityGroup.getCurator((String)CLUSTERS.getZkUrl1(), (Properties)new Properties());
    }

    private static CuratorFramework getCurator2() throws IOException {
        return HighAvailabilityGroup.getCurator((String)CLUSTERS.getZkUrl2(), (Properties)new Properties());
    }
}

