/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.phoenix.jdbc.HAURLInfo;
import org.apache.phoenix.jdbc.HighAvailabilityTestingUtility;
import org.apache.phoenix.jdbc.ParallelPhoenixContext;
import org.apache.phoenix.jdbc.ParallelPhoenixResultSet;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class ParallelPhoenixResultSetTest {
    CompletableFuture<ResultSet> completableRs1;
    CompletableFuture<ResultSet> completableRs2;
    ParallelPhoenixResultSet resultSet;

    @Before
    public void init() {
        this.completableRs1 = (CompletableFuture)Mockito.mock(CompletableFuture.class);
        this.completableRs2 = (CompletableFuture)Mockito.mock(CompletableFuture.class);
        this.resultSet = new ParallelPhoenixResultSet(new ParallelPhoenixContext(new Properties(), null, HighAvailabilityTestingUtility.getListOfSingleThreadExecutorServices(), null, (HAURLInfo)Mockito.mock(HAURLInfo.class)), this.completableRs1, this.completableRs2);
    }

    @Test
    public void testUnbound() throws SQLException {
        ResultSet rs = this.resultSet.getResultSet();
        Assert.assertNull((Object)rs);
    }

    @Test
    public void testNextBound() throws SQLException {
        ResultSet rs = (ResultSet)Mockito.mock(ResultSet.class);
        this.resultSet.setResultSet(rs);
        this.resultSet.next();
        ((ResultSet)Mockito.verify((Object)rs)).next();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{rs});
    }

    @Test
    public void testRS1WinsNext() throws Exception {
        ResultSet rs1 = (ResultSet)Mockito.mock(ResultSet.class);
        ResultSet rs2 = (ResultSet)Mockito.mock(ResultSet.class);
        Executor rsExecutor2 = (Executor)Mockito.mock(Executor.class);
        CountDownLatch latch = new CountDownLatch(1);
        ((Executor)Mockito.doAnswer(invocation -> {
            Thread thread = new Thread(() -> {
                try {
                    latch.await(5L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException();
                }
                ((Runnable)invocation.getArguments()[0]).run();
            });
            thread.start();
            return null;
        }).when((Object)rsExecutor2)).execute((Runnable)ArgumentMatchers.any(Runnable.class));
        this.completableRs1 = CompletableFuture.completedFuture(rs1);
        this.completableRs2 = CompletableFuture.supplyAsync(() -> rs2, rsExecutor2);
        this.resultSet = new ParallelPhoenixResultSet(new ParallelPhoenixContext(new Properties(), null, HighAvailabilityTestingUtility.getListOfSingleThreadExecutorServices(), null, (HAURLInfo)Mockito.mock(HAURLInfo.class)), this.completableRs1, this.completableRs2);
        this.resultSet.next();
        Assert.assertEquals((Object)rs1, (Object)this.resultSet.getResultSet());
    }

    @Test
    public void testRS2WinsNext() throws Exception {
        ResultSet rs1 = (ResultSet)Mockito.mock(ResultSet.class);
        ResultSet rs2 = (ResultSet)Mockito.mock(ResultSet.class);
        Executor rsExecutor1 = (Executor)Mockito.mock(Executor.class);
        CountDownLatch latch = new CountDownLatch(1);
        ((Executor)Mockito.doAnswer(invocation -> {
            Thread thread = new Thread(() -> {
                try {
                    latch.await(5L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException();
                }
                ((Runnable)invocation.getArguments()[0]).run();
            });
            thread.start();
            return null;
        }).when((Object)rsExecutor1)).execute((Runnable)ArgumentMatchers.any(Runnable.class));
        this.completableRs1 = CompletableFuture.supplyAsync(() -> rs1, rsExecutor1);
        this.completableRs2 = CompletableFuture.completedFuture(rs2);
        this.resultSet = new ParallelPhoenixResultSet(new ParallelPhoenixContext(new Properties(), null, HighAvailabilityTestingUtility.getListOfSingleThreadExecutorServices(), null, (HAURLInfo)Mockito.mock(HAURLInfo.class)), this.completableRs1, this.completableRs2);
        this.resultSet.next();
        Assert.assertEquals((Object)rs2, (Object)this.resultSet.getResultSet());
    }

    @Test
    public void testRS1FailsImmediatelyNext() throws Exception {
        ResultSet rs2 = (ResultSet)Mockito.mock(ResultSet.class);
        Executor rsExecutor2 = (Executor)Mockito.mock(Executor.class);
        CountDownLatch latch = new CountDownLatch(1);
        ((Executor)Mockito.doAnswer(invocation -> {
            Thread thread = new Thread(() -> {
                try {
                    latch.await(5L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException();
                }
                ((Runnable)invocation.getArguments()[0]).run();
            });
            thread.start();
            return null;
        }).when((Object)rsExecutor2)).execute((Runnable)ArgumentMatchers.any(Runnable.class));
        this.completableRs1 = new CompletableFuture();
        this.completableRs1.completeExceptionally(new RuntimeException("Failure"));
        this.completableRs2 = CompletableFuture.supplyAsync(() -> rs2, rsExecutor2);
        this.resultSet = new ParallelPhoenixResultSet(new ParallelPhoenixContext(new Properties(), null, HighAvailabilityTestingUtility.getListOfSingleThreadExecutorServices(), null, (HAURLInfo)Mockito.mock(HAURLInfo.class)), this.completableRs1, this.completableRs2);
        this.resultSet.next();
        Assert.assertEquals((Object)rs2, (Object)this.resultSet.getResultSet());
    }

    @Test
    public void testRS1SucceedsDuringNext() throws Exception {
        ResultSet rs1 = (ResultSet)Mockito.mock(ResultSet.class);
        ResultSet rs2 = (ResultSet)Mockito.mock(ResultSet.class);
        Executor rsExecutor1 = (Executor)Mockito.mock(Executor.class);
        Executor rsExecutor2 = (Executor)Mockito.mock(Executor.class);
        CountDownLatch latch0 = new CountDownLatch(1);
        CountDownLatch latch1 = new CountDownLatch(1);
        CountDownLatch latch2 = new CountDownLatch(1);
        CountDownLatch latch3 = new CountDownLatch(1);
        ((Executor)Mockito.doAnswer(invocation -> {
            Thread thread = new Thread(() -> {
                try {
                    latch1.await(10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException();
                }
                ((Runnable)invocation.getArguments()[0]).run();
            });
            thread.start();
            return null;
        }).when((Object)rsExecutor1)).execute((Runnable)ArgumentMatchers.any(Runnable.class));
        ((Executor)Mockito.doAnswer(invocation -> {
            Thread thread = new Thread(() -> {
                try {
                    latch2.await(10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException();
                }
                ((Runnable)invocation.getArguments()[0]).run();
            });
            thread.start();
            return null;
        }).when((Object)rsExecutor2)).execute((Runnable)ArgumentMatchers.any(Runnable.class));
        this.completableRs1 = CompletableFuture.supplyAsync(() -> rs1, rsExecutor1);
        this.completableRs2 = CompletableFuture.supplyAsync(() -> rs2, rsExecutor2);
        this.resultSet = new ParallelPhoenixResultSet(new ParallelPhoenixContext(new Properties(), null, HighAvailabilityTestingUtility.getListOfSingleThreadExecutorServices(), null, (HAURLInfo)Mockito.mock(HAURLInfo.class)), this.completableRs1, this.completableRs2);
        ExecutorService testService = Executors.newSingleThreadExecutor();
        testService.execute(() -> {
            try {
                latch0.countDown();
                this.resultSet.next();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            finally {
                latch3.countDown();
            }
        });
        latch0.await(10L, TimeUnit.SECONDS);
        latch1.countDown();
        latch3.await(10L, TimeUnit.SECONDS);
        Assert.assertEquals((Object)rs1, (Object)this.resultSet.getResultSet());
        latch2.countDown();
    }
}

