/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.phoenix.jdbc.HAURLInfo;
import org.apache.phoenix.jdbc.HighAvailabilityGroup;
import org.apache.phoenix.jdbc.HighAvailabilityTestingUtility;
import org.apache.phoenix.jdbc.ParallelPhoenixContext;
import org.apache.phoenix.jdbc.ParallelPhoenixPreparedStatement;
import org.apache.phoenix.jdbc.ParallelPhoenixResultSet;
import org.apache.phoenix.jdbc.PhoenixMonitoredPreparedStatement;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class ParallelPhoenixPreparedStatementTest {
    ParallelPhoenixContext context;
    CompletableFuture<PhoenixMonitoredPreparedStatement> future1;
    CompletableFuture<PhoenixMonitoredPreparedStatement> future2;
    PhoenixMonitoredPreparedStatement statement1;
    PhoenixMonitoredPreparedStatement statement2;
    ParallelPhoenixPreparedStatement phoenixPreparedStatement;

    @Before
    public void init() throws Exception {
        this.context = new ParallelPhoenixContext(new Properties(), (HighAvailabilityGroup)Mockito.mock(HighAvailabilityGroup.class), HighAvailabilityTestingUtility.getListOfSingleThreadExecutorServices(), null, (HAURLInfo)Mockito.mock(HAURLInfo.class));
        this.statement1 = (PhoenixMonitoredPreparedStatement)Mockito.mock(PhoenixMonitoredPreparedStatement.class);
        this.statement2 = (PhoenixMonitoredPreparedStatement)Mockito.mock(PhoenixMonitoredPreparedStatement.class);
        this.future1 = CompletableFuture.completedFuture(this.statement1);
        this.future2 = CompletableFuture.completedFuture(this.statement2);
        this.phoenixPreparedStatement = new ParallelPhoenixPreparedStatement(this.context, this.future1, this.future2);
    }

    @Test
    public void getStatement1() throws SQLException {
        this.future1 = (CompletableFuture)Mockito.mock(CompletableFuture.class);
        this.future2 = (CompletableFuture)Mockito.mock(CompletableFuture.class);
        this.phoenixPreparedStatement = new ParallelPhoenixPreparedStatement(this.context, this.future1, this.future2);
        Assert.assertEquals(this.future1, (Object)this.phoenixPreparedStatement.getStatement1());
    }

    @Test
    public void getStatement2() throws SQLException {
        this.future1 = (CompletableFuture)Mockito.mock(CompletableFuture.class);
        this.future2 = (CompletableFuture)Mockito.mock(CompletableFuture.class);
        this.phoenixPreparedStatement = new ParallelPhoenixPreparedStatement(this.context, this.future1, this.future2);
        Assert.assertEquals(this.future2, (Object)this.phoenixPreparedStatement.getStatement2());
    }

    @Test
    public void executeQuery() throws SQLException, ExecutionException, InterruptedException {
        ResultSet mockResultSet1 = (ResultSet)Mockito.mock(ResultSet.class);
        ResultSet mockResultSet2 = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)this.statement1.executeQuery()).thenReturn((Object)mockResultSet1);
        Mockito.when((Object)this.statement2.executeQuery()).thenReturn((Object)mockResultSet2);
        ResultSet rs = this.phoenixPreparedStatement.executeQuery();
        Thread.sleep(5000L);
        ((PhoenixMonitoredPreparedStatement)Mockito.verify((Object)this.statement1)).executeQuery();
        ((PhoenixMonitoredPreparedStatement)Mockito.verify((Object)this.statement2)).executeQuery();
        ParallelPhoenixResultSet parallelRS = (ParallelPhoenixResultSet)rs;
        Assert.assertEquals((Object)mockResultSet1, parallelRS.getResultSetFuture1().get());
        Assert.assertEquals((Object)mockResultSet2, parallelRS.getResultSetFuture2().get());
    }

    @Test
    public void setInt() throws SQLException, ExecutionException, InterruptedException {
        this.phoenixPreparedStatement.setInt(1, 2);
        Thread.sleep(5000L);
        ((PhoenixMonitoredPreparedStatement)Mockito.verify((Object)this.statement1)).setInt(1, 2);
        ((PhoenixMonitoredPreparedStatement)Mockito.verify((Object)this.statement2)).setInt(1, 2);
    }

    @Test
    public void execute() throws SQLException, ExecutionException, InterruptedException {
        this.phoenixPreparedStatement.execute();
        Thread.sleep(5000L);
        ((PhoenixMonitoredPreparedStatement)Mockito.verify((Object)this.statement1)).execute();
        ((PhoenixMonitoredPreparedStatement)Mockito.verify((Object)this.statement2)).execute();
    }
}

