/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.ClusterRoleRecord;
import org.apache.phoenix.jdbc.HAURLInfo;
import org.apache.phoenix.jdbc.HighAvailabilityGroup;
import org.apache.phoenix.jdbc.HighAvailabilityTestingUtility;
import org.apache.phoenix.jdbc.ParallelPhoenixContext;
import org.apache.phoenix.jdbc.ParallelPhoenixNullComparingResultSet;
import org.apache.phoenix.jdbc.ParallelPhoenixResultSet;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class ParallelPhoenixNullComparingResultSetTest {
    ParallelPhoenixContext context;
    ResultSet rs1;
    ResultSet rs2;
    CompletableFuture<ResultSet> completableRs1;
    CompletableFuture<ResultSet> completableRs2;
    ParallelPhoenixResultSet resultSet;

    @Before
    public void init() {
        HighAvailabilityGroup.HAGroupInfo haGroupInfo = new HighAvailabilityGroup.HAGroupInfo("test", "test1", "test2");
        this.context = new ParallelPhoenixContext(new Properties(), new HighAvailabilityGroup(haGroupInfo, (Properties)Mockito.mock(Properties.class), (ClusterRoleRecord)Mockito.mock(ClusterRoleRecord.class), HighAvailabilityGroup.State.READY), HighAvailabilityTestingUtility.getListOfSingleThreadExecutorServices(), null, (HAURLInfo)Mockito.mock(HAURLInfo.class));
        this.rs1 = (ResultSet)Mockito.mock(ResultSet.class);
        this.rs2 = (ResultSet)Mockito.mock(ResultSet.class);
        this.completableRs1 = CompletableFuture.completedFuture(this.rs1);
        this.completableRs2 = CompletableFuture.completedFuture(this.rs2);
        this.resultSet = new ParallelPhoenixResultSet(this.context, this.completableRs1, this.completableRs2);
    }

    @Test
    public void testRs1Null() throws SQLException {
        Mockito.when((Object)this.rs1.next()).thenReturn((Object)false);
        Mockito.when((Object)this.rs2.next()).thenReturn((Object)true);
        ParallelPhoenixNullComparingResultSet ncrs = new ParallelPhoenixNullComparingResultSet(this.context, this.completableRs1, this.completableRs2);
        Assert.assertNull((Object)ncrs.getResultSet());
        Assert.assertTrue((boolean)ncrs.next());
        Assert.assertEquals((Object)this.rs2, (Object)ncrs.getResultSet());
        ((ResultSet)Mockito.verify((Object)this.rs2)).next();
    }

    @Test
    public void testRs2Null() throws SQLException {
        Mockito.when((Object)this.rs1.next()).thenReturn((Object)true);
        Mockito.when((Object)this.rs2.next()).thenReturn((Object)false);
        ParallelPhoenixNullComparingResultSet ncrs = new ParallelPhoenixNullComparingResultSet(this.context, this.completableRs1, this.completableRs2);
        Assert.assertNull((Object)ncrs.getResultSet());
        Assert.assertTrue((boolean)ncrs.next());
        Assert.assertEquals((Object)this.rs1, (Object)ncrs.getResultSet());
        ((ResultSet)Mockito.verify((Object)this.rs1)).next();
    }

    @Test
    public void testRs1Rs2Null() throws SQLException {
        Mockito.when((Object)this.rs1.next()).thenReturn((Object)false);
        Mockito.when((Object)this.rs2.next()).thenReturn((Object)false);
        ParallelPhoenixNullComparingResultSet ncrs = new ParallelPhoenixNullComparingResultSet(this.context, this.completableRs1, this.completableRs2);
        Assert.assertNull((Object)ncrs.getResultSet());
        Assert.assertFalse((boolean)ncrs.next());
        Assert.assertTrue((this.rs1 == ncrs.getResultSet() || this.rs2 == ncrs.getResultSet() ? 1 : 0) != 0);
        ((ResultSet)Mockito.verify((Object)this.rs1)).next();
        ((ResultSet)Mockito.verify((Object)this.rs2)).next();
    }

    @Test
    public void testRs1ExceptionRs2Null() throws SQLException {
        Mockito.when((Object)this.rs1.next()).thenThrow(new Throwable[]{new RuntimeException()});
        Mockito.when((Object)this.rs2.next()).thenReturn((Object)false);
        ParallelPhoenixNullComparingResultSet ncrs = new ParallelPhoenixNullComparingResultSet(this.context, this.completableRs1, this.completableRs2);
        Assert.assertNull((Object)ncrs.getResultSet());
        Assert.assertFalse((boolean)ncrs.next());
        Assert.assertEquals((Object)this.rs2, (Object)ncrs.getResultSet());
        ((ResultSet)Mockito.verify((Object)this.rs1)).next();
        ((ResultSet)Mockito.verify((Object)this.rs2)).next();
    }

    @Test
    public void testRs2Exception() throws SQLException {
        Mockito.when((Object)this.rs1.next()).thenReturn((Object)true);
        Mockito.when((Object)this.rs2.next()).thenThrow(new Throwable[]{new RuntimeException()});
        ParallelPhoenixNullComparingResultSet ncrs = new ParallelPhoenixNullComparingResultSet(this.context, this.completableRs1, this.completableRs2);
        Assert.assertNull((Object)ncrs.getResultSet());
        Assert.assertTrue((boolean)ncrs.next());
        Assert.assertEquals((Object)this.rs1, (Object)ncrs.getResultSet());
        ((ResultSet)Mockito.verify((Object)this.rs1)).next();
    }

    @Test
    public void testRs1Rs2Exception() throws SQLException {
        Mockito.when((Object)this.rs1.next()).thenThrow(new Throwable[]{new SQLException()});
        Mockito.when((Object)this.rs2.next()).thenThrow(new Throwable[]{new SQLException()});
        ParallelPhoenixNullComparingResultSet ncrs = new ParallelPhoenixNullComparingResultSet(this.context, this.completableRs1, this.completableRs2);
        Assert.assertNull((Object)ncrs.getResultSet());
        try {
            ncrs.next();
            Assert.fail((String)"RS should've thrown exception");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs1)).next();
        ((ResultSet)Mockito.verify((Object)this.rs2)).next();
    }

    @Test
    public void testErrorOnSingleNullRs1Null() throws SQLException {
        Mockito.when((Object)this.rs1.next()).thenReturn((Object)false);
        Mockito.when((Object)this.rs2.next()).thenThrow(new Throwable[]{new RuntimeException()});
        this.context.getProperties().setProperty("phoenix.parallel.nullComparingRs.errorOnSingleNull", "true");
        ParallelPhoenixNullComparingResultSet ncrs = new ParallelPhoenixNullComparingResultSet(this.context, this.completableRs1, this.completableRs2);
        Assert.assertNull((Object)ncrs.getResultSet());
        try {
            ncrs.next();
            Assert.fail((String)"RS should've thrown exception");
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.HA_READ_FROM_CLUSTER_FAILED_ON_NULL.getErrorCode(), (long)e.getErrorCode());
        }
        ((ResultSet)Mockito.verify((Object)this.rs1)).next();
        ((ResultSet)Mockito.verify((Object)this.rs2)).next();
    }

    @Test
    public void testErrorOnSingleNullRs2Null() throws SQLException {
        Mockito.when((Object)this.rs1.next()).thenThrow(new Throwable[]{new RuntimeException()});
        Mockito.when((Object)this.rs2.next()).thenReturn((Object)false);
        this.context.getProperties().setProperty("phoenix.parallel.nullComparingRs.errorOnSingleNull", "true");
        ParallelPhoenixNullComparingResultSet ncrs = new ParallelPhoenixNullComparingResultSet(this.context, this.completableRs1, this.completableRs2);
        Assert.assertNull((Object)ncrs.getResultSet());
        try {
            ncrs.next();
            Assert.fail((String)"RS should've thrown exception");
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.HA_READ_FROM_CLUSTER_FAILED_ON_NULL.getErrorCode(), (long)e.getErrorCode());
        }
        ((ResultSet)Mockito.verify((Object)this.rs1)).next();
        ((ResultSet)Mockito.verify((Object)this.rs2)).next();
    }

    @Test
    public void testReadValueAfterWaitRs2Null() throws SQLException {
        Answer answer = i -> {
            Thread.sleep(2000L);
            return true;
        };
        ((ResultSet)Mockito.doAnswer((Answer)answer).when((Object)this.rs1)).next();
        Mockito.when((Object)this.rs1.getString(0)).thenReturn((Object)"test");
        Mockito.when((Object)this.rs2.next()).thenReturn((Object)false);
        ParallelPhoenixNullComparingResultSet ncrs = new ParallelPhoenixNullComparingResultSet(this.context, this.completableRs1, this.completableRs2);
        Assert.assertTrue((boolean)ncrs.next());
        Assert.assertEquals((Object)this.rs1, (Object)ncrs.getResultSet());
        Assert.assertEquals((Object)"test", (Object)ncrs.getString(0));
    }
}

