/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CountDownLatch;
import java.util.function.Supplier;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.HAURLInfo;
import org.apache.phoenix.jdbc.HighAvailabilityGroup;
import org.apache.phoenix.jdbc.HighAvailabilityTestingUtility;
import org.apache.phoenix.jdbc.ParallelPhoenixConnection;
import org.apache.phoenix.jdbc.ParallelPhoenixContext;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixMonitoredConnection;
import org.apache.phoenix.monitoring.GlobalClientMetrics;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.exceptions.verification.WantedButNotInvoked;
import org.mockito.invocation.InvocationOnMock;

public class ParallelPhoenixConnectionTest {
    ParallelPhoenixContext context;
    ParallelPhoenixConnection parallelPhoenixConnection;
    PhoenixConnection connection1 = (PhoenixConnection)Mockito.mock(PhoenixConnection.class);
    PhoenixConnection connection2 = (PhoenixConnection)Mockito.mock(PhoenixConnection.class);

    @Before
    public void init() throws SQLException {
        this.context = new ParallelPhoenixContext(new Properties(), (HighAvailabilityGroup)Mockito.mock(HighAvailabilityGroup.class), HighAvailabilityTestingUtility.getListOfSingleThreadExecutorServices(), null, (HAURLInfo)Mockito.mock(HAURLInfo.class));
        this.parallelPhoenixConnection = new ParallelPhoenixConnection(this.context, CompletableFuture.completedFuture(this.connection1), CompletableFuture.completedFuture(this.connection2));
    }

    @Test
    public void getWarningsBothWarnTest() throws Exception {
        SQLWarning warning1 = new SQLWarning("warning1");
        SQLWarning warning2 = new SQLWarning("warning2");
        Mockito.when((Object)this.connection1.getWarnings()).thenReturn((Object)warning1);
        Mockito.when((Object)this.connection2.getWarnings()).thenReturn((Object)warning2);
        SQLWarning result = this.parallelPhoenixConnection.getWarnings();
        Assert.assertEquals((Object)warning1, (Object)result.getNextWarning());
        Assert.assertEquals((Object)warning2, (Object)result.getNextWarning().getNextWarning());
    }

    @Test
    public void getWarnings1WarnTest() throws Exception {
        SQLWarning warning2 = new SQLWarning("warning2");
        Mockito.when((Object)this.connection1.getWarnings()).thenReturn(null);
        Mockito.when((Object)this.connection2.getWarnings()).thenReturn((Object)warning2);
        SQLWarning result = this.parallelPhoenixConnection.getWarnings();
        Assert.assertEquals((Object)warning2, (Object)result);
    }

    @Test
    public void getWarnings0WarnTest() throws Exception {
        Mockito.when((Object)this.connection1.getWarnings()).thenReturn(null);
        Mockito.when((Object)this.connection2.getWarnings()).thenReturn(null);
        SQLWarning result = this.parallelPhoenixConnection.getWarnings();
        Assert.assertNull((Object)result);
    }

    @Test
    public void isWrapperForPhoenixConnectionFalseTest() throws SQLException {
        boolean result = this.parallelPhoenixConnection.isWrapperFor(PhoenixConnection.class);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void isWrapperForPhoenixMonitoredConnectionTrueTest() throws SQLException {
        boolean result = this.parallelPhoenixConnection.isWrapperFor(PhoenixMonitoredConnection.class);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void unwrapPhoenixConnectionFailsTest() {
        try {
            this.parallelPhoenixConnection.unwrap(PhoenixConnection.class);
        }
        catch (SQLException e) {
            Assert.assertEquals((long)e.getErrorCode(), (long)SQLExceptionCode.CLASS_NOT_UNWRAPPABLE.getErrorCode());
        }
    }

    @Test
    public void unwrapPhoenixMonitoredConnectionTest() throws SQLException {
        PhoenixMonitoredConnection result = (PhoenixMonitoredConnection)this.parallelPhoenixConnection.unwrap(PhoenixMonitoredConnection.class);
        Assert.assertEquals((Object)this.parallelPhoenixConnection, (Object)result);
    }

    @Test
    public void testOpenConnection1Error() throws SQLException {
        CompletableFuture<PhoenixConnection> futureConnection1 = CompletableFuture.supplyAsync(() -> {
            throw new CompletionException(new Exception("Failed in completing future connection1"));
        });
        CompletableFuture<PhoenixConnection> futureConnection2 = CompletableFuture.completedFuture(this.connection2);
        this.parallelPhoenixConnection = new ParallelPhoenixConnection(this.context, futureConnection1, futureConnection2);
        this.parallelPhoenixConnection.close();
        ((PhoenixConnection)Mockito.verify((Object)this.connection2)).close();
    }

    @Test
    public void testOpenConnection2Error() throws SQLException {
        CompletableFuture<PhoenixConnection> futureConnection1 = CompletableFuture.completedFuture(this.connection1);
        CompletableFuture<PhoenixConnection> futureConnection2 = CompletableFuture.supplyAsync(() -> {
            throw new CompletionException(new Exception("Failed in completing future connection2"));
        });
        this.parallelPhoenixConnection = new ParallelPhoenixConnection(this.context, futureConnection1, futureConnection2);
        this.parallelPhoenixConnection.close();
        ((PhoenixConnection)Mockito.verify((Object)this.connection1)).close();
    }

    @Test
    public void testOpenBothConnectionError() {
        CompletableFuture<PhoenixConnection> futureConnection1 = CompletableFuture.supplyAsync(() -> {
            throw new CompletionException(new Exception("Failed in completing future connection1"));
        });
        CompletableFuture<PhoenixConnection> futureConnection2 = CompletableFuture.supplyAsync(() -> {
            throw new CompletionException(new Exception("Failed in completing future connection2"));
        });
        try {
            this.parallelPhoenixConnection = new ParallelPhoenixConnection(this.context, futureConnection1, futureConnection2);
            Assert.fail((String)"Initialization should throw an exception if both the future connections fail.");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Test
    public void testOpenConnection1Delay() throws Exception {
        Properties properties = new Properties();
        properties.setProperty("phoenix.ha.parallel.operation.timeout.ms", "1000");
        ParallelPhoenixContext context = new ParallelPhoenixContext(properties, (HighAvailabilityGroup)Mockito.mock(HighAvailabilityGroup.class), HighAvailabilityTestingUtility.getListOfSingleThreadExecutorServices(), null, (HAURLInfo)Mockito.mock(HAURLInfo.class));
        CountDownLatch cdl = new CountDownLatch(1);
        CompletableFuture<PhoenixConnection> futureConnection1 = CompletableFuture.supplyAsync(this.getDelayConnectionSupplier(cdl, this.connection1));
        CompletableFuture<PhoenixConnection> futureConnection2 = CompletableFuture.completedFuture(this.connection2);
        this.parallelPhoenixConnection = new ParallelPhoenixConnection(context, futureConnection1, futureConnection2);
        this.parallelPhoenixConnection.close();
        ((PhoenixConnection)Mockito.verify((Object)this.connection2)).close();
        cdl.countDown();
        this.waitForConnectionClose(this.connection1);
    }

    @Test
    public void testOpenConnection2Delay() throws Exception {
        Properties properties = new Properties();
        properties.setProperty("phoenix.ha.parallel.operation.timeout.ms", "1000");
        ParallelPhoenixContext context = new ParallelPhoenixContext(properties, (HighAvailabilityGroup)Mockito.mock(HighAvailabilityGroup.class), HighAvailabilityTestingUtility.getListOfSingleThreadExecutorServices(), null, (HAURLInfo)Mockito.mock(HAURLInfo.class));
        CountDownLatch cdl = new CountDownLatch(1);
        CompletableFuture<PhoenixConnection> futureConnection1 = CompletableFuture.completedFuture(this.connection1);
        CompletableFuture<PhoenixConnection> futureConnection2 = CompletableFuture.supplyAsync(this.getDelayConnectionSupplier(cdl, this.connection2));
        this.parallelPhoenixConnection = new ParallelPhoenixConnection(context, futureConnection1, futureConnection2);
        this.parallelPhoenixConnection.close();
        ((PhoenixConnection)Mockito.verify((Object)this.connection1)).close();
        cdl.countDown();
        this.waitForConnectionClose(this.connection2);
    }

    @Test(timeout=10000L)
    public void testOpenBothConnectionDelay() throws SQLException {
        Properties properties = new Properties();
        properties.setProperty("phoenix.ha.parallel.operation.timeout.ms", "1000");
        ParallelPhoenixContext context = new ParallelPhoenixContext(properties, (HighAvailabilityGroup)Mockito.mock(HighAvailabilityGroup.class), HighAvailabilityTestingUtility.getListOfSingleThreadExecutorServices(), null, (HAURLInfo)Mockito.mock(HAURLInfo.class));
        CountDownLatch cdl1 = new CountDownLatch(1);
        CompletableFuture<PhoenixConnection> futureConnection1 = CompletableFuture.supplyAsync(this.getDelayConnectionSupplier(cdl1, this.connection1));
        CountDownLatch cdl2 = new CountDownLatch(1);
        CompletableFuture<PhoenixConnection> futureConnection2 = CompletableFuture.supplyAsync(this.getDelayConnectionSupplier(cdl2, this.connection2));
        long prevTimeoutCounter = GlobalClientMetrics.GLOBAL_HA_PARALLEL_TASK_TIMEOUT_COUNTER.getMetric().getValue();
        try {
            this.parallelPhoenixConnection = new ParallelPhoenixConnection(context, futureConnection1, futureConnection2);
            Assert.fail((String)"Initialization should throw an exception if both the future connections timeout");
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.OPERATION_TIMED_OUT.getErrorCode(), (long)e.getErrorCode());
            Assert.assertTrue((GlobalClientMetrics.GLOBAL_HA_PARALLEL_TASK_TIMEOUT_COUNTER.getMetric().getValue() > prevTimeoutCounter ? 1 : 0) != 0);
        }
    }

    @Test
    public void testCloseConnection1Error() throws SQLException {
        ((PhoenixConnection)Mockito.doThrow((Throwable[])new Throwable[]{new SQLException()}).when((Object)this.connection1)).close();
        this.parallelPhoenixConnection.close();
        ((PhoenixConnection)Mockito.verify((Object)this.connection2)).close();
    }

    @Test
    public void testCloseConnection2Error() throws SQLException {
        ((PhoenixConnection)Mockito.doThrow((Throwable[])new Throwable[]{new SQLException()}).when((Object)this.connection2)).close();
        this.parallelPhoenixConnection.close();
        ((PhoenixConnection)Mockito.verify((Object)this.connection1)).close();
    }

    @Test
    public void testCloseBothConnectionError() throws SQLException {
        ((PhoenixConnection)Mockito.doThrow((Throwable[])new Throwable[]{new SQLException()}).when((Object)this.connection1)).close();
        ((PhoenixConnection)Mockito.doThrow((Throwable[])new Throwable[]{new SQLException()}).when((Object)this.connection2)).close();
        try {
            this.parallelPhoenixConnection.close();
            Assert.fail((String)"Close should throw exception when both underlying close throw exceptions");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((PhoenixConnection)Mockito.verify((Object)this.connection1)).close();
        ((PhoenixConnection)Mockito.verify((Object)this.connection2)).close();
    }

    @Test
    public void testConnection1CloseDelay() throws Exception {
        CountDownLatch cdl = new CountDownLatch(1);
        Supplier<Void> delaySupplier = this.getDelaySupplier(cdl);
        this.context.chainOnConn1(delaySupplier);
        this.parallelPhoenixConnection.close();
        long countConnection1 = Mockito.mockingDetails((Object)this.connection1).getInvocations().stream().map(InvocationOnMock::getMethod).filter(s -> s.getName().equals("close")).count();
        long countConnection2 = Mockito.mockingDetails((Object)this.connection2).getInvocations().stream().map(InvocationOnMock::getMethod).filter(s -> s.getName().equals("close")).count();
        Assert.assertTrue((String)"Close should be called on at least one of the connections", (countConnection1 > 0L || countConnection2 > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testConnection2CloseDelay() throws Exception {
        CountDownLatch cdl = new CountDownLatch(1);
        Supplier<Void> delaySupplier = this.getDelaySupplier(cdl);
        this.context.chainOnConn2(delaySupplier);
        this.parallelPhoenixConnection.close();
        long countConnection1 = Mockito.mockingDetails((Object)this.connection1).getInvocations().stream().map(InvocationOnMock::getMethod).filter(s -> s.getName().equals("close")).count();
        long countConnection2 = Mockito.mockingDetails((Object)this.connection2).getInvocations().stream().map(InvocationOnMock::getMethod).filter(s -> s.getName().equals("close")).count();
        Assert.assertTrue((String)"Close should be called on at least one of the connections", (countConnection1 > 0L || countConnection2 > 0L ? 1 : 0) != 0);
        cdl.countDown();
    }

    @Test
    public void testConnectionCloseNoTimeout() throws Exception {
        Properties properties = new Properties();
        properties.setProperty("phoenix.ha.parallel.operation.timeout.ms", "1000");
        ParallelPhoenixContext context = new ParallelPhoenixContext(properties, (HighAvailabilityGroup)Mockito.mock(HighAvailabilityGroup.class), HighAvailabilityTestingUtility.getListOfSingleThreadExecutorServices(), null, (HAURLInfo)Mockito.mock(HAURLInfo.class));
        this.parallelPhoenixConnection = new ParallelPhoenixConnection(context, CompletableFuture.completedFuture(this.connection1), CompletableFuture.completedFuture(this.connection2));
        CountDownLatch cdl1 = new CountDownLatch(1);
        CountDownLatch cdl2 = new CountDownLatch(1);
        Supplier<Void> delaySupplier1 = this.getDelaySupplier(cdl1);
        Supplier<Void> delaySupplier2 = this.getDelaySupplier(cdl2);
        context.chainOnConn1(delaySupplier1);
        context.chainOnConn2(delaySupplier2);
        this.parallelPhoenixConnection.close();
        long countConnection1 = Mockito.mockingDetails((Object)this.connection1).getInvocations().stream().map(InvocationOnMock::getMethod).filter(s -> s.getName().equals("close")).count();
        long countConnection2 = Mockito.mockingDetails((Object)this.connection2).getInvocations().stream().map(InvocationOnMock::getMethod).filter(s -> s.getName().equals("close")).count();
        Assert.assertTrue((String)"Close should be called on at least one of the connections", (countConnection1 > 0L || countConnection2 > 0L ? 1 : 0) != 0);
        cdl1.countDown();
        cdl2.countDown();
    }

    private void waitForConnectionClose(PhoenixConnection connection) throws Exception {
        GenericTestUtils.waitFor(() -> {
            try {
                ((PhoenixConnection)Mockito.verify((Object)connection)).close();
            }
            catch (SQLException | WantedButNotInvoked e) {
                return false;
            }
            return true;
        }, (long)1000L, (long)30000L);
    }

    private Supplier<Void> getDelaySupplier(CountDownLatch cdl) {
        return () -> {
            try {
                cdl.await();
            }
            catch (InterruptedException e) {
                throw new CompletionException(e);
            }
            return null;
        };
    }

    private Supplier<PhoenixConnection> getDelayConnectionSupplier(CountDownLatch cdl, PhoenixConnection returnConnection) {
        return () -> {
            try {
                cdl.await();
            }
            catch (InterruptedException e) {
                throw new CompletionException(e);
            }
            return returnConnection;
        };
    }
}

