/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.jdbc.HighAvailabilityGroup;
import org.apache.phoenix.jdbc.HighAvailabilityPolicy;
import org.apache.phoenix.jdbc.HighAvailabilityTestingUtility;
import org.apache.phoenix.jdbc.ParallelPhoenixConnection;
import org.apache.phoenix.jdbc.ParallelPhoenixContext;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDriver;
import org.apache.phoenix.jdbc.PhoenixHAExecutorServiceProvider;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={NeedsOwnMiniClusterTest.class})
public class ParallelPhoenixConnectionFallbackIT {
    private static final Logger LOG = LoggerFactory.getLogger(ParallelPhoenixConnectionFallbackIT.class);
    private static final HighAvailabilityTestingUtility.HBaseTestingUtilityPair CLUSTERS = new HighAvailabilityTestingUtility.HBaseTestingUtilityPair();
    private static final Properties PROPERTIES = new Properties();
    private static String jdbcUrl;
    private static HighAvailabilityGroup haGroup;
    private static String tableName;
    private static String haGroupName;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        haGroupName = ParallelPhoenixConnectionFallbackIT.class.getSimpleName();
        CLUSTERS.start();
        DriverManager.registerDriver((Driver)PhoenixDriver.INSTANCE);
        PROPERTIES.setProperty("phoenix.ha.group.name", haGroupName);
        PROPERTIES.setProperty("phoenix.ha.max.pool.size", "1");
        PROPERTIES.setProperty("phoenix.ha.max.queue.size", "2");
        PROPERTIES.setProperty("phoenix.ha.threadpool.queue.backoff.threshold", "0.5");
        CLUSTERS.initClusterRole(haGroupName, HighAvailabilityPolicy.PARALLEL);
        jdbcUrl = CLUSTERS.getJdbcHAUrl();
        haGroup = HighAvailabilityTestingUtility.getHighAvailibilityGroup(jdbcUrl, PROPERTIES);
        LOG.info("Initialized haGroup {} with URL {}", (Object)haGroup.getGroupInfo().getName(), (Object)jdbcUrl);
        CLUSTERS.createTableOnClusterPair(haGroup, tableName);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        DriverManager.deregisterDriver((Driver)PhoenixDriver.INSTANCE);
        CLUSTERS.close();
    }

    @Test
    public void testParallelConnectionBackoff() throws Exception {
        Connection connA = DriverManager.getConnection(jdbcUrl, PROPERTIES);
        Assert.assertTrue((boolean)(connA instanceof ParallelPhoenixConnection));
        HighAvailabilityTestingUtility.doTestBasicOperationsWithConnection(connA, tableName, haGroupName);
        CountDownLatch cdl1 = new CountDownLatch(1);
        CountDownLatch cdl2 = new CountDownLatch(1);
        ParallelPhoenixContext contextA = ((ParallelPhoenixConnection)connA).getContext();
        GenericTestUtils.waitFor(() -> contextA.getChainOnConn1().isDone(), (long)100L, (long)5000L);
        GenericTestUtils.waitFor(() -> contextA.getChainOnConn2().isDone(), (long)100L, (long)5000L);
        contextA.chainOnConn1(this.getSuplierWithLatch(cdl1));
        contextA.chainOnConn2(this.getSuplierWithLatch(cdl2));
        GenericTestUtils.waitFor(() -> (Boolean)PhoenixHAExecutorServiceProvider.hasCapacity((Properties)PROPERTIES).get(0) != false && (Boolean)PhoenixHAExecutorServiceProvider.hasCapacity((Properties)PROPERTIES).get(1) != false, (long)100L, (long)5000L);
        ExecutorService executor = Executors.newFixedThreadPool(1);
        Future<Connection> futureConnB = executor.submit(() -> DriverManager.getConnection(jdbcUrl, PROPERTIES));
        GenericTestUtils.waitFor(() -> (Boolean)PhoenixHAExecutorServiceProvider.hasCapacity((Properties)PROPERTIES).get(0) == false && (Boolean)PhoenixHAExecutorServiceProvider.hasCapacity((Properties)PROPERTIES).get(1) == false, (long)100L, (long)5000L);
        Connection connC = DriverManager.getConnection(jdbcUrl, PROPERTIES);
        Assert.assertTrue((boolean)(connC instanceof PhoenixConnection));
        cdl1.countDown();
        cdl2.countDown();
        GenericTestUtils.waitFor(() -> futureConnB.isDone(), (long)1000L, (long)5000L);
        Connection connB = futureConnB.get();
        Assert.assertTrue((boolean)(connB instanceof ParallelPhoenixConnection));
        HighAvailabilityTestingUtility.doTestBasicOperationsWithConnection(connB, tableName, haGroupName);
        ParallelPhoenixContext contextB = ((ParallelPhoenixConnection)connB).getContext();
        GenericTestUtils.waitFor(() -> contextB.getChainOnConn1().isDone(), (long)100L, (long)5000L);
        GenericTestUtils.waitFor(() -> contextB.getChainOnConn2().isDone(), (long)100L, (long)5000L);
        Connection connD = DriverManager.getConnection(jdbcUrl, PROPERTIES);
        Assert.assertTrue((boolean)(connD instanceof ParallelPhoenixConnection));
        this.closeConnections(connA, connB, connC, connD);
    }

    private Supplier<?> getSuplierWithLatch(CountDownLatch cdl) {
        Supplier<Object> s = () -> {
            try {
                cdl.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            return null;
        };
        return s;
    }

    private void closeConnections(Connection ... connections) {
        for (Connection conn : connections) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    static {
        tableName = ParallelPhoenixConnectionFallbackIT.class.getSimpleName();
    }
}

