/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.phoenix.jdbc.HAURLInfo;
import org.apache.phoenix.jdbc.HighAvailabilityGroup;
import org.apache.phoenix.jdbc.HighAvailabilityTestingUtility;
import org.apache.phoenix.jdbc.ParallelPhoenixConnection;
import org.apache.phoenix.jdbc.ParallelPhoenixContext;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.query.BaseTest;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class ParallelPhoenixConnectionFailureTest
extends BaseTest {
    private static String url = "jdbc:phoenix:none";
    private static int WAIT_MS = 30000;

    @Test
    public void testExecuteQueryChainFailure() throws SQLException {
        HBaseTestingUtility hbaseTestingUtility = new HBaseTestingUtility();
        Properties props = new Properties();
        PhoenixConnection conn1 = (PhoenixConnection)DriverManager.getConnection(url, props);
        PhoenixConnection conn2 = (PhoenixConnection)DriverManager.getConnection(url, props);
        PhoenixConnection connSpy1 = (PhoenixConnection)Mockito.spy((Object)conn1);
        PhoenixConnection connSpy2 = (PhoenixConnection)Mockito.spy((Object)conn2);
        AtomicInteger numStatementsCreatedOnConn1 = new AtomicInteger();
        AtomicInteger numStatementsCreatedOnConn2 = new AtomicInteger();
        Answer answer1 = i -> {
            numStatementsCreatedOnConn1.getAndIncrement();
            return conn1.createStatement();
        };
        Answer answer2 = i -> {
            numStatementsCreatedOnConn2.getAndIncrement();
            return conn2.createStatement();
        };
        ((PhoenixConnection)Mockito.doAnswer((Answer)answer1).when((Object)connSpy1)).createStatement();
        ((PhoenixConnection)Mockito.doAnswer((Answer)answer2).when((Object)connSpy2)).createStatement();
        ParallelPhoenixContext context = new ParallelPhoenixContext(new Properties(), (HighAvailabilityGroup)Mockito.mock(HighAvailabilityGroup.class), HighAvailabilityTestingUtility.getListOfSingleThreadExecutorServices(), null, (HAURLInfo)Mockito.mock(HAURLInfo.class));
        ParallelPhoenixConnection parallelConn = new ParallelPhoenixConnection(context, CompletableFuture.completedFuture(connSpy1), CompletableFuture.completedFuture(connSpy2));
        parallelConn.createStatement().execute("SELECT * FROM SYSTEM.CATALOG");
        parallelConn.createStatement().execute("SELECT * FROM SYSTEM.CATALOG");
        hbaseTestingUtility.waitFor((long)WAIT_MS, () -> numStatementsCreatedOnConn1.get() == 2 && numStatementsCreatedOnConn2.get() == 2);
        ((PhoenixConnection)Mockito.doThrow((Throwable[])new Throwable[]{new SQLException()}).when((Object)connSpy1)).createStatement();
        parallelConn.createStatement().execute("SELECT * FROM SYSTEM.CATALOG");
        hbaseTestingUtility.waitFor((long)WAIT_MS, () -> numStatementsCreatedOnConn2.get() == 3);
        ((PhoenixConnection)Mockito.doAnswer((Answer)answer1).when((Object)connSpy1)).createStatement();
        parallelConn.createStatement().execute("SELECT * FROM SYSTEM.CATALOG");
        hbaseTestingUtility.waitFor((long)WAIT_MS, () -> numStatementsCreatedOnConn1.get() == 2 && numStatementsCreatedOnConn2.get() == 4);
        Assert.assertTrue((boolean)context.chainOnConn1(() -> Boolean.TRUE).isCompletedExceptionally());
    }
}

