/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.jdbc.ConnectionInfo;
import org.apache.phoenix.jdbc.LoggingConnectionLimiterIT;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDriver;
import org.apache.phoenix.jdbc.PhoenixTestDriver;
import org.apache.phoenix.log.ConnectionLimiter;
import org.apache.phoenix.query.ConfigurationFactory;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.HBaseFactoryProvider;
import org.apache.phoenix.util.InstanceResolver;
import org.junit.BeforeClass;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={NeedsOwnMiniClusterTest.class})
public class LoggingSingleConnectionLimiterIT
extends LoggingConnectionLimiterIT {
    private static final Logger LOG = LoggerFactory.getLogger(LoggingSingleConnectionLimiterIT.class);

    @BeforeClass
    public static void doSetup() throws Exception {
        InstanceResolver.clearSingletons();
        InstanceResolver.getSingleton(ConfigurationFactory.class, (Object)new ConfigurationFactory(){

            public Configuration getConfiguration() {
                Configuration conf = HBaseConfiguration.create();
                conf.set("phoenix.connection.activity.logging.enabled", String.valueOf(true));
                conf.set("phoenix.client.connection.max.allowed.connections", String.valueOf(20));
                conf.set("phoenix.internal.connection.max.allowed.connections", String.valueOf(20));
                conf.set("phoenix.ha.max.pool.size", String.valueOf(5));
                conf.set("phoenix.ha.max.queue.size", String.valueOf(30));
                conf.set("phoenix.connection.activity.logging.explain.plan.enabled", String.valueOf(true));
                conf.set("hbase.client.registry.impl", "org.apache.hadoop.hbase.client.ZKConnectionRegistry");
                return conf;
            }

            public Configuration getConfiguration(Configuration confToClone) {
                Configuration conf = HBaseConfiguration.create();
                conf.set("phoenix.connection.activity.logging.enabled", String.valueOf(true));
                conf.set("phoenix.client.connection.max.allowed.connections", String.valueOf(20));
                conf.set("phoenix.internal.connection.max.allowed.connections", String.valueOf(20));
                conf.set("phoenix.ha.max.pool.size", String.valueOf(5));
                conf.set("phoenix.ha.max.queue.size", String.valueOf(30));
                conf.set("phoenix.connection.activity.logging.explain.plan.enabled", String.valueOf(true));
                conf.set("hbase.client.registry.impl", "org.apache.hadoop.hbase.client.ZKConnectionRegistry");
                Configuration copy = new Configuration(conf);
                copy.addResource(confToClone);
                return copy;
            }
        });
        Configuration conf = HBaseFactoryProvider.getConfigurationFactory().getConfiguration();
        HBaseTestingUtility hBaseTestingUtility = new HBaseTestingUtility(conf);
        LoggingSingleConnectionLimiterIT.setUpConfigForMiniCluster(conf);
        hBaseTestingUtility.startMiniCluster();
        String zkQuorum = "localhost:" + hBaseTestingUtility.getZkCluster().getClientPort();
        url = "jdbc:phoenix:" + zkQuorum;
        DriverManager.registerDriver((Driver)PhoenixDriver.INSTANCE);
        DriverManager.registerDriver((Driver)((Object)new PhoenixTestDriver()));
        String profileName = "setup";
        Properties props = new Properties();
        String urlWithPrinc = ConnectionInfo.createNoLogin((String)url, null, (Properties)props).withPrincipal("nocache").toUrl();
        try (Connection connection = DriverManager.getConnection(urlWithPrinc, props);){
            try (Statement statement = connection.createStatement();){
                statement.execute(CREATE_TABLE_SQL);
            }
            connection.commit();
        }
        connection = DriverManager.getConnection(urlWithPrinc, props);
        try {
            LoggingSingleConnectionLimiterIT.loadData(connection, "org000000000000001", "groupId", 100, 20);
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ConnectionLimiter getConnectionLimiter() throws Exception {
        ConnectionQueryServices cqs = null;
        try (Connection testConnection = null;){
            testConnection = this.getConnection();
            PhoenixConnection phoenixConnection = testConnection.unwrap(PhoenixConnection.class);
            cqs = phoenixConnection.getQueryServices();
            ConnectionLimiter connectionLimiter = cqs.getConnectionLimiter();
            return connectionLimiter;
        }
    }

    @Override
    protected Connection getConnection() throws SQLException {
        String profileName = this.testName.getMethodName();
        String urlWithPrinc = url + ":" + profileName + ";";
        Properties props = new Properties();
        Connection connection = DriverManager.getConnection(urlWithPrinc, props);
        connection.setAutoCommit(true);
        return connection;
    }
}

