/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.io.Closeable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.RandomUtils;
import org.apache.curator.framework.CuratorFramework;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.GenericTestUtils;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.StartMiniClusterOption;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.ipc.PhoenixRpcSchedulerFactory;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.phoenix.end2end.PhoenixRegionServerEndpointTestImpl;
import org.apache.phoenix.end2end.ServerMetadataCacheTestImpl;
import org.apache.phoenix.hbase.index.write.TestTrackingParallelWriterIndexCommitter;
import org.apache.phoenix.jdbc.ClusterRoleRecord;
import org.apache.phoenix.jdbc.HighAvailabilityGroup;
import org.apache.phoenix.jdbc.HighAvailabilityPolicy;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixHAAdmin;
import org.apache.phoenix.jdbc.PhoenixHAExecutorServiceProvider;
import org.apache.phoenix.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.phoenix.thirdparty.com.google.common.collect.ImmutableList;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HighAvailabilityTestingUtility {
    private static final Logger LOG = LoggerFactory.getLogger(HighAvailabilityTestingUtility.class);

    public static void doTestBasicOperationsWithConnection(Connection conn, String tableName, String haGroupName) throws SQLException {
        try (Statement stmt = conn.createStatement();){
            Assert.assertNotNull((Object)conn.getClientInfo());
            Assert.assertEquals((Object)haGroupName, (Object)conn.getClientInfo("phoenix.ha.group.name"));
            HighAvailabilityTestingUtility.doTestBasicOperationsWithStatement(conn, stmt, tableName);
        }
    }

    public static void doTestBasicOperationsWithStatement(Connection conn, Statement stmt, String tableName) throws SQLException {
        int id = RandomUtils.nextInt();
        stmt.executeUpdate(String.format("UPSERT INTO %s VALUES(%d, 1984)", tableName, id));
        conn.commit();
        try (ResultSet rs = conn.createStatement().executeQuery(String.format("SELECT v FROM %s WHERE id = %d", tableName, id));){
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1984L, (long)rs.getInt(1));
        }
    }

    public static HighAvailabilityGroup getHighAvailibilityGroup(String jdbcUrl, Properties clientProperties) throws TimeoutException, InterruptedException {
        AtomicReference haGroupRef = new AtomicReference();
        GenericTestUtils.waitFor(() -> {
            try {
                Optional haGroup = HighAvailabilityGroup.get((String)jdbcUrl, (Properties)clientProperties);
                if (!haGroup.isPresent()) {
                    return false;
                }
                haGroupRef.set((HighAvailabilityGroup)haGroup.get());
                return true;
            }
            catch (SQLException throwables) {
                return false;
            }
        }, (int)1000, (int)180000);
        return (HighAvailabilityGroup)haGroupRef.get();
    }

    public static List<PhoenixHAExecutorServiceProvider.PhoenixHAClusterExecutorServices> getListOfSingleThreadExecutorServices() {
        return ImmutableList.of((Object)new PhoenixHAExecutorServiceProvider.PhoenixHAClusterExecutorServices(Executors.newFixedThreadPool(1), Executors.newFixedThreadPool(1)), (Object)new PhoenixHAExecutorServiceProvider.PhoenixHAClusterExecutorServices(Executors.newFixedThreadPool(1), Executors.newFixedThreadPool(1)));
    }

    public static Properties getHATestProperties() {
        Properties properties = new Properties();
        properties.setProperty("phoenix.query.request.metrics.enabled", String.valueOf(true));
        properties.setProperty("phoenix.ha.failover.timeout.ms", "30000");
        properties.setProperty("phoenix.ha.zk.retry.max", "3");
        properties.setProperty("phoenix.ha.zk.retry.max.sleep.ms", "1000");
        properties.setProperty("hbase.zookeeper.sync.timeout.millis", "1000");
        properties.setProperty("zookeeper.session.timeout", "3000");
        properties.setProperty("phoenix.ha.transition.timeout.ms", "3000");
        properties.setProperty("zookeeper.recovery.retry.maxsleeptime", "1000");
        properties.setProperty("zookeeper.recovery.retry", "1");
        properties.setProperty("zookeeper.recovery.retry.intervalmill", "10");
        properties.setProperty("hbase.client.retries.number", "4");
        properties.setProperty("hbase.client.pause", "2000");
        properties.setProperty("hbase.rpc.timeout", "2000");
        properties.setProperty("hbase.client.meta.operation.timeout", "2000");
        properties.setProperty("hbase.ipc.client.socket.timeout.connect", "2000");
        properties.setProperty("hbase.ipc.client.socket.timeout.read", "2000");
        properties.setProperty("hbase.ipc.client.socket.timeout.write", "2000");
        properties.setProperty("replication.source.shipedits.timeout", "5000");
        properties.setProperty("hbase.server.thread.wakefrequency", "100");
        return properties;
    }

    public static class HBaseTestingUtilityPair
    implements Closeable {
        private final HBaseTestingUtility hbaseCluster1 = new HBaseTestingUtility();
        private final HBaseTestingUtility hbaseCluster2 = new HBaseTestingUtility();
        private String zkUrl1;
        private String zkUrl2;
        private PhoenixHAAdmin haAdmin1;
        private PhoenixHAAdmin haAdmin2;
        private Admin admin1;
        private Admin admin2;
        @VisibleForTesting
        static final String PRINCIPAL = "USER_FOO";

        public HBaseTestingUtilityPair() {
            Configuration conf1 = this.hbaseCluster1.getConfiguration();
            Configuration conf2 = this.hbaseCluster2.getConfiguration();
            HBaseTestingUtilityPair.setUpDefaultHBaseConfig(conf1);
            HBaseTestingUtilityPair.setUpDefaultHBaseConfig(conf2);
        }

        public void start() throws Exception {
            this.hbaseCluster1.startMiniCluster();
            this.hbaseCluster2.startMiniCluster();
            String confAddress1 = this.hbaseCluster1.getConfiguration().get("hbase.zookeeper.quorum");
            String confAddress2 = this.hbaseCluster2.getConfiguration().get("hbase.zookeeper.quorum");
            this.zkUrl1 = String.format("%s\\:%d::/hbase", confAddress1, this.hbaseCluster1.getZkCluster().getClientPort());
            this.zkUrl2 = String.format("%s\\:%d::/hbase", confAddress2, this.hbaseCluster2.getZkCluster().getClientPort());
            this.haAdmin1 = new PhoenixHAAdmin(this.getZkUrl1(), this.hbaseCluster1.getConfiguration(), PhoenixHAAdmin.HighAvailibilityCuratorProvider.INSTANCE);
            this.haAdmin2 = new PhoenixHAAdmin(this.getZkUrl2(), this.hbaseCluster2.getConfiguration(), PhoenixHAAdmin.HighAvailibilityCuratorProvider.INSTANCE);
            this.admin1 = this.hbaseCluster1.getConnection().getAdmin();
            this.admin2 = this.hbaseCluster2.getConnection().getAdmin();
            ReplicationPeerConfig replicationPeerConfig1 = ReplicationPeerConfig.newBuilder().setClusterKey(this.hbaseCluster2.getClusterKey()).build();
            ReplicationPeerConfig replicationPeerConfig2 = ReplicationPeerConfig.newBuilder().setClusterKey(this.hbaseCluster1.getClusterKey()).build();
            this.admin1.addReplicationPeer("1", replicationPeerConfig1);
            this.admin2.addReplicationPeer("1", replicationPeerConfig2);
            LOG.info("MiniHBase DR cluster pair is ready for testing.  Cluster Urls [{},{}]", (Object)this.getZkUrl1(), (Object)this.getZkUrl2());
            this.logClustersStates();
        }

        public String getURL(int clusterIndex, ClusterRoleRecord.RegistryType registryType) {
            if (registryType == null) {
                return clusterIndex == 1 ? this.zkUrl1 : this.zkUrl2;
            }
            String masterAddress1 = this.hbaseCluster1.getConfiguration().get("hbase.masters");
            String masterAddress2 = this.hbaseCluster2.getConfiguration().get("hbase.masters");
            switch (registryType) {
                case RPC: 
                case MASTER: {
                    return clusterIndex == 1 ? masterAddress1.replaceAll(":", "\\\\:") : masterAddress2.replaceAll(":", "\\\\:");
                }
            }
            return clusterIndex == 1 ? this.zkUrl1 : this.zkUrl2;
        }

        public void initClusterRole(String haGroupName, HighAvailabilityPolicy policy) throws Exception {
            ClusterRoleRecord record = new ClusterRoleRecord(haGroupName, policy, this.getZkUrl1(), ClusterRoleRecord.ClusterRole.ACTIVE, this.getZkUrl2(), ClusterRoleRecord.ClusterRole.STANDBY, 1L);
            this.addRoleRecordToClusters(record);
        }

        public void initClusterRole(String haGroupName, HighAvailabilityPolicy policy, ClusterRoleRecord.RegistryType type) throws Exception {
            ClusterRoleRecord record = new ClusterRoleRecord(haGroupName, policy, type, this.getURL(1, type), ClusterRoleRecord.ClusterRole.ACTIVE, this.getURL(2, type), ClusterRoleRecord.ClusterRole.STANDBY, 1L);
            this.addRoleRecordToClusters(record);
        }

        private void addRoleRecordToClusters(ClusterRoleRecord record) throws Exception {
            int failures = 0;
            do {
                try {
                    this.haAdmin1.createOrUpdateDataOnZookeeper(record);
                }
                catch (Exception e) {
                    ++failures;
                }
            } while (failures > 0 && failures < 4);
            failures = 0;
            do {
                try {
                    this.haAdmin2.createOrUpdateDataOnZookeeper(record);
                }
                catch (Exception e) {
                    ++failures;
                    Thread.sleep(200L);
                }
            } while (failures > 0 && failures < 4);
        }

        public void transitClusterRole(HighAvailabilityGroup haGroup, ClusterRoleRecord.ClusterRole role1, ClusterRoleRecord.ClusterRole role2) throws Exception {
            ClusterRoleRecord newRoleRecord = new ClusterRoleRecord(haGroup.getGroupInfo().getName(), haGroup.getRoleRecord().getPolicy(), haGroup.getRoleRecord().getRegistryType(), this.getURL(1, haGroup.getRoleRecord().getRegistryType()), role1, this.getURL(2, haGroup.getRoleRecord().getRegistryType()), role2, haGroup.getRoleRecord().getVersion() + 1L);
            this.applyNewRoleRecord(newRoleRecord, haGroup);
        }

        public void transitClusterRoleRecordRegistry(HighAvailabilityGroup haGroup, ClusterRoleRecord.RegistryType type) throws Exception {
            ClusterRoleRecord newRoleRecord = new ClusterRoleRecord(haGroup.getGroupInfo().getName(), haGroup.getRoleRecord().getPolicy(), type, this.getURL(1, type), ClusterRoleRecord.ClusterRole.ACTIVE, this.getURL(2, type), ClusterRoleRecord.ClusterRole.STANDBY, haGroup.getRoleRecord().getVersion() + 1L);
            this.applyNewRoleRecord(newRoleRecord, haGroup);
        }

        public void refreshClusterRoleRecordAfterClusterRestart(HighAvailabilityGroup haGroup, ClusterRoleRecord.ClusterRole role1, ClusterRoleRecord.ClusterRole role2) throws Exception {
            ClusterRoleRecord newRoleRecord = new ClusterRoleRecord(haGroup.getGroupInfo().getName(), haGroup.getRoleRecord().getPolicy(), haGroup.getRoleRecord().getRegistryType(), this.getURL(1, haGroup.getRoleRecord().getRegistryType()), role1, this.getURL(2, haGroup.getRoleRecord().getRegistryType()), role2, haGroup.getRoleRecord().getVersion() + 1L);
            this.applyNewRoleRecord(newRoleRecord, haGroup);
        }

        private void applyNewRoleRecord(ClusterRoleRecord newRoleRecord, HighAvailabilityGroup haGroup) throws Exception {
            LOG.info("Transiting cluster role for HA group {} V{}->V{}, existing: {}, new: {}", new Object[]{haGroup.getGroupInfo().getName(), haGroup.getRoleRecord().getVersion(), newRoleRecord.getVersion(), haGroup.getRoleRecord(), newRoleRecord});
            boolean successAtLeastOnce = false;
            try {
                this.haAdmin1.createOrUpdateDataOnZookeeper(newRoleRecord);
                successAtLeastOnce = true;
            }
            catch (IOException e) {
                LOG.warn("Fail to update new record on {} because {}", (Object)this.getZkUrl1(), (Object)e.getMessage());
            }
            try {
                this.haAdmin2.createOrUpdateDataOnZookeeper(newRoleRecord);
                successAtLeastOnce = true;
            }
            catch (IOException e) {
                LOG.warn("Fail to update new record on {} because {}", (Object)this.getZkUrl2(), (Object)e.getMessage());
            }
            if (!successAtLeastOnce) {
                throw new IOException("Failed to update the new role record on either cluster");
            }
            org.apache.hadoop.test.GenericTestUtils.waitFor(() -> newRoleRecord.equals((Object)haGroup.getRoleRecord()), (long)1000L, (long)10000L);
            Thread.sleep(5000L);
            LOG.info("Now the HA group {} should have detected and updated V{} cluster role record", (Object)haGroup, (Object)newRoleRecord.getVersion());
        }

        public void logClustersStates() {
            String cluster2Status;
            String cluster1Status;
            try {
                cluster1Status = this.admin1.getClusterMetrics().toString();
            }
            catch (IOException e) {
                cluster1Status = "Unable to get cluster status.";
            }
            try {
                cluster2Status = this.admin2.getClusterMetrics().toString();
            }
            catch (IOException e) {
                cluster2Status = "Unable to get cluster status.";
            }
            LOG.info("Cluster Status [\n{},\n{}\n]", (Object)cluster1Status, (Object)cluster2Status);
        }

        public HBaseTestingUtility getHBaseCluster1() {
            return this.hbaseCluster1;
        }

        public HBaseTestingUtility getHBaseCluster2() {
            return this.hbaseCluster2;
        }

        public Connection getClusterConnection(int clusterIndex, HighAvailabilityGroup haGroup) throws SQLException {
            Properties props = new Properties();
            String url = this.getJdbcUrl(haGroup, this.getURL(clusterIndex, haGroup.getRoleRecord().getRegistryType()));
            return DriverManager.getConnection(url, props);
        }

        public Connection getCluster1Connection(HighAvailabilityGroup haGroup) throws SQLException {
            return this.getClusterConnection(1, haGroup);
        }

        public Connection getCluster2Connection(HighAvailabilityGroup haGroup) throws SQLException {
            return this.getClusterConnection(2, haGroup);
        }

        public boolean checkReplicationComplete() {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            return true;
        }

        public static void doTestWhenOneHBaseDown(HBaseTestingUtility cluster, Testable testable) throws Exception {
            int zkClientPort = cluster.getZkCluster().getClientPort();
            try {
                LOG.info("Shutting down HBase cluster using ZK localhost:{}", (Object)zkClientPort);
                cluster.shutdownMiniHBaseCluster();
                LOG.info("Start testing when HBase is down using ZK localhost:{}", (Object)zkClientPort);
                testable.test();
                LOG.info("Test succeeded when HBase is down using ZK localhost:{}", (Object)zkClientPort);
            }
            finally {
                LOG.info("Finished testing when HBase is down using ZK localhost:{}", (Object)zkClientPort);
                cluster.startMiniHBaseCluster(StartMiniClusterOption.builder().numMasters(1).numRegionServers(1).build());
                LOG.info("Restarted HBase cluster using ZK localhost:{}", (Object)zkClientPort);
            }
        }

        public static void doTestWhenOneZKDown(HBaseTestingUtility cluster, Testable testable) throws Exception {
            int zkClientPort = cluster.getZkCluster().getClientPort();
            try {
                LOG.info("Shutting down HBase cluster using ZK localhost:{}", (Object)zkClientPort);
                cluster.shutdownMiniHBaseCluster();
                LOG.info("Shutting down ZK cluster at localhost:{}", (Object)zkClientPort);
                cluster.shutdownMiniZKCluster();
                LOG.info("Start testing when ZK & HBase is down at localhost:{}", (Object)zkClientPort);
                testable.test();
                LOG.info("Test succeeded when ZK & HBase is down at localhost:{}", (Object)zkClientPort);
            }
            catch (Throwable throwable) {
                LOG.info("Finished testing when ZK & HBase is down at localhost:{}", (Object)zkClientPort);
                cluster.startMiniZKCluster(1, new int[]{zkClientPort});
                LOG.info("Restarted ZK cluster at localhost:{}", (Object)zkClientPort);
                cluster.startMiniHBaseCluster(StartMiniClusterOption.builder().numMasters(1).numRegionServers(1).build());
                LOG.info("Restarted HBase cluster using ZK localhost:{}", (Object)zkClientPort);
                throw throwable;
            }
            LOG.info("Finished testing when ZK & HBase is down at localhost:{}", (Object)zkClientPort);
            cluster.startMiniZKCluster(1, new int[]{zkClientPort});
            LOG.info("Restarted ZK cluster at localhost:{}", (Object)zkClientPort);
            cluster.startMiniHBaseCluster(StartMiniClusterOption.builder().numMasters(1).numRegionServers(1).build());
            LOG.info("Restarted HBase cluster using ZK localhost:{}", (Object)zkClientPort);
        }

        public String getJdbcHAUrl() {
            return this.getJdbcHAUrl(PRINCIPAL);
        }

        public String getJdbcHAUrl(String principal) {
            return String.format("%s:[%s|%s]:%s", "jdbc:phoenix+zk", this.getZkUrl1(), this.getZkUrl2(), principal);
        }

        public String getJdbcHAUrlWithoutPrincipal() {
            return String.format("%s:[%s|%s]", "jdbc:phoenix+zk", this.getZkUrl1(), this.getZkUrl2());
        }

        public String getJdbcUrl1(HighAvailabilityGroup haGroup) {
            return this.getJdbcUrl(haGroup, this.getURL(1, haGroup.getRoleRecord().getRegistryType()));
        }

        public String getJdbcUrl1(HighAvailabilityGroup haGroup, String principal) {
            return this.getJdbcUrl(haGroup, this.getURL(1, haGroup.getRoleRecord().getRegistryType()), principal);
        }

        public String getJdbcUrl2(HighAvailabilityGroup haGroup) {
            return this.getJdbcUrl(haGroup, this.getURL(2, haGroup.getRoleRecord().getRegistryType()));
        }

        public String getJdbcUrl2(HighAvailabilityGroup haGroup, String principal) {
            return this.getJdbcUrl(haGroup, this.getURL(2, haGroup.getRoleRecord().getRegistryType()), principal);
        }

        public String getJdbcUrl(HighAvailabilityGroup haGroup, String url) {
            String interimUrl = this.getUrlWithoutPrincipal(haGroup, url);
            return String.format("%s:%s", interimUrl, PRINCIPAL);
        }

        public String getJdbcUrl(HighAvailabilityGroup haGroup, String url, String principal) {
            String interimUrl = this.getUrlWithoutPrincipal(haGroup, url);
            return String.format("%s:%s", interimUrl, principal);
        }

        public String getJdbcUrl(String url) {
            return String.format("jdbc:phoenix+zk:%s:%s", url, PRINCIPAL);
        }

        public String getJdbcUrlWithoutPrincipal(HighAvailabilityGroup haGroup, String url) {
            String interimUrl = this.getUrlWithoutPrincipal(haGroup, url);
            if (interimUrl.endsWith("::")) {
                interimUrl = interimUrl.substring(0, interimUrl.length() - 2);
            }
            return interimUrl;
        }

        public String getZkUrl1() {
            return this.zkUrl1;
        }

        public String getZkUrl2() {
            return this.zkUrl2;
        }

        private String getUrlWithoutPrincipal(HighAvailabilityGroup haGroup, String url) {
            StringBuilder sb = new StringBuilder();
            switch (haGroup.getRoleRecord().getRegistryType()) {
                case MASTER: {
                    return sb.append("jdbc:phoenix+master").append(":").append(url).append("::").toString();
                }
                case RPC: {
                    return sb.append("jdbc:phoenix+rpc").append(":").append(url).append("::").toString();
                }
            }
            return sb.append("jdbc:phoenix+zk").append(":").append(url).toString();
        }

        public CuratorFramework createCurator1() throws IOException {
            Properties properties = new Properties();
            this.getHBaseCluster1().getConfiguration().iterator().forEachRemaining(k -> properties.setProperty((String)k.getKey(), (String)k.getValue()));
            return HighAvailabilityGroup.getCurator((String)this.getZkUrl1(), (Properties)properties);
        }

        public CuratorFramework createCurator2() throws IOException {
            Properties properties = new Properties();
            this.getHBaseCluster2().getConfiguration().iterator().forEachRemaining(k -> properties.setProperty((String)k.getKey(), (String)k.getValue()));
            return HighAvailabilityGroup.getCurator((String)this.getZkUrl2(), (Properties)properties);
        }

        public void createTableOnClusterPair(HighAvailabilityGroup haGroup, String tableName) throws SQLException {
            this.createTableOnClusterPair(haGroup, tableName, true);
        }

        public void createTableOnClusterPair(HighAvailabilityGroup haGroup, String tableName, boolean replicationScope) throws SQLException {
            for (String url : Arrays.asList(this.getURL(1, haGroup.getRoleRecord().getRegistryType()), this.getURL(2, haGroup.getRoleRecord().getRegistryType()))) {
                String jdbcUrl = this.getJdbcUrl(haGroup, url);
                Connection conn = DriverManager.getConnection(jdbcUrl, new Properties());
                try {
                    conn.createStatement().execute(String.format("CREATE TABLE IF NOT EXISTS %s (\nid INTEGER PRIMARY KEY,\nv INTEGER\n) REPLICATION_SCOPE=%d", tableName, replicationScope ? 1 : 0));
                    conn.createStatement().execute(String.format("CREATE LOCAL INDEX IF NOT EXISTS IDX_%s ON %s(v)", tableName, tableName));
                    conn.commit();
                    ((PhoenixConnection)conn).getQueryServices().clearCache();
                }
                finally {
                    if (conn == null) continue;
                    conn.close();
                }
            }
            LOG.info("Created table {} on cluster pair {}", (Object)tableName, (Object)this);
        }

        public void createTenantSpecificTable(HighAvailabilityGroup haGroup, String tableName) throws SQLException {
            for (String url : Arrays.asList(this.getURL(1, haGroup.getRoleRecord().getRegistryType()), this.getURL(2, haGroup.getRoleRecord().getRegistryType()))) {
                String jdbcUrl = this.getJdbcUrl(haGroup, url);
                Connection conn = DriverManager.getConnection(jdbcUrl, new Properties());
                try {
                    conn.createStatement().execute(String.format("CREATE TABLE IF NOT EXISTS %s (\ntenant_id VARCHAR NOT NULL,\nid INTEGER NOT NULL,\nv INTEGER\nCONSTRAINT pk PRIMARY KEY (tenant_id, id)) REPLICATION_SCOPE=1, MULTI_TENANT=true", tableName));
                    conn.commit();
                    ((PhoenixConnection)conn).getQueryServices().clearCache();
                }
                finally {
                    if (conn == null) continue;
                    conn.close();
                }
            }
            LOG.info("Created multi-tenant table {} on cluster pair {}", (Object)tableName, (Object)this);
        }

        public void restartCluster1() throws Exception {
            try {
                this.hbaseCluster1.shutdownMiniHBaseCluster();
                this.hbaseCluster1.shutdownMiniZKCluster();
            }
            catch (Throwable throwable) {
                this.hbaseCluster1.startMiniZKCluster(1, new int[0]);
                this.hbaseCluster1.startMiniHBaseCluster(StartMiniClusterOption.builder().numMasters(1).numRegionServers(1).build());
                String confAddress = this.hbaseCluster1.getConfiguration().get("hbase.zookeeper.quorum");
                this.zkUrl1 = String.format("%s\\:%d::/hbase", confAddress, this.hbaseCluster1.getZkCluster().getClientPort());
                this.haAdmin1 = new PhoenixHAAdmin(this.getZkUrl1(), this.hbaseCluster1.getConfiguration(), PhoenixHAAdmin.HighAvailibilityCuratorProvider.INSTANCE);
                this.admin1 = this.hbaseCluster1.getConnection().getAdmin();
                throw throwable;
            }
            this.hbaseCluster1.startMiniZKCluster(1, new int[0]);
            this.hbaseCluster1.startMiniHBaseCluster(StartMiniClusterOption.builder().numMasters(1).numRegionServers(1).build());
            String confAddress = this.hbaseCluster1.getConfiguration().get("hbase.zookeeper.quorum");
            this.zkUrl1 = String.format("%s\\:%d::/hbase", confAddress, this.hbaseCluster1.getZkCluster().getClientPort());
            this.haAdmin1 = new PhoenixHAAdmin(this.getZkUrl1(), this.hbaseCluster1.getConfiguration(), PhoenixHAAdmin.HighAvailibilityCuratorProvider.INSTANCE);
            this.admin1 = this.hbaseCluster1.getConnection().getAdmin();
        }

        public void restartCluster2() throws Exception {
            try {
                this.hbaseCluster2.shutdownMiniHBaseCluster();
                this.hbaseCluster2.shutdownMiniZKCluster();
            }
            catch (Throwable throwable) {
                this.hbaseCluster2.startMiniZKCluster(1, new int[0]);
                this.hbaseCluster2.startMiniHBaseCluster(StartMiniClusterOption.builder().numMasters(1).numRegionServers(1).build());
                String confAddress = this.hbaseCluster2.getConfiguration().get("hbase.zookeeper.quorum");
                this.zkUrl2 = String.format("%s\\:%d::/hbase", confAddress, this.hbaseCluster2.getZkCluster().getClientPort());
                this.haAdmin2 = new PhoenixHAAdmin(this.getZkUrl2(), this.hbaseCluster2.getConfiguration(), PhoenixHAAdmin.HighAvailibilityCuratorProvider.INSTANCE);
                this.admin2 = this.hbaseCluster2.getConnection().getAdmin();
                throw throwable;
            }
            this.hbaseCluster2.startMiniZKCluster(1, new int[0]);
            this.hbaseCluster2.startMiniHBaseCluster(StartMiniClusterOption.builder().numMasters(1).numRegionServers(1).build());
            String confAddress = this.hbaseCluster2.getConfiguration().get("hbase.zookeeper.quorum");
            this.zkUrl2 = String.format("%s\\:%d::/hbase", confAddress, this.hbaseCluster2.getZkCluster().getClientPort());
            this.haAdmin2 = new PhoenixHAAdmin(this.getZkUrl2(), this.hbaseCluster2.getConfiguration(), PhoenixHAAdmin.HighAvailibilityCuratorProvider.INSTANCE);
            this.admin2 = this.hbaseCluster2.getConnection().getAdmin();
        }

        @Override
        public void close() throws IOException {
            this.haAdmin1.close();
            this.haAdmin2.close();
            this.admin1.close();
            this.admin2.close();
            try {
                ServerMetadataCacheTestImpl.resetCache();
                this.hbaseCluster1.shutdownMiniCluster();
                this.hbaseCluster2.shutdownMiniCluster();
            }
            catch (Exception e) {
                LOG.error("Got exception to close HBaseTestingUtilityPair", (Throwable)e);
                throw new IOException(e);
            }
            LOG.info("Cluster pair {} is closed successfully.", (Object)this);
        }

        public String toString() {
            return "HBaseTestingUtilityPair{" + this.getZkUrl1() + ", " + this.getZkUrl2() + "}";
        }

        private static void setUpDefaultHBaseConfig(Configuration conf) {
            conf.setInt("phoenix.ha.zk.connection.timeout.ms", 1000);
            conf.setInt("phoenix.ha.zk.session.timeout.ms", 1000);
            conf.setInt("phoenix.ha.zk.retry.base.sleep.ms", 100);
            conf.setInt("phoenix.ha.zk.retry.max", 2);
            conf.setInt("phoenix.ha.zk.retry.max.sleep.ms", 1000);
            conf.set("hbase.regionserver.wal.codec", "org.apache.hadoop.hbase.regionserver.wal.IndexedWALEditCodec");
            conf.set("hbase.region.server.rpc.scheduler.factory.class", PhoenixRpcSchedulerFactory.class.getName());
            conf.setInt("phoenix.index.writer.threads.max", 1);
            conf.setLong("zookeeper.session.timeout", 12000L);
            conf.setLong("hbase.zookeeper.property.tickTime", 6000L);
            conf.setInt("hbase.client.retries.number", 2);
            conf.setBoolean("hbase.unsafe.stream.capability.enforcefalse", false);
            conf.setBoolean("hbase.procedure.store.wal.use.hsync", false);
            conf.setBoolean("hbase.table.sanity.checks", false);
            conf.setInt("hbase.regionserver.handler.count", 5);
            conf.setInt("hbase.regionserver.metahandler.count", 2);
            conf.setInt("hbase.master.handler.count", 2);
            conf.setInt("dfs.namenode.handler.count", 2);
            conf.setInt("dfs.namenode.service.handler.count", 2);
            conf.setInt("dfs.datanode.handler.count", 2);
            conf.setInt("ipc.server.read.threadpool.size", 2);
            conf.setInt("ipc.server.handler.threadpool.size", 2);
            conf.setInt("hbase.regionserver.hlog.syncer.count", 2);
            conf.setInt("hbase.hfile.compaction.discharger.interval", 5000);
            conf.setInt("hbase.hlog.asyncer.number", 2);
            conf.setInt("hbase.assignment.zkevent.workers", 5);
            conf.setInt("hbase.assignment.threads.max", 5);
            conf.setInt("hbase.catalogjanitor.interval", 5000);
            conf.setInt("dfs.replication", 1);
            conf.set("hbase.coprocessor.regionserver.classes", PhoenixRegionServerEndpointTestImpl.class.getName());
            conf.set("phoenix.index.writer.commiter.class", TestTrackingParallelWriterIndexCommitter.class.getName());
        }

        @FunctionalInterface
        public static interface Testable {
            public void test() throws Exception;
        }
    }
}

