/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.ClusterRoleRecord;
import org.apache.phoenix.jdbc.FailoverPhoenixConnection;
import org.apache.phoenix.jdbc.HAURLInfo;
import org.apache.phoenix.jdbc.HighAvailabilityGroup;
import org.apache.phoenix.jdbc.HighAvailabilityPolicy;
import org.apache.phoenix.jdbc.HighAvailabilityTestingUtility;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDriver;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.junit.rules.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={NeedsOwnMiniClusterTest.class})
public class HighAvailabilityGroupIT {
    private static final Logger LOG = LoggerFactory.getLogger(HighAvailabilityGroupIT.class);
    private static final HighAvailabilityTestingUtility.HBaseTestingUtilityPair CLUSTERS = new HighAvailabilityTestingUtility.HBaseTestingUtilityPair();
    private Properties clientProperties;
    private String jdbcHAUrl;
    private HighAvailabilityGroup haGroup;
    private HAURLInfo haURLInfo;
    private String haGroupName;
    @Rule
    public final TestName testName = new TestName();
    @Rule
    public final Timeout globalTimeout = new Timeout(180L, TimeUnit.SECONDS);
    private final ClusterRoleRecord.RegistryType registryType = ClusterRoleRecord.RegistryType.ZK;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        CLUSTERS.start();
        DriverManager.registerDriver((Driver)PhoenixDriver.INSTANCE);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        HighAvailabilityGroup.CURATOR_CACHE.invalidateAll();
        DriverManager.deregisterDriver((Driver)PhoenixDriver.INSTANCE);
        CLUSTERS.close();
    }

    @Before
    public void setup() throws Exception {
        this.haGroupName = this.testName.getMethodName();
        this.clientProperties = HighAvailabilityTestingUtility.getHATestProperties();
        this.clientProperties.setProperty("phoenix.ha.group.name", this.haGroupName);
        CLUSTERS.initClusterRole(this.haGroupName, HighAvailabilityPolicy.FAILOVER);
        this.jdbcHAUrl = CLUSTERS.getJdbcHAUrl();
        this.haURLInfo = HighAvailabilityGroup.getUrlInfo((String)this.jdbcHAUrl, (Properties)this.clientProperties);
        this.haGroup = HighAvailabilityTestingUtility.getHighAvailibilityGroup(this.jdbcHAUrl, this.clientProperties);
    }

    @After
    public void tearDown() throws Exception {
        this.haGroup.close();
        try {
            PhoenixDriver.INSTANCE.getConnectionQueryServices(CLUSTERS.getJdbcUrl1(this.haGroup), this.haGroup.getProperties()).close();
            PhoenixDriver.INSTANCE.getConnectionQueryServices(CLUSTERS.getJdbcUrl2(this.haGroup), this.haGroup.getProperties()).close();
        }
        catch (Exception e) {
            LOG.error("Fail to tear down the HA group and the CQS. Will ignore", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGet() throws Exception {
        Optional haGroup2 = Optional.empty();
        try {
            haGroup2 = HighAvailabilityGroup.get((String)this.jdbcHAUrl, (Properties)this.clientProperties);
            Assert.assertTrue((boolean)haGroup2.isPresent());
            Assert.assertSame((Object)this.haGroup, haGroup2.get());
        }
        finally {
            haGroup2.ifPresent(HighAvailabilityGroup::close);
        }
        String haGroupName3 = this.testName.getMethodName() + RandomStringUtils.randomAlphabetic((int)3);
        CLUSTERS.initClusterRole(haGroupName3, HighAvailabilityPolicy.FAILOVER);
        this.clientProperties.setProperty("phoenix.ha.group.name", haGroupName3);
        Optional haGroup3 = Optional.empty();
        try {
            haGroup3 = HighAvailabilityGroup.get((String)this.jdbcHAUrl, (Properties)this.clientProperties);
            Assert.assertTrue((boolean)haGroup3.isPresent());
            Assert.assertNotSame((Object)this.haGroup, haGroup3.get());
        }
        finally {
            haGroup3.ifPresent(HighAvailabilityGroup::close);
        }
        this.clientProperties.setProperty("phoenix.ha.group.name", this.haGroup.getGroupInfo().getName());
        Optional haGroup4 = Optional.empty();
        try {
            haGroup4 = HighAvailabilityGroup.get((String)this.jdbcHAUrl, (Properties)this.clientProperties);
            Assert.assertTrue((boolean)haGroup4.isPresent());
            Assert.assertSame((Object)this.haGroup, haGroup4.get());
        }
        finally {
            haGroup4.ifPresent(HighAvailabilityGroup::close);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetWithDifferentPrincipals() throws Exception {
        this.assertJDBCUrlForGivenHAGroup(this.haGroup, this.haURLInfo, null);
        Optional haGroup2 = Optional.empty();
        try {
            String principal = RandomStringUtils.randomAlphabetic((int)5);
            String haUrl2 = CLUSTERS.getJdbcHAUrl(principal);
            HAURLInfo haURLInfo2 = HighAvailabilityGroup.getUrlInfo((String)haUrl2, (Properties)this.clientProperties);
            haGroup2 = HighAvailabilityGroup.get((String)haUrl2, (Properties)this.clientProperties);
            Assert.assertTrue((boolean)haGroup2.isPresent());
            Assert.assertSame((Object)this.haGroup, haGroup2.get());
            this.assertJDBCUrlForGivenHAGroup((HighAvailabilityGroup)haGroup2.get(), haURLInfo2, principal);
        }
        finally {
            haGroup2.ifPresent(HighAvailabilityGroup::close);
        }
        String haGroupName3 = this.testName.getMethodName() + RandomStringUtils.randomAlphabetic((int)3);
        CLUSTERS.initClusterRole(haGroupName3, HighAvailabilityPolicy.FAILOVER);
        this.clientProperties.setProperty("phoenix.ha.group.name", haGroupName3);
        Optional haGroup3 = Optional.empty();
        Optional haGroup4 = Optional.empty();
        try {
            HAURLInfo haurlInfo3 = HighAvailabilityGroup.getUrlInfo((String)this.jdbcHAUrl, (Properties)this.clientProperties);
            haGroup3 = HighAvailabilityGroup.get((String)this.jdbcHAUrl, (Properties)this.clientProperties);
            Assert.assertTrue((boolean)haGroup3.isPresent());
            Assert.assertNotSame((Object)this.haGroup, haGroup3.get());
            Assert.assertNotSame((Object)this.haGroup.getGroupInfo(), (Object)((HighAvailabilityGroup)haGroup3.get()).getGroupInfo());
            this.assertJDBCUrlForGivenHAGroup((HighAvailabilityGroup)haGroup3.get(), haurlInfo3, null);
            String haUrl4 = CLUSTERS.getJdbcHAUrlWithoutPrincipal();
            HAURLInfo haURLInfo4 = HighAvailabilityGroup.getUrlInfo((String)haUrl4, (Properties)this.clientProperties);
            haGroup4 = HighAvailabilityGroup.get((String)haUrl4, (Properties)this.clientProperties);
            Assert.assertTrue((boolean)haGroup4.isPresent());
            Assert.assertNotSame((Object)this.haGroup, haGroup4.get());
            Assert.assertSame(haGroup3.get(), haGroup4.get());
            Assert.assertNotSame((Object)this.haGroup.getGroupInfo(), (Object)((HighAvailabilityGroup)haGroup4.get()).getGroupInfo());
            Assert.assertSame((Object)((HighAvailabilityGroup)haGroup3.get()).getGroupInfo(), (Object)((HighAvailabilityGroup)haGroup4.get()).getGroupInfo());
            Assert.assertNotEquals((Object)haurlInfo3, (Object)haURLInfo4);
        }
        finally {
            haGroup3.ifPresent(HighAvailabilityGroup::close);
            haGroup4.ifPresent(HighAvailabilityGroup::close);
        }
        this.clientProperties.setProperty("phoenix.ha.group.name", this.haGroup.getGroupInfo().getName());
        Optional haGroup5 = Optional.empty();
        try {
            String principal = RandomStringUtils.randomAlphabetic((int)5);
            String haUrl5 = CLUSTERS.getJdbcHAUrl(principal);
            HAURLInfo haURLInfo5 = HighAvailabilityGroup.getUrlInfo((String)haUrl5, (Properties)this.clientProperties);
            haGroup5 = HighAvailabilityGroup.get((String)haUrl5, (Properties)this.clientProperties);
            Assert.assertTrue((boolean)haGroup5.isPresent());
            Assert.assertSame((Object)this.haGroup, haGroup5.get());
            this.assertJDBCUrlForGivenHAGroup((HighAvailabilityGroup)haGroup5.get(), haURLInfo5, principal);
        }
        finally {
            haGroup5.ifPresent(HighAvailabilityGroup::close);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHAGroupMappings() throws Exception {
        Optional haGroup2 = Optional.empty();
        try {
            String principal = RandomStringUtils.randomAlphabetic((int)5);
            String haUrl2 = CLUSTERS.getJdbcHAUrl(principal);
            HAURLInfo haURLInfo2 = HighAvailabilityGroup.getUrlInfo((String)haUrl2, (Properties)this.clientProperties);
            haGroup2 = HighAvailabilityGroup.get((String)haUrl2, (Properties)this.clientProperties);
            Assert.assertTrue((boolean)haGroup2.isPresent());
            Assert.assertSame((Object)this.haGroup, haGroup2.get());
            Assert.assertEquals((long)2L, (long)((Set)HighAvailabilityGroup.URLS.get(this.haGroup.getGroupInfo())).size());
            Assert.assertTrue((boolean)((Set)HighAvailabilityGroup.URLS.get(this.haGroup.getGroupInfo())).contains(haURLInfo2));
        }
        finally {
            haGroup2.ifPresent(HighAvailabilityGroup::close);
        }
        String haGroupName3 = this.testName.getMethodName() + RandomStringUtils.randomAlphabetic((int)3);
        CLUSTERS.initClusterRole(haGroupName3, HighAvailabilityPolicy.FAILOVER);
        this.clientProperties.setProperty("phoenix.ha.group.name", haGroupName3);
        Optional haGroup3 = Optional.empty();
        Optional haGroup4 = Optional.empty();
        try {
            HAURLInfo haurlInfo3 = HighAvailabilityGroup.getUrlInfo((String)this.jdbcHAUrl, (Properties)this.clientProperties);
            haGroup3 = HighAvailabilityGroup.get((String)this.jdbcHAUrl, (Properties)this.clientProperties);
            Assert.assertTrue((boolean)haGroup3.isPresent());
            Assert.assertNotSame((Object)this.haGroup, haGroup3.get());
            Assert.assertNotSame((Object)this.haGroup.getGroupInfo(), (Object)((HighAvailabilityGroup)haGroup3.get()).getGroupInfo());
            Assert.assertEquals((long)1L, (long)((Set)HighAvailabilityGroup.URLS.get(((HighAvailabilityGroup)haGroup3.get()).getGroupInfo())).size());
            String haUrl4 = CLUSTERS.getJdbcHAUrlWithoutPrincipal();
            HAURLInfo haURLInfo4 = HighAvailabilityGroup.getUrlInfo((String)haUrl4, (Properties)this.clientProperties);
            haGroup4 = HighAvailabilityGroup.get((String)haUrl4, (Properties)this.clientProperties);
            Assert.assertTrue((boolean)haGroup4.isPresent());
            Assert.assertNotSame((Object)this.haGroup, haGroup4.get());
            Assert.assertSame(haGroup3.get(), haGroup4.get());
            Assert.assertEquals((long)2L, (long)((Set)HighAvailabilityGroup.URLS.get(((HighAvailabilityGroup)haGroup4.get()).getGroupInfo())).size());
            Assert.assertNotEquals((Object)haurlInfo3, (Object)haURLInfo4);
        }
        finally {
            haGroup3.ifPresent(HighAvailabilityGroup::close);
            haGroup4.ifPresent(HighAvailabilityGroup::close);
        }
        this.clientProperties.setProperty("phoenix.ha.group.name", this.haGroup.getGroupInfo().getName());
        Optional haGroup5 = Optional.empty();
        try {
            String haUrl5 = CLUSTERS.getJdbcHAUrl();
            HAURLInfo haURLInfo5 = HighAvailabilityGroup.getUrlInfo((String)haUrl5, (Properties)this.clientProperties);
            haGroup5 = HighAvailabilityGroup.get((String)haUrl5, (Properties)this.clientProperties);
            Assert.assertTrue((boolean)haGroup5.isPresent());
            Assert.assertSame((Object)this.haGroup, haGroup5.get());
            Assert.assertEquals((long)2L, (long)((Set)HighAvailabilityGroup.URLS.get(this.haGroup.getGroupInfo())).size());
            Assert.assertTrue((boolean)((Set)HighAvailabilityGroup.URLS.get(this.haGroup.getGroupInfo())).contains(haURLInfo5));
            Assert.assertEquals((Object)haURLInfo5, (Object)this.haURLInfo);
        }
        finally {
            haGroup5.ifPresent(HighAvailabilityGroup::close);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetWithDifferentRecordVersion() throws Exception {
        String haGroupName2 = this.testName.getMethodName() + RandomStringUtils.randomAlphabetic((int)3);
        this.clientProperties.setProperty("phoenix.ha.group.name", haGroupName2);
        String zpath = "/" + haGroupName2;
        ClusterRoleRecord record1 = new ClusterRoleRecord(haGroupName2, HighAvailabilityPolicy.FAILOVER, this.registryType, CLUSTERS.getURL(1, this.registryType), ClusterRoleRecord.ClusterRole.ACTIVE, CLUSTERS.getURL(2, this.registryType), ClusterRoleRecord.ClusterRole.STANDBY, 1L);
        CLUSTERS.createCurator1().create().forPath(zpath, ClusterRoleRecord.toJson((ClusterRoleRecord)record1));
        ClusterRoleRecord record2 = new ClusterRoleRecord(record1.getHaGroupName(), record1.getPolicy(), record1.getRegistryType(), record1.getUrl1(), record1.getRole1(), record1.getUrl2(), record1.getRole2(), record1.getVersion() + 1L);
        CLUSTERS.createCurator2().create().forPath(zpath, ClusterRoleRecord.toJson((ClusterRoleRecord)record2));
        Optional haGroup2 = Optional.empty();
        try {
            haGroup2 = HighAvailabilityGroup.get((String)this.jdbcHAUrl, (Properties)this.clientProperties);
            Assert.assertTrue((boolean)haGroup2.isPresent());
            Assert.assertNotSame(haGroup2.get(), (Object)this.haGroup);
            HighAvailabilityGroup finalHaGroup = (HighAvailabilityGroup)haGroup2.get();
            GenericTestUtils.waitFor(() -> record2.equals((Object)finalHaGroup.getRoleRecord()), (long)100L, (long)30000L);
        }
        finally {
            haGroup2.ifPresent(HighAvailabilityGroup::close);
        }
    }

    @Test
    public void testCanGetHaGroupWhenActiveZKClusterDown() throws Exception {
        String haGroupName2 = this.testName.getMethodName() + "2";
        this.clientProperties.setProperty("phoenix.ha.group.name", haGroupName2);
        CLUSTERS.initClusterRole(haGroupName2, HighAvailabilityPolicy.FAILOVER);
        HighAvailabilityTestingUtility.HBaseTestingUtilityPair.doTestWhenOneZKDown(CLUSTERS.getHBaseCluster1(), () -> {
            try (HighAvailabilityGroup haGroup2 = null;){
                haGroup2 = HighAvailabilityTestingUtility.getHighAvailibilityGroup(this.jdbcHAUrl, this.clientProperties);
                LOG.info("Can get the new HA group {} after both ZK clusters restart", (Object)haGroup2);
            }
        });
    }

    @Test
    public void testCanNotGetHaGroupWhenTwoZKClustersDown() throws Exception {
        String haGroupName2 = this.testName.getMethodName() + "2";
        this.clientProperties.setProperty("phoenix.ha.group.name", haGroupName2);
        CLUSTERS.initClusterRole(haGroupName2, HighAvailabilityPolicy.FAILOVER);
        HighAvailabilityTestingUtility.HBaseTestingUtilityPair.doTestWhenOneZKDown(CLUSTERS.getHBaseCluster1(), () -> HighAvailabilityTestingUtility.HBaseTestingUtilityPair.doTestWhenOneZKDown(CLUSTERS.getHBaseCluster2(), () -> {
            try {
                HighAvailabilityGroup.get((String)this.jdbcHAUrl, (Properties)this.clientProperties);
                Assert.fail((String)"Should have failed because both ZK cluster were shutdown!");
            }
            catch (SQLException e) {
                LOG.info("Got expected SQLException because both ZK clusters are down", (Throwable)e);
                Assert.assertEquals((long)SQLExceptionCode.CANNOT_ESTABLISH_CONNECTION.getErrorCode(), (long)e.getErrorCode());
                Assert.assertTrue((boolean)(e.getCause() instanceof IOException));
            }
        }));
        try (HighAvailabilityGroup haGroup2 = null;){
            haGroup2 = HighAvailabilityTestingUtility.getHighAvailibilityGroup(this.jdbcHAUrl, this.clientProperties);
            LOG.info("Can get the new HA group {} after both ZK clusters restart", (Object)haGroup2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=16000L)
    public void testGetHaGroupFailsFastWhenBothZKClusterDownFromBeginning() {
        String haGroupName = this.testName.getMethodName();
        this.clientProperties.setProperty("phoenix.ha.group.name", haGroupName);
        String badJdbcUrl = String.format("jdbc:phoenix:[%s|%s]", "127.0.0.1:0", "127.0.0.1:1");
        LOG.info("Start testing HighAvailabilityGroup::get() when both ZK clusters are down...");
        try {
            HighAvailabilityGroup.get((String)badJdbcUrl, (Properties)this.clientProperties);
            Assert.fail((String)"Should always throw an exception.");
        }
        catch (SQLException e) {
            LOG.info("Got expected exception", (Throwable)e);
            Assert.assertEquals((long)SQLExceptionCode.CANNOT_ESTABLISH_CONNECTION.getErrorCode(), (long)e.getErrorCode());
        }
        finally {
            LOG.info("Stop testing HighAvailabilityGroup::get() when both ZK clusters are down...");
            long l = 16000L;
        }
    }

    @Test
    public void testGetShouldFailWithoutClusterRoleData() throws SQLException {
        String invalidHaGroupName = this.testName.getMethodName() + RandomStringUtils.randomAlphanumeric((int)3);
        this.clientProperties.setProperty("phoenix.ha.group.name", invalidHaGroupName);
        Assert.assertFalse((boolean)HighAvailabilityGroup.get((String)this.jdbcHAUrl, (Properties)this.clientProperties).isPresent());
    }

    @Test
    public void testGetShouldFailWithNonHAJdbcString() {
        String oldJdbcString = CLUSTERS.getJdbcUrl1(this.haGroup);
        try {
            HighAvailabilityGroup.get((String)oldJdbcString, (Properties)this.clientProperties);
            Assert.fail((String)("Should have failed with invalid connection string '" + oldJdbcString + "'"));
        }
        catch (SQLException e) {
            LOG.info("Got expected exception with invalid connection string {}", (Object)oldJdbcString, (Object)e);
            Assert.assertEquals((long)SQLExceptionCode.MALFORMED_CONNECTION_URL.getErrorCode(), (long)e.getErrorCode());
        }
    }

    @Test
    public void testConnect() throws SQLException {
        Connection connection = this.haGroup.connect(this.clientProperties, this.haURLInfo);
        Assert.assertNotNull((Object)connection);
        Assert.assertNotNull((Object)connection.unwrap(FailoverPhoenixConnection.class));
    }

    @Test
    public void testConnectToOneCluster() throws SQLException {
        String url = CLUSTERS.getJdbcUrl1(this.haGroup);
        PhoenixConnection connection = this.haGroup.connectToOneCluster(url, this.clientProperties, this.haURLInfo);
        Assert.assertEquals((Object)url, (Object)connection.getURL());
        try {
            this.haGroup.connectToOneCluster(null, this.clientProperties, this.haURLInfo);
            Assert.fail((String)"Should have failed since null is not in any HA group");
        }
        catch (Exception e) {
            LOG.info("Got expected exception with invalid null host url", (Throwable)e);
        }
        String randomHostUrl = String.format("%s:%d", RandomStringUtils.randomAlphabetic((int)4), RandomUtils.nextInt((int)0, (int)65536));
        try {
            this.haGroup.connectToOneCluster(randomHostUrl, this.clientProperties, this.haURLInfo);
            Assert.fail((String)("Should have failed since '" + randomHostUrl + "' is not in HA group " + this.haGroup));
        }
        catch (SQLException e) {
            LOG.info("Got expected exception with invalid host url '{}'", (Object)randomHostUrl, (Object)e);
        }
    }

    @Test
    public void testConnectToOneClusterAfterZKRestart() throws Exception {
        String tableName = RandomStringUtils.randomAlphabetic((int)10);
        CLUSTERS.createTableOnClusterPair(this.haGroup, tableName);
        String jdbcUrlToCluster1 = CLUSTERS.getJdbcUrl1(this.haGroup);
        HighAvailabilityTestingUtility.HBaseTestingUtilityPair.doTestWhenOneZKDown(CLUSTERS.getHBaseCluster1(), () -> {
            try {
                DriverManager.getConnection(jdbcUrlToCluster1);
            }
            catch (SQLException e) {
                LOG.info("Got expected IOException when creating Phoenix connection", (Throwable)e);
            }
        });
        try (Connection conn = DriverManager.getConnection(jdbcUrlToCluster1);){
            HighAvailabilityTestingUtility.doTestBasicOperationsWithConnection(conn, tableName, null);
        }
        conn = this.haGroup.connectToOneCluster(jdbcUrlToCluster1, this.clientProperties, this.haURLInfo);
        try {
            HighAvailabilityTestingUtility.doTestBasicOperationsWithConnection(conn, tableName, this.haGroupName);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    @Test
    public void testIsConnectionActive() throws Exception {
        PhoenixConnection conn1 = this.haGroup.connectToOneCluster(CLUSTERS.getJdbcUrl1(this.haGroup), this.clientProperties, this.haURLInfo);
        Assert.assertTrue((boolean)this.haGroup.isActive(conn1));
        PhoenixConnection conn2 = this.haGroup.connectToOneCluster(CLUSTERS.getJdbcUrl2(this.haGroup), this.clientProperties, this.haURLInfo);
        Assert.assertFalse((boolean)this.haGroup.isActive(conn2));
        CLUSTERS.transitClusterRole(this.haGroup, ClusterRoleRecord.ClusterRole.STANDBY, ClusterRoleRecord.ClusterRole.ACTIVE);
        Assert.assertFalse((boolean)this.haGroup.isActive(conn1));
        Assert.assertTrue((boolean)this.haGroup.isActive(conn2));
    }

    @Test
    public void testNodeChange() throws Exception {
        Assert.assertEquals((Object)ClusterRoleRecord.ClusterRole.ACTIVE, (Object)this.haGroup.getRoleRecord().getRole(CLUSTERS.getURL(1, this.registryType)));
        Assert.assertEquals((Object)ClusterRoleRecord.ClusterRole.STANDBY, (Object)this.haGroup.getRoleRecord().getRole(CLUSTERS.getURL(2, this.registryType)));
        CLUSTERS.transitClusterRole(this.haGroup, ClusterRoleRecord.ClusterRole.STANDBY, ClusterRoleRecord.ClusterRole.ACTIVE);
        Assert.assertEquals((Object)ClusterRoleRecord.ClusterRole.STANDBY, (Object)this.haGroup.getRoleRecord().getRole(CLUSTERS.getURL(1, this.registryType)));
        Assert.assertEquals((Object)ClusterRoleRecord.ClusterRole.ACTIVE, (Object)this.haGroup.getRoleRecord().getRole(CLUSTERS.getURL(2, this.registryType)));
    }

    private void assertJDBCUrlForGivenHAGroup(HighAvailabilityGroup haGroup, HAURLInfo haURLInfo, String testPrincipal) {
        String testUrl1 = testPrincipal == null ? CLUSTERS.getJdbcUrl1(haGroup) : CLUSTERS.getJdbcUrl1(haGroup, testPrincipal);
        String testUrl2 = testPrincipal == null ? CLUSTERS.getJdbcUrl2(haGroup) : CLUSTERS.getJdbcUrl2(haGroup, testPrincipal);
        String testHAUrl = testPrincipal == null ? CLUSTERS.getJdbcHAUrl() : CLUSTERS.getJdbcHAUrl(testPrincipal);
        Assert.assertTrue((this.getJdbcUrl1ForGivenHAGroup(haGroup, haURLInfo).equals(testUrl1) || this.getJdbcUrl1ForGivenHAGroup(haGroup, haURLInfo).equals(testUrl2) ? 1 : 0) != 0);
        Assert.assertTrue((this.getJdbcUrl2ForGivenHAGroup(haGroup, haURLInfo).equals(testUrl1) || this.getJdbcUrl2ForGivenHAGroup(haGroup, haURLInfo).equals(testUrl2) ? 1 : 0) != 0);
        Assert.assertEquals((Object)testHAUrl, (Object)this.getJdbcHAUrlForGivenHAGroup(haURLInfo));
    }

    private String getJdbcUrl1ForGivenHAGroup(HighAvailabilityGroup haGroup, HAURLInfo haURLInfo) {
        return HighAvailabilityGroup.getJDBCUrl((String)haGroup.getRoleRecord().getUrl1(), (HAURLInfo)haURLInfo, (ClusterRoleRecord.RegistryType)haGroup.getRoleRecord().getRegistryType());
    }

    private String getJdbcUrl2ForGivenHAGroup(HighAvailabilityGroup haGroup, HAURLInfo haURLInfo) {
        return HighAvailabilityGroup.getJDBCUrl((String)haGroup.getRoleRecord().getUrl2(), (HAURLInfo)haURLInfo, (ClusterRoleRecord.RegistryType)haGroup.getRoleRecord().getRegistryType());
    }

    private String getJdbcHAUrlForGivenHAGroup(HAURLInfo haURLInfo) {
        return HighAvailabilityGroup.getJDBCUrl((String)String.format("[%s|%s]", CLUSTERS.getZkUrl1(), CLUSTERS.getZkUrl2()), (HAURLInfo)haURLInfo, (ClusterRoleRecord.RegistryType)ClusterRoleRecord.RegistryType.ZK);
    }
}

