/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.ClusterRoleRecord;
import org.apache.phoenix.jdbc.FailoverPhoenixConnection;
import org.apache.phoenix.jdbc.HAURLInfo;
import org.apache.phoenix.jdbc.HighAvailabilityGroup;
import org.apache.phoenix.jdbc.HighAvailabilityPolicy;
import org.apache.phoenix.jdbc.HighAvailabilityTestingUtility;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDriver;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.junit.rules.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={NeedsOwnMiniClusterTest.class})
public class HighAvailabilityGroup2IT {
    private static final Logger LOG = LoggerFactory.getLogger(HighAvailabilityGroup2IT.class);
    private static final HighAvailabilityTestingUtility.HBaseTestingUtilityPair CLUSTERS = new HighAvailabilityTestingUtility.HBaseTestingUtilityPair();
    private Properties clientProperties;
    private String jdbcHAUrl;
    private HighAvailabilityGroup haGroup;
    private HAURLInfo haURLInfo;
    private String haGroupName;
    @Rule
    public final TestName testName = new TestName();
    @Rule
    public final Timeout globalTimeout = new Timeout(180L, TimeUnit.SECONDS);
    private final ClusterRoleRecord.RegistryType registryType = ClusterRoleRecord.RegistryType.ZK;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        CLUSTERS.start();
        DriverManager.registerDriver((Driver)PhoenixDriver.INSTANCE);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        HighAvailabilityGroup.CURATOR_CACHE.invalidateAll();
        DriverManager.deregisterDriver((Driver)PhoenixDriver.INSTANCE);
        CLUSTERS.close();
    }

    @Before
    public void setup() throws Exception {
        this.haGroupName = this.testName.getMethodName();
        this.clientProperties = HighAvailabilityTestingUtility.getHATestProperties();
        this.clientProperties.setProperty("phoenix.ha.group.name", this.haGroupName);
        CLUSTERS.initClusterRole(this.haGroupName, HighAvailabilityPolicy.FAILOVER);
        this.jdbcHAUrl = CLUSTERS.getJdbcHAUrl();
        this.haURLInfo = HighAvailabilityGroup.getUrlInfo((String)this.jdbcHAUrl, (Properties)this.clientProperties);
        this.haGroup = HighAvailabilityTestingUtility.getHighAvailibilityGroup(this.jdbcHAUrl, this.clientProperties);
    }

    @After
    public void tearDown() throws Exception {
        this.haGroup.close();
        try {
            PhoenixDriver.INSTANCE.getConnectionQueryServices(CLUSTERS.getJdbcUrl1(this.haGroup), this.haGroup.getProperties()).close();
            PhoenixDriver.INSTANCE.getConnectionQueryServices(CLUSTERS.getJdbcUrl2(this.haGroup), this.haGroup.getProperties()).close();
        }
        catch (Exception e) {
            LOG.error("Fail to tear down the HA group and the CQS. Will ignore", (Throwable)e);
        }
    }

    @Test
    public void testCanConnectWhenStandbyHBaseClusterDown() throws Exception {
        HighAvailabilityTestingUtility.HBaseTestingUtilityPair.doTestWhenOneHBaseDown(CLUSTERS.getHBaseCluster2(), () -> {
            Connection connection = this.haGroup.connect(this.clientProperties, this.haURLInfo);
            Assert.assertNotNull((Object)connection);
            Assert.assertNotNull((Object)connection.unwrap(FailoverPhoenixConnection.class));
        });
    }

    @Test
    public void testCanConnectWhenStandbyZKClusterDown() throws Exception {
        HighAvailabilityTestingUtility.HBaseTestingUtilityPair.doTestWhenOneZKDown(CLUSTERS.getHBaseCluster2(), () -> {
            HighAvailabilityGroup.CURATOR_CACHE.invalidateAll();
            Connection connection = this.haGroup.connect(this.clientProperties, this.haURLInfo);
            Assert.assertNotNull((Object)connection);
            Assert.assertNotNull((Object)connection.unwrap(FailoverPhoenixConnection.class));
        });
    }

    @Test
    public void testCanConnectNewGroupWhenStandbyHBaseClusterDown() throws Exception {
        HighAvailabilityTestingUtility.HBaseTestingUtilityPair.doTestWhenOneHBaseDown(CLUSTERS.getHBaseCluster2(), () -> {
            String haGroupName2 = this.testName.getMethodName() + RandomStringUtils.randomAlphabetic((int)3);
            this.clientProperties.setProperty("phoenix.ha.group.name", haGroupName2);
            CLUSTERS.initClusterRole(haGroupName2, HighAvailabilityPolicy.FAILOVER);
            Optional haGroup2 = Optional.empty();
            try {
                HAURLInfo haURLInfo = HighAvailabilityGroup.getUrlInfo((String)this.jdbcHAUrl, (Properties)this.clientProperties);
                haGroup2 = HighAvailabilityGroup.get((String)this.jdbcHAUrl, (Properties)this.clientProperties);
                Assert.assertTrue((boolean)haGroup2.isPresent());
                Assert.assertNotSame(haGroup2.get(), (Object)this.haGroup);
                try (Connection connection = ((HighAvailabilityGroup)haGroup2.get()).connect(this.clientProperties, haURLInfo);){
                    Assert.assertNotNull((Object)connection);
                    Assert.assertNotNull((Object)connection.unwrap(FailoverPhoenixConnection.class));
                }
            }
            finally {
                haGroup2.ifPresent(HighAvailabilityGroup::close);
            }
        });
    }

    @Test
    public void testCanConnectNewGroupWhenStandbyZKClusterDown() throws Exception {
        String haGroupName2 = this.testName.getMethodName() + RandomStringUtils.randomAlphabetic((int)3);
        this.clientProperties.setProperty("phoenix.ha.group.name", haGroupName2);
        CLUSTERS.initClusterRole(haGroupName2, HighAvailabilityPolicy.FAILOVER);
        HighAvailabilityTestingUtility.HBaseTestingUtilityPair.doTestWhenOneZKDown(CLUSTERS.getHBaseCluster2(), () -> {
            Optional haGroup2 = Optional.empty();
            try {
                HAURLInfo haURLInfo = HighAvailabilityGroup.getUrlInfo((String)this.jdbcHAUrl, (Properties)this.clientProperties);
                haGroup2 = HighAvailabilityGroup.get((String)this.jdbcHAUrl, (Properties)this.clientProperties);
                Assert.assertTrue((boolean)haGroup2.isPresent());
                Assert.assertNotSame(haGroup2.get(), (Object)this.haGroup);
                Connection connection = ((HighAvailabilityGroup)haGroup2.get()).connect(this.clientProperties, haURLInfo);
                Assert.assertNotNull((Object)connection);
                Assert.assertNotNull((Object)connection.unwrap(FailoverPhoenixConnection.class));
            }
            finally {
                haGroup2.ifPresent(HighAvailabilityGroup::close);
            }
        });
    }

    @Test
    public void testCanNotEstablishConnectionWhenActiveHBaseClusterDown() throws Exception {
        HighAvailabilityTestingUtility.HBaseTestingUtilityPair.doTestWhenOneHBaseDown(CLUSTERS.getHBaseCluster1(), () -> {
            try {
                this.haGroup.connectActive(this.clientProperties, this.haURLInfo);
                Assert.fail((String)"Should have failed because ACTIVE HBase cluster is down.");
            }
            catch (SQLException e) {
                LOG.info("Got expected exception when ACTIVE HBase cluster is down", (Throwable)e);
                Assert.assertEquals((long)SQLExceptionCode.CANNOT_ESTABLISH_CONNECTION.getErrorCode(), (long)e.getErrorCode());
            }
        });
    }

    @Test
    public void testConnectActiveWhenActiveZKClusterRestarts() throws Exception {
        HighAvailabilityTestingUtility.HBaseTestingUtilityPair.doTestWhenOneZKDown(CLUSTERS.getHBaseCluster1(), () -> {
            try {
                this.haGroup.connectActive(this.clientProperties, this.haURLInfo);
                Assert.fail((String)"Should have failed because of ACTIVE ZK cluster is down.");
            }
            catch (SQLException e) {
                LOG.info("Got expected exception when ACTIVE ZK cluster is down", (Throwable)e);
                Assert.assertEquals((long)SQLExceptionCode.CANNOT_ESTABLISH_CONNECTION.getErrorCode(), (long)e.getErrorCode());
            }
        });
        try (PhoenixConnection conn = this.haGroup.connectActive(this.clientProperties, this.haURLInfo);){
            Assert.assertNotNull((Object)conn);
            LOG.info("Successfully connect to HA group {} after restarting ACTIVE ZK", (Object)this.haGroup);
        }
    }

    @Test
    public void testOneZKStartsAfterInit() throws Exception {
        String haGroupName2 = this.testName.getMethodName() + RandomStringUtils.randomAlphabetic((int)3);
        this.clientProperties.setProperty("phoenix.ha.group.name", haGroupName2);
        String zpath = "/" + haGroupName2;
        ClusterRoleRecord record1 = new ClusterRoleRecord(haGroupName2, HighAvailabilityPolicy.FAILOVER, this.registryType, CLUSTERS.getURL(1, this.registryType), ClusterRoleRecord.ClusterRole.ACTIVE, CLUSTERS.getURL(2, this.registryType), ClusterRoleRecord.ClusterRole.STANDBY, 1L);
        CLUSTERS.createCurator1().create().forPath(zpath, ClusterRoleRecord.toJson((ClusterRoleRecord)record1));
        ClusterRoleRecord record2 = new ClusterRoleRecord(record1.getHaGroupName(), record1.getPolicy(), record1.getRegistryType(), record1.getUrl1(), record1.getRole1(), record1.getUrl2(), record1.getRole2(), record1.getVersion() + 1L);
        CLUSTERS.createCurator2().create().forPath(zpath, ClusterRoleRecord.toJson((ClusterRoleRecord)record2));
        HighAvailabilityTestingUtility.HBaseTestingUtilityPair.doTestWhenOneZKDown(CLUSTERS.getHBaseCluster2(), () -> {
            Optional haGroup2 = HighAvailabilityGroup.get((String)this.jdbcHAUrl, (Properties)this.clientProperties);
            Assert.assertTrue((boolean)haGroup2.isPresent());
            Assert.assertNotSame(haGroup2.get(), (Object)this.haGroup);
            Assert.assertEquals((Object)record1, (Object)((HighAvailabilityGroup)haGroup2.get()).getRoleRecord());
        });
        GenericTestUtils.waitFor(() -> {
            try {
                Optional haGroup2 = HighAvailabilityGroup.get((String)this.jdbcHAUrl, (Properties)this.clientProperties);
                return haGroup2.isPresent() && record2.equals((Object)((HighAvailabilityGroup)haGroup2.get()).getRoleRecord());
            }
            catch (SQLException e) {
                LOG.warn("Fail to get HA group {}", (Object)haGroupName2);
                return false;
            }
        }, (long)100L, (long)30000L);
        HighAvailabilityGroup.get((String)this.jdbcHAUrl, (Properties)this.clientProperties).ifPresent(HighAvailabilityGroup::close);
    }

    @Test
    public void testFallbackToSingleConnection() throws Exception {
        String tableName = RandomStringUtils.randomAlphabetic((int)10);
        CLUSTERS.createTableOnClusterPair(this.haGroup, tableName);
        String haGroupName2 = this.testName.getMethodName() + RandomStringUtils.randomAlphabetic((int)3);
        this.clientProperties.setProperty("phoenix.ha.group.name", haGroupName2);
        this.clientProperties.setProperty("phoenix.ha.fallback.cluster", CLUSTERS.getJdbcUrl1(this.haGroup));
        try (Connection conn = DriverManager.getConnection(this.jdbcHAUrl, this.clientProperties);){
            Assert.assertTrue((boolean)(conn instanceof PhoenixConnection));
            String firstClusterUrl = CLUSTERS.getJdbcUrl1(this.haGroup);
            Assert.assertEquals((Object)firstClusterUrl, (Object)((PhoenixConnection)conn).getURL());
            HighAvailabilityTestingUtility.doTestBasicOperationsWithConnection(conn, tableName, haGroupName2);
        }
        this.clientProperties.setProperty("phoenix.ha.fallback.enabled", "false");
        try {
            DriverManager.getConnection(this.jdbcHAUrl, this.clientProperties);
            Assert.fail((String)"Should have failed when disabling fallback to single cluster");
        }
        catch (SQLException e) {
            LOG.info("Got expected exception when disabling fallback");
        }
        this.clientProperties.remove("phoenix.ha.fallback.enabled");
        this.clientProperties.remove("phoenix.ha.fallback.cluster");
        try {
            DriverManager.getConnection(this.jdbcHAUrl, this.clientProperties);
            Assert.fail((String)"Should have failed when fallback cluster key is missing");
        }
        catch (SQLException e) {
            LOG.info("Should have failed when fallback cluster key is missing");
        }
        CLUSTERS.initClusterRole(haGroupName2, HighAvailabilityPolicy.FAILOVER);
        HighAvailabilityGroup.MISSING_CRR_GROUPS_CACHE.invalidateAll();
        conn = DriverManager.getConnection(this.jdbcHAUrl, this.clientProperties);
        try {
            Assert.assertTrue((boolean)(conn instanceof FailoverPhoenixConnection));
            HighAvailabilityTestingUtility.doTestBasicOperationsWithConnection(conn, tableName, haGroupName2);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    @Test
    public void testNotFallbackToSingleConnection() throws Exception {
        String tableName = RandomStringUtils.randomAlphabetic((int)10);
        CLUSTERS.createTableOnClusterPair(this.haGroup, tableName);
        String haGroupName2 = this.testName.getMethodName() + RandomStringUtils.randomAlphabetic((int)3);
        this.clientProperties.setProperty("phoenix.ha.group.name", haGroupName2);
        this.clientProperties.setProperty("phoenix.ha.fallback.cluster", CLUSTERS.getJdbcUrl1(this.haGroup));
        HighAvailabilityTestingUtility.HBaseTestingUtilityPair.doTestWhenOneZKDown(CLUSTERS.getHBaseCluster2(), () -> {
            try {
                DriverManager.getConnection(this.jdbcHAUrl, this.clientProperties);
                Assert.fail((String)"Should have failed since one HA group can not initialized. Not falling back");
            }
            catch (SQLException e) {
                LOG.info("Got expected exception as HA group fails to initialize", (Throwable)e);
            }
        });
        try (Connection conn = DriverManager.getConnection(this.jdbcHAUrl, this.clientProperties);){
            Assert.assertTrue((boolean)(conn instanceof PhoenixConnection));
        }
    }
}

