/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.hadoop.hbase.util.VersionInfo;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.jdbc.ClusterRoleRecord;
import org.apache.phoenix.jdbc.ConnectionInfo;
import org.apache.phoenix.jdbc.FailoverPhoenixConnection;
import org.apache.phoenix.jdbc.HighAvailabilityGroup;
import org.apache.phoenix.jdbc.HighAvailabilityPolicy;
import org.apache.phoenix.jdbc.HighAvailabilityTestingUtility;
import org.apache.phoenix.jdbc.ParallelPhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDriver;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.ConnectionQueryServicesImpl;
import org.apache.phoenix.util.ReadOnlyProps;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
@Category(value={NeedsOwnMiniClusterTest.class})
public class HAConnectionWithMasterAndRPCRegistryIT {
    private static final Logger LOG = LoggerFactory.getLogger(HAConnectionWithMasterAndRPCRegistryIT.class);
    private static final HighAvailabilityTestingUtility.HBaseTestingUtilityPair CLUSTERS = new HighAvailabilityTestingUtility.HBaseTestingUtilityPair();
    @Rule
    public final TestName testName = new TestName();
    private Properties parallelClientProperties;
    private Properties failoverClientProperties;
    private HighAvailabilityGroup parallelHAGroup;
    private HighAvailabilityGroup failoverHAGroup;
    private String tableName;
    private String parallelHAGroupName;
    private String failoverHAGroupName;
    private final ClusterRoleRecord.RegistryType registryType;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        CLUSTERS.start();
        DriverManager.registerDriver((Driver)PhoenixDriver.INSTANCE);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        DriverManager.deregisterDriver((Driver)PhoenixDriver.INSTANCE);
        CLUSTERS.close();
    }

    @Before
    public void setup() throws Exception {
        if (this.registryType == ClusterRoleRecord.RegistryType.RPC) {
            Assume.assumeTrue((VersionInfo.compareVersion((String)VersionInfo.getVersion(), (String)"2.5.0") >= 0 ? 1 : 0) != 0);
        }
        this.parallelHAGroupName = this.testName.getMethodName() + "_" + HighAvailabilityPolicy.PARALLEL.name();
        this.failoverHAGroupName = this.testName.getMethodName() + "_" + HighAvailabilityPolicy.FAILOVER.name();
        this.parallelClientProperties = HighAvailabilityTestingUtility.getHATestProperties();
        this.parallelClientProperties.setProperty("phoenix.ha.group.name", this.parallelHAGroupName);
        this.failoverClientProperties = HighAvailabilityTestingUtility.getHATestProperties();
        this.failoverClientProperties.setProperty("phoenix.ha.group.name", this.failoverHAGroupName);
        CLUSTERS.initClusterRole(this.parallelHAGroupName, HighAvailabilityPolicy.PARALLEL, this.registryType);
        CLUSTERS.initClusterRole(this.failoverHAGroupName, HighAvailabilityPolicy.FAILOVER, this.registryType);
        this.parallelHAGroup = HighAvailabilityTestingUtility.getHighAvailibilityGroup(CLUSTERS.getJdbcHAUrl(), this.parallelClientProperties);
        LOG.info("Initialized haGroup {} with URL {}", (Object)this.parallelHAGroup, (Object)CLUSTERS.getJdbcHAUrl());
        this.failoverHAGroup = HighAvailabilityTestingUtility.getHighAvailibilityGroup(CLUSTERS.getJdbcHAUrl(), this.failoverClientProperties);
        LOG.info("Initialized haGroup {} with URL {}", (Object)this.failoverHAGroup, (Object)CLUSTERS.getJdbcHAUrl());
        this.tableName = RandomStringUtils.randomAlphabetic((int)10).toUpperCase();
        CLUSTERS.createTableOnClusterPair(this.parallelHAGroup, this.tableName);
    }

    @After
    public void tearDown() throws Exception {
        try {
            this.parallelHAGroup.close();
            this.failoverHAGroup.close();
            PhoenixDriver.INSTANCE.getConnectionQueryServices(CLUSTERS.getJdbcUrl1(this.parallelHAGroup), this.parallelHAGroup.getProperties()).close();
            PhoenixDriver.INSTANCE.getConnectionQueryServices(CLUSTERS.getJdbcUrl2(this.parallelHAGroup), this.parallelHAGroup.getProperties()).close();
        }
        catch (Exception e) {
            LOG.error("Fail to tear down the HA group and the CQS. Will ignore", (Throwable)e);
        }
    }

    @Parameterized.Parameters(name="ClusterRoleRecord_registryType={0}")
    public static Collection<Object> data() {
        return Arrays.asList(ClusterRoleRecord.RegistryType.MASTER, ClusterRoleRecord.RegistryType.RPC);
    }

    public HAConnectionWithMasterAndRPCRegistryIT(ClusterRoleRecord.RegistryType registryType) {
        this.registryType = registryType;
    }

    @Test(timeout=300000L)
    public void testFailoverCanFinishWhenOneConnectionGotStuckClosing() throws Exception {
        Connection conn = this.getFailoverConnection();
        HighAvailabilityTestingUtility.doTestBasicOperationsWithConnection(conn, this.tableName, this.failoverHAGroupName);
        Assert.assertEquals((Object)CLUSTERS.getJdbcUrl1(this.failoverHAGroup), (Object)conn.unwrap(FailoverPhoenixConnection.class).getWrappedConnection().getURL());
        PhoenixConnection wrapped = conn.unwrap(FailoverPhoenixConnection.class).getWrappedConnection();
        Connection spy = (Connection)Mockito.spy((Object)wrapped);
        CountDownLatch latch = new CountDownLatch(1);
        ((Connection)Mockito.doAnswer(invocation -> {
            latch.await();
            invocation.callRealMethod();
            return null;
        }).when((Object)spy)).close();
        ConnectionQueryServices cqs = PhoenixDriver.INSTANCE.getConnectionQueryServices(CLUSTERS.getJdbcUrl1(this.failoverHAGroup), this.failoverClientProperties);
        cqs.removeConnection(wrapped.unwrap(PhoenixConnection.class));
        cqs.addConnection(spy.unwrap(PhoenixConnection.class));
        CLUSTERS.transitClusterRole(this.failoverHAGroup, ClusterRoleRecord.ClusterRole.STANDBY, ClusterRoleRecord.ClusterRole.ACTIVE);
        ((Connection)Mockito.verify((Object)spy, (VerificationMode)Mockito.times((int)1))).close();
        Assert.assertFalse((boolean)spy.isClosed());
        Assert.assertFalse((boolean)conn.isClosed());
        try (Connection conn2 = this.getFailoverConnection();){
            HighAvailabilityTestingUtility.doTestBasicOperationsWithConnection(conn2, this.tableName, this.failoverHAGroupName);
            Assert.assertEquals((Object)CLUSTERS.getJdbcUrl2(this.failoverHAGroup), (Object)conn2.unwrap(FailoverPhoenixConnection.class).getWrappedConnection().getURL());
        }
        latch.countDown();
        conn.close();
        GenericTestUtils.waitFor(() -> {
            try {
                ((ConnectionQueryServicesImpl)cqs).checkClosed();
                return false;
            }
            catch (IllegalStateException e) {
                LOG.info("CQS got closed as we get expected exception.", (Throwable)e);
                return true;
            }
        }, (long)100L, (long)10000L);
    }

    @Test(timeout=300000L)
    public void testConnectionWhenActiveHBaseRestarts() throws Exception {
        try (Connection conn = this.getFailoverConnection();){
            HighAvailabilityTestingUtility.doTestBasicOperationsWithConnection(conn, this.tableName, this.failoverHAGroupName);
        }
        HighAvailabilityTestingUtility.HBaseTestingUtilityPair.doTestWhenOneHBaseDown(CLUSTERS.getHBaseCluster1(), () -> {
            Connection conn;
            try {
                conn = this.getFailoverConnection();
                try {
                    HighAvailabilityTestingUtility.doTestBasicOperationsWithConnection(conn, this.tableName, this.failoverHAGroupName);
                }
                finally {
                    if (conn != null) {
                        conn.close();
                    }
                }
                Assert.fail((String)"Should have failed since ACTIVE ZK cluster was shutdown");
            }
            catch (SQLException e) {
                LOG.info("Got expected exception when ACTIVE ZK cluster is down", (Throwable)e);
            }
            CLUSTERS.transitClusterRole(this.failoverHAGroup, ClusterRoleRecord.ClusterRole.STANDBY, ClusterRoleRecord.ClusterRole.ACTIVE);
            conn = this.getFailoverConnection();
            try {
                HighAvailabilityTestingUtility.doTestBasicOperationsWithConnection(conn, this.tableName, this.failoverHAGroupName);
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        });
        LOG.info("Testing failover connection when both clusters are up and running");
        conn = this.getFailoverConnection();
        try {
            FailoverPhoenixConnection failoverConn = conn.unwrap(FailoverPhoenixConnection.class);
            Assert.assertEquals((Object)CLUSTERS.getJdbcUrl2(this.failoverHAGroup), (Object)failoverConn.getWrappedConnection().getURL());
            HighAvailabilityTestingUtility.doTestBasicOperationsWithConnection(conn, this.tableName, this.failoverHAGroupName);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        LOG.info("Testing failover back to cluster1 when bot clusters are up and running");
        CLUSTERS.transitClusterRole(this.failoverHAGroup, ClusterRoleRecord.ClusterRole.ACTIVE, ClusterRoleRecord.ClusterRole.STANDBY);
        conn = this.getFailoverConnection();
        try {
            HighAvailabilityTestingUtility.doTestBasicOperationsWithConnection(conn, this.tableName, this.failoverHAGroupName);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    @Test(timeout=300000L)
    public void testConnectionWhenStandbyHBaseRestarts() throws Exception {
        HighAvailabilityTestingUtility.HBaseTestingUtilityPair.doTestWhenOneHBaseDown(CLUSTERS.getHBaseCluster2(), () -> {
            try (Connection conn = this.getFailoverConnection();){
                HighAvailabilityTestingUtility.doTestBasicOperationsWithConnection(conn, this.tableName, this.failoverHAGroupName);
            }
            CLUSTERS.transitClusterRole(this.failoverHAGroup, ClusterRoleRecord.ClusterRole.STANDBY, ClusterRoleRecord.ClusterRole.ACTIVE);
            try {
                this.getFailoverConnection();
                Assert.fail((String)"Should have failed since ACTIVE HBase cluster was shutdown");
            }
            catch (SQLException e) {
                LOG.info("Got expected exception when ACTIVE HBase cluster {} was shutdown", (Object)CLUSTERS.getZkUrl2(), (Object)e);
            }
        });
        CLUSTERS.refreshClusterRoleRecordAfterClusterRestart(this.failoverHAGroup, ClusterRoleRecord.ClusterRole.STANDBY, ClusterRoleRecord.ClusterRole.ACTIVE);
        try (Connection conn = this.getFailoverConnection();){
            HighAvailabilityTestingUtility.doTestBasicOperationsWithConnection(conn, this.tableName, this.failoverHAGroupName);
        }
    }

    @Test(timeout=300000L)
    public void testConnectionWhenTwoHBaseRestarts() throws Exception {
        HighAvailabilityTestingUtility.HBaseTestingUtilityPair.doTestWhenOneHBaseDown(CLUSTERS.getHBaseCluster1(), () -> {
            HighAvailabilityTestingUtility.HBaseTestingUtilityPair.doTestWhenOneHBaseDown(CLUSTERS.getHBaseCluster2(), () -> {
                try {
                    this.getFailoverConnection();
                    Assert.fail((String)"Should have failed since ACTIVE HBase cluster was shutdown");
                }
                catch (SQLException e) {
                    LOG.info("Got expected exception when both clusters are down", (Throwable)e);
                }
            });
            try {
                this.getFailoverConnection();
                Assert.fail((String)"Should have failed since ACTIVE HBase cluster was shutdown");
            }
            catch (SQLException e) {
                LOG.info("Got expected exception when ACTIVE HBase cluster {} was shutdown", (Object)CLUSTERS.getZkUrl2(), (Object)e);
            }
            CLUSTERS.transitClusterRole(this.failoverHAGroup, ClusterRoleRecord.ClusterRole.STANDBY, ClusterRoleRecord.ClusterRole.ACTIVE);
            try (Connection conn = this.getFailoverConnection();){
                HighAvailabilityTestingUtility.doTestBasicOperationsWithConnection(conn, this.tableName, this.failoverHAGroupName);
            }
        });
    }

    @Test(timeout=300000L)
    public void testAllWrappedConnectionsClosedAfterActiveURLChange() throws Exception {
        short numberOfConnections = 5;
        ArrayList<Connection> connectionList = new ArrayList<Connection>(numberOfConnections);
        ArrayList<Connection> parallelConnectionList = new ArrayList<Connection>(numberOfConnections);
        for (short i = 0; i < numberOfConnections; i = (short)((short)(i + 1))) {
            connectionList.add(this.getFailoverConnection());
            parallelConnectionList.add(this.getParallelConnection());
        }
        String url = CLUSTERS.getJdbcUrl1(this.parallelHAGroup);
        CLUSTERS.restartCluster1();
        CLUSTERS.refreshClusterRoleRecordAfterClusterRestart(this.failoverHAGroup, ClusterRoleRecord.ClusterRole.ACTIVE, ClusterRoleRecord.ClusterRole.STANDBY);
        CLUSTERS.refreshClusterRoleRecordAfterClusterRestart(this.parallelHAGroup, ClusterRoleRecord.ClusterRole.ACTIVE, ClusterRoleRecord.ClusterRole.STANDBY);
        for (short i = 0; i < numberOfConnections; i = (short)(i + 1)) {
            LOG.info("Asserting connection number {}", (Object)i);
            FailoverPhoenixConnection conn = (FailoverPhoenixConnection)connectionList.get(i);
            Assert.assertFalse((boolean)conn.isClosed());
            Assert.assertTrue((boolean)conn.getWrappedConnection().isClosed());
            conn.close();
            ParallelPhoenixConnection conn2 = (ParallelPhoenixConnection)parallelConnectionList.get(i);
            Assert.assertFalse((boolean)conn2.isClosed());
            if (((PhoenixConnection)conn2.futureConnection1.get()).getURL().equals(url)) {
                Assert.assertTrue((boolean)((PhoenixConnection)conn2.futureConnection1.get()).isClosed());
                Assert.assertFalse((boolean)((PhoenixConnection)conn2.futureConnection2.get()).isClosed());
            } else {
                Assert.assertTrue((boolean)((PhoenixConnection)conn2.futureConnection2.get()).isClosed());
                Assert.assertFalse((boolean)((PhoenixConnection)conn2.futureConnection1.get()).isClosed());
            }
            conn2.close();
        }
    }

    @Test(timeout=300000L)
    public void testAllWrappedConnectionsNotClosedAfterStandbyURLChange() throws Exception {
        short numberOfConnections = 5;
        ArrayList<Connection> connectionList = new ArrayList<Connection>(numberOfConnections);
        ArrayList<Connection> parallelConnectionList = new ArrayList<Connection>(numberOfConnections);
        for (short i = 0; i < numberOfConnections; i = (short)((short)(i + 1))) {
            connectionList.add(this.getFailoverConnection());
            parallelConnectionList.add(this.getParallelConnection());
        }
        String url = CLUSTERS.getJdbcUrl2(this.parallelHAGroup);
        CLUSTERS.restartCluster2();
        CLUSTERS.refreshClusterRoleRecordAfterClusterRestart(this.failoverHAGroup, ClusterRoleRecord.ClusterRole.ACTIVE, ClusterRoleRecord.ClusterRole.STANDBY);
        CLUSTERS.refreshClusterRoleRecordAfterClusterRestart(this.parallelHAGroup, ClusterRoleRecord.ClusterRole.ACTIVE, ClusterRoleRecord.ClusterRole.STANDBY);
        for (short i = 0; i < numberOfConnections; i = (short)(i + 1)) {
            LOG.info("Asserting connection number {}", (Object)i);
            FailoverPhoenixConnection conn = (FailoverPhoenixConnection)connectionList.get(i);
            Assert.assertFalse((boolean)conn.isClosed());
            Assert.assertFalse((boolean)conn.getWrappedConnection().isClosed());
            conn.close();
            ParallelPhoenixConnection conn2 = (ParallelPhoenixConnection)parallelConnectionList.get(i);
            Assert.assertFalse((boolean)conn2.isClosed());
            if (((PhoenixConnection)conn2.futureConnection1.get()).getURL().equals(url)) {
                Assert.assertTrue((boolean)((PhoenixConnection)conn2.futureConnection1.get()).isClosed());
                Assert.assertFalse((boolean)((PhoenixConnection)conn2.futureConnection2.get()).isClosed());
            } else {
                Assert.assertTrue((boolean)((PhoenixConnection)conn2.futureConnection2.get()).isClosed());
                Assert.assertFalse((boolean)((PhoenixConnection)conn2.futureConnection1.get()).isClosed());
            }
            conn2.close();
        }
    }

    @Test(timeout=300000L)
    public void testAllWrappedConnectionsClosedAfterRegistryChange() throws Exception {
        short numberOfConnections = 5;
        ArrayList<Connection> connectionList = new ArrayList<Connection>(numberOfConnections);
        ArrayList<Connection> parallelConnectionList = new ArrayList<Connection>(numberOfConnections);
        for (short i = 0; i < numberOfConnections; i = (short)((short)(i + 1))) {
            connectionList.add(this.getFailoverConnection());
            parallelConnectionList.add(this.getParallelConnection());
        }
        ClusterRoleRecord.RegistryType newRegistry = this.registryType == ClusterRoleRecord.RegistryType.MASTER ? ClusterRoleRecord.RegistryType.ZK : ClusterRoleRecord.RegistryType.MASTER;
        ConnectionQueryServicesImpl cqsiF = (ConnectionQueryServicesImpl)PhoenixDriver.INSTANCE.getConnectionQueryServices(CLUSTERS.getJdbcUrl1(this.failoverHAGroup), this.failoverClientProperties);
        ConnectionQueryServicesImpl cqsiP = (ConnectionQueryServicesImpl)PhoenixDriver.INSTANCE.getConnectionQueryServices(CLUSTERS.getJdbcUrl1(this.parallelHAGroup), this.parallelClientProperties);
        ConnectionInfo connInfoF = ConnectionInfo.create((String)CLUSTERS.getJdbcUrl1(this.failoverHAGroup), (ReadOnlyProps)PhoenixDriver.INSTANCE.getQueryServices().getProps(), (Properties)this.failoverClientProperties);
        ConnectionInfo connInfoP = ConnectionInfo.create((String)CLUSTERS.getJdbcUrl1(this.parallelHAGroup), (ReadOnlyProps)PhoenixDriver.INSTANCE.getQueryServices().getProps(), (Properties)this.failoverClientProperties);
        CLUSTERS.transitClusterRoleRecordRegistry(this.failoverHAGroup, newRegistry);
        CLUSTERS.transitClusterRoleRecordRegistry(this.parallelHAGroup, newRegistry);
        for (short i = 0; i < numberOfConnections; i = (short)(i + 1)) {
            LOG.info("Asserting connection number {}", (Object)i);
            FailoverPhoenixConnection conn = (FailoverPhoenixConnection)connectionList.get(i);
            Assert.assertFalse((boolean)conn.isClosed());
            Assert.assertTrue((boolean)conn.getWrappedConnection().isClosed());
            ParallelPhoenixConnection conn2 = (ParallelPhoenixConnection)parallelConnectionList.get(i);
            Assert.assertFalse((boolean)conn2.isClosed());
            Assert.assertTrue((boolean)((PhoenixConnection)conn2.futureConnection1.get()).isClosed());
            Assert.assertTrue((boolean)((PhoenixConnection)conn2.futureConnection1.get()).isClosed());
            conn2.close();
        }
        try {
            cqsiF.checkClosed();
            Assert.fail((String)"Should have thrown an exception as cqsi should be closed");
        }
        catch (IllegalStateException e) {
            Assert.assertFalse((boolean)PhoenixDriver.INSTANCE.checkIfCQSIIsInCache(connInfoF));
        }
        catch (Exception e) {
            Assert.fail((String)"Should have thrown on IllegalStateException as cqsi should be closed");
        }
        try {
            cqsiP.checkClosed();
            Assert.fail((String)"Should have thrown an exception as cqsi should be closed");
        }
        catch (IllegalStateException e) {
            Assert.assertFalse((boolean)PhoenixDriver.INSTANCE.checkIfCQSIIsInCache(connInfoP));
        }
        catch (Exception e) {
            Assert.fail((String)"Should have thrown on IllegalStateException as cqsi should be closed");
        }
    }

    @Test(timeout=300000L)
    public void testAllWrappedConnectionsClosedAfterRegistryChange2() throws Exception {
        ClusterRoleRecord.RegistryType newRegistry;
        short numberOfConnections = 5;
        ArrayList<Connection> connectionList = new ArrayList<Connection>(numberOfConnections);
        ArrayList<Connection> parallelConnectionList = new ArrayList<Connection>(numberOfConnections);
        for (short i = 0; i < numberOfConnections; i = (short)((short)(i + 1))) {
            connectionList.add(this.getFailoverConnection());
            parallelConnectionList.add(this.getParallelConnection());
        }
        if (this.registryType == ClusterRoleRecord.RegistryType.MASTER) {
            newRegistry = ClusterRoleRecord.RegistryType.RPC;
            Assume.assumeTrue((VersionInfo.compareVersion((String)VersionInfo.getVersion(), (String)"2.5.0") >= 0 ? 1 : 0) != 0);
        } else {
            newRegistry = ClusterRoleRecord.RegistryType.ZK;
        }
        ConnectionQueryServicesImpl cqsiF = (ConnectionQueryServicesImpl)PhoenixDriver.INSTANCE.getConnectionQueryServices(CLUSTERS.getJdbcUrl1(this.failoverHAGroup), this.failoverClientProperties);
        ConnectionQueryServicesImpl cqsiP = (ConnectionQueryServicesImpl)PhoenixDriver.INSTANCE.getConnectionQueryServices(CLUSTERS.getJdbcUrl1(this.parallelHAGroup), this.parallelClientProperties);
        ConnectionInfo connInfoF = ConnectionInfo.create((String)CLUSTERS.getJdbcUrl1(this.failoverHAGroup), (ReadOnlyProps)PhoenixDriver.INSTANCE.getQueryServices().getProps(), (Properties)this.failoverClientProperties);
        ConnectionInfo connInfoP = ConnectionInfo.create((String)CLUSTERS.getJdbcUrl1(this.parallelHAGroup), (ReadOnlyProps)PhoenixDriver.INSTANCE.getQueryServices().getProps(), (Properties)this.failoverClientProperties);
        CLUSTERS.transitClusterRoleRecordRegistry(this.failoverHAGroup, newRegistry);
        CLUSTERS.transitClusterRoleRecordRegistry(this.parallelHAGroup, newRegistry);
        for (short i = 0; i < numberOfConnections; i = (short)(i + 1)) {
            LOG.info("Asserting connection number {}", (Object)i);
            FailoverPhoenixConnection conn = (FailoverPhoenixConnection)connectionList.get(i);
            Assert.assertFalse((boolean)conn.isClosed());
            Assert.assertTrue((boolean)conn.getWrappedConnection().isClosed());
            ParallelPhoenixConnection conn2 = (ParallelPhoenixConnection)parallelConnectionList.get(i);
            Assert.assertFalse((boolean)conn2.isClosed());
            Assert.assertTrue((boolean)((PhoenixConnection)conn2.futureConnection1.get()).isClosed());
            Assert.assertTrue((boolean)((PhoenixConnection)conn2.futureConnection1.get()).isClosed());
            conn2.close();
        }
        try {
            cqsiF.checkClosed();
            Assert.fail((String)"Should have thrown an exception as cqsi should be closed");
        }
        catch (IllegalStateException e) {
            Assert.assertFalse((boolean)PhoenixDriver.INSTANCE.checkIfCQSIIsInCache(connInfoF));
        }
        catch (Exception e) {
            Assert.fail((String)"Should have thrown on IllegalStateException as cqsi should be closed");
        }
        try {
            cqsiP.checkClosed();
            Assert.fail((String)"Should have thrown an exception as cqsi should be closed");
        }
        catch (IllegalStateException e) {
            Assert.assertFalse((boolean)PhoenixDriver.INSTANCE.checkIfCQSIIsInCache(connInfoP));
        }
        catch (Exception e) {
            Assert.fail((String)"Should have thrown on IllegalStateException as cqsi should be closed");
        }
    }

    private Connection getFailoverConnection() throws SQLException {
        return DriverManager.getConnection(CLUSTERS.getJdbcHAUrl(), this.failoverClientProperties);
    }

    private Connection getParallelConnection() throws SQLException {
        return DriverManager.getConnection(CLUSTERS.getJdbcHAUrl(), this.parallelClientProperties);
    }
}

