/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.phoenix.exception.FailoverSQLException;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.FailoverPhoenixConnection;
import org.apache.phoenix.jdbc.FailoverPhoenixContext;
import org.apache.phoenix.jdbc.HAURLInfo;
import org.apache.phoenix.jdbc.HighAvailabilityGroup;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailoverPhoenixConnectionTest {
    private static final Logger LOG = LoggerFactory.getLogger(FailoverPhoenixConnectionTest.class);
    @Mock
    PhoenixConnection connection1;
    @Mock
    PhoenixConnection connection2;
    @Mock
    HighAvailabilityGroup haGroup;
    final HighAvailabilityGroup.HAGroupInfo haGroupInfo = new HighAvailabilityGroup.HAGroupInfo("fake", "zk1", "zk2");
    final HAURLInfo haURLInfo = new HAURLInfo("fake");
    FailoverPhoenixContext context;
    FailoverPhoenixConnection failoverConnection;

    @Before
    public void init() throws SQLException {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.haGroup.getGroupInfo()).thenReturn((Object)this.haGroupInfo);
        Mockito.when((Object)this.haGroup.connectActive((Properties)ArgumentMatchers.any(Properties.class), (HAURLInfo)ArgumentMatchers.any(HAURLInfo.class))).thenReturn((Object)this.connection1);
        this.context = new FailoverPhoenixContext(new Properties(), this.haGroup, this.haURLInfo);
        this.failoverConnection = new FailoverPhoenixConnection(this.context);
    }

    @Test
    public void testWrapActionDuringFailover() throws SQLException {
        String str = "Hello, World!";
        Assert.assertEquals((Object)str, (Object)this.failoverConnection.wrapActionDuringFailover(() -> str));
        AtomicInteger counter = new AtomicInteger(0);
        this.failoverConnection.wrapActionDuringFailover(counter::incrementAndGet);
        Assert.assertEquals((long)1L, (long)counter.get());
    }

    @Test
    public void testFailover() throws SQLException {
        Mockito.when((Object)this.haGroup.connectActive((Properties)ArgumentMatchers.any(Properties.class), (HAURLInfo)ArgumentMatchers.any(HAURLInfo.class))).thenReturn((Object)this.connection2);
        this.failoverConnection.failover(1000L);
        ((PhoenixConnection)Mockito.verify((Object)this.connection1, (VerificationMode)Mockito.times((int)1))).close((SQLException)ArgumentMatchers.any(FailoverSQLException.class));
        Assert.assertEquals((Object)this.connection2, (Object)this.failoverConnection.getWrappedConnection());
    }

    @Test
    public void testFailoverStatic() throws SQLException {
        try {
            FailoverPhoenixConnection.failover((Connection)this.connection1, (long)1000L);
            Assert.fail((String)"Should have failed since plain phoenix connection can not failover!");
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.CLASS_NOT_UNWRAPPABLE.getErrorCode(), (long)e.getErrorCode());
            LOG.info("Got expected exception when trying to failover on non-HA connection", (Throwable)e);
        }
        FailoverPhoenixConnection.failover((Connection)this.failoverConnection, (long)1000L);
        ((PhoenixConnection)Mockito.verify((Object)this.connection1, (VerificationMode)Mockito.times((int)1))).close((SQLException)ArgumentMatchers.any(FailoverSQLException.class));
    }

    @Test
    public void testActiveFailoverIsNoOp() throws SQLException {
        Mockito.when((Object)this.haGroup.isActive(this.connection1)).thenReturn((Object)true);
        Mockito.when((Object)this.haGroup.connectActive((Properties)ArgumentMatchers.any(Properties.class), (HAURLInfo)ArgumentMatchers.any(HAURLInfo.class))).thenReturn((Object)this.connection2);
        this.failoverConnection.failover(1000L);
        ((PhoenixConnection)Mockito.verify((Object)this.connection1, (VerificationMode)Mockito.never())).close((SQLException)ArgumentMatchers.any(FailoverSQLException.class));
        Assert.assertEquals((Object)this.connection1, (Object)this.failoverConnection.getWrappedConnection());
    }

    @Test
    public void testFailoverToActivePolicy() throws SQLException {
        Properties properties = new Properties();
        properties.setProperty("phoenix.ha.failover.policy", "active");
        FailoverPhoenixContext context = new FailoverPhoenixContext(properties, this.haGroup, this.haURLInfo);
        this.failoverConnection = new FailoverPhoenixConnection(context);
        LOG.info("Close the wrapped phoenix connection due to failover...");
        Mockito.when((Object)this.haGroup.connectActive((Properties)ArgumentMatchers.any(Properties.class), (HAURLInfo)ArgumentMatchers.any(HAURLInfo.class))).thenReturn((Object)this.connection2);
        ((PhoenixConnection)Mockito.doThrow((Throwable[])new Throwable[]{new FailoverSQLException("", "", (Throwable)new Exception())}).when((Object)this.connection1)).commit();
        this.failoverConnection.commit();
        ((PhoenixConnection)Mockito.verify((Object)this.connection1, (VerificationMode)Mockito.times((int)1))).close((SQLException)ArgumentMatchers.any(SQLException.class));
        Assert.assertEquals((Object)this.connection2, (Object)this.failoverConnection.getWrappedConnection());
    }

    @Test
    public void testConnectionClosed() throws SQLException {
        this.failoverConnection.close();
        try {
            this.failoverConnection.failover(1000L);
            Assert.fail((String)"failover should have failed after failover connection is closed!");
        }
        catch (SQLException e) {
            LOG.info("Got expected exception", (Throwable)e);
            Assert.assertEquals((long)SQLExceptionCode.CONNECTION_CLOSED.getErrorCode(), (long)e.getErrorCode());
        }
        ((PhoenixConnection)Mockito.verify((Object)this.connection1, (VerificationMode)Mockito.never())).close((SQLException)ArgumentMatchers.any(FailoverSQLException.class));
        ((PhoenixConnection)Mockito.verify((Object)this.connection2, (VerificationMode)Mockito.never())).close((SQLException)ArgumentMatchers.any(FailoverSQLException.class));
    }

    @Test
    public void testCloseOnceMore() throws SQLException {
        this.failoverConnection.close();
        Assert.assertTrue((boolean)this.failoverConnection.isClosed());
        ((PhoenixConnection)Mockito.verify((Object)this.connection1, (VerificationMode)Mockito.times((int)1))).close();
        ((PhoenixConnection)Mockito.verify((Object)this.connection1, (VerificationMode)Mockito.never())).close((SQLException)ArgumentMatchers.any(SQLException.class));
        this.failoverConnection.close();
        ((PhoenixConnection)Mockito.verify((Object)this.connection1, (VerificationMode)Mockito.times((int)1))).close();
        ((PhoenixConnection)Mockito.verify((Object)this.connection1, (VerificationMode)Mockito.never())).close((SQLException)ArgumentMatchers.any(SQLException.class));
    }

    @Test
    public void testCheckConnection() throws SQLException {
        Mockito.when((Object)this.haGroup.connectActive((Properties)ArgumentMatchers.any(Properties.class), (HAURLInfo)ArgumentMatchers.any(HAURLInfo.class))).thenReturn(null);
        this.failoverConnection = new FailoverPhoenixConnection(this.context);
        Assert.assertNull((Object)this.failoverConnection.getWrappedConnection());
        try {
            this.failoverConnection.commit();
            Assert.fail((String)"Should have failed because the wrapped phoenix connection is null");
        }
        catch (SQLException e) {
            LOG.info("Got expected exception", (Throwable)e);
            Assert.assertEquals((long)SQLExceptionCode.CANNOT_ESTABLISH_CONNECTION.getErrorCode(), (long)e.getErrorCode());
        }
    }
}

