/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.hadoop.hbase.util.VersionInfo;
import org.apache.phoenix.jdbc.ClusterRoleRecord;
import org.apache.phoenix.jdbc.HighAvailabilityPolicy;
import org.apache.phoenix.util.JacksonUtil;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class ClusterRoleRecordTest {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterRoleRecordTest.class);
    private static final String URL1 = "zk1-1\\:2181,zk1-2\\:2181";
    private static final String URL2 = "zk2-1\\:2181,zk2-2\\:2181";
    private final ClusterRoleRecord.RegistryType registryType;
    @Rule
    public final TestName testName = new TestName();

    public ClusterRoleRecordTest(ClusterRoleRecord.RegistryType registryType) {
        this.registryType = registryType;
    }

    @Parameterized.Parameters(name="ClusterRoleRecord_registryType={0}")
    public static Collection<Object> data() {
        return Arrays.asList(ClusterRoleRecord.RegistryType.ZK, ClusterRoleRecord.RegistryType.MASTER, ClusterRoleRecord.RegistryType.RPC, null);
    }

    public static String createJsonFileWithRecords(ClusterRoleRecord ... records) throws IOException {
        File file = File.createTempFile("phoenix.ha.cluster.role.records", ".test.json");
        file.deleteOnExit();
        JacksonUtil.getObjectWriterPretty().writeValue(file, (Object)records);
        LOG.info("Prepared the JSON file for testing, file:{}, content:\n{}", (Object)file, (Object)FileUtils.readFileToString((File)file, (String)"UTF-8"));
        return file.getPath();
    }

    @Before
    public void setUp() throws Exception {
        if (this.registryType == ClusterRoleRecord.RegistryType.RPC) {
            Assume.assumeTrue((VersionInfo.compareVersion((String)VersionInfo.getVersion(), (String)"2.5.0") >= 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testReadWriteJsonToFile() throws IOException {
        ClusterRoleRecord record = this.getClusterRoleRecord(this.testName.getMethodName(), HighAvailabilityPolicy.FAILOVER, URL1, ClusterRoleRecord.ClusterRole.ACTIVE, URL2, ClusterRoleRecord.ClusterRole.STANDBY, 1);
        String fileName = ClusterRoleRecordTest.createJsonFileWithRecords(record);
        String fileContent = FileUtils.readFileToString((File)new File(fileName), (String)"UTF-8");
        Assert.assertTrue((boolean)fileContent.contains(record.getHaGroupName()));
    }

    @Test
    public void testOldFormatCompatibility() throws IOException {
        String oldFormatPath = "json/test_role_record_old_format.json";
        String newFormatPath = "json/test_role_record.json";
        byte[] oldFormat = this.readFile(oldFormatPath);
        byte[] newFormat = this.readFile(newFormatPath);
        Assert.assertFalse((boolean)Arrays.equals(oldFormat, newFormat));
        ClusterRoleRecord oldFormatCRR = (ClusterRoleRecord)ClusterRoleRecord.fromJson((byte[])oldFormat).get();
        ClusterRoleRecord newFormatCRR = (ClusterRoleRecord)ClusterRoleRecord.fromJson((byte[])newFormat).get();
        Assert.assertEquals((Object)oldFormatCRR, (Object)newFormatCRR);
    }

    @Test
    public void testUrlNullInRoleRecord() throws IOException {
        String wrongFormatPath = "json/test_role_record_wrong_format.json";
        String wrongFormatForRolePath = "json/test_role_record_wrong_role_format.json";
        byte[] roleRecord = this.readFile(wrongFormatPath);
        byte[] roleRecordWithWrongRole = this.readFile(wrongFormatForRolePath);
        Optional record = ClusterRoleRecord.fromJson((byte[])roleRecord);
        Assert.assertEquals((Object)record, Optional.empty());
        Optional recordWithNullRole = ClusterRoleRecord.fromJson((byte[])roleRecordWithWrongRole);
        Assert.assertEquals((Object)record, Optional.empty());
    }

    @Test
    public void testToAndFromJson() throws IOException {
        ClusterRoleRecord record = this.getClusterRoleRecord(this.testName.getMethodName(), HighAvailabilityPolicy.FAILOVER, URL1, ClusterRoleRecord.ClusterRole.ACTIVE, URL2, ClusterRoleRecord.ClusterRole.STANDBY, 1);
        byte[] bytes = ClusterRoleRecord.toJson((ClusterRoleRecord)record);
        Optional record2 = ClusterRoleRecord.fromJson((byte[])bytes);
        Assert.assertTrue((boolean)record2.isPresent());
        Assert.assertEquals((Object)record, record2.get());
    }

    @Test
    public void testGetActiveUrl() {
        ClusterRoleRecord record = this.getClusterRoleRecord(this.testName.getMethodName(), HighAvailabilityPolicy.FAILOVER, URL1, ClusterRoleRecord.ClusterRole.ACTIVE, URL2, ClusterRoleRecord.ClusterRole.STANDBY, 0);
        Assert.assertTrue((boolean)record.getActiveUrl().isPresent());
        Assert.assertEquals((Object)this.getUrlWithSuffix(URL1), record.getActiveUrl().get());
        record = this.getClusterRoleRecord(this.testName.getMethodName(), HighAvailabilityPolicy.FAILOVER, URL1, ClusterRoleRecord.ClusterRole.STANDBY, URL2, ClusterRoleRecord.ClusterRole.STANDBY, 0);
        Assert.assertFalse((boolean)record.getActiveUrl().isPresent());
    }

    @Test
    public void testIsNewerThan() {
        String haGroupName = this.testName.getMethodName();
        ClusterRoleRecord recordV0 = this.getClusterRoleRecord(haGroupName, HighAvailabilityPolicy.FAILOVER, URL1, ClusterRoleRecord.ClusterRole.STANDBY, URL2, ClusterRoleRecord.ClusterRole.STANDBY, 0);
        ClusterRoleRecord recordV1 = this.getClusterRoleRecord(haGroupName, HighAvailabilityPolicy.FAILOVER, URL1, ClusterRoleRecord.ClusterRole.STANDBY, URL2, ClusterRoleRecord.ClusterRole.STANDBY, 2);
        Assert.assertTrue((boolean)recordV1.isNewerThan(recordV0));
        Assert.assertFalse((boolean)recordV1.isNewerThan(recordV1));
        Assert.assertFalse((boolean)recordV0.isNewerThan(recordV1));
        String haGroupName2 = haGroupName + RandomStringUtils.randomAlphabetic((int)2);
        ClusterRoleRecord record2 = this.getClusterRoleRecord(haGroupName2, HighAvailabilityPolicy.FAILOVER, URL1, ClusterRoleRecord.ClusterRole.STANDBY, URL2, ClusterRoleRecord.ClusterRole.STANDBY, 1);
        Assert.assertFalse((boolean)recordV0.isNewerThan(record2));
        Assert.assertFalse((boolean)recordV1.isNewerThan(record2));
        Assert.assertFalse((boolean)record2.isNewerThan(recordV0));
        Assert.assertFalse((boolean)record2.isNewerThan(recordV1));
    }

    @Test
    public void testHasSameInfo() {
        String haGroupName = this.testName.getMethodName();
        ClusterRoleRecord recordV0 = this.getClusterRoleRecord(haGroupName, HighAvailabilityPolicy.FAILOVER, URL1, ClusterRoleRecord.ClusterRole.ACTIVE, URL2, ClusterRoleRecord.ClusterRole.STANDBY, 0);
        ClusterRoleRecord recordV1 = this.getClusterRoleRecord(haGroupName, HighAvailabilityPolicy.FAILOVER, URL1, ClusterRoleRecord.ClusterRole.ACTIVE, URL2, ClusterRoleRecord.ClusterRole.STANDBY, 1);
        Assert.assertTrue((boolean)recordV1.hasSameInfo(recordV0));
        Assert.assertTrue((boolean)recordV1.hasSameInfo(recordV1));
        Assert.assertTrue((boolean)recordV0.hasSameInfo(recordV1));
    }

    @Test
    public void testHasSameInfoDifferentZKOrder() {
        String haGroupName = this.testName.getMethodName();
        ClusterRoleRecord recordV0 = this.getClusterRoleRecord(haGroupName, HighAvailabilityPolicy.FAILOVER, URL2, ClusterRoleRecord.ClusterRole.ACTIVE, URL1, ClusterRoleRecord.ClusterRole.STANDBY, 0);
        ClusterRoleRecord recordV1 = this.getClusterRoleRecord(haGroupName, HighAvailabilityPolicy.FAILOVER, URL1, ClusterRoleRecord.ClusterRole.ACTIVE, URL2, ClusterRoleRecord.ClusterRole.STANDBY, 1);
        Assert.assertTrue((boolean)recordV1.hasSameInfo(recordV0));
        Assert.assertTrue((boolean)recordV1.hasSameInfo(recordV1));
        Assert.assertTrue((boolean)recordV0.hasSameInfo(recordV1));
    }

    @Test
    public void testHasSameInfoDifferentHostOrder() {
        String hostzk1ordered = "zk1-1,zk1-2:2181";
        String hostzk1unordered = "zk1-2,zk1-1:2181";
        String haGroupName = this.testName.getMethodName();
        ClusterRoleRecord recordV0 = this.getClusterRoleRecord(haGroupName, HighAvailabilityPolicy.FAILOVER, URL2, ClusterRoleRecord.ClusterRole.ACTIVE, hostzk1ordered, ClusterRoleRecord.ClusterRole.STANDBY, 0);
        ClusterRoleRecord recordV1 = this.getClusterRoleRecord(haGroupName, HighAvailabilityPolicy.FAILOVER, hostzk1unordered, ClusterRoleRecord.ClusterRole.ACTIVE, URL2, ClusterRoleRecord.ClusterRole.STANDBY, 1);
        Assert.assertTrue((boolean)recordV1.hasSameInfo(recordV0));
        Assert.assertTrue((boolean)recordV1.hasSameInfo(recordV1));
        Assert.assertTrue((boolean)recordV0.hasSameInfo(recordV1));
    }

    @Test
    public void testHasSameInfoNegative() {
        String haGroupName = this.testName.getMethodName();
        ClusterRoleRecord record = this.getClusterRoleRecord(haGroupName, HighAvailabilityPolicy.PARALLEL, URL1, ClusterRoleRecord.ClusterRole.ACTIVE, URL2, ClusterRoleRecord.ClusterRole.STANDBY, 0);
        ClusterRoleRecord recordFailover = this.getClusterRoleRecord(haGroupName, HighAvailabilityPolicy.FAILOVER, URL1, ClusterRoleRecord.ClusterRole.ACTIVE, URL2, ClusterRoleRecord.ClusterRole.STANDBY, 1);
        Assert.assertFalse((boolean)record.hasSameInfo(recordFailover));
        Assert.assertFalse((boolean)recordFailover.hasSameInfo(record));
        String haGroupName2 = haGroupName + RandomStringUtils.randomAlphabetic((int)2);
        ClusterRoleRecord record2 = this.getClusterRoleRecord(haGroupName2, HighAvailabilityPolicy.PARALLEL, URL1, ClusterRoleRecord.ClusterRole.ACTIVE, URL2, ClusterRoleRecord.ClusterRole.STANDBY, 1);
        Assert.assertFalse((boolean)record.hasSameInfo(record2));
        Assert.assertFalse((boolean)record2.hasSameInfo(record));
    }

    @Test
    public void testGetRole() {
        ClusterRoleRecord record = this.getClusterRoleRecord(this.testName.getMethodName(), HighAvailabilityPolicy.FAILOVER, URL1, ClusterRoleRecord.ClusterRole.ACTIVE, URL2, ClusterRoleRecord.ClusterRole.STANDBY, 0);
        Assert.assertEquals((Object)ClusterRoleRecord.ClusterRole.ACTIVE, (Object)record.getRole(this.getUrlWithSuffix(URL1)));
        Assert.assertEquals((Object)ClusterRoleRecord.ClusterRole.ACTIVE, (Object)record.getRole(record.getUrl1()));
        Assert.assertEquals((Object)ClusterRoleRecord.ClusterRole.STANDBY, (Object)record.getRole(record.getUrl2()));
        Assert.assertEquals((Object)ClusterRoleRecord.ClusterRole.UNKNOWN, (Object)record.getRole(null));
        Assert.assertEquals((Object)ClusterRoleRecord.ClusterRole.UNKNOWN, (Object)record.getRole("foo"));
    }

    @Test
    public void testToPrettyString() {
        ClusterRoleRecord record = this.getClusterRoleRecord(this.testName.getMethodName(), HighAvailabilityPolicy.PARALLEL, URL1, ClusterRoleRecord.ClusterRole.ACTIVE, URL2, ClusterRoleRecord.ClusterRole.STANDBY, 1);
        LOG.info("toString(): {}", (Object)record.toString());
        LOG.info("toPrettyString:\n{}", (Object)record.toPrettyString());
        Assert.assertNotEquals((Object)record.toString(), (Object)record.toPrettyString());
    }

    private ClusterRoleRecord getClusterRoleRecord(String name, HighAvailabilityPolicy policy, String url1, ClusterRoleRecord.ClusterRole role1, String url2, ClusterRoleRecord.ClusterRole role2, int version) {
        url1 = this.getUrlWithSuffix(url1);
        url2 = this.getUrlWithSuffix(url2);
        if (this.registryType == null) {
            return new ClusterRoleRecord(name, policy, url1, role1, url2, role2, (long)version);
        }
        return new ClusterRoleRecord(name, policy, this.registryType, url1, role1, url2, role2, (long)version);
    }

    private String getUrlWithSuffix(String url) {
        if (this.registryType == null) {
            return url + "::/hbase";
        }
        switch (this.registryType) {
            case MASTER: 
            case RPC: {
                return url;
            }
        }
        return url + "::/hbase";
    }

    private byte[] readFile(String fileName) throws IOException {
        int bytesRead;
        InputStream inputStream = ClusterRoleRecordTest.class.getClassLoader().getResourceAsStream(fileName);
        assert (inputStream != null);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] temp = new byte[1024];
        while ((bytesRead = inputStream.read(temp)) != -1) {
            buffer.write(temp, 0, bytesRead);
        }
        return buffer.toByteArray();
    }
}

