/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.phoenix.jdbc.ClusterRoleRecordGeneratorTool;
import org.apache.phoenix.jdbc.HighAvailabilityPolicy;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterRoleRecordGeneratorToolTest {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterRoleRecordGeneratorToolTest.class);
    private final Configuration conf = HBaseConfiguration.create();
    private final ClusterRoleRecordGeneratorTool generator = new ClusterRoleRecordGeneratorTool();
    @Rule
    public final TestName testName = new TestName();

    @Before
    public void before() {
        this.generator.setConf(this.conf);
    }

    @Test
    public void testGetPeerClusterKey() throws Exception {
        String peerZk = "localhost:2188:/hbase";
        ReplicationPeerConfig replicationConfig = (ReplicationPeerConfig)Mockito.mock(ReplicationPeerConfig.class);
        Mockito.when((Object)replicationConfig.getClusterKey()).thenReturn((Object)peerZk);
        Admin admin = (Admin)Mockito.mock(Admin.class);
        String id = "1";
        Mockito.when((Object)admin.getReplicationPeerConfig((String)ArgumentMatchers.eq((Object)id))).thenReturn((Object)replicationConfig);
        Assert.assertEquals((Object)peerZk, (Object)ClusterRoleRecordGeneratorTool.getPeerClusterKey((Admin)admin, (String)id));
        id = "1984";
        Mockito.when((Object)admin.getReplicationPeerConfig((String)ArgumentMatchers.eq((Object)id))).thenReturn((Object)replicationConfig);
        Assert.assertEquals((Object)peerZk, (Object)ClusterRoleRecordGeneratorTool.getPeerClusterKey((Admin)admin, (String)id));
    }

    @Test
    public void testGetHaPolicy() throws IOException {
        String haGroupName = this.testName.getMethodName();
        Assert.assertEquals((Object)HighAvailabilityPolicy.PARALLEL, (Object)this.generator.getHaPolicy(haGroupName));
        this.conf.set(String.format("phoenix.ha.role.generator.policy.%s", haGroupName), HighAvailabilityPolicy.FAILOVER.name());
        Assert.assertEquals((Object)HighAvailabilityPolicy.FAILOVER, (Object)this.generator.getHaPolicy(haGroupName));
        String haGroupName2 = haGroupName + "2";
        Assert.assertEquals((Object)HighAvailabilityPolicy.PARALLEL, (Object)this.generator.getHaPolicy(haGroupName2));
        String invalidHaPolicy = "foobar";
        this.conf.set(String.format("phoenix.ha.role.generator.policy.%s", haGroupName), invalidHaPolicy);
        try {
            this.generator.getHaPolicy(haGroupName);
            Assert.fail((String)("Should have failed since no such HA policy named " + invalidHaPolicy));
        }
        catch (IOException e) {
            LOG.info("Got expected exception for invalid HA policy name {}", (Object)invalidHaPolicy, (Object)e);
            Assert.assertNotNull((Object)e.getCause());
            Assert.assertTrue((boolean)(e.getCause() instanceof IllegalArgumentException));
        }
    }
}

