/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import java.util.Arrays;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.iterate.MaterializedResultIterator;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.iterate.SpoolTooBigToDiskException;
import org.apache.phoenix.iterate.SpoolingResultIterator;
import org.apache.phoenix.log.LogLevel;
import org.apache.phoenix.memory.DelegatingMemoryManager;
import org.apache.phoenix.memory.GlobalMemoryManager;
import org.apache.phoenix.memory.MemoryManager;
import org.apache.phoenix.monitoring.MemoryMetricsHolder;
import org.apache.phoenix.monitoring.ReadMetricQueue;
import org.apache.phoenix.monitoring.SpoolingMetricsHolder;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.tuple.SingleKeyValueTuple;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.util.AssertResults;
import org.junit.Test;

public class SpoolingResultIteratorTest {
    private static final byte[] A = Bytes.toBytes((String)"a");
    private static final byte[] B = Bytes.toBytes((String)"b");

    private void testSpooling(int threshold, long maxSizeSpool) throws Throwable {
        Tuple[] results = new Tuple[]{new SingleKeyValueTuple((Cell)new KeyValue(A, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Bytes.toBytes((int)1))), new SingleKeyValueTuple((Cell)new KeyValue(B, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Bytes.toBytes((int)1)))};
        MaterializedResultIterator iterator = new MaterializedResultIterator(Arrays.asList(results));
        Tuple[] expectedResults = new Tuple[]{new SingleKeyValueTuple((Cell)new KeyValue(A, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Bytes.toBytes((int)1))), new SingleKeyValueTuple((Cell)new KeyValue(B, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Bytes.toBytes((int)1)))};
        DelegatingMemoryManager memoryManager = new DelegatingMemoryManager((MemoryManager)new GlobalMemoryManager((long)threshold));
        SpoolingResultIterator scanner = new SpoolingResultIterator(SpoolingMetricsHolder.NO_OP_INSTANCE, new MemoryMetricsHolder(new ReadMetricQueue(false, LogLevel.OFF), ""), (ResultIterator)iterator, (MemoryManager)memoryManager, (long)threshold, maxSizeSpool, "/tmp");
        AssertResults.assertResults((ResultIterator)scanner, expectedResults);
    }

    @Test
    public void testInMemorySpooling() throws Throwable {
        this.testSpooling(0x100000, 1024000000L);
    }

    @Test
    public void testOnDiskSpooling() throws Throwable {
        this.testSpooling(1, 1024000000L);
    }

    @Test(expected=SpoolTooBigToDiskException.class)
    public void testFailToSpool() throws Throwable {
        this.testSpooling(1, 0L);
    }
}

