/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.iterate.DelayedTableResultIteratorFactory;
import org.apache.phoenix.iterate.TableResultIteratorFactory;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDriver;
import org.apache.phoenix.jdbc.PhoenixTestDriver;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class ScannerLeaseRenewalIT {
    private static HBaseTestingUtility hbaseTestUtil;
    private static String zkQuorum;
    private static final long LEASE_TIMEOUT_PERIOD_MILLIS = 6000L;
    private static String url;

    @BeforeClass
    public static synchronized void setUp() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        hbaseTestUtil = new HBaseTestingUtility(conf);
        BaseTest.setUpConfigForMiniCluster(conf);
        conf.setLong("hbase.client.scanner.timeout.period", 6000L);
        hbaseTestUtil.startMiniCluster();
        zkQuorum = "localhost:" + hbaseTestUtil.getZkCluster().getClientPort();
        url = "jdbc:phoenix+zk:" + zkQuorum;
        Properties driverProps = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        driverProps.put("phoenix.scanner.lease.pool.size", Long.toString(4L));
        driverProps.put("phoenix.scanner.lease.renew.enabled", Boolean.toString(true));
        driverProps.put("phoenix.scanner.lease.threshold", Long.toString(3000L));
        driverProps.put("phoenix.scanner.lease.renew.interval", Long.toString(1500L));
        driverProps.put("hbase.client.scanner.timeout.period", Long.toString(6000L));
        driverProps.put("phoenix.query.force.rowkeyorder", Boolean.toString(false));
        DriverManager.registerDriver((Driver)PhoenixDriver.INSTANCE);
        DriverManager.registerDriver((Driver)((Object)new PhoenixTestDriver()));
        try (PhoenixConnection phxConn = DriverManager.getConnection(url, driverProps).unwrap(PhoenixConnection.class);){
            Assume.assumeTrue((boolean)phxConn.getQueryServices().supportsFeature(ConnectionQueryServices.Feature.RENEW_LEASE));
        }
    }

    @Test
    public void testRenewLeasePreventsSelectQueryFromFailing() throws Exception {
        String tableName = "testRenewLeasePreventsSelectQueryFromFailing";
        int numRecords = 5;
        try (Connection conn = DriverManager.getConnection(url);){
            conn.createStatement().execute("CREATE TABLE " + tableName + " (PK1 INTEGER NOT NULL PRIMARY KEY, KV1 VARCHAR)");
            String upsert = "UPSERT INTO " + tableName + " VALUES (?, ?)";
            Random random = new Random();
            PreparedStatement stmt = conn.prepareStatement(upsert);
            for (int i = 0; i < numRecords; ++i) {
                stmt.setInt(1, random.nextInt());
                stmt.setString(2, "KV" + random.nextInt());
                stmt.executeUpdate();
            }
            conn.commit();
        }
        try (PhoenixConnection phxConn = DriverManager.getConnection(url).unwrap(PhoenixConnection.class);){
            String sql = "SELECT * FROM " + tableName;
            long delayOnNext = 12000L;
            phxConn.setTableResultIteratorFactory((TableResultIteratorFactory)new DelayedTableResultIteratorFactory(delayOnNext));
            Statement s = phxConn.createStatement();
            s.setFetchSize(2);
            ResultSet rs = s.executeQuery(sql);
            int count = 0;
            while (rs.next()) {
                ++count;
            }
            Assert.assertEquals((long)numRecords, (long)count);
        }
    }

    @Test
    public void testRenewLeasePreventsUpsertSelectFromFailing() throws Exception {
        String table1 = "testRenewLeasePreventsUpsertSelectFromFailing";
        String table2 = "testRenewLeasePreventsUpsertSelectFromFailing2";
        try (Connection conn = DriverManager.getConnection(url);){
            conn.createStatement().execute("CREATE TABLE " + table1 + " (PK1 INTEGER NOT NULL PRIMARY KEY, KV1 VARCHAR)");
            conn.createStatement().execute("CREATE TABLE " + table2 + " (PK1 INTEGER NOT NULL PRIMARY KEY, KV1 VARCHAR)");
            int numRecords = 5;
            String upsert = "UPSERT INTO " + table1 + " VALUES (?, ?)";
            Random random = new Random();
            PreparedStatement stmt = conn.prepareStatement(upsert);
            for (int i = 0; i < numRecords; ++i) {
                stmt.setInt(1, random.nextInt());
                stmt.setString(2, "KV" + random.nextInt());
                stmt.executeUpdate();
            }
            conn.commit();
        }
        try (PhoenixConnection phxConn = DriverManager.getConnection(url).unwrap(PhoenixConnection.class);){
            String upsertSelect = "UPSERT INTO " + table2 + " SELECT PK1, KV1 FROM " + table1;
            long delayAfterInit = 12000L;
            phxConn.setTableResultIteratorFactory((TableResultIteratorFactory)new DelayedTableResultIteratorFactory(delayAfterInit));
            Statement s = phxConn.createStatement();
            s.setFetchSize(2);
            s.executeUpdate(upsertSelect);
        }
    }
}

