/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.expression.aggregator.Aggregators;
import org.apache.phoenix.expression.aggregator.ClientAggregators;
import org.apache.phoenix.iterate.MaterializedResultIterator;
import org.apache.phoenix.iterate.MaterializedResultIterators;
import org.apache.phoenix.iterate.PeekingResultIterator;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.iterate.ResultIterators;
import org.apache.phoenix.iterate.RowKeyOrderedAggregateResultIterator;
import org.apache.phoenix.query.BaseConnectionlessQueryTest;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.tuple.SingleKeyValueTuple;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.util.AssertResults;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Test;

public class RowKeyOrderedAggregateResultIteratorTest
extends BaseConnectionlessQueryTest {
    private static final byte[] A = Bytes.toBytes((String)"a");
    private static final byte[] B = Bytes.toBytes((String)"b");
    private static final byte[] C = Bytes.toBytes((String)"c");
    private static final byte[] D = Bytes.toBytes((String)"d");

    @Test
    public void testNoSpan() throws Exception {
        Tuple[] results1 = new Tuple[]{new SingleKeyValueTuple((Cell)new KeyValue(A, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Bytes.toBytes((long)1L)))};
        Tuple[] results2 = new Tuple[]{new SingleKeyValueTuple((Cell)new KeyValue(B, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Bytes.toBytes((long)2L)))};
        Tuple[] results3 = new Tuple[]{new SingleKeyValueTuple((Cell)new KeyValue(C, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Bytes.toBytes((long)3L))), new SingleKeyValueTuple((Cell)new KeyValue(D, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Bytes.toBytes((long)4L)))};
        List<PeekingResultIterator> results = Arrays.asList(new MaterializedResultIterator(Arrays.asList(results1)), new MaterializedResultIterator(Arrays.asList(results2)), new MaterializedResultIterator(Arrays.asList(results3)));
        MaterializedResultIterators iterators = new MaterializedResultIterators(results);
        Tuple[] expectedResults = new Tuple[]{new SingleKeyValueTuple((Cell)new KeyValue(A, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Bytes.toBytes((long)1L))), new SingleKeyValueTuple((Cell)new KeyValue(B, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Bytes.toBytes((long)2L))), new SingleKeyValueTuple((Cell)new KeyValue(C, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Bytes.toBytes((long)3L))), new SingleKeyValueTuple((Cell)new KeyValue(D, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Bytes.toBytes((long)4L)))};
        ClientAggregators aggregators = TestUtil.getSingleSumAggregator(RowKeyOrderedAggregateResultIteratorTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
        RowKeyOrderedAggregateResultIterator scanner = new RowKeyOrderedAggregateResultIterator((ResultIterators)iterators, (Aggregators)aggregators);
        AssertResults.assertResults((ResultIterator)scanner, expectedResults);
    }

    @Test
    public void testSpanThree() throws Exception {
        Tuple[] results1 = new Tuple[]{new SingleKeyValueTuple((Cell)new KeyValue(A, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Bytes.toBytes((long)1L))), new SingleKeyValueTuple((Cell)new KeyValue(B, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Bytes.toBytes((long)2L)))};
        Tuple[] results2 = new Tuple[]{new SingleKeyValueTuple((Cell)new KeyValue(B, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Bytes.toBytes((long)3L)))};
        Tuple[] results3 = new Tuple[]{new SingleKeyValueTuple((Cell)new KeyValue(B, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Bytes.toBytes((long)4L))), new SingleKeyValueTuple((Cell)new KeyValue(C, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Bytes.toBytes((long)5L)))};
        List<PeekingResultIterator> results = Arrays.asList(new MaterializedResultIterator(Arrays.asList(results1)), new MaterializedResultIterator(Arrays.asList(results2)), new MaterializedResultIterator(Arrays.asList(results3)));
        MaterializedResultIterators iterators = new MaterializedResultIterators(results);
        Tuple[] expectedResults = new Tuple[]{new SingleKeyValueTuple((Cell)new KeyValue(A, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Bytes.toBytes((long)1L))), new SingleKeyValueTuple((Cell)new KeyValue(B, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Bytes.toBytes((long)9L))), new SingleKeyValueTuple((Cell)new KeyValue(C, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Bytes.toBytes((long)5L)))};
        ClientAggregators aggregators = TestUtil.getSingleSumAggregator(RowKeyOrderedAggregateResultIteratorTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
        RowKeyOrderedAggregateResultIterator scanner = new RowKeyOrderedAggregateResultIterator((ResultIterators)iterators, (Aggregators)aggregators);
        AssertResults.assertResults((ResultIterator)scanner, expectedResults);
    }

    @Test
    public void testSpanAll() throws Exception {
        Tuple[] results1 = new Tuple[]{new SingleKeyValueTuple((Cell)new KeyValue(B, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Bytes.toBytes((long)2L)))};
        Tuple[] results2 = new Tuple[]{new SingleKeyValueTuple((Cell)new KeyValue(B, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Bytes.toBytes((long)3L)))};
        Tuple[] results3 = new Tuple[]{new SingleKeyValueTuple((Cell)new KeyValue(B, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Bytes.toBytes((long)4L)))};
        List<PeekingResultIterator> results = Arrays.asList(new MaterializedResultIterator(Arrays.asList(results1)), new MaterializedResultIterator(Arrays.asList(results2)), new MaterializedResultIterator(Arrays.asList(results3)));
        MaterializedResultIterators iterators = new MaterializedResultIterators(results);
        Tuple[] expectedResults = new Tuple[]{new SingleKeyValueTuple((Cell)new KeyValue(B, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Bytes.toBytes((long)9L)))};
        ClientAggregators aggregators = TestUtil.getSingleSumAggregator(RowKeyOrderedAggregateResultIteratorTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
        RowKeyOrderedAggregateResultIterator scanner = new RowKeyOrderedAggregateResultIterator((ResultIterators)iterators, (Aggregators)aggregators);
        AssertResults.assertResults((ResultIterator)scanner, expectedResults);
    }

    @Test
    public void testSpanEnd() throws Exception {
        Tuple[] results1 = new Tuple[]{new SingleKeyValueTuple((Cell)new KeyValue(A, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Bytes.toBytes((long)1L)))};
        Tuple[] results2 = new Tuple[]{new SingleKeyValueTuple((Cell)new KeyValue(A, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Bytes.toBytes((long)2L))), new SingleKeyValueTuple((Cell)new KeyValue(B, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Bytes.toBytes((long)3L))), new SingleKeyValueTuple((Cell)new KeyValue(C, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Bytes.toBytes((long)4L))), new SingleKeyValueTuple((Cell)new KeyValue(D, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Bytes.toBytes((long)5L)))};
        Tuple[] results3 = new Tuple[]{new SingleKeyValueTuple((Cell)new KeyValue(D, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Bytes.toBytes((long)6L)))};
        List<PeekingResultIterator> results = Arrays.asList(new MaterializedResultIterator(Arrays.asList(results1)), new MaterializedResultIterator(Arrays.asList(results2)), new MaterializedResultIterator(Arrays.asList(results3)));
        MaterializedResultIterators iterators = new MaterializedResultIterators(results);
        Tuple[] expectedResults = new Tuple[]{new SingleKeyValueTuple((Cell)new KeyValue(A, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Bytes.toBytes((long)3L))), new SingleKeyValueTuple((Cell)new KeyValue(B, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Bytes.toBytes((long)3L))), new SingleKeyValueTuple((Cell)new KeyValue(C, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Bytes.toBytes((long)4L))), new SingleKeyValueTuple((Cell)new KeyValue(D, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Bytes.toBytes((long)11L)))};
        ClientAggregators aggregators = TestUtil.getSingleSumAggregator(RowKeyOrderedAggregateResultIteratorTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
        RowKeyOrderedAggregateResultIterator scanner = new RowKeyOrderedAggregateResultIterator((ResultIterators)iterators, (Aggregators)aggregators);
        AssertResults.assertResults((ResultIterator)scanner, expectedResults);
    }
}

