/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.iterate.MockParallelIteratorFactory;
import org.apache.phoenix.iterate.ParallelIteratorFactory;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixResultSet;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.ReadOnlyProps;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class RoundRobinResultIteratorWithStatsIT
extends BaseTest {
    private String tableName;

    @Before
    public void generateTableName() {
        this.tableName = RoundRobinResultIteratorWithStatsIT.generateUniqueName();
    }

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap props = Maps.newHashMapWithExpectedSize((int)3);
        props.put("phoenix.stats.guidepost.width", Long.toString(70000L));
        props.put("phoenix.query.queueSize", Integer.toString(10000));
        props.put("phoenix.explain.displayChunkCount", Boolean.TRUE.toString());
        props.put("phoenix.query.force.rowkeyorder", Boolean.toString(false));
        RoundRobinResultIteratorWithStatsIT.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
    }

    @Test
    public void testRoundRobinBehavior() throws Exception {
        int nRows = 30000;
        try (Connection conn = DriverManager.getConnection(RoundRobinResultIteratorWithStatsIT.getUrl());){
            int i;
            conn.createStatement().execute("CREATE TABLE " + this.tableName + "(K VARCHAR PRIMARY KEY)");
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + this.tableName + " VALUES(?)");
            for (int i2 = 1; i2 <= nRows; ++i2) {
                stmt.setString(1, "" + i2);
                stmt.executeUpdate();
                if (i2 % 2000 != 0) continue;
                conn.commit();
            }
            conn.commit();
            conn.createStatement().execute("UPDATE STATISTICS " + this.tableName);
            PhoenixConnection phxConn = conn.unwrap(PhoenixConnection.class);
            MockParallelIteratorFactory parallelIteratorFactory = new MockParallelIteratorFactory();
            phxConn.setIteratorFactory((ParallelIteratorFactory)parallelIteratorFactory);
            ResultSet rs = stmt.executeQuery("SELECT * FROM " + this.tableName);
            StatementContext ctx = rs.unwrap(PhoenixResultSet.class).getContext();
            PTable table = ((TableRef)ctx.getResolver().getTables().get(0)).getTable();
            parallelIteratorFactory.setTable(table);
            PhoenixStatement pstmt = stmt.unwrap(PhoenixStatement.class);
            int numIterators = pstmt.getQueryPlan().getSplits().size();
            Assert.assertTrue((numIterators > 1 ? 1 : 0) != 0);
            int numFetches = 2 * numIterators;
            ArrayList<String> iteratorOrder = new ArrayList<String>(numFetches);
            for (i = 1; i <= numFetches; ++i) {
                rs.next();
                iteratorOrder.add(rs.getString(1));
            }
            for (i = 0; i < numIterators; ++i) {
                Assert.assertEquals(iteratorOrder.get(i), iteratorOrder.get(i + numIterators));
            }
        }
    }
}

