/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import java.sql.SQLException;
import org.apache.phoenix.iterate.TableResultIterator;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;

public class RenewLeaseOnlyTableIterator
extends TableResultIterator {
    private final int numberOfLeaseRenewals;
    private final int thresholdNotReachedAt;
    private final int failToAcquireLockAt;
    private final int failLeaseRenewalAt;
    private int counter = 0;
    private TableResultIterator.RenewLeaseStatus lastRenewLeaseStatus;

    public RenewLeaseOnlyTableIterator(int renewLeaseCount, int skipRenewLeaseAt, int failToAcquireLockAt, int doNotRenewLeaseAt) throws SQLException {
        Preconditions.checkArgument((renewLeaseCount >= skipRenewLeaseAt ? 1 : 0) != 0);
        this.numberOfLeaseRenewals = renewLeaseCount;
        this.thresholdNotReachedAt = skipRenewLeaseAt;
        this.failToAcquireLockAt = failToAcquireLockAt;
        this.failLeaseRenewalAt = doNotRenewLeaseAt;
    }

    public TableResultIterator.RenewLeaseStatus renewLease() {
        ++this.counter;
        if (this.counter == this.thresholdNotReachedAt) {
            this.lastRenewLeaseStatus = TableResultIterator.RenewLeaseStatus.THRESHOLD_NOT_REACHED;
        } else {
            if (this.counter == this.failLeaseRenewalAt) {
                this.lastRenewLeaseStatus = null;
                throw new RuntimeException("Failing lease renewal");
            }
            this.lastRenewLeaseStatus = this.counter == this.failToAcquireLockAt ? TableResultIterator.RenewLeaseStatus.LOCK_NOT_ACQUIRED : (this.counter <= this.numberOfLeaseRenewals ? TableResultIterator.RenewLeaseStatus.RENEWED : TableResultIterator.RenewLeaseStatus.CLOSED);
        }
        return this.lastRenewLeaseStatus;
    }

    public TableResultIterator.RenewLeaseStatus getLastRenewLeaseStatus() {
        return this.lastRenewLeaseStatus;
    }
}

