/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.iterate.BaseResultIterators;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.util.EnvironmentEdge;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.ManualEnvironmentEdge;
import org.apache.phoenix.util.ReadOnlyProps;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class PhoenixQueryTimeoutIT
extends ParallelStatsDisabledIT {
    private static final ExecutorService EXECUTOR_SERVICE = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("query-timeout-tests-%d").build());
    private String tableName;

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("phoenix.max.lookback.age.seconds", Integer.toString(3600));
        props.put("phoenix.use.stats.parallelization", Boolean.toString(false));
        props.put("phoenix.tests.minicluster.numregionservers", String.valueOf(2));
        PhoenixQueryTimeoutIT.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
    }

    @Before
    public void createTableAndInsertRows() throws Exception {
        this.tableName = PhoenixQueryTimeoutIT.generateUniqueName();
        int numRows = 1000;
        String ddl = "CREATE TABLE " + this.tableName + " (K INTEGER NOT NULL PRIMARY KEY, V VARCHAR)";
        try (Connection conn = DriverManager.getConnection(PhoenixQueryTimeoutIT.getUrl());){
            conn.createStatement().execute(ddl);
            String dml = "UPSERT INTO " + this.tableName + " VALUES (?, ?)";
            PreparedStatement stmt = conn.prepareStatement(dml);
            for (int i = 1; i <= numRows; ++i) {
                stmt.setInt(1, i);
                stmt.setString(2, "value" + i);
                stmt.executeUpdate();
            }
            conn.commit();
        }
    }

    @Test
    public void testCustomQueryTimeoutWithVeryLowTimeout() throws Exception {
        PreparedStatement ps = this.loadDataAndPrepareQuery(1, 1);
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
            }
            Assert.fail((String)"Expected query to timeout with a 1 ms timeout");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testCustomQueryTimeoutWithVeryLowTimeoutWithRegionMoves() throws Exception {
        PreparedStatement ps = this.loadDataAndPrepareQuery(1, 1);
        try {
            ResultSet rs = ps.executeQuery();
            PhoenixQueryTimeoutIT.moveRegionsOfTable(this.tableName);
            while (rs.next()) {
                PhoenixQueryTimeoutIT.moveRegionsOfTable(this.tableName);
            }
            Assert.fail((String)"Expected query to timeout with a 1 ms timeout");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testCustomQueryTimeoutWithNormalTimeout() throws Exception {
        PreparedStatement ps = this.loadDataAndPrepareQuery(30000, 30);
        try {
            ResultSet rs = ps.executeQuery();
            int count = 0;
            while (rs.next()) {
                ++count;
            }
            Assert.assertEquals((String)"Unexpected number of records returned", (long)1000L, (long)count);
        }
        catch (Exception e) {
            Assert.fail((String)"Expected query to succeed");
        }
    }

    @Test
    public void testCustomQueryTimeoutWithNormalTimeoutWithRegionMoves() throws Exception {
        PreparedStatement ps = this.loadDataAndPrepareQuery(30000, 30);
        ResultSet rs = ps.executeQuery();
        int count = 0;
        PhoenixQueryTimeoutIT.moveRegionsOfTable(this.tableName);
        while (rs.next()) {
            if (count % 200 == 0) {
                PhoenixQueryTimeoutIT.moveRegionsOfTable(this.tableName);
            }
            ++count;
        }
        Assert.assertEquals((String)"Unexpected number of records returned", (long)1000L, (long)count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScanningResultIteratorQueryTimeoutForPagingWithVeryLowTimeout() throws Exception {
        PreparedStatement ps = this.loadDataAndPreparePagedQuery(1, 1);
        try {
            BaseResultIterators.setForTestingSetTimeoutToMaxToLetQueryPassHere((boolean)true);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
            }
            Assert.fail((String)"Expected query to timeout with a 1 ms timeout");
        }
        catch (SQLException e) {
            Throwable t;
            for (t = e; t != null && !(t instanceof SQLTimeoutException); t = t.getCause()) {
            }
            if (t == null) {
                Assert.fail((String)"Expected query to fail with SQLTimeoutException");
            }
            Assert.assertEquals((long)SQLExceptionCode.OPERATION_TIMED_OUT.getErrorCode(), (long)((SQLTimeoutException)t).getErrorCode());
        }
        finally {
            BaseResultIterators.setForTestingSetTimeoutToMaxToLetQueryPassHere((boolean)false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScanningResultIteratorShouldNotQueryTimeoutForPagingAfterReceivingAValidRow() throws Exception {
        PreparedStatement ps = this.loadDataAndPreparePagedQuery(10, 1);
        ManualEnvironmentEdge injectEdge = new ManualEnvironmentEdge();
        injectEdge.setValue(EnvironmentEdgeManager.currentTimeMillis());
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)injectEdge);
        try {
            BaseResultIterators.setForTestingSetTimeoutToMaxToLetQueryPassHere((boolean)true);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                injectEdge.incrementValue(10L);
            }
        }
        catch (SQLException e) {
            Assert.fail((String)"Query should have run smoothly");
        }
        finally {
            BaseResultIterators.setForTestingSetTimeoutToMaxToLetQueryPassHere((boolean)false);
        }
        PreparedStatement failingPs = this.loadDataAndPreparePagedQuery(0, 0);
        try {
            BaseResultIterators.setForTestingSetTimeoutToMaxToLetQueryPassHere((boolean)true);
            ResultSet rs = failingPs.executeQuery();
            EnvironmentEdgeManager.reset();
            while (rs.next()) {
            }
            Assert.fail((String)"Expected query to timeout with a 0 ms timeout");
        }
        catch (SQLException e) {
            Throwable t;
            for (t = e; t != null && !(t instanceof SQLTimeoutException); t = t.getCause()) {
            }
            if (t == null) {
                Assert.fail((String)"Expected query to fail with SQLTimeoutException");
            }
            Assert.assertEquals((long)SQLExceptionCode.OPERATION_TIMED_OUT.getErrorCode(), (long)((SQLTimeoutException)t).getErrorCode());
        }
        finally {
            BaseResultIterators.setForTestingSetTimeoutToMaxToLetQueryPassHere((boolean)false);
            EnvironmentEdgeManager.reset();
        }
    }

    @Test
    public void testQueryTimeoutWithMetadataLookup() throws Exception {
        PreparedStatement ps = this.loadDataAndPreparePagedQuery(0, 0);
        try {
            ResultSet rs = ps.executeQuery();
            rs.next();
            Assert.fail((String)"Query timeout is 0ms");
        }
        catch (SQLException e) {
            Throwable t;
            for (t = e; t != null && !(t instanceof SQLTimeoutException); t = t.getCause()) {
            }
            if (t == null) {
                Assert.fail((String)"Expected query to fail with SQLTimeoutException");
            }
            Assert.assertEquals((long)SQLExceptionCode.OPERATION_TIMED_OUT.getErrorCode(), (long)((SQLTimeoutException)t).getErrorCode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScanningResultIteratorQueryTimeoutForPagingWithNormalLowTimeout() throws Exception {
        PreparedStatement ps = this.loadDataAndPreparePagedQuery(30000, 30);
        try {
            BaseResultIterators.setForTestingSetTimeoutToMaxToLetQueryPassHere((boolean)true);
            ResultSet rs = ps.executeQuery();
            int count = 0;
            while (rs.next()) {
                ++count;
            }
            Assert.assertEquals((String)"Unexpected number of records returned", (long)500L, (long)count);
        }
        catch (SQLException e) {
            Assert.fail((String)"Expected query to succeed");
        }
        finally {
            BaseResultIterators.setForTestingSetTimeoutToMaxToLetQueryPassHere((boolean)false);
        }
    }

    private PreparedStatement loadDataAndPrepareQuery(int timeoutMs, int timeoutSecs) throws Exception, SQLException {
        Properties props = new Properties();
        props.setProperty("phoenix.query.timeoutMs", String.valueOf(timeoutMs));
        Connection conn = DriverManager.getConnection(PhoenixQueryTimeoutIT.getUrl(), props);
        PreparedStatement ps = conn.prepareStatement("SELECT * FROM " + this.tableName);
        PhoenixStatement phoenixStmt = ps.unwrap(PhoenixStatement.class);
        Assert.assertEquals((long)timeoutMs, (long)phoenixStmt.getQueryTimeoutInMillis());
        Assert.assertEquals((long)timeoutSecs, (long)phoenixStmt.getQueryTimeout());
        return ps;
    }

    private static void moveRegionsOfTable(String tableName) throws IOException {
        Admin admin = PhoenixQueryTimeoutIT.getUtility().getAdmin();
        ArrayList servers = new ArrayList(admin.getRegionServers());
        ServerName server1 = (ServerName)servers.get(0);
        ServerName server2 = (ServerName)servers.get(1);
        EXECUTOR_SERVICE.execute(() -> {
            List regionsOnServer2;
            List regionsOnServer1;
            try {
                regionsOnServer1 = admin.getRegions(server1);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            try {
                regionsOnServer2 = admin.getRegions(server2);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            regionsOnServer1.forEach(regionInfo -> {
                if (regionInfo.getTable().equals((Object)TableName.valueOf((String)tableName))) {
                    try {
                        admin.move(regionInfo.getEncodedNameAsBytes(), server2);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            regionsOnServer2.forEach(regionInfo -> {
                if (regionInfo.getTable().equals((Object)TableName.valueOf((String)tableName))) {
                    try {
                        admin.move(regionInfo.getEncodedNameAsBytes(), server1);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        });
    }

    private PreparedStatement loadDataAndPreparePagedQuery(int timeoutMs, int timeoutSecs) throws Exception {
        Properties props = new Properties();
        props.setProperty("phoenix.query.timeoutMs", String.valueOf(timeoutMs));
        props.setProperty("phoenix.server.page.size.ms", Integer.toString(0));
        PhoenixConnection conn = DriverManager.getConnection(PhoenixQueryTimeoutIT.getUrl(), props).unwrap(PhoenixConnection.class);
        PreparedStatement ps = conn.prepareStatement("SELECT * FROM " + this.tableName + " WHERE K % 2 = 0");
        PhoenixStatement phoenixStmt = ps.unwrap(PhoenixStatement.class);
        Assert.assertEquals((long)timeoutMs, (long)phoenixStmt.getQueryTimeoutInMillis());
        Assert.assertEquals((long)timeoutSecs, (long)phoenixStmt.getQueryTimeout());
        Assert.assertEquals((long)0L, (long)conn.getQueryServices().getProps().getInt("phoenix.server.page.size.ms", -1));
        return ps;
    }
}

