/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.phoenix.execute.ScanPlan;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.OrderByExpression;
import org.apache.phoenix.hbase.index.util.VersionUtil;
import org.apache.phoenix.iterate.NonAggregateRegionScannerFactory;
import org.apache.phoenix.iterate.OrderedResultIterator;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.util.ScanUtil;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class OrderedResultIteratorTest {
    @Test
    public void testNullIteratorOnClose() throws SQLException {
        ResultIterator delegate = ResultIterator.EMPTY_ITERATOR;
        List<Object> orderByExpressions = Collections.singletonList(null);
        int thresholdBytes = Integer.MAX_VALUE;
        boolean spoolingEnabled = true;
        OrderedResultIterator iterator = new OrderedResultIterator(delegate, orderByExpressions, spoolingEnabled, (long)thresholdBytes);
        iterator.close();
    }

    @Test
    public void testSpoolingBackwardCompatibility() {
        RegionScanner s = (RegionScanner)Mockito.mock(RegionScanner.class);
        RegionInfo regionInfo = (RegionInfo)Mockito.mock(RegionInfo.class);
        Mockito.when((Object)s.getRegionInfo()).thenReturn((Object)regionInfo);
        Scan scan = new Scan();
        LiteralExpression exp = LiteralExpression.newConstant((Object)Boolean.TRUE);
        OrderByExpression ex = OrderByExpression.createByCheckIfOrderByReverse((Expression)exp, (boolean)false, (boolean)false, (boolean)false);
        ScanPlan.serializeScanRegionObserverIntoScan((Scan)scan, (int)0, Arrays.asList(ex), (int)100);
        ScanUtil.setClientVersion((Scan)scan, (int)VersionUtil.encodeVersion((String)"5.1.0"));
        NonAggregateRegionScannerFactory.deserializeFromScan((Scan)scan, (RegionScanner)s, (boolean)false, (long)100L);
        ScanUtil.setClientVersion((Scan)scan, (int)VersionUtil.encodeVersion((String)"5.2.0"));
        NonAggregateRegionScannerFactory.deserializeFromScan((Scan)scan, (RegionScanner)s, (boolean)false, (long)100L);
        ScanUtil.setClientVersion((Scan)scan, (int)VersionUtil.encodeVersion((String)"4.15.0"));
        NonAggregateRegionScannerFactory.deserializeFromScan((Scan)scan, (RegionScanner)s, (boolean)false, (long)100L);
        ScanUtil.setClientVersion((Scan)scan, (int)VersionUtil.encodeVersion((String)"4.15.1"));
        NonAggregateRegionScannerFactory.deserializeFromScan((Scan)scan, (RegionScanner)s, (boolean)false, (long)100L);
        ScanUtil.setClientVersion((Scan)scan, (int)VersionUtil.encodeVersion((String)"5.0.0"));
        try {
            NonAggregateRegionScannerFactory.deserializeFromScan((Scan)scan, (RegionScanner)s, (boolean)false, (long)100L);
            Assert.fail((String)"Deserialize should fail for 5.0.0 since we didn't serialize thresholdBytes");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        ScanUtil.setClientVersion((Scan)scan, (int)VersionUtil.encodeVersion((String)"4.14.0"));
        try {
            NonAggregateRegionScannerFactory.deserializeFromScan((Scan)scan, (RegionScanner)s, (boolean)false, (long)100L);
            Assert.fail((String)"Deserialize should fail for 4.14.0 since we didn't serialize thresholdBytes");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

