/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.compile.ColumnProjector;
import org.apache.phoenix.compile.RowProjector;
import org.apache.phoenix.expression.KeyValueColumnExpression;
import org.apache.phoenix.iterate.AggregatingResultIterator;
import org.apache.phoenix.iterate.DistinctAggregatingResultIterator;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.schema.tuple.MultiKeyValueTuple;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.util.AssertResults;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class DistinctAggregatingResultIteratorTest {
    private static final byte[] cf = Bytes.toBytes((String)"cf");
    private static final byte[] cq1 = Bytes.toBytes((String)"cq1");
    private static final byte[] cq2 = Bytes.toBytes((String)"cq2");
    private static final byte[] cq3 = Bytes.toBytes((String)"cq3");
    private static final byte[] rowKey1 = Bytes.toBytes((String)"rowKey1");
    private static final byte[] rowKey2 = Bytes.toBytes((String)"rowKey2");
    private static final byte[] rowKey3 = Bytes.toBytes((String)"rowKey3");
    private static final byte[] rowKey4 = Bytes.toBytes((String)"rowKey4");
    private static final byte[] rowKey5 = Bytes.toBytes((String)"rowKey4");

    @Test
    public void testDistinctAggregatingResultIterator() throws Throwable {
        Tuple[] input1 = new Tuple[]{new MultiKeyValueTuple(Arrays.asList(new KeyValue(rowKey1, cf, cq1, PInteger.INSTANCE.toBytes((Object)1)), new KeyValue(rowKey1, cf, cq2, PInteger.INSTANCE.toBytes((Object)2)))), new MultiKeyValueTuple(Arrays.asList(new KeyValue(rowKey2, cf, cq1, PInteger.INSTANCE.toBytes((Object)11)), new KeyValue(rowKey2, cf, cq2, PInteger.INSTANCE.toBytes((Object)12)))), new MultiKeyValueTuple(Arrays.asList(new KeyValue(rowKey3, cf, cq1, PInteger.INSTANCE.toBytes((Object)4)), new KeyValue(rowKey3, cf, cq2, PInteger.INSTANCE.toBytes((Object)2)))), new MultiKeyValueTuple(Arrays.asList(new KeyValue(rowKey1, cf, cq1, PInteger.INSTANCE.toBytes((Object)1)), new KeyValue(rowKey1, cf, cq2, PInteger.INSTANCE.toBytes((Object)2)))), new MultiKeyValueTuple(Arrays.asList(new KeyValue(rowKey4, cf, cq1, PInteger.INSTANCE.toBytes((Object)7)), new KeyValue(rowKey4, cf, cq2, PInteger.INSTANCE.toBytes((Object)8)))), new MultiKeyValueTuple(Arrays.asList(new KeyValue(rowKey2, cf, cq1, PInteger.INSTANCE.toBytes((Object)11)), new KeyValue(rowKey2, cf, cq2, PInteger.INSTANCE.toBytes((Object)12)))), new MultiKeyValueTuple(Arrays.asList(new KeyValue(rowKey5, cf, cq1, PInteger.INSTANCE.toBytes((Object)90)), new KeyValue(rowKey5, cf, cq2, PInteger.INSTANCE.toBytes((Object)100)))), null};
        Tuple[] result1 = new Tuple[]{new MultiKeyValueTuple(Arrays.asList(new KeyValue(rowKey1, cf, cq1, PInteger.INSTANCE.toBytes((Object)1)), new KeyValue(rowKey1, cf, cq2, PInteger.INSTANCE.toBytes((Object)2)))), new MultiKeyValueTuple(Arrays.asList(new KeyValue(rowKey2, cf, cq1, PInteger.INSTANCE.toBytes((Object)11)), new KeyValue(rowKey2, cf, cq2, PInteger.INSTANCE.toBytes((Object)12)))), new MultiKeyValueTuple(Arrays.asList(new KeyValue(rowKey3, cf, cq1, PInteger.INSTANCE.toBytes((Object)4)), new KeyValue(rowKey3, cf, cq2, PInteger.INSTANCE.toBytes((Object)2)))), new MultiKeyValueTuple(Arrays.asList(new KeyValue(rowKey4, cf, cq1, PInteger.INSTANCE.toBytes((Object)7)), new KeyValue(rowKey4, cf, cq2, PInteger.INSTANCE.toBytes((Object)8)))), new MultiKeyValueTuple(Arrays.asList(new KeyValue(rowKey5, cf, cq1, PInteger.INSTANCE.toBytes((Object)90)), new KeyValue(rowKey5, cf, cq2, PInteger.INSTANCE.toBytes((Object)100))))};
        RowProjector mockRowProjector = (RowProjector)Mockito.mock(RowProjector.class);
        Mockito.when((Object)mockRowProjector.getColumnCount()).thenReturn((Object)2);
        KeyValueColumnExpression columnExpression1 = new KeyValueColumnExpression(cf, cq1);
        KeyValueColumnExpression columnExpression2 = new KeyValueColumnExpression(cf, cq2);
        final ColumnProjector mockColumnProjector1 = (ColumnProjector)Mockito.mock(ColumnProjector.class);
        Mockito.when((Object)mockColumnProjector1.getExpression()).thenReturn((Object)columnExpression1);
        final ColumnProjector mockColumnProjector2 = (ColumnProjector)Mockito.mock(ColumnProjector.class);
        Mockito.when((Object)mockColumnProjector2.getExpression()).thenReturn((Object)columnExpression2);
        Mockito.when((Object)mockRowProjector.getColumnProjectors()).thenAnswer((Answer)new Answer<List<ColumnProjector>>(){

            public List<ColumnProjector> answer(InvocationOnMock invocation) throws Throwable {
                return Arrays.asList(mockColumnProjector1, mockColumnProjector2);
            }
        });
        this.assertResults(input1, result1, mockRowProjector);
        Tuple[] input2 = new Tuple[]{new MultiKeyValueTuple(Arrays.asList(new KeyValue(rowKey1, cf, cq1, PInteger.INSTANCE.toBytes((Object)1)), new KeyValue(rowKey1, cf, cq2, PInteger.INSTANCE.toBytes((Object)2)))), new MultiKeyValueTuple(Arrays.asList(new KeyValue(rowKey2, cf, cq1, PInteger.INSTANCE.toBytes((Object)11)), new KeyValue(rowKey2, cf, cq2, PInteger.INSTANCE.toBytes((Object)12)))), new MultiKeyValueTuple(Arrays.asList(new KeyValue(rowKey3, cf, cq1, PInteger.INSTANCE.toBytes((Object)4)), new KeyValue(rowKey3, cf, cq2, PInteger.INSTANCE.toBytes((Object)2)))), new MultiKeyValueTuple(Arrays.asList(new KeyValue(rowKey1, cf, cq2, PInteger.INSTANCE.toBytes((Object)1)), new KeyValue(rowKey1, cf, cq1, PInteger.INSTANCE.toBytes((Object)2)))), new MultiKeyValueTuple(Arrays.asList(new KeyValue(rowKey4, cf, cq1, PInteger.INSTANCE.toBytes((Object)7)), new KeyValue(rowKey4, cf, cq2, PInteger.INSTANCE.toBytes((Object)8)))), new MultiKeyValueTuple(Arrays.asList(new KeyValue(rowKey2, cf, cq1, PInteger.INSTANCE.toBytes((Object)11)), new KeyValue(rowKey2, cf, cq3, PInteger.INSTANCE.toBytes((Object)12)))), new MultiKeyValueTuple(Arrays.asList(new KeyValue(rowKey1, cf, cq2, PInteger.INSTANCE.toBytes((Object)1)), new KeyValue(rowKey1, cf, cq1, PInteger.INSTANCE.toBytes((Object)2)))), new MultiKeyValueTuple(Arrays.asList(new KeyValue(rowKey5, cf, cq1, PInteger.INSTANCE.toBytes((Object)90)), new KeyValue(rowKey5, cf, cq2, PInteger.INSTANCE.toBytes((Object)100)))), new MultiKeyValueTuple(Arrays.asList(new KeyValue(rowKey2, cf, cq1, PInteger.INSTANCE.toBytes((Object)11)), new KeyValue(rowKey2, cf, cq3, PInteger.INSTANCE.toBytes((Object)12)))), null};
        Tuple[] result2 = new Tuple[]{new MultiKeyValueTuple(Arrays.asList(new KeyValue(rowKey1, cf, cq1, PInteger.INSTANCE.toBytes((Object)1)), new KeyValue(rowKey1, cf, cq2, PInteger.INSTANCE.toBytes((Object)2)))), new MultiKeyValueTuple(Arrays.asList(new KeyValue(rowKey2, cf, cq1, PInteger.INSTANCE.toBytes((Object)11)), new KeyValue(rowKey2, cf, cq2, PInteger.INSTANCE.toBytes((Object)12)))), new MultiKeyValueTuple(Arrays.asList(new KeyValue(rowKey3, cf, cq1, PInteger.INSTANCE.toBytes((Object)4)), new KeyValue(rowKey3, cf, cq2, PInteger.INSTANCE.toBytes((Object)2)))), new MultiKeyValueTuple(Arrays.asList(new KeyValue(rowKey1, cf, cq2, PInteger.INSTANCE.toBytes((Object)1)), new KeyValue(rowKey1, cf, cq1, PInteger.INSTANCE.toBytes((Object)2)))), new MultiKeyValueTuple(Arrays.asList(new KeyValue(rowKey4, cf, cq1, PInteger.INSTANCE.toBytes((Object)7)), new KeyValue(rowKey4, cf, cq2, PInteger.INSTANCE.toBytes((Object)8)))), new MultiKeyValueTuple(Arrays.asList(new KeyValue(rowKey2, cf, cq1, PInteger.INSTANCE.toBytes((Object)11)), new KeyValue(rowKey2, cf, cq3, PInteger.INSTANCE.toBytes((Object)12)))), new MultiKeyValueTuple(Arrays.asList(new KeyValue(rowKey5, cf, cq1, PInteger.INSTANCE.toBytes((Object)90)), new KeyValue(rowKey5, cf, cq2, PInteger.INSTANCE.toBytes((Object)100))))};
        this.assertResults(input2, result2, mockRowProjector);
        int n = 100;
        Tuple[] input3 = new Tuple[n + 1];
        for (int i = 0; i <= n; ++i) {
            byte[] rowKey = PInteger.INSTANCE.toBytes((Object)i);
            input3[i] = new MultiKeyValueTuple(Arrays.asList(new KeyValue(rowKey, cf, cq1, PInteger.INSTANCE.toBytes((Object)(i + 1))), new KeyValue(rowKey, cf, cq2, PInteger.INSTANCE.toBytes((Object)(i + 2)))));
        }
        input3[n] = null;
        Tuple[] result3 = Arrays.copyOfRange(input3, 0, n);
        this.assertResults(input3, result3, mockRowProjector);
        Tuple[] input4 = new Tuple[n + 1];
        for (int i = 0; i <= n; ++i) {
            byte[] rowKey = PInteger.INSTANCE.toBytes((Object)1);
            input4[i] = new MultiKeyValueTuple(Arrays.asList(new KeyValue(rowKey, cf, cq1, PInteger.INSTANCE.toBytes((Object)2)), new KeyValue(rowKey, cf, cq2, PInteger.INSTANCE.toBytes((Object)3))));
        }
        input4[n] = null;
        Tuple[] result4 = new Tuple[]{input4[0]};
        this.assertResults(input4, result4, mockRowProjector);
    }

    private void assertResults(Tuple[] input, Tuple[] result, RowProjector rowProjector) throws Exception {
        AggregatingResultIterator mockAggregatingResultIterator = (AggregatingResultIterator)Mockito.mock(AggregatingResultIterator.class);
        Mockito.when((Object)mockAggregatingResultIterator.next()).thenReturn((Object)input[0], (Object[])Arrays.copyOfRange(input, 1, input.length));
        DistinctAggregatingResultIterator distinctAggregatingResultIterator = new DistinctAggregatingResultIterator(mockAggregatingResultIterator, rowProjector);
        AssertResults.assertResults((ResultIterator)distinctAggregatingResultIterator, result);
    }
}

