/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.util.Properties;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class ChunkedResultIteratorIT
extends ParallelStatsDisabledIT {
    @Test
    public void testChunked() throws Exception {
        Properties props = new Properties();
        props.setProperty("phoenix.scanner.lease.renew.enabled", "false");
        props.setProperty("phoenix.query.scanResultChunkSize", "2");
        Connection conn = DriverManager.getConnection(ChunkedResultIteratorIT.getUrl(), props);
        String tableName = ChunkedResultIteratorIT.generateUniqueName();
        conn.createStatement().execute("CREATE TABLE " + tableName + " (A UNSIGNED_LONG NOT NULL PRIMARY KEY, B VARCHAR(10))");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES (1, 'A')");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES (2, 'B')");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES (3, 'C')");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES (4, 'D')");
        conn.commit();
        String sql = "SELECT A, B FROM " + tableName + " ORDER BY A DESC";
        PhoenixStatement stmt = conn.createStatement().unwrap(PhoenixStatement.class);
        ResultSet rs = stmt.executeQuery(sql);
        int cnt = 0;
        while (rs.next()) {
            Assert.assertTrue((String)"too many results returned", (++cnt <= 4 ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)4L, (long)cnt);
    }
}

