/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.expression.aggregator.Aggregators;
import org.apache.phoenix.expression.aggregator.ClientAggregators;
import org.apache.phoenix.iterate.GroupedAggregatingResultIterator;
import org.apache.phoenix.iterate.MaterializedResultIterator;
import org.apache.phoenix.iterate.MaterializedResultIterators;
import org.apache.phoenix.iterate.MergeSortRowKeyResultIterator;
import org.apache.phoenix.iterate.PeekingResultIterator;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.iterate.ResultIterators;
import org.apache.phoenix.query.BaseConnectionlessQueryTest;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.tuple.SingleKeyValueTuple;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.util.AssertResults;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Test;

public class AggregateResultScannerTest
extends BaseConnectionlessQueryTest {
    private static final byte[] A = Bytes.toBytes((String)"a");
    private static final byte[] B = Bytes.toBytes((String)"b");

    @Test
    public void testAggregatingMergeSort() throws Throwable {
        Tuple[] results1 = new Tuple[]{new SingleKeyValueTuple((Cell)new KeyValue(A, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, PLong.INSTANCE.toBytes((Object)1L)))};
        Tuple[] results2 = new Tuple[]{new SingleKeyValueTuple((Cell)new KeyValue(B, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, PLong.INSTANCE.toBytes((Object)1L)))};
        Tuple[] results3 = new Tuple[]{new SingleKeyValueTuple((Cell)new KeyValue(A, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, PLong.INSTANCE.toBytes((Object)1L))), new SingleKeyValueTuple((Cell)new KeyValue(B, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, PLong.INSTANCE.toBytes((Object)1L)))};
        Tuple[] results4 = new Tuple[]{new SingleKeyValueTuple((Cell)new KeyValue(A, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, PLong.INSTANCE.toBytes((Object)1L)))};
        ArrayList<PeekingResultIterator> results = new ArrayList<PeekingResultIterator>(Arrays.asList(new MaterializedResultIterator(Arrays.asList(results1)), new MaterializedResultIterator(Arrays.asList(results2)), new MaterializedResultIterator(Arrays.asList(results3)), new MaterializedResultIterator(Arrays.asList(results4))));
        Tuple[] expectedResults = new Tuple[]{new SingleKeyValueTuple((Cell)new KeyValue(A, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, PLong.INSTANCE.toBytes((Object)3L))), new SingleKeyValueTuple((Cell)new KeyValue(B, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, PLong.INSTANCE.toBytes((Object)2L)))};
        MaterializedResultIterators iterators = new MaterializedResultIterators(results);
        ClientAggregators aggregators = TestUtil.getSingleSumAggregator(AggregateResultScannerTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
        GroupedAggregatingResultIterator scanner = new GroupedAggregatingResultIterator((PeekingResultIterator)new MergeSortRowKeyResultIterator((ResultIterators)iterators), (Aggregators)aggregators);
        AssertResults.assertResults((ResultIterator)scanner, expectedResults);
    }
}

