/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.index.automated;

import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.phoenix.mapreduce.index.automation.PhoenixAsyncIndex;
import org.apache.phoenix.mapreduce.index.automation.PhoenixMRJobSubmitter;
import org.apache.phoenix.schema.PTable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MRJobSubmitterTest {
    private Map<String, PhoenixAsyncIndex> candidateJobs = new LinkedHashMap<String, PhoenixAsyncIndex>();
    private Set<String> submittedJobs = new HashSet<String>();

    @Before
    public void prepare() {
        PhoenixAsyncIndex index1 = new PhoenixAsyncIndex();
        index1.setDataTableName("DT1");
        index1.setTableName("IT1");
        index1.setTableSchem("NEW_SCHEM1");
        index1.setIndexType(PTable.IndexType.LOCAL);
        this.candidateJobs.put(String.format("PHOENIX_%s.%s_INDX_%s", index1.getTableSchem(), index1.getDataTableName(), index1.getTableName()), index1);
        PhoenixAsyncIndex index2 = new PhoenixAsyncIndex();
        index2.setDataTableName("DT2");
        index2.setTableName("IT2");
        index2.setTableSchem("NEW_SCHEM2");
        index2.setIndexType(PTable.IndexType.LOCAL);
        this.candidateJobs.put(String.format("PHOENIX_%s.%s_INDX_%s", index2.getTableSchem(), index2.getDataTableName(), index2.getTableName()), index2);
    }

    @Test
    public void testLocalIndexJobsSubmission() throws IOException {
        for (String jobId : this.candidateJobs.keySet()) {
            this.candidateJobs.get(jobId).setIndexType(PTable.IndexType.LOCAL);
        }
        PhoenixMRJobSubmitter submitter = new PhoenixMRJobSubmitter();
        Set jobsToSubmit = submitter.getJobsToSubmit(this.candidateJobs, this.submittedJobs);
        Assert.assertEquals((long)2L, (long)jobsToSubmit.size());
    }

    @Test
    public void testIndexJobsName() throws IOException {
        PhoenixAsyncIndex index = new PhoenixAsyncIndex();
        index.setDataTableName("MyDataTable");
        index.setTableName("MyTableName");
        index.setTableSchem("MySchem");
        index.setIndexType(PTable.IndexType.LOCAL);
        String jobName = String.format("PHOENIX_%s.%s_INDX_%s", index.getTableSchem(), index.getDataTableName(), index.getTableName());
        Assert.assertEquals((Object)"PHOENIX_MySchem.MyDataTable_INDX_MyTableName", (Object)jobName);
    }

    @Test
    public void testGlobalIndexJobsForSubmission() throws IOException {
        for (String jobId : this.candidateJobs.keySet()) {
            this.candidateJobs.get(jobId).setIndexType(PTable.IndexType.GLOBAL);
        }
        PhoenixMRJobSubmitter submitter = new PhoenixMRJobSubmitter();
        Set jobsToSubmit = submitter.getJobsToSubmit(this.candidateJobs, this.submittedJobs);
        Assert.assertEquals((long)2L, (long)jobsToSubmit.size());
        Assert.assertEquals((Object)true, (Object)jobsToSubmit.containsAll(this.candidateJobs.values()));
    }

    @Test
    public void testSkipSubmittedJob() throws IOException {
        PhoenixAsyncIndex[] jobs = new PhoenixAsyncIndex[this.candidateJobs.size()];
        this.candidateJobs.values().toArray(jobs);
        this.submittedJobs.add(String.format("PHOENIX_%s.%s_INDX_%s", jobs[0].getTableSchem(), jobs[0].getDataTableName(), jobs[0].getTableName()));
        PhoenixMRJobSubmitter submitter = new PhoenixMRJobSubmitter();
        Set jobsToSubmit = submitter.getJobsToSubmit(this.candidateJobs, this.submittedJobs);
        Assert.assertEquals((long)1L, (long)jobsToSubmit.size());
        Assert.assertEquals((Object)false, (Object)jobsToSubmit.containsAll(this.candidateJobs.values()));
        Assert.assertEquals((Object)true, (Object)jobsToSubmit.contains(jobs[1]));
    }

    @Test
    public void testSkipAllSubmittedJobs() throws IOException {
        PhoenixAsyncIndex[] jobs = new PhoenixAsyncIndex[this.candidateJobs.size()];
        this.candidateJobs.values().toArray(jobs);
        this.submittedJobs.add(String.format("PHOENIX_%s.%s_INDX_%s", jobs[0].getTableSchem(), jobs[0].getDataTableName(), jobs[0].getTableName()));
        this.submittedJobs.add(String.format("PHOENIX_%s.%s_INDX_%s", jobs[1].getTableSchem(), jobs[1].getDataTableName(), jobs[1].getTableName()));
        PhoenixMRJobSubmitter submitter = new PhoenixMRJobSubmitter();
        Set jobsToSubmit = submitter.getJobsToSubmit(this.candidateJobs, this.submittedJobs);
        Assert.assertEquals((long)0L, (long)jobsToSubmit.size());
    }

    @Test
    public void testNoJobsToSubmit() throws IOException {
        this.candidateJobs.clear();
        this.submittedJobs.add(String.format("PHOENIX_%s.%s_INDX_%s", "s1", "d1", "i1"));
        this.submittedJobs.add(String.format("PHOENIX_%s.%s_INDX_%s", "s2", "d2", "i2"));
        PhoenixMRJobSubmitter submitter = new PhoenixMRJobSubmitter();
        Set jobsToSubmit = submitter.getJobsToSubmit(this.candidateJobs, this.submittedJobs);
        Assert.assertEquals((long)0L, (long)jobsToSubmit.size());
    }
}

