/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.index;

import java.io.IOException;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.coprocessor.IndexRebuildRegionScanner;
import org.apache.phoenix.coprocessor.IndexToolVerificationResult;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.mapreduce.index.IndexTool;
import org.apache.phoenix.mapreduce.index.IndexVerificationResultRepository;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class ShouldVerifyTest {
    @Mock
    IndexRebuildRegionScanner scanner;
    @Mock
    IndexMaintainer im;
    @Mock
    Scan scan;
    @Mock
    Region region;
    @Mock
    IndexVerificationResultRepository resultRepository;
    byte[] indexRowKey;
    @Mock
    IndexToolVerificationResult verificationResult;

    @Before
    public void setup() throws IOException {
        MockitoAnnotations.initMocks((Object)this);
        this.indexRowKey = null;
        Mockito.when((Object)this.im.getIndexTableName()).thenReturn((Object)Bytes.toBytes((String)"indexName"));
        Mockito.when((Object)this.scanner.shouldVerify((IndexTool.IndexVerifyType)ArgumentMatchers.any(IndexTool.IndexVerifyType.class), (byte[])ArgumentMatchers.any(), (Scan)ArgumentMatchers.any(Scan.class), (Region)ArgumentMatchers.any(Region.class), (IndexMaintainer)ArgumentMatchers.any(IndexMaintainer.class), (IndexVerificationResultRepository)ArgumentMatchers.any(IndexVerificationResultRepository.class), ArgumentMatchers.anyBoolean())).thenCallRealMethod();
        Mockito.when((Object)this.scanner.shouldVerify()).thenCallRealMethod();
    }

    @Test
    public void testShouldVerify_repair_true() throws IOException {
        this.indexRowKey = new byte[5];
        Assert.assertTrue((boolean)this.scanner.shouldVerify(IndexTool.IndexVerifyType.ONLY, this.indexRowKey, this.scan, this.region, this.im, this.resultRepository, false));
    }

    @Test
    public void testShouldVerify_repair_rebuild_true() throws IOException {
        this.indexRowKey = new byte[5];
        Mockito.when((Object)this.scan.getAttribute("_IndexRetryVerify")).thenReturn((Object)Bytes.toBytes((long)1L));
        this.assertShouldVerify(true);
    }

    private void assertShouldVerify(boolean assertion) throws IOException {
        Assert.assertEquals((Object)assertion, (Object)this.scanner.shouldVerify(IndexTool.IndexVerifyType.NONE, this.indexRowKey, this.scan, this.region, this.im, this.resultRepository, false));
        Assert.assertEquals((Object)assertion, (Object)this.scanner.shouldVerify(IndexTool.IndexVerifyType.BEFORE, this.indexRowKey, this.scan, this.region, this.im, this.resultRepository, false));
        Assert.assertEquals((Object)assertion, (Object)this.scanner.shouldVerify(IndexTool.IndexVerifyType.AFTER, this.indexRowKey, this.scan, this.region, this.im, this.resultRepository, false));
    }

    @Test
    public void testShouldVerify_false() throws IOException {
        Mockito.when((Object)this.scan.getAttribute("_IndexRetryVerify")).thenReturn((Object)Bytes.toBytes((long)1L));
        Mockito.when((Object)this.resultRepository.getVerificationResult(Long.valueOf(1L), this.scan, this.region, this.im.getIndexTableName())).thenReturn((Object)this.verificationResult);
        this.assertShouldVerify(false);
    }

    @Test
    public void testShouldVerify_rebuild_true() throws IOException {
        Mockito.when((Object)this.scan.getAttribute("_IndexRetryVerify")).thenReturn((Object)Bytes.toBytes((long)1L));
        Mockito.when((Object)this.resultRepository.getVerificationResult(Long.valueOf(1L), this.scan, this.region, this.im.getIndexTableName())).thenReturn(null);
        this.assertShouldVerify(true);
    }

    @Test
    public void testShouldVerify_noTime_true() throws IOException {
        Mockito.when((Object)this.resultRepository.getVerificationResult(Long.valueOf(1L), this.scan, this.region, this.im.getIndexTableName())).thenReturn((Object)this.verificationResult);
        this.assertShouldVerify(true);
    }
}

