/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.index;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilderFactory;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.phoenix.coprocessor.IndexRebuildRegionScanner;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.query.BaseConnectionlessQueryTest;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.thirdparty.com.google.common.primitives.Bytes;
import org.apache.phoenix.util.SchemaUtil;
import org.junit.Assert;
import org.junit.Test;

public class PrepareIndexMutationsForRebuildTest
extends BaseConnectionlessQueryTest {
    private static String ROW_KEY = "k1";
    private static String TABLE_NAME = "dataTable";
    private static String INDEX_NAME = "idx";

    private SetupInfo setup(String tableName, String indexName, String columns, String indexColumns, String pk, String includeColumns) throws Exception {
        try (Connection conn = DriverManager.getConnection(PrepareIndexMutationsForRebuildTest.getUrl());){
            String fullTableName = SchemaUtil.getTableName((String)SchemaUtil.normalizeIdentifier((String)""), (String)SchemaUtil.normalizeIdentifier((String)tableName));
            String fullIndexName = SchemaUtil.getTableName((String)SchemaUtil.normalizeIdentifier((String)""), (String)SchemaUtil.normalizeIdentifier((String)indexName));
            String str1 = String.format("CREATE TABLE %1$s (%2$s CONSTRAINT pk PRIMARY KEY (%3$s)) COLUMN_ENCODED_BYTES=0", fullTableName, columns, pk);
            conn.createStatement().execute(str1);
            Object str2 = String.format("CREATE INDEX %1$s ON %2$s (%3$s)", fullIndexName, fullTableName, indexColumns);
            if (!includeColumns.isEmpty()) {
                str2 = (String)str2 + " INCLUDE (" + includeColumns + ")";
            }
            conn.createStatement().execute((String)str2);
            PhoenixConnection pconn = conn.unwrap(PhoenixConnection.class);
            PTable pIndexTable = pconn.getTable(new PTableKey(pconn.getTenantId(), fullIndexName));
            PTable pDataTable = pconn.getTable(new PTableKey(pconn.getTenantId(), fullTableName));
            IndexMaintainer im = pIndexTable.getIndexMaintainer(pDataTable, pconn);
            SetupInfo info = new SetupInfo();
            info.indexMaintainer = im;
            info.pDataTable = pDataTable;
            SetupInfo setupInfo = info;
            return setupInfo;
        }
    }

    @Test
    public void testSinglePutOnIndexColumn() throws Exception {
        SetupInfo info = this.setup(TABLE_NAME, INDEX_NAME, "ROW_KEY VARCHAR, C1 VARCHAR, C2 VARCHAR", "C1", "ROW_KEY", "");
        Put dataPut = new Put(org.apache.hadoop.hbase.util.Bytes.toBytes((String)ROW_KEY));
        this.addCellToPutMutation(dataPut, info.indexMaintainer.getEmptyKeyValueFamily().copyBytesIfNecessary(), org.apache.hadoop.hbase.util.Bytes.toBytes((String)"C1"), 1L, org.apache.hadoop.hbase.util.Bytes.toBytes((String)"v1"));
        this.addCellToPutMutation(dataPut, info.indexMaintainer.getEmptyKeyValueFamily().copyBytesIfNecessary(), org.apache.hadoop.hbase.util.Bytes.toBytes((String)"C2"), 1L, org.apache.hadoop.hbase.util.Bytes.toBytes((String)"v2"));
        this.addEmptyColumnToDataPutMutation(dataPut, info.pDataTable, 1L);
        List actualIndexMutations = IndexRebuildRegionScanner.prepareIndexMutationsForRebuild((IndexMaintainer)info.indexMaintainer, (Put)dataPut, null, null, null, (boolean)true);
        Put idxPut1 = new Put(this.generateIndexRowKey("v1"));
        this.addEmptyColumnToIndexPutMutation(idxPut1, info.indexMaintainer, 1L);
        this.assertEqualMutationList(Arrays.asList(idxPut1), actualIndexMutations);
    }

    @Test
    public void testSinglePutOnNonIndexColumn() throws Exception {
        SetupInfo info = this.setup(TABLE_NAME, INDEX_NAME, "ROW_KEY VARCHAR, C1 VARCHAR, C2 VARCHAR", "C1", "ROW_KEY", "");
        Put dataPut = new Put(org.apache.hadoop.hbase.util.Bytes.toBytes((String)ROW_KEY));
        this.addCellToPutMutation(dataPut, info.indexMaintainer.getEmptyKeyValueFamily().copyBytesIfNecessary(), org.apache.hadoop.hbase.util.Bytes.toBytes((String)"C2"), 1L, org.apache.hadoop.hbase.util.Bytes.toBytes((String)"v2"));
        this.addEmptyColumnToDataPutMutation(dataPut, info.pDataTable, 1L);
        List actualIndexMutations = IndexRebuildRegionScanner.prepareIndexMutationsForRebuild((IndexMaintainer)info.indexMaintainer, (Put)dataPut, null, null, null, (boolean)true);
        Put idxPut1 = new Put(this.generateIndexRowKey(null));
        this.addEmptyColumnToIndexPutMutation(idxPut1, info.indexMaintainer, 1L);
        this.assertEqualMutationList(Arrays.asList(idxPut1), actualIndexMutations);
    }

    @Test
    public void testDelOnIndexColumn() throws Exception {
        SetupInfo info = this.setup(TABLE_NAME, INDEX_NAME, "ROW_KEY VARCHAR, C1 VARCHAR, C2 VARCHAR", "C1", "ROW_KEY", "");
        Put dataPut = new Put(org.apache.hadoop.hbase.util.Bytes.toBytes((String)ROW_KEY));
        this.addCellToPutMutation(dataPut, info.indexMaintainer.getEmptyKeyValueFamily().copyBytesIfNecessary(), org.apache.hadoop.hbase.util.Bytes.toBytes((String)"C1"), 1L, org.apache.hadoop.hbase.util.Bytes.toBytes((String)"v1"));
        this.addCellToPutMutation(dataPut, info.indexMaintainer.getEmptyKeyValueFamily().copyBytesIfNecessary(), org.apache.hadoop.hbase.util.Bytes.toBytes((String)"C2"), 1L, org.apache.hadoop.hbase.util.Bytes.toBytes((String)"v2"));
        this.addEmptyColumnToDataPutMutation(dataPut, info.pDataTable, 1L);
        Delete dataDel = new Delete(org.apache.hadoop.hbase.util.Bytes.toBytes((String)ROW_KEY));
        this.addCellToDelMutation(dataDel, info.indexMaintainer.getEmptyKeyValueFamily().copyBytesIfNecessary(), org.apache.hadoop.hbase.util.Bytes.toBytes((String)"C1"), 2L, Cell.Type.DeleteColumn);
        List actualIndexMutations = IndexRebuildRegionScanner.prepareIndexMutationsForRebuild((IndexMaintainer)info.indexMaintainer, (Put)dataPut, (Delete)dataDel, null, null, (boolean)true);
        ArrayList<Mutation> expectedIndexMutation = new ArrayList<Mutation>();
        byte[] idxKeyBytes = this.generateIndexRowKey("v1");
        Put idxPut1 = new Put(idxKeyBytes);
        this.addEmptyColumnToIndexPutMutation(idxPut1, info.indexMaintainer, 1L);
        expectedIndexMutation.add((Mutation)idxPut1);
        Put idxPut2 = new Put(this.generateIndexRowKey(null));
        this.addEmptyColumnToIndexPutMutation(idxPut2, info.indexMaintainer, 2L);
        expectedIndexMutation.add((Mutation)idxPut2);
        Delete idxDel = new Delete(idxKeyBytes);
        this.addCellToDelMutation(idxDel, QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, null, 2L, Cell.Type.DeleteFamily);
        expectedIndexMutation.add((Mutation)idxDel);
        this.assertEqualMutationList(expectedIndexMutation, actualIndexMutations);
    }

    @Test
    public void testDelOnNonIndexColumn() throws Exception {
        SetupInfo info = this.setup(TABLE_NAME, INDEX_NAME, "ROW_KEY VARCHAR, C1 VARCHAR, C2 VARCHAR", "C1", "ROW_KEY", "");
        Put dataPut = new Put(org.apache.hadoop.hbase.util.Bytes.toBytes((String)ROW_KEY));
        this.addCellToPutMutation(dataPut, info.indexMaintainer.getEmptyKeyValueFamily().copyBytesIfNecessary(), org.apache.hadoop.hbase.util.Bytes.toBytes((String)"C1"), 1L, org.apache.hadoop.hbase.util.Bytes.toBytes((String)"v1"));
        this.addCellToPutMutation(dataPut, info.indexMaintainer.getEmptyKeyValueFamily().copyBytesIfNecessary(), org.apache.hadoop.hbase.util.Bytes.toBytes((String)"C2"), 1L, org.apache.hadoop.hbase.util.Bytes.toBytes((String)"v2"));
        this.addEmptyColumnToDataPutMutation(dataPut, info.pDataTable, 1L);
        Delete dataDel = new Delete(org.apache.hadoop.hbase.util.Bytes.toBytes((String)ROW_KEY));
        this.addCellToDelMutation(dataDel, info.indexMaintainer.getEmptyKeyValueFamily().copyBytesIfNecessary(), org.apache.hadoop.hbase.util.Bytes.toBytes((String)"C2"), 2L, Cell.Type.DeleteColumn);
        List actualIndexMutations = IndexRebuildRegionScanner.prepareIndexMutationsForRebuild((IndexMaintainer)info.indexMaintainer, (Put)dataPut, (Delete)dataDel, null, null, (boolean)true);
        ArrayList<Mutation> expectedIndexMutations = new ArrayList<Mutation>();
        byte[] idxKeyBytes = this.generateIndexRowKey("v1");
        Put idxPut1 = new Put(idxKeyBytes);
        this.addEmptyColumnToIndexPutMutation(idxPut1, info.indexMaintainer, 1L);
        expectedIndexMutations.add((Mutation)idxPut1);
        Put idxPut2 = new Put(idxKeyBytes);
        this.addEmptyColumnToIndexPutMutation(idxPut2, info.indexMaintainer, 2L);
        expectedIndexMutations.add((Mutation)idxPut2);
        this.assertEqualMutationList(expectedIndexMutations, actualIndexMutations);
    }

    @Test
    public void testDeleteAllVersions() throws Exception {
        SetupInfo info = this.setup(TABLE_NAME, INDEX_NAME, "ROW_KEY VARCHAR, C1 VARCHAR", "C1", "ROW_KEY", "");
        Put dataPut = new Put(org.apache.hadoop.hbase.util.Bytes.toBytes((String)ROW_KEY));
        this.addCellToPutMutation(dataPut, info.indexMaintainer.getEmptyKeyValueFamily().copyBytesIfNecessary(), org.apache.hadoop.hbase.util.Bytes.toBytes((String)"C1"), 1L, org.apache.hadoop.hbase.util.Bytes.toBytes((String)"v1"));
        this.addEmptyColumnToDataPutMutation(dataPut, info.pDataTable, 1L);
        this.addCellToPutMutation(dataPut, info.indexMaintainer.getEmptyKeyValueFamily().copyBytesIfNecessary(), org.apache.hadoop.hbase.util.Bytes.toBytes((String)"C1"), 2L, org.apache.hadoop.hbase.util.Bytes.toBytes((String)"v2"));
        this.addEmptyColumnToDataPutMutation(dataPut, info.pDataTable, 2L);
        Delete dataDel = new Delete(org.apache.hadoop.hbase.util.Bytes.toBytes((String)ROW_KEY));
        this.addCellToDelMutation(dataDel, info.indexMaintainer.getEmptyKeyValueFamily().copyBytesIfNecessary(), null, 3L, Cell.Type.DeleteFamily);
        List actualIndexMutations = IndexRebuildRegionScanner.prepareIndexMutationsForRebuild((IndexMaintainer)info.indexMaintainer, (Put)dataPut, (Delete)dataDel, null, null, (boolean)true);
        ArrayList<Mutation> expectedIndexMutations = new ArrayList<Mutation>();
        byte[] idxKeyBytes1 = this.generateIndexRowKey("v1");
        byte[] idxKeyBytes2 = this.generateIndexRowKey("v2");
        Put idxPut1 = new Put(idxKeyBytes1);
        this.addEmptyColumnToIndexPutMutation(idxPut1, info.indexMaintainer, 1L);
        expectedIndexMutations.add((Mutation)idxPut1);
        Put idxPut2 = new Put(idxKeyBytes2);
        this.addEmptyColumnToIndexPutMutation(idxPut2, info.indexMaintainer, 2L);
        expectedIndexMutations.add((Mutation)idxPut2);
        Delete idxDel1 = new Delete(idxKeyBytes1);
        this.addCellToDelMutation(idxDel1, info.indexMaintainer.getEmptyKeyValueFamily().copyBytesIfNecessary(), null, 2L, Cell.Type.DeleteFamily);
        expectedIndexMutations.add((Mutation)idxDel1);
        Delete idxDel2 = new Delete(idxKeyBytes2);
        this.addCellToDelMutation(idxDel2, info.indexMaintainer.getEmptyKeyValueFamily().copyBytesIfNecessary(), null, 3L, Cell.Type.DeleteFamily);
        expectedIndexMutations.add((Mutation)idxDel2);
        this.assertEqualMutationList(expectedIndexMutations, actualIndexMutations);
    }

    @Test
    public void testPutDeleteOnSameTimeStamp() throws Exception {
        SetupInfo info = this.setup(TABLE_NAME, INDEX_NAME, "ROW_KEY VARCHAR, C1 VARCHAR", "C1", "ROW_KEY", "");
        Put dataPut = new Put(org.apache.hadoop.hbase.util.Bytes.toBytes((String)ROW_KEY));
        this.addCellToPutMutation(dataPut, info.indexMaintainer.getEmptyKeyValueFamily().copyBytesIfNecessary(), org.apache.hadoop.hbase.util.Bytes.toBytes((String)"C1"), 1L, org.apache.hadoop.hbase.util.Bytes.toBytes((String)"v1"));
        this.addEmptyColumnToDataPutMutation(dataPut, info.pDataTable, 1L);
        Delete dataDel = new Delete(org.apache.hadoop.hbase.util.Bytes.toBytes((String)ROW_KEY));
        this.addCellToDelMutation(dataDel, info.indexMaintainer.getEmptyKeyValueFamily().copyBytesIfNecessary(), org.apache.hadoop.hbase.util.Bytes.toBytes((String)"C1"), 1L, Cell.Type.DeleteColumn);
        List actualIndexMutations = IndexRebuildRegionScanner.prepareIndexMutationsForRebuild((IndexMaintainer)info.indexMaintainer, (Put)dataPut, (Delete)dataDel, null, null, (boolean)true);
        ArrayList<Put> expectedIndexMutations = new ArrayList<Put>();
        Put idxPut1 = new Put(this.generateIndexRowKey(null));
        this.addEmptyColumnToIndexPutMutation(idxPut1, info.indexMaintainer, 1L);
        expectedIndexMutations.add(idxPut1);
        this.assertEqualMutationList(Arrays.asList(idxPut1), actualIndexMutations);
    }

    @Test
    public void testPutDeleteOnSameTimeStampAndPutNullifiedByDelete() throws Exception {
        SetupInfo info = this.setup(TABLE_NAME, INDEX_NAME, "ROW_KEY VARCHAR, CF1.C1 VARCHAR, CF2.C2 VARCHAR", "CF2.C2", "ROW_KEY", "");
        Put dataPut = new Put(org.apache.hadoop.hbase.util.Bytes.toBytes((String)ROW_KEY));
        this.addCellToPutMutation(dataPut, org.apache.hadoop.hbase.util.Bytes.toBytes((String)"CF2"), org.apache.hadoop.hbase.util.Bytes.toBytes((String)"C2"), 1L, org.apache.hadoop.hbase.util.Bytes.toBytes((String)"v2"));
        this.addEmptyColumnToDataPutMutation(dataPut, info.pDataTable, 1L);
        this.addCellToPutMutation(dataPut, org.apache.hadoop.hbase.util.Bytes.toBytes((String)"CF1"), org.apache.hadoop.hbase.util.Bytes.toBytes((String)"C1"), 2L, org.apache.hadoop.hbase.util.Bytes.toBytes((String)"v1"));
        this.addEmptyColumnToDataPutMutation(dataPut, info.pDataTable, 2L);
        Delete dataDel = new Delete(org.apache.hadoop.hbase.util.Bytes.toBytes((String)ROW_KEY));
        this.addCellToDelMutation(dataDel, org.apache.hadoop.hbase.util.Bytes.toBytes((String)"CF1"), null, 2L, Cell.Type.DeleteFamily);
        List actualIndexMutations = IndexRebuildRegionScanner.prepareIndexMutationsForRebuild((IndexMaintainer)info.indexMaintainer, (Put)dataPut, (Delete)dataDel, null, null, (boolean)true);
        ArrayList<Mutation> expectedIndexMutations = new ArrayList<Mutation>();
        byte[] idxKeyBytes = this.generateIndexRowKey("v2");
        Put idxPut1 = new Put(idxKeyBytes);
        this.addEmptyColumnToIndexPutMutation(idxPut1, info.indexMaintainer, 1L);
        expectedIndexMutations.add((Mutation)idxPut1);
        Put idxPut2 = new Put(idxKeyBytes);
        this.addEmptyColumnToIndexPutMutation(idxPut2, info.indexMaintainer, 2L);
        expectedIndexMutations.add((Mutation)idxPut2);
        this.assertEqualMutationList(expectedIndexMutations, actualIndexMutations);
    }

    @Test
    public void testPutDeleteOnSameTimeStampAndPutAndOldPutAllNullifiedByDelete() throws Exception {
        SetupInfo info = this.setup(TABLE_NAME, INDEX_NAME, "ROW_KEY VARCHAR, CF1.C1 VARCHAR, CF2.C2 VARCHAR", "CF2.C2", "ROW_KEY", "");
        Put dataPut = new Put(org.apache.hadoop.hbase.util.Bytes.toBytes((String)ROW_KEY));
        this.addCellToPutMutation(dataPut, org.apache.hadoop.hbase.util.Bytes.toBytes((String)"CF2"), org.apache.hadoop.hbase.util.Bytes.toBytes((String)"C2"), 1L, org.apache.hadoop.hbase.util.Bytes.toBytes((String)"v2"));
        this.addEmptyColumnToDataPutMutation(dataPut, info.pDataTable, 1L);
        this.addCellToPutMutation(dataPut, org.apache.hadoop.hbase.util.Bytes.toBytes((String)"CF2"), org.apache.hadoop.hbase.util.Bytes.toBytes((String)"C2"), 2L, org.apache.hadoop.hbase.util.Bytes.toBytes((String)"v2"));
        this.addEmptyColumnToDataPutMutation(dataPut, info.pDataTable, 2L);
        Delete dataDel = new Delete(org.apache.hadoop.hbase.util.Bytes.toBytes((String)ROW_KEY));
        this.addCellToDelMutation(dataDel, org.apache.hadoop.hbase.util.Bytes.toBytes((String)"CF2"), null, 2L, Cell.Type.DeleteFamily);
        this.addCellToDelMutation(dataDel, SchemaUtil.getEmptyColumnFamily((PTable)info.pDataTable), null, 2L, Cell.Type.DeleteFamily);
        List actualIndexMutations = IndexRebuildRegionScanner.prepareIndexMutationsForRebuild((IndexMaintainer)info.indexMaintainer, (Put)dataPut, (Delete)dataDel, null, null, (boolean)true);
        ArrayList<Mutation> expectedIndexMutations = new ArrayList<Mutation>();
        byte[] idxKeyBytes = this.generateIndexRowKey("v2");
        Put idxPut1 = new Put(idxKeyBytes);
        this.addEmptyColumnToIndexPutMutation(idxPut1, info.indexMaintainer, 1L);
        expectedIndexMutations.add((Mutation)idxPut1);
        Delete idxDel2 = new Delete(idxKeyBytes);
        this.addCellToDelMutation(idxDel2, info.indexMaintainer.getEmptyKeyValueFamily().copyBytesIfNecessary(), null, 2L, Cell.Type.DeleteFamily);
        expectedIndexMutations.add((Mutation)idxDel2);
        this.assertEqualMutationList(expectedIndexMutations, actualIndexMutations);
    }

    @Test
    public void testCoveredIndexColumns() throws Exception {
        SetupInfo info = this.setup(TABLE_NAME, INDEX_NAME, "ROW_KEY VARCHAR, C1 VARCHAR, C2 VARCHAR", "C1", "ROW_KEY", "C2");
        Put dataPut = new Put(org.apache.hadoop.hbase.util.Bytes.toBytes((String)ROW_KEY));
        this.addCellToPutMutation(dataPut, info.indexMaintainer.getEmptyKeyValueFamily().copyBytesIfNecessary(), org.apache.hadoop.hbase.util.Bytes.toBytes((String)"C1"), 1L, org.apache.hadoop.hbase.util.Bytes.toBytes((String)"v1"));
        this.addCellToPutMutation(dataPut, info.indexMaintainer.getEmptyKeyValueFamily().copyBytesIfNecessary(), org.apache.hadoop.hbase.util.Bytes.toBytes((String)"C2"), 1L, org.apache.hadoop.hbase.util.Bytes.toBytes((String)"v2"));
        this.addEmptyColumnToDataPutMutation(dataPut, info.pDataTable, 1L);
        Delete dataDel = new Delete(org.apache.hadoop.hbase.util.Bytes.toBytes((String)ROW_KEY));
        this.addCellToDelMutation(dataDel, info.indexMaintainer.getEmptyKeyValueFamily().copyBytesIfNecessary(), org.apache.hadoop.hbase.util.Bytes.toBytes((String)"C1"), 2L, Cell.Type.DeleteColumn);
        List actualIndexMutations = IndexRebuildRegionScanner.prepareIndexMutationsForRebuild((IndexMaintainer)info.indexMaintainer, (Put)dataPut, (Delete)dataDel, null, null, (boolean)true);
        ArrayList<Mutation> expectedIndexMutations = new ArrayList<Mutation>();
        byte[] idxKeyBytes = this.generateIndexRowKey("v1");
        Put idxPut1 = new Put(idxKeyBytes);
        this.addCellToPutMutation(idxPut1, QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, org.apache.hadoop.hbase.util.Bytes.toBytes((String)"0:C2"), 1L, org.apache.hadoop.hbase.util.Bytes.toBytes((String)"v2"));
        this.addEmptyColumnToIndexPutMutation(idxPut1, info.indexMaintainer, 1L);
        expectedIndexMutations.add((Mutation)idxPut1);
        ArrayList<Byte> idxKey2 = new ArrayList<Byte>();
        idxKey2.add((byte)0);
        idxKey2.addAll(Bytes.asList((byte[])org.apache.hadoop.hbase.util.Bytes.toBytes((String)ROW_KEY)));
        byte[] idxKeyBytes2 = Bytes.toArray(idxKey2);
        Put idxPut2 = new Put(idxKeyBytes2);
        this.addCellToPutMutation(idxPut2, QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, org.apache.hadoop.hbase.util.Bytes.toBytes((String)"0:C2"), 2L, org.apache.hadoop.hbase.util.Bytes.toBytes((String)"v2"));
        this.addEmptyColumnToIndexPutMutation(idxPut2, info.indexMaintainer, 2L);
        expectedIndexMutations.add((Mutation)idxPut2);
        Delete idxDel = new Delete(idxKeyBytes);
        this.addCellToDelMutation(idxDel, QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, null, 2L, Cell.Type.DeleteFamily);
        expectedIndexMutations.add((Mutation)idxDel);
        this.assertEqualMutationList(expectedIndexMutations, actualIndexMutations);
    }

    @Test
    public void testForMultipleFamilies() throws Exception {
        SetupInfo info = this.setup(TABLE_NAME, INDEX_NAME, "ROW_KEY VARCHAR, CF1.C1 VARCHAR, CF2.C2 VARCHAR", "CF1.C1", "ROW_KEY", "CF2.C2");
        Put dataPut = new Put(org.apache.hadoop.hbase.util.Bytes.toBytes((String)ROW_KEY));
        this.addCellToPutMutation(dataPut, org.apache.hadoop.hbase.util.Bytes.toBytes((String)"CF1"), org.apache.hadoop.hbase.util.Bytes.toBytes((String)"C1"), 1L, org.apache.hadoop.hbase.util.Bytes.toBytes((String)"v1"));
        this.addCellToPutMutation(dataPut, org.apache.hadoop.hbase.util.Bytes.toBytes((String)"CF2"), org.apache.hadoop.hbase.util.Bytes.toBytes((String)"C2"), 1L, org.apache.hadoop.hbase.util.Bytes.toBytes((String)"v2"));
        this.addEmptyColumnToDataPutMutation(dataPut, info.pDataTable, 1L);
        Delete dataDel = new Delete(org.apache.hadoop.hbase.util.Bytes.toBytes((String)ROW_KEY));
        this.addCellToDelMutation(dataDel, org.apache.hadoop.hbase.util.Bytes.toBytes((String)"CF1"), org.apache.hadoop.hbase.util.Bytes.toBytes((String)"C1"), 2L, Cell.Type.DeleteColumn);
        List actualIndexMutations = IndexRebuildRegionScanner.prepareIndexMutationsForRebuild((IndexMaintainer)info.indexMaintainer, (Put)dataPut, (Delete)dataDel, null, null, (boolean)true);
        ArrayList<Mutation> expectedIndexMutation = new ArrayList<Mutation>();
        byte[] idxKeyBytes = this.generateIndexRowKey("v1");
        Put idxPut1 = new Put(idxKeyBytes);
        this.addCellToPutMutation(idxPut1, org.apache.hadoop.hbase.util.Bytes.toBytes((String)"CF2"), org.apache.hadoop.hbase.util.Bytes.toBytes((String)"CF2:C2"), 1L, org.apache.hadoop.hbase.util.Bytes.toBytes((String)"v2"));
        this.addEmptyColumnToIndexPutMutation(idxPut1, info.indexMaintainer, 1L);
        expectedIndexMutation.add((Mutation)idxPut1);
        Put idxPut2 = new Put(this.generateIndexRowKey(null));
        this.addCellToPutMutation(idxPut2, org.apache.hadoop.hbase.util.Bytes.toBytes((String)"CF2"), org.apache.hadoop.hbase.util.Bytes.toBytes((String)"CF2:C2"), 2L, org.apache.hadoop.hbase.util.Bytes.toBytes((String)"v2"));
        this.addEmptyColumnToIndexPutMutation(idxPut2, info.indexMaintainer, 2L);
        expectedIndexMutation.add((Mutation)idxPut2);
        Delete idxDel = new Delete(idxKeyBytes);
        this.addCellToDelMutation(idxDel, org.apache.hadoop.hbase.util.Bytes.toBytes((String)"CF2"), null, 2L, Cell.Type.DeleteFamily);
        expectedIndexMutation.add((Mutation)idxDel);
        this.assertEqualMutationList(expectedIndexMutation, actualIndexMutations);
    }

    @Test
    public void testSameTypeOfMutationWithSameValueButDifferentTimeStamp() throws Exception {
        SetupInfo info = this.setup(TABLE_NAME, INDEX_NAME, "ROW_KEY VARCHAR, C1 VARCHAR, C2 VARCHAR", "C1", "ROW_KEY", "");
        Put dataPut = new Put(org.apache.hadoop.hbase.util.Bytes.toBytes((String)ROW_KEY));
        this.addCellToPutMutation(dataPut, info.indexMaintainer.getEmptyKeyValueFamily().copyBytesIfNecessary(), org.apache.hadoop.hbase.util.Bytes.toBytes((String)"C2"), 1L, org.apache.hadoop.hbase.util.Bytes.toBytes((String)"v2"));
        this.addEmptyColumnToDataPutMutation(dataPut, info.pDataTable, 1L);
        this.addCellToPutMutation(dataPut, info.indexMaintainer.getEmptyKeyValueFamily().copyBytesIfNecessary(), org.apache.hadoop.hbase.util.Bytes.toBytes((String)"C2"), 1L, org.apache.hadoop.hbase.util.Bytes.toBytes((String)"v3"));
        this.addEmptyColumnToDataPutMutation(dataPut, info.pDataTable, 2L);
        List actualIndexMutations = IndexRebuildRegionScanner.prepareIndexMutationsForRebuild((IndexMaintainer)info.indexMaintainer, (Put)dataPut, null, null, null, (boolean)true);
        byte[] idxKeyBytes = this.generateIndexRowKey(null);
        Put idxPut1 = new Put(idxKeyBytes);
        this.addEmptyColumnToIndexPutMutation(idxPut1, info.indexMaintainer, 1L);
        Put idxPut2 = new Put(idxKeyBytes);
        this.addEmptyColumnToIndexPutMutation(idxPut2, info.indexMaintainer, 2L);
        this.assertEqualMutationList(Arrays.asList(idxPut1, idxPut2), actualIndexMutations);
    }

    byte[] generateIndexRowKey(String indexVal) {
        ArrayList<Byte> idxKey = new ArrayList<Byte>();
        if (indexVal != null && !indexVal.isEmpty()) {
            idxKey.addAll(Bytes.asList((byte[])org.apache.hadoop.hbase.util.Bytes.toBytes((String)indexVal)));
        }
        idxKey.add((byte)0);
        idxKey.addAll(Bytes.asList((byte[])org.apache.hadoop.hbase.util.Bytes.toBytes((String)ROW_KEY)));
        return Bytes.toArray(idxKey);
    }

    void addCellToPutMutation(Put put, byte[] family, byte[] column, long ts, byte[] value) throws Exception {
        byte[] rowKey = put.getRow();
        Cell cell = CellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(rowKey).setFamily(family).setQualifier(column).setTimestamp(ts).setType(Cell.Type.Put).setValue(value).build();
        put.add(cell);
    }

    void addCellToDelMutation(Delete del, byte[] family, byte[] column, long ts, Cell.Type type) throws Exception {
        byte[] rowKey = del.getRow();
        Cell cell = CellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(rowKey).setFamily(family).setQualifier(column).setTimestamp(ts).setType(type).setValue(null).build();
        del.add(cell);
    }

    void addEmptyColumnToDataPutMutation(Put put, PTable ptable, long ts) throws Exception {
        this.addCellToPutMutation(put, SchemaUtil.getEmptyColumnFamily((PTable)ptable), QueryConstants.EMPTY_COLUMN_BYTES, ts, QueryConstants.EMPTY_COLUMN_VALUE_BYTES);
    }

    void addEmptyColumnToIndexPutMutation(Put put, IndexMaintainer im, long ts) throws Exception {
        this.addCellToPutMutation(put, im.getEmptyKeyValueFamily().copyBytesIfNecessary(), QueryConstants.EMPTY_COLUMN_BYTES, ts, QueryConstants.VERIFIED_BYTES);
    }

    void assertEqualMutationList(List<Mutation> expectedMutations, List<Mutation> actualMutations) {
        Assert.assertEquals((long)expectedMutations.size(), (long)actualMutations.size());
        for (Mutation expected : expectedMutations) {
            boolean found = false;
            for (Mutation actual : actualMutations) {
                if (!this.isEqualMutation(expected, actual)) continue;
                actualMutations.remove(actual);
                found = true;
                break;
            }
            if (found) continue;
            Assert.fail((String)String.format("Cannot find mutation:%s", expected));
        }
    }

    boolean isEqualMutation(Mutation expectedMutation, Mutation actualMutation) {
        ArrayList expectedCells = new ArrayList();
        for (List cells : expectedMutation.getFamilyCellMap().values()) {
            expectedCells.addAll(cells);
        }
        ArrayList actualCells = new ArrayList();
        for (List cells : actualMutation.getFamilyCellMap().values()) {
            actualCells.addAll(cells);
        }
        if (expectedCells.size() != actualCells.size()) {
            return false;
        }
        for (Cell expected : expectedCells) {
            boolean found = false;
            for (Cell actual : actualCells) {
                if (!this.isEqualCell(expected, actual)) continue;
                actualCells.remove(actual);
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    boolean isEqualCell(Cell a, Cell b) {
        return CellUtil.matchingRows((Cell)a, (Cell)b) && CellUtil.matchingFamily((Cell)a, (Cell)b) && CellUtil.matchingQualifier((Cell)a, (Cell)b) && CellUtil.matchingTimestamp((Cell)a, (Cell)b) && a.getType() == b.getType() && CellUtil.matchingValue((Cell)a, (Cell)b);
    }

    class SetupInfo {
        public IndexMaintainer indexMaintainer;
        public PTable pDataTable;

        SetupInfo() {
        }
    }
}

