/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.index;

import java.sql.Connection;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.phoenix.mapreduce.index.IndexTool;
import org.apache.phoenix.mapreduce.index.IndexUpgradeTool;
import org.apache.phoenix.mapreduce.util.PhoenixConfigurationUtil;
import org.apache.phoenix.query.BaseConnectionlessQueryTest;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.CommandLine;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class IndexUpgradeToolTest
extends BaseConnectionlessQueryTest {
    private static final String INPUT_LIST = "TEST.MOCK1,TEST1.MOCK2,TEST.MOCK3";
    private final boolean upgrade;
    private static final String DUMMY_STRING_VALUE = "anyValue";
    private static final String DUMMY_VERIFY_VALUE = "someVerifyValue";
    private static final String ONLY_VERIFY_VALUE = "ONLY";
    private IndexUpgradeTool indexUpgradeTool = null;
    private String outputFile;

    public IndexUpgradeToolTest(boolean upgrade) {
        this.upgrade = upgrade;
        this.outputFile = "/tmp/index_upgrade_" + UUID.randomUUID().toString();
    }

    private void setup(String[] args) {
        this.indexUpgradeTool = new IndexUpgradeTool();
        CommandLine cmd = this.indexUpgradeTool.parseOptions(args);
        this.indexUpgradeTool.initializeTool(cmd);
    }

    @Test
    public void testCommandLineParsing() {
        String[] args = new String[]{"-o", this.upgrade ? "upgrade" : "rollback", "-tb", INPUT_LIST, "-lf", this.outputFile, "-d"};
        this.setup(args);
        Assert.assertEquals((Object)this.indexUpgradeTool.getDryRun(), (Object)true);
        Assert.assertEquals((Object)this.indexUpgradeTool.getInputTables(), (Object)INPUT_LIST);
        Assert.assertEquals((Object)this.indexUpgradeTool.getOperation(), (Object)(this.upgrade ? "upgrade" : "rollback"));
        Assert.assertEquals((Object)this.indexUpgradeTool.getLogFile(), (Object)this.outputFile);
        Assert.assertEquals((Object)false, (Object)this.indexUpgradeTool.getIsRebuild());
        Assert.assertNull((Object)this.indexUpgradeTool.getIndexToolOpts());
    }

    @Test
    public void testRebuildOptionParsing() {
        String[] args = new String[]{"-o", this.upgrade ? "upgrade" : "rollback", "-tb", INPUT_LIST, "-rb"};
        this.setup(args);
        Assert.assertEquals((Object)true, (Object)this.indexUpgradeTool.getIsRebuild());
        Assert.assertNull((Object)this.indexUpgradeTool.getIndexToolOpts());
    }

    @Test(expected=IllegalStateException.class)
    public void testIndexToolOptionsNoRebuild() {
        String indexToolOpts = "-v someVerifyValue";
        String[] args = new String[]{"-o", this.upgrade ? "upgrade" : "rollback", "-tb", INPUT_LIST, "-tool", indexToolOpts};
        this.setup(args);
    }

    @Test
    public void testIfOptionsArePassedToIndexTool() throws Exception {
        if (!this.upgrade) {
            return;
        }
        CharSequence[] indexToolOpts = new String[]{"-v", ONLY_VERIFY_VALUE, "-runfg", "-st", "100"};
        String indexToolarg = String.join((CharSequence)" ", indexToolOpts);
        String[] args = new String[]{"-o", this.upgrade ? "upgrade" : "rollback", "-tb", INPUT_LIST, "-lf", this.outputFile, "-d", "-rb", "-tool", indexToolarg};
        this.setup(args);
        Assert.assertEquals((String)"value passed to index tool option does not match with provided value", (Object)indexToolarg, (Object)this.indexUpgradeTool.getIndexToolOpts());
        String[] values = this.indexUpgradeTool.getIndexToolArgValues(DUMMY_STRING_VALUE, DUMMY_STRING_VALUE, DUMMY_STRING_VALUE, DUMMY_STRING_VALUE, DUMMY_STRING_VALUE);
        List<String> argList = Arrays.asList(values);
        Assert.assertTrue((boolean)argList.contains("-v"));
        Assert.assertTrue((boolean)argList.contains(ONLY_VERIFY_VALUE));
        Assert.assertEquals((String)"verify option and value are not passed consecutively", (long)1L, (long)(argList.indexOf(ONLY_VERIFY_VALUE) - argList.indexOf("-v")));
        Assert.assertTrue((boolean)argList.contains("-runfg"));
        Assert.assertTrue((boolean)argList.contains("-st"));
        IndexTool it = new IndexTool();
        CommandLine commandLine = it.parseOptions(values);
        it.populateIndexToolAttributes(commandLine);
    }

    @Test
    public void testMalformedSpacingOptionsArePassedToIndexTool() throws Exception {
        if (!this.upgrade) {
            return;
        }
        CharSequence[] indexToolOpts = new String[]{"-vONLY", "     -runfg", " -st  ", "100  "};
        String indexToolarg = String.join((CharSequence)" ", indexToolOpts);
        String[] args = new String[]{"-o", this.upgrade ? "upgrade" : "rollback", "-tb", INPUT_LIST, "-rb", "-tool", indexToolarg};
        this.setup(args);
        Assert.assertEquals((String)"value passed to index tool option does not match with provided value", (Object)indexToolarg, (Object)this.indexUpgradeTool.getIndexToolOpts());
        String[] values = this.indexUpgradeTool.getIndexToolArgValues(DUMMY_STRING_VALUE, DUMMY_STRING_VALUE, DUMMY_STRING_VALUE, DUMMY_STRING_VALUE, DUMMY_STRING_VALUE);
        List<String> argList = Arrays.asList(values);
        Assert.assertTrue((boolean)argList.contains("-vONLY"));
        Assert.assertTrue((boolean)argList.contains("-runfg"));
        Assert.assertTrue((boolean)argList.contains("-st"));
        IndexTool it = new IndexTool();
        CommandLine commandLine = it.parseOptions(values);
        it.populateIndexToolAttributes(commandLine);
    }

    @Test(expected=IllegalStateException.class)
    public void testBadIndexToolOptions() throws Exception {
        CharSequence[] indexToolOpts = new String[]{"-vsomeVerifyValue"};
        String indexToolarg = String.join((CharSequence)" ", indexToolOpts);
        String[] args = new String[]{"-o", "upgrade", "-tb", INPUT_LIST, "-rb", "-tool", indexToolarg};
        this.setup(args);
        String[] values = this.indexUpgradeTool.getIndexToolArgValues(DUMMY_STRING_VALUE, DUMMY_STRING_VALUE, DUMMY_STRING_VALUE, DUMMY_STRING_VALUE, DUMMY_STRING_VALUE);
        IndexTool it = new IndexTool();
        CommandLine commandLine = it.parseOptions(values);
        it.populateIndexToolAttributes(commandLine);
    }

    @Parameterized.Parameters(name="IndexUpgradeToolTest_mutable={1}")
    public static synchronized Collection<Boolean> data() {
        return Arrays.asList(false, true);
    }

    private void setupConfForConnectionlessQuery(Configuration conf) {
        String connectionlessUrl = "jdbc:phoenix+zk:none;test=true;";
        PhoenixConfigurationUtil.setInputClusterUrl((Configuration)conf, (String)connectionlessUrl);
        PhoenixConfigurationUtil.setOutputClusterUrl((Configuration)conf, (String)connectionlessUrl);
        conf.unset("hbase.zookeeper.property.clientPort");
        conf.unset("zookeeper.znode.parent");
    }

    @Test
    public void testConnectionProperties() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        long indexRebuildQueryTimeoutMs = 2000L;
        long indexRebuildRpcTimeoutMs = 3000L;
        long indexRebuildClientScannerTimeoutMs = 4000L;
        int indexRebuildRpcRetryCount = 10;
        conf.setLong("phoenix.index.rebuild.query.timeout", indexRebuildQueryTimeoutMs);
        conf.setLong("phoenix.index.rebuild.rpc.timeout", indexRebuildRpcTimeoutMs);
        conf.setLong("phoenix.index.rebuild.client.scanner.timeout", indexRebuildClientScannerTimeoutMs);
        conf.setInt("phoenix.index.rebuild.rpc.retries.counter", indexRebuildRpcRetryCount);
        this.setupConfForConnectionlessQuery(conf);
        try (Connection conn = IndexUpgradeTool.getConnection((Configuration)conf);){
            Assert.assertEquals((Object)conn.getClientInfo("phoenix.query.timeoutMs"), (Object)Long.toString(indexRebuildQueryTimeoutMs));
            Assert.assertEquals((Object)conn.getClientInfo("hbase.rpc.timeout"), (Object)Long.toString(indexRebuildRpcTimeoutMs));
            Assert.assertEquals((Object)conn.getClientInfo("hbase.client.scanner.timeout.period"), (Object)Long.toString(indexRebuildClientScannerTimeoutMs));
            Assert.assertEquals((Object)conn.getClientInfo("hbase.client.retries.number"), (Object)Long.toString(indexRebuildRpcRetryCount));
        }
    }

    @Test
    public void testConnectionDefaults() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        long indexRebuildQueryTimeoutMs = conf.getLong("phoenix.index.rebuild.query.timeout", 9002100L);
        long indexRebuildRpcTimeoutMs = conf.getLong("phoenix.index.rebuild.rpc.timeout", 1800000L);
        long indexRebuildClientScannerTimeoutMs = conf.getLong("phoenix.index.rebuild.client.scanner.timeout", 1800000L);
        long indexRebuildRpcRetryCount = conf.getInt("phoenix.index.rebuild.rpc.retries.counter", 5);
        this.setupConfForConnectionlessQuery(conf);
        try (Connection conn = IndexUpgradeTool.getConnection((Configuration)conf);){
            Assert.assertEquals((Object)conn.getClientInfo("phoenix.query.timeoutMs"), (Object)Long.toString(indexRebuildQueryTimeoutMs));
            Assert.assertEquals((Object)conn.getClientInfo("hbase.rpc.timeout"), (Object)Long.toString(indexRebuildRpcTimeoutMs));
            Assert.assertEquals((Object)conn.getClientInfo("hbase.client.scanner.timeout.period"), (Object)Long.toString(indexRebuildClientScannerTimeoutMs));
            Assert.assertEquals((Object)conn.getClientInfo("hbase.client.retries.number"), (Object)Long.toString(indexRebuildRpcRetryCount));
        }
    }
}

