/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.index;

import org.apache.phoenix.end2end.IndexToolIT;
import org.apache.phoenix.mapreduce.index.IndexScrutinyTool;
import org.apache.phoenix.mapreduce.index.IndexTool;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.CommandLine;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class IndexToolTest
extends BaseTest {
    IndexTool it;
    private String dataTable;
    private String indexTable;
    private String schema;
    private String tenantId;
    @Mock
    PTable pDataTable;
    boolean localIndex = true;
    @Rule
    public ExpectedException exceptionRule = ExpectedException.none();

    @Before
    public void setup() {
        this.it = new IndexTool();
        this.schema = IndexToolTest.generateUniqueName();
        this.dataTable = IndexToolTest.generateUniqueName();
        this.indexTable = IndexToolTest.generateUniqueName();
        this.tenantId = IndexToolTest.generateUniqueName();
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void testParseOptions_timeRange_timeRangeNotNull() throws Exception {
        Long startTime = 10L;
        Long endTime = 15L;
        String[] args = IndexToolIT.getArgValues(true, this.schema, this.dataTable, this.indexTable, this.tenantId, IndexTool.IndexVerifyType.NONE, startTime, endTime);
        CommandLine cmdLine = this.it.parseOptions(args);
        this.it.populateIndexToolAttributes(cmdLine);
        Assert.assertEquals((Object)startTime, (Object)this.it.getStartTime());
        Assert.assertEquals((Object)endTime, (Object)this.it.getEndTime());
    }

    @Test
    public void testParseOptions_timeRange_null() throws Exception {
        String[] args = IndexToolIT.getArgValues(true, this.schema, this.dataTable, this.indexTable, this.tenantId, IndexTool.IndexVerifyType.NONE);
        CommandLine cmdLine = this.it.parseOptions(args);
        this.it.populateIndexToolAttributes(cmdLine);
        Assert.assertNull((Object)this.it.getStartTime());
        Assert.assertNull((Object)this.it.getEndTime());
    }

    @Test
    public void testParseOptions_timeRange_startTimeNotNull() throws Exception {
        Long startTime = 10L;
        String[] args = IndexToolIT.getArgValues(true, this.schema, this.dataTable, this.indexTable, this.tenantId, IndexTool.IndexVerifyType.NONE, startTime, null);
        CommandLine cmdLine = this.it.parseOptions(args);
        this.it.populateIndexToolAttributes(cmdLine);
        Assert.assertEquals((Object)startTime, (Object)this.it.getStartTime());
        Assert.assertEquals(null, (Object)this.it.getEndTime());
    }

    @Test
    public void testParseOptions_timeRange_endTimeNotNull() throws Exception {
        Long endTime = 15L;
        String[] args = IndexToolIT.getArgValues(true, this.schema, this.dataTable, this.indexTable, this.tenantId, IndexTool.IndexVerifyType.NONE, null, endTime);
        CommandLine cmdLine = this.it.parseOptions(args);
        this.it.populateIndexToolAttributes(cmdLine);
        Assert.assertEquals(null, (Object)this.it.getStartTime());
        Assert.assertEquals((Object)endTime, (Object)this.it.getEndTime());
    }

    @Test
    public void testParseOptions_timeRange_startTimeNullEndTimeInFuture() throws Exception {
        Long endTime = EnvironmentEdgeManager.currentTimeMillis() + 100000L;
        String[] args = IndexToolIT.getArgValues(true, this.schema, this.dataTable, this.indexTable, this.tenantId, IndexTool.IndexVerifyType.NONE, null, endTime);
        CommandLine cmdLine = this.it.parseOptions(args);
        this.exceptionRule.expect(RuntimeException.class);
        this.exceptionRule.expectMessage("startTime is greater than or equal to endTime or either of them are set in the future; IndexTool can't proceed.");
        this.it.populateIndexToolAttributes(cmdLine);
    }

    @Test
    public void testParseOptions_timeRange_endTimeNullStartTimeInFuture() throws Exception {
        Long startTime = EnvironmentEdgeManager.currentTimeMillis() + 100000L;
        String[] args = IndexToolIT.getArgValues(true, this.schema, this.dataTable, this.indexTable, this.tenantId, IndexTool.IndexVerifyType.NONE, startTime, null);
        CommandLine cmdLine = this.it.parseOptions(args);
        this.exceptionRule.expect(RuntimeException.class);
        this.exceptionRule.expectMessage("startTime is greater than or equal to endTime or either of them are set in the future; IndexTool can't proceed.");
        this.it.populateIndexToolAttributes(cmdLine);
    }

    @Test(timeout=10000L)
    public void testParseOptions_timeRange_startTimeInFuture() throws Exception {
        Long startTime = EnvironmentEdgeManager.currentTimeMillis() + 100000L;
        Long endTime = EnvironmentEdgeManager.currentTimeMillis() + 200000L;
        String[] args = IndexToolIT.getArgValues(true, this.schema, this.dataTable, this.indexTable, this.tenantId, IndexTool.IndexVerifyType.NONE, startTime, endTime);
        CommandLine cmdLine = this.it.parseOptions(args);
        this.exceptionRule.expect(RuntimeException.class);
        this.exceptionRule.expectMessage("startTime is greater than or equal to endTime or either of them are set in the future; IndexTool can't proceed.");
        this.it.populateIndexToolAttributes(cmdLine);
    }

    @Test(timeout=10000L)
    public void testParseOptions_timeRange_endTimeInFuture() throws Exception {
        Long startTime = EnvironmentEdgeManager.currentTimeMillis();
        Long endTime = EnvironmentEdgeManager.currentTimeMillis() + 100000L;
        String[] args = IndexToolIT.getArgValues(true, this.schema, this.dataTable, this.indexTable, this.tenantId, IndexTool.IndexVerifyType.NONE, startTime, endTime);
        CommandLine cmdLine = this.it.parseOptions(args);
        this.exceptionRule.expect(RuntimeException.class);
        this.exceptionRule.expectMessage("startTime is greater than or equal to endTime or either of them are set in the future; IndexTool can't proceed.");
        this.it.populateIndexToolAttributes(cmdLine);
    }

    @Test
    public void testParseOptions_timeRange_startTimeEqEndTime() throws Exception {
        Long startTime = 10L;
        Long endTime = 10L;
        String[] args = IndexToolIT.getArgValues(true, this.schema, this.dataTable, this.indexTable, this.tenantId, IndexTool.IndexVerifyType.NONE, startTime, endTime);
        CommandLine cmdLine = this.it.parseOptions(args);
        this.exceptionRule.expect(RuntimeException.class);
        this.exceptionRule.expectMessage("startTime is greater than or equal to endTime or either of them are set in the future; IndexTool can't proceed.");
        this.it.populateIndexToolAttributes(cmdLine);
    }

    @Test
    public void testParseOptions_timeRange_startTimeGtEndTime() throws Exception {
        Long startTime = 10L;
        Long endTime = 1L;
        String[] args = IndexToolIT.getArgValues(true, this.schema, this.dataTable, this.indexTable, this.tenantId, IndexTool.IndexVerifyType.NONE, startTime, endTime);
        CommandLine cmdLine = this.it.parseOptions(args);
        this.exceptionRule.expect(RuntimeException.class);
        this.exceptionRule.expectMessage("startTime is greater than or equal to endTime or either of them are set in the future; IndexTool can't proceed.");
        this.it.populateIndexToolAttributes(cmdLine);
    }

    @Test
    public void testCheckTimeRangeFeature_timeRangeSet_transactionalTable_globalIndex() {
        Mockito.when((Object)this.pDataTable.isTransactional()).thenReturn((Object)true);
        this.exceptionRule.expect(RuntimeException.class);
        this.exceptionRule.expectMessage("start-time/end-time and retry verify feature are only applicable for local or non-transactional global indexes");
        IndexTool.checkIfFeatureApplicable((Long)1L, (Long)3L, null, (PTable)this.pDataTable, (!this.localIndex ? 1 : 0) != 0);
    }

    @Test
    public void testIncrcementalVerifyOption() throws Exception {
        IndexTool mockTool = (IndexTool)Mockito.mock(IndexTool.class);
        Mockito.when((Object)mockTool.getLastVerifyTime()).thenCallRealMethod();
        Long lastVerifyTime = 10L;
        String[] args = IndexToolIT.getArgValues(true, this.schema, this.dataTable, this.indexTable, this.tenantId, IndexTool.IndexVerifyType.NONE, lastVerifyTime, null, IndexTool.IndexDisableLoggingType.NONE, lastVerifyTime);
        Mockito.when((Object)mockTool.parseOptions(args)).thenCallRealMethod();
        CommandLine cmdLine = mockTool.parseOptions(args);
        Mockito.when((Object)mockTool.populateIndexToolAttributes(cmdLine)).thenCallRealMethod();
        Mockito.when((Object)mockTool.isValidLastVerifyTime(lastVerifyTime)).thenReturn((Object)true);
        mockTool.populateIndexToolAttributes(cmdLine);
        Assert.assertEquals((Object)lastVerifyTime, (Object)mockTool.getLastVerifyTime());
        Mockito.when((Object)this.pDataTable.isTransactional()).thenReturn((Object)true);
        this.exceptionRule.expect(RuntimeException.class);
        this.exceptionRule.expectMessage("start-time/end-time and retry verify feature are only applicable for local or non-transactional global indexes");
        IndexTool.checkIfFeatureApplicable(null, null, (Long)lastVerifyTime, (PTable)this.pDataTable, (!this.localIndex ? 1 : 0) != 0);
    }

    @Test
    public void testIncrcementalVerifyOption_notApplicable() throws Exception {
        IndexTool mockTool = (IndexTool)Mockito.mock(IndexTool.class);
        Mockito.when((Object)mockTool.getLastVerifyTime()).thenCallRealMethod();
        Long lastVerifyTime = 10L;
        String[] args = IndexToolIT.getArgValues(true, this.schema, this.dataTable, this.indexTable, this.tenantId, IndexTool.IndexVerifyType.AFTER, lastVerifyTime, null, IndexTool.IndexDisableLoggingType.NONE, lastVerifyTime);
        Mockito.when((Object)mockTool.parseOptions(args)).thenCallRealMethod();
        CommandLine cmdLine = mockTool.parseOptions(args);
        Mockito.when((Object)mockTool.populateIndexToolAttributes(cmdLine)).thenCallRealMethod();
        Mockito.when((Object)mockTool.validateLastVerifyTime()).thenCallRealMethod();
        Mockito.when((Object)mockTool.isValidLastVerifyTime(lastVerifyTime)).thenReturn((Object)false);
        this.exceptionRule.expect(RuntimeException.class);
        this.exceptionRule.expectMessage("retry verify feature accepts non-zero ts set in the past and ts must be present in PHOENIX_INDEX_TOOL_RESULT table");
        mockTool.populateIndexToolAttributes(cmdLine);
    }

    @Test
    public void testCheckVerifyAndDisableLogging_defaultsNone() throws Exception {
        Long startTime = null;
        Long endTime = 10L;
        String[] args = IndexToolIT.getArgValues(true, this.schema, this.dataTable, this.indexTable, this.tenantId, IndexTool.IndexVerifyType.NONE, startTime, endTime);
        CommandLine cmdLine = this.it.parseOptions(args);
        this.it.populateIndexToolAttributes(cmdLine);
        Assert.assertEquals((Object)IndexTool.IndexDisableLoggingType.NONE, (Object)this.it.getDisableLoggingType());
    }

    @Test
    public void testDisableLogging_allowsNone() throws Exception {
        this.verifyDisableLogging(IndexTool.IndexDisableLoggingType.NONE, IndexTool.IndexVerifyType.NONE);
        this.verifyDisableLogging(IndexTool.IndexDisableLoggingType.NONE, IndexTool.IndexVerifyType.ONLY);
        this.verifyDisableLogging(IndexTool.IndexDisableLoggingType.NONE, IndexTool.IndexVerifyType.BEFORE);
        this.verifyDisableLogging(IndexTool.IndexDisableLoggingType.NONE, IndexTool.IndexVerifyType.AFTER);
        this.verifyDisableLogging(IndexTool.IndexDisableLoggingType.NONE, IndexTool.IndexVerifyType.BOTH);
    }

    @Test
    public void testDisableLogging_allowsBefore() throws Exception {
        this.verifyDisableLogging(IndexTool.IndexDisableLoggingType.BEFORE, IndexTool.IndexVerifyType.BEFORE);
        this.verifyDisableLogging(IndexTool.IndexDisableLoggingType.BEFORE, IndexTool.IndexVerifyType.ONLY);
        this.verifyDisableLogging(IndexTool.IndexDisableLoggingType.BEFORE, IndexTool.IndexVerifyType.BOTH);
        this.verifyDisableLoggingException(IndexTool.IndexDisableLoggingType.BEFORE, IndexTool.IndexVerifyType.AFTER);
        this.verifyDisableLoggingException(IndexTool.IndexDisableLoggingType.BEFORE, IndexTool.IndexVerifyType.NONE);
    }

    @Test
    public void testDisableLogging_allowsAfter() throws Exception {
        this.verifyDisableLogging(IndexTool.IndexDisableLoggingType.AFTER, IndexTool.IndexVerifyType.BOTH);
        this.verifyDisableLogging(IndexTool.IndexDisableLoggingType.AFTER, IndexTool.IndexVerifyType.AFTER);
        this.verifyDisableLoggingException(IndexTool.IndexDisableLoggingType.AFTER, IndexTool.IndexVerifyType.NONE);
        this.verifyDisableLoggingException(IndexTool.IndexDisableLoggingType.AFTER, IndexTool.IndexVerifyType.BEFORE);
        this.verifyDisableLoggingException(IndexTool.IndexDisableLoggingType.BOTH, IndexTool.IndexVerifyType.ONLY);
    }

    @Test
    public void testCheckVerifyAndDisableLogging_allowsBoth() throws Exception {
        this.verifyDisableLogging(IndexTool.IndexDisableLoggingType.BOTH, IndexTool.IndexVerifyType.BOTH);
        this.verifyDisableLoggingException(IndexTool.IndexDisableLoggingType.BOTH, IndexTool.IndexVerifyType.NONE);
        this.verifyDisableLoggingException(IndexTool.IndexDisableLoggingType.BOTH, IndexTool.IndexVerifyType.ONLY);
        this.verifyDisableLoggingException(IndexTool.IndexDisableLoggingType.BOTH, IndexTool.IndexVerifyType.BEFORE);
        this.verifyDisableLoggingException(IndexTool.IndexDisableLoggingType.BOTH, IndexTool.IndexVerifyType.AFTER);
    }

    public void verifyDisableLogging(IndexTool.IndexDisableLoggingType disableType, IndexTool.IndexVerifyType verifyType) throws Exception {
        Long startTime = null;
        Long endTime = 10L;
        String[] args = IndexToolIT.getArgValues(true, this.schema, this.dataTable, this.indexTable, this.tenantId, verifyType, startTime, endTime, disableType, null);
        CommandLine cmdLine = this.it.parseOptions(args);
        this.it.populateIndexToolAttributes(cmdLine);
        Assert.assertEquals((Object)disableType, (Object)this.it.getDisableLoggingType());
    }

    public void verifyDisableLoggingException(IndexTool.IndexDisableLoggingType disableType, IndexTool.IndexVerifyType verifyType) {
        Long startTime = null;
        Long endTime = 10L;
        String[] args = IndexToolIT.getArgValues(true, this.schema, this.dataTable, this.indexTable, this.tenantId, verifyType, startTime, endTime, disableType, null);
        this.exceptionRule.expect(IllegalStateException.class);
        CommandLine cmdLine = this.it.parseOptions(args);
    }

    @Test
    public void testIndexToolDefaultSource() throws Exception {
        Long startTime = 1L;
        Long endTime = 10L;
        String[] args = IndexToolIT.getArgValues(true, this.schema, this.dataTable, this.indexTable, this.tenantId, IndexTool.IndexVerifyType.NONE, startTime, endTime);
        CommandLine cmdLine = this.it.parseOptions(args);
        this.it.populateIndexToolAttributes(cmdLine);
        Assert.assertEquals((Object)IndexScrutinyTool.SourceTable.DATA_TABLE_SOURCE, (Object)this.it.getSourceTable());
    }

    @Test
    public void testIndexToolFromIndexSource() throws Exception {
        this.verifyFromIndexOption(IndexTool.IndexVerifyType.ONLY);
        this.verifyFromIndexOption(IndexTool.IndexVerifyType.BEFORE);
    }

    private void verifyFromIndexOption(IndexTool.IndexVerifyType verifyType) throws Exception {
        Long startTime = 1L;
        Long endTime = 10L;
        String[] args = IndexToolIT.getArgValues(true, true, this.schema, this.dataTable, this.indexTable, this.tenantId, verifyType, startTime, endTime, IndexTool.IndexDisableLoggingType.BEFORE, null, true);
        CommandLine cmdLine = this.it.parseOptions(args);
        this.it.populateIndexToolAttributes(cmdLine);
        Assert.assertEquals((Object)IndexScrutinyTool.SourceTable.INDEX_TABLE_SOURCE, (Object)this.it.getSourceTable());
    }
}

