/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.index;

import java.util.Arrays;
import java.util.Collection;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.mapreduce.index.IndexScrutinyMapper;
import org.apache.phoenix.query.BaseConnectionlessQueryTest;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class IndexScrutinyMapperTest
extends BaseConnectionlessQueryTest {
    String schema;
    String tableName;
    String indexName;
    boolean isNamespaceEnabled;
    PTable inputTable;

    @Before
    public void setup() {
        this.schema = "S_" + IndexScrutinyMapperTest.generateUniqueName();
        this.tableName = "T_" + IndexScrutinyMapperTest.generateUniqueName();
        this.indexName = "I_" + IndexScrutinyMapperTest.generateUniqueName();
        this.inputTable = (PTable)Mockito.mock(PTable.class);
    }

    @Parameterized.Parameters(name="IndexUpgradeToolTest_isNamespaceEnabled={0}")
    public static synchronized Collection<Boolean> data() {
        return Arrays.asList(false, true);
    }

    public IndexScrutinyMapperTest(boolean isNamespaceEnabled) {
        this.isNamespaceEnabled = isNamespaceEnabled;
    }

    @Test
    public void testGetSourceTableName_table() {
        String fullTableName = SchemaUtil.getQualifiedTableName((String)this.schema, (String)this.tableName);
        PName sourcePhysicalName = SchemaUtil.getPhysicalHBaseTableName((String)this.schema, (String)this.tableName, (boolean)this.isNamespaceEnabled);
        String expectedName = SchemaUtil.getPhysicalTableName((byte[])Bytes.toBytes((String)fullTableName), (boolean)this.isNamespaceEnabled).toString();
        Mockito.when((Object)this.inputTable.getType()).thenReturn((Object)PTableType.TABLE);
        Mockito.when((Object)this.inputTable.getPhysicalName()).thenReturn((Object)sourcePhysicalName);
        Mockito.when((Object)this.inputTable.getTableName()).thenReturn((Object)PNameFactory.newName((String)this.tableName));
        Mockito.when((Object)this.inputTable.getSchemaName()).thenReturn((Object)PNameFactory.newName((String)this.schema));
        String output = IndexScrutinyMapper.getSourceTableName((PTable)this.inputTable, (boolean)this.isNamespaceEnabled);
        Assert.assertEquals((Object)expectedName, (Object)output);
    }

    @Test
    public void testGetSourceTableName_view() {
        String fullTableName = SchemaUtil.getQualifiedTableName((String)this.schema, (String)this.tableName);
        PName sourcePhysicalName = SchemaUtil.getPhysicalHBaseTableName((String)this.schema, (String)this.tableName, (boolean)this.isNamespaceEnabled);
        String expectedName = SchemaUtil.getPhysicalTableName((byte[])Bytes.toBytes((String)fullTableName), (boolean)this.isNamespaceEnabled).toString();
        Mockito.when((Object)this.inputTable.getType()).thenReturn((Object)PTableType.VIEW);
        Mockito.when((Object)this.inputTable.getPhysicalName()).thenReturn((Object)sourcePhysicalName);
        String output = IndexScrutinyMapper.getSourceTableName((PTable)this.inputTable, (boolean)this.isNamespaceEnabled);
        Assert.assertEquals((Object)expectedName, (Object)output);
    }

    @Test
    public void testGetSourceTableName_index() {
        String fullTableName = SchemaUtil.getQualifiedTableName((String)this.schema, (String)this.indexName);
        PName sourcePhysicalName = SchemaUtil.getPhysicalHBaseTableName((String)this.schema, (String)this.indexName, (boolean)this.isNamespaceEnabled);
        String expectedName = SchemaUtil.getPhysicalTableName((byte[])Bytes.toBytes((String)fullTableName), (boolean)this.isNamespaceEnabled).toString();
        Mockito.when((Object)this.inputTable.getType()).thenReturn((Object)PTableType.INDEX);
        Mockito.when((Object)this.inputTable.getPhysicalName()).thenReturn((Object)sourcePhysicalName);
        Mockito.when((Object)this.inputTable.getTableName()).thenReturn((Object)PNameFactory.newName((String)this.indexName));
        Mockito.when((Object)this.inputTable.getSchemaName()).thenReturn((Object)PNameFactory.newName((String)this.schema));
        String output = IndexScrutinyMapper.getSourceTableName((PTable)this.inputTable, (boolean)this.isNamespaceEnabled);
        Assert.assertEquals((Object)expectedName, (Object)output);
    }

    @Test
    public void testGetSourceTableName_viewIndex() {
        PName physicalTableName = SchemaUtil.getPhysicalHBaseTableName((String)this.schema, (String)this.tableName, (boolean)this.isNamespaceEnabled);
        String expectedName = MetaDataUtil.getViewIndexPhysicalName((String)physicalTableName.getString());
        PName physicalIndexTableName = PNameFactory.newName((String)MetaDataUtil.getViewIndexPhysicalName((String)physicalTableName.getString()));
        PTable pSourceTable = (PTable)Mockito.mock(PTable.class);
        Mockito.when((Object)pSourceTable.getPhysicalName()).thenReturn((Object)physicalIndexTableName);
        String output = IndexScrutinyMapper.getSourceTableName((PTable)pSourceTable, (boolean)this.isNamespaceEnabled);
        Assert.assertEquals((Object)expectedName, (Object)output);
    }
}

