/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.write;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.VersionInfo;
import org.apache.phoenix.hbase.index.IndexTableName;
import org.apache.phoenix.hbase.index.table.HTableFactory;
import org.apache.phoenix.hbase.index.table.HTableInterfaceReference;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.hbase.index.write.FakeTableFactory;
import org.apache.phoenix.hbase.index.write.TrackingParallelWriterIndexCommitter;
import org.apache.phoenix.thirdparty.com.google.common.collect.ArrayListMultimap;
import org.apache.phoenix.thirdparty.com.google.common.collect.Multimap;
import org.apache.phoenix.util.ScanUtil;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestParalleWriterIndexCommitter {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestParalleWriterIndexCommitter.class);
    @Rule
    public IndexTableName test = new IndexTableName();
    private final byte[] row = Bytes.toBytes((String)"row");

    @Test
    public void testCorrectlyCleansUpResources() throws Exception {
        ExecutorService exec = Executors.newFixedThreadPool(1);
        FakeTableFactory factory = new FakeTableFactory(Collections.emptyMap());
        TrackingParallelWriterIndexCommitter writer = new TrackingParallelWriterIndexCommitter(VersionInfo.getVersion());
        Stoppable mockStop = (Stoppable)Mockito.mock(Stoppable.class);
        RegionCoprocessorEnvironment e = (RegionCoprocessorEnvironment)Mockito.mock(RegionCoprocessorEnvironment.class);
        Configuration conf = new Configuration();
        Mockito.when((Object)e.getConfiguration()).thenReturn((Object)conf);
        Mockito.when((Object)e.getSharedData()).thenReturn(new ConcurrentHashMap());
        writer.setup((HTableFactory)factory, exec, mockStop, e);
        writer.stop(this.test.getTableNameString() + " finished");
        Assert.assertTrue((String)"Factory didn't get shutdown after writer#stop!", (boolean)factory.shutdown);
        Assert.assertTrue((String)"ExectorService isn't terminated after writer#stop!", (boolean)exec.isShutdown());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockStop});
    }

    @Test
    public void testSynchronouslyCompletesAllWrites() throws Exception {
        LOGGER.info("Starting " + this.test.getTableNameString());
        LOGGER.info("Current thread is interrupted: " + Thread.interrupted());
        RegionCoprocessorEnvironment e = (RegionCoprocessorEnvironment)Mockito.mock(RegionCoprocessorEnvironment.class);
        Configuration conf = new Configuration();
        Mockito.when((Object)e.getConfiguration()).thenReturn((Object)conf);
        Mockito.when((Object)e.getSharedData()).thenReturn(new ConcurrentHashMap());
        Region mockRegion = (Region)Mockito.mock(Region.class);
        Mockito.when((Object)e.getRegion()).thenReturn((Object)mockRegion);
        TableDescriptor mockTableDesc = (TableDescriptor)Mockito.mock(TableDescriptor.class);
        Mockito.when((Object)mockTableDesc.getTableName()).thenReturn((Object)TableName.valueOf((String)"test"));
        Connection mockConnection = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)e.getConnection()).thenReturn((Object)mockConnection);
        Mockito.when((Object)mockRegion.getTableDescriptor()).thenReturn((Object)mockTableDesc);
        Stoppable stop = (Stoppable)Mockito.mock(Stoppable.class);
        ExecutorService exec = Executors.newFixedThreadPool(1);
        LinkedHashMap<ImmutableBytesPtr, Table> tables = new LinkedHashMap<ImmutableBytesPtr, Table>();
        FakeTableFactory factory = new FakeTableFactory(tables);
        ImmutableBytesPtr tableName = new ImmutableBytesPtr(this.test.getTableName());
        Put m = new Put(this.row);
        m.addColumn(Bytes.toBytes((String)"family"), Bytes.toBytes((String)"qual"), null);
        ArrayListMultimap indexUpdates = ArrayListMultimap.create();
        indexUpdates.put((Object)new HTableInterfaceReference(tableName), (Object)m);
        Table table = (Table)Mockito.mock(Table.class);
        final boolean[] completed = new boolean[]{false};
        ((Table)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                completed[0] = true;
                return null;
            }
        }).when((Object)table)).batch(Mockito.anyList(), (Object[])Mockito.any());
        Mockito.when((Object)table.getName()).thenReturn((Object)TableName.valueOf((byte[])this.test.getTableName()));
        tables.put(tableName, table);
        TrackingParallelWriterIndexCommitter writer = new TrackingParallelWriterIndexCommitter(VersionInfo.getVersion());
        writer.setup((HTableFactory)factory, exec, stop, e);
        writer.write((Multimap)indexUpdates, true, ScanUtil.UNKNOWN_CLIENT_VERSION);
        Assert.assertTrue((String)"Writer returned before the table batch completed! Likely a race condition tripped", (boolean)completed[0]);
        writer.stop(this.test.getTableNameString() + " finished");
        Assert.assertTrue((String)"Factory didn't get shutdown after writer#stop!", (boolean)factory.shutdown);
        Assert.assertTrue((String)"ExectorService isn't terminated after writer#stop!", (boolean)exec.isShutdown());
    }
}

