/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.write;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.VersionInfo;
import org.apache.phoenix.hbase.index.IndexTableName;
import org.apache.phoenix.hbase.index.StubAbortable;
import org.apache.phoenix.hbase.index.exception.IndexWriteException;
import org.apache.phoenix.hbase.index.table.HTableFactory;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.hbase.index.write.FakeTableFactory;
import org.apache.phoenix.hbase.index.write.IndexCommitter;
import org.apache.phoenix.hbase.index.write.IndexFailurePolicy;
import org.apache.phoenix.hbase.index.write.IndexWriter;
import org.apache.phoenix.hbase.index.write.KillServerOnFailurePolicy;
import org.apache.phoenix.hbase.index.write.TrackingParallelWriterIndexCommitter;
import org.apache.phoenix.util.ScanUtil;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestIndexWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestIndexWriter.class);
    @Rule
    public IndexTableName testName = new IndexTableName();
    private final byte[] row = Bytes.toBytes((String)"row");

    @Test
    public void getDefaultWriter() throws Exception {
        Configuration conf = new Configuration(false);
        RegionCoprocessorEnvironment env = (RegionCoprocessorEnvironment)Mockito.mock(RegionCoprocessorEnvironment.class);
        Mockito.when((Object)env.getConfiguration()).thenReturn((Object)conf);
        Assert.assertNotNull((Object)IndexWriter.getCommitter((RegionCoprocessorEnvironment)env));
    }

    @Test
    public void getDefaultFailurePolicy() throws Exception {
        Configuration conf = new Configuration(false);
        RegionCoprocessorEnvironment env = (RegionCoprocessorEnvironment)Mockito.mock(RegionCoprocessorEnvironment.class);
        Region region = (Region)Mockito.mock(Region.class);
        Mockito.when((Object)env.getRegion()).thenReturn((Object)region);
        Mockito.when((Object)env.getConfiguration()).thenReturn((Object)conf);
        Mockito.when((Object)region.getTableDescriptor()).thenReturn((Object)TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)"dummy")).build());
        Assert.assertNotNull((Object)IndexWriter.getFailurePolicy((RegionCoprocessorEnvironment)env));
    }

    @Test
    public void testSynchronouslyCompletesAllWrites() throws Exception {
        LOGGER.info("Starting " + this.testName.getTableNameString());
        LOGGER.info("Current thread is interrupted: " + Thread.interrupted());
        StubAbortable abort = new StubAbortable();
        Stoppable stop = (Stoppable)Mockito.mock(Stoppable.class);
        RegionCoprocessorEnvironment e = (RegionCoprocessorEnvironment)Mockito.mock(RegionCoprocessorEnvironment.class);
        Configuration conf = new Configuration();
        Mockito.when((Object)e.getConfiguration()).thenReturn((Object)conf);
        Mockito.when((Object)e.getSharedData()).thenReturn(new ConcurrentHashMap());
        Region mockRegion = (Region)Mockito.mock(Region.class);
        Mockito.when((Object)e.getRegion()).thenReturn((Object)mockRegion);
        TableDescriptor mockTableDesc = (TableDescriptor)Mockito.mock(TableDescriptor.class);
        Mockito.when((Object)mockRegion.getTableDescriptor()).thenReturn((Object)mockTableDesc);
        TableName mockTN = TableName.valueOf((String)"test");
        Mockito.when((Object)mockTableDesc.getTableName()).thenReturn((Object)mockTN);
        Connection mockConnection = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)e.getConnection()).thenReturn((Object)mockConnection);
        ExecutorService exec = Executors.newFixedThreadPool(1);
        HashMap<ImmutableBytesPtr, Table> tables = new HashMap<ImmutableBytesPtr, Table>();
        FakeTableFactory factory = new FakeTableFactory(tables);
        byte[] tableName = this.testName.getTableName();
        Put m = new Put(this.row);
        m.addColumn(Bytes.toBytes((String)"family"), Bytes.toBytes((String)"qual"), null);
        List<Pair> indexUpdates = Arrays.asList(new Pair((Object)m, (Object)tableName));
        Table table = (Table)Mockito.mock(Table.class);
        final boolean[] completed = new boolean[]{false};
        ((Table)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                completed[0] = true;
                return null;
            }
        }).when((Object)table)).batch(Mockito.anyList(), (Object[])Mockito.any());
        Mockito.when((Object)table.getName()).thenReturn((Object)TableName.valueOf((byte[])this.testName.getTableName()));
        tables.put(new ImmutableBytesPtr(tableName), table);
        TrackingParallelWriterIndexCommitter committer = new TrackingParallelWriterIndexCommitter(VersionInfo.getVersion());
        committer.setup((HTableFactory)factory, exec, stop, e);
        KillServerOnFailurePolicy policy = new KillServerOnFailurePolicy();
        policy.setup(stop, e);
        IndexWriter writer = new IndexWriter((IndexCommitter)committer, (IndexFailurePolicy)policy);
        writer.write(indexUpdates, ScanUtil.UNKNOWN_CLIENT_VERSION);
        Assert.assertTrue((String)"Writer returned before the table batch completed! Likely a race condition tripped", (boolean)completed[0]);
        writer.stop(this.testName.getTableNameString() + " finished");
        Assert.assertTrue((String)"Factory didn't get shutdown after writer#stop!", (boolean)factory.shutdown);
        Assert.assertTrue((String)"ExectorService isn't terminated after writer#stop!", (boolean)exec.isShutdown());
    }

    @Test
    public void testShutdownInterruptsAsExpected() throws Exception {
        Stoppable stop = (Stoppable)Mockito.mock(Stoppable.class);
        StubAbortable abort = new StubAbortable();
        ExecutorService exec = Executors.newFixedThreadPool(1);
        HashMap<ImmutableBytesPtr, Table> tables = new HashMap<ImmutableBytesPtr, Table>();
        RegionCoprocessorEnvironment e = (RegionCoprocessorEnvironment)Mockito.mock(RegionCoprocessorEnvironment.class);
        Configuration conf = new Configuration();
        Mockito.when((Object)e.getConfiguration()).thenReturn((Object)conf);
        Mockito.when((Object)e.getSharedData()).thenReturn(new ConcurrentHashMap());
        Region mockRegion = (Region)Mockito.mock(Region.class);
        Mockito.when((Object)e.getRegion()).thenReturn((Object)mockRegion);
        TableDescriptor mockTableDesc = (TableDescriptor)Mockito.mock(TableDescriptor.class);
        Mockito.when((Object)mockRegion.getTableDescriptor()).thenReturn((Object)mockTableDesc);
        Mockito.when((Object)mockTableDesc.getTableName()).thenReturn((Object)TableName.valueOf((String)"test"));
        Connection mockConnection = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)e.getConnection()).thenReturn((Object)mockConnection);
        FakeTableFactory factory = new FakeTableFactory(tables);
        byte[] tableName = this.testName.getTableName();
        Table table = (Table)Mockito.mock(Table.class);
        Mockito.when((Object)table.getName()).thenReturn((Object)TableName.valueOf((byte[])tableName));
        final CountDownLatch writeStartedLatch = new CountDownLatch(1);
        final CountDownLatch waitOnAbortedLatch = new CountDownLatch(1);
        ((Table)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                LOGGER.info("Write started");
                writeStartedLatch.countDown();
                try {
                    waitOnAbortedLatch.await();
                }
                catch (InterruptedException e) {
                    LOGGER.info("Correctly interrupted while writing!");
                    throw e;
                }
                return null;
            }
        }).when((Object)table)).batch(Mockito.anyList(), (Object[])Mockito.any());
        tables.put(new ImmutableBytesPtr(tableName), table);
        Put m = new Put(this.row);
        m.addColumn(Bytes.toBytes((String)"family"), Bytes.toBytes((String)"qual"), null);
        final ArrayList<Pair> indexUpdates = new ArrayList<Pair>();
        indexUpdates.add(new Pair((Object)m, (Object)tableName));
        TrackingParallelWriterIndexCommitter committer = new TrackingParallelWriterIndexCommitter(VersionInfo.getVersion());
        committer.setup((HTableFactory)factory, exec, stop, e);
        KillServerOnFailurePolicy policy = new KillServerOnFailurePolicy();
        policy.setup(stop, e);
        final IndexWriter writer = new IndexWriter((IndexCommitter)committer, (IndexFailurePolicy)policy);
        final boolean[] failedWrite = new boolean[]{false};
        Thread primaryWriter = new Thread(){

            @Override
            public void run() {
                try {
                    writer.write((Collection)indexUpdates, ScanUtil.UNKNOWN_CLIENT_VERSION);
                }
                catch (IndexWriteException e) {
                    failedWrite[0] = true;
                }
                catch (IOException e) {
                    failedWrite[0] = true;
                }
            }
        };
        primaryWriter.start();
        writeStartedLatch.await();
        writer.stop("Shutting down writer for test " + this.testName.getTableNameString());
        primaryWriter.join();
        Assert.assertTrue((String)"Writer should have failed because of the stop we issued", (boolean)failedWrite[0]);
    }
}

