/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.util;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.KeepDeletedCells;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.regionserver.wal.IndexedHLogReader;
import org.apache.hadoop.hbase.regionserver.wal.IndexedWALEditCodec;
import org.apache.phoenix.hbase.index.covered.CoveredColumnIndexCodec;
import org.apache.phoenix.hbase.index.util.IndexManagementUtil;
import org.junit.Test;

public class TestIndexManagementUtil {
    @Test
    public void testUncompressedWal() throws Exception {
        Configuration conf = new Configuration(false);
        conf.set("hbase.regionserver.wal.codec", IndexedWALEditCodec.class.getName());
        IndexManagementUtil.ensureMutableIndexingCorrectlyConfigured((Configuration)conf);
        conf = new Configuration(false);
        conf.set("hbase.regionserver.hlog.reader.impl", IndexedHLogReader.class.getName());
        IndexManagementUtil.ensureMutableIndexingCorrectlyConfigured((Configuration)conf);
    }

    @Test
    public void testCompressedWALWithCodec() throws Exception {
        Configuration conf = new Configuration(false);
        conf.setBoolean("hbase.regionserver.wal.enablecompression", true);
        conf.set("hbase.regionserver.wal.codec", IndexedWALEditCodec.class.getName());
        IndexManagementUtil.ensureMutableIndexingCorrectlyConfigured((Configuration)conf);
    }

    @Test(expected=IllegalStateException.class)
    public void testCompressedWALWithHLogReader() throws Exception {
        Configuration conf = new Configuration(false);
        conf.setBoolean("hbase.regionserver.wal.enablecompression", true);
        conf.set("hbase.regionserver.hlog.reader.impl", IndexedHLogReader.class.getName());
        IndexManagementUtil.ensureMutableIndexingCorrectlyConfigured((Configuration)conf);
    }

    public static void createIndexTable(Admin admin, String indexTable) throws IOException {
        TestIndexManagementUtil.createIndexTable(admin, TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)indexTable)));
    }

    public static void createIndexTable(Admin admin, TableDescriptorBuilder indexBuilder) throws IOException {
        indexBuilder.setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])CoveredColumnIndexCodec.INDEX_ROW_COLUMN_FAMILY).setKeepDeletedCells(KeepDeletedCells.TRUE).build());
        admin.createTable(indexBuilder.build());
    }
}

